/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.util;

import java.awt.Component;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    public static String createFilePath(TreePath treePath) {
        StringBuilder sb = new StringBuilder();
        if (treePath != null) {
            Object[] nodes = treePath.getPath();
            for (int i = 0; i < nodes.length; ++i) {
                Object obj = ((DefaultMutableTreeNode)nodes[i]).getUserObject();
                String name = "";
                if (obj instanceof String) {
                    name = (String)obj;
                } else if (obj instanceof Component) {
                    name = ((Component)obj).getName();
                }
                if (name.length() <= 0) continue;
                sb.append("/").append(name);
            }
        }
        return sb.toString();
    }

    public static TreePath findByName(JTree tree, String[] names) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        return TreeUtils.find(tree, new TreePath(root), names, 0);
    }

    private static TreePath find(JTree tree, TreePath parent, Object[] nodes, int depth) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        Object obj = ((DefaultMutableTreeNode)node).getUserObject();
        String name = "";
        if (obj instanceof Component) {
            name = ((Component)obj).getName();
        } else if (obj instanceof String) {
            name = (String)obj;
        }
        if (name.equals(nodes[depth])) {
            if (depth == nodes.length - 1) {
                return parent;
            }
            if (node.getChildCount() >= 0) {
                Enumeration<? extends TreeNode> e = node.children();
                while (e.hasMoreElements()) {
                    TreeNode n = e.nextElement();
                    TreePath path = parent.pathByAddingChild(n);
                    TreePath result = TreeUtils.find(tree, path, nodes, depth + 1);
                    if (result == null) continue;
                    return result;
                }
            }
        }
        return null;
    }
}

