/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.reports.PDFKeywordsCoordinatesFinder;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDBorderStyleDictionary;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.destination.PDPageXYZDestination;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;

public class PDFReportEditor {
    private String reportFileName;
    private List keywords;
    private List diagramNamesWithPathAndExtension;
    private List diagramNames;
    private List schemaNames;
    private String reportsPath;
    private ApplicationView appView;
    private Map<String, PDDestinationOrAction> actionsMap;
    private PDDocumentOutline bookmarks;
    private PDDocument reportDocument = null;
    private File reportFile;
    private static final Logger LOGGER = new Logger(PDFReportEditor.class);

    public PDFReportEditor(ApplicationView appView, String reportFileName, List keywords, List diagramsList, List schemaNames) {
        this.keywords = keywords;
        this.diagramNamesWithPathAndExtension = diagramsList;
        this.reportFileName = reportFileName;
        this.reportsPath = ReportUtils.getReportsPath(appView).replace("\\", "/");
        this.appView = appView;
        this.schemaNames = schemaNames;
        this.diagramNames = new ArrayList();
        this.init();
    }

    private void init() {
        try {
            this.actionsMap = new TreeMap<String, PDDestinationOrAction>();
            this.reportFile = new File(this.reportsPath + "/" + this.reportFileName);
            this.reportDocument = PDDocument.load((File)this.reportFile);
            this.bookmarks = this.reportDocument.getDocumentCatalog().getDocumentOutline();
        }
        catch (Exception e) {
            LOGGER.error("PDFReportEditor.init()" + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createDiagramsHyperlinks() {
        if (this.diagramNamesWithPathAndExtension.size() > 0) {
            PDOutlineItem item = null;
            TreeMap<String, PDPage> diagramNameToPageMap = new TreeMap<String, PDPage>();
            TreeMap<String, PDDocument> diagamDocumentsMap = new TreeMap<String, PDDocument>();
            PDOutlineItem diagramsMenuItem = null;
            Iterator it = this.diagramNamesWithPathAndExtension.iterator();
            while (it.hasNext()) {
                try {
                    String diagramName = (String)it.next();
                    PDDocument pdd = PDDocument.load((File)new File(this.reportsPath + "/" + diagramName));
                    diagramName = diagramName.substring(diagramName.indexOf("/") + 1, diagramName.lastIndexOf("."));
                    diagamDocumentsMap.put(diagramName, pdd);
                    this.diagramNames.add(diagramName.substring(diagramName.indexOf("/") + 1, diagramName.length()));
                }
                catch (FileNotFoundException e) {
                }
                catch (Exception ex) {
                    LOGGER.error("PDFReportEditor.createDiagramsHyperlinks() " + ex);
                }
            }
            if (diagamDocumentsMap.size() > 0) {
                try {
                    this.arrangeObjects(false, true, true);
                    if (this.bookmarks != null) {
                        diagramsMenuItem = new PDOutlineItem();
                        diagramsMenuItem.setTitle("Diagrams");
                        this.bookmarks.addLast(diagramsMenuItem);
                    }
                    for (Map.Entry entry : diagamDocumentsMap.entrySet()) {
                        String diagramName = (String)entry.getKey();
                        PDDocument diagramDocument = (PDDocument)entry.getValue();
                        PDPage pp = diagramDocument.getDocumentCatalog().getPages().get(0);
                        PDPage newPageWithDiagram = this.reportDocument.importPage(pp);
                        diagramNameToPageMap.put(diagramName, newPageWithDiagram);
                        PDFKeywordsCoordinatesFinder stripper = new PDFKeywordsCoordinatesFinder(diagramDocument, this.keywords);
                        Map<Map<PDPage, String>, float[]> objCoordinates = stripper.getObjCoordinates();
                        for (Map.Entry<Map<PDPage, String>, float[]> entry1 : objCoordinates.entrySet()) {
                            Map<PDPage, String> key = entry1.getKey();
                            String objectName = "";
                            for (Map.Entry<PDPage, String> e : key.entrySet()) {
                                objectName = e.getValue();
                            }
                            PDAnnotationLink txtLink = new PDAnnotationLink();
                            PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
                            borderULine.setWidth(0.0f);
                            txtLink.setBorderStyle(borderULine);
                            PDActionGoTo action = null;
                            if (this.actionsMap.size() == 0) {
                                PDPageXYZDestination dest = new PDPageXYZDestination();
                                PDPage firstPage = this.reportDocument.getDocumentCatalog().getPages().get(0);
                                dest.setPage(firstPage);
                                action = new PDActionGoTo();
                                action.setDestination((PDDestination)dest);
                            } else {
                                action = (PDActionGoTo)this.actionsMap.get(objectName);
                            }
                            txtLink.setAction((PDAction)action);
                            float[] quads = entry1.getValue();
                            PDRectangle rect = new PDRectangle();
                            rect.setLowerLeftX(quads[0]);
                            rect.setLowerLeftY(quads[5]);
                            rect.setUpperRightX(quads[2]);
                            rect.setUpperRightY(quads[1]);
                            txtLink.setRectangle(rect);
                            newPageWithDiagram.getAnnotations().add(txtLink);
                        }
                        if (this.bookmarks == null) continue;
                        PDOutlineItem menuItem = new PDOutlineItem();
                        menuItem.setTitle(diagramName);
                        menuItem.setDestination(newPageWithDiagram);
                        diagramsMenuItem.addLast(menuItem);
                    }
                    if (this.bookmarks != null) {
                        this.actionsMap.clear();
                        this.bookmarks = this.reportDocument.getDocumentCatalog().getDocumentOutline();
                        for (item = this.bookmarks.getFirstChild(); item != null; item = item.getNextSibling()) {
                            this.actionsMap.put(item.getTitle(), (PDDestinationOrAction)item.getAction());
                            for (PDOutlineItem diagramItem = item.getFirstChild(); diagramItem != null; diagramItem = diagramItem.getNextSibling()) {
                                this.actionsMap.put(diagramItem.getTitle(), (PDDestinationOrAction)diagramItem.getDestination());
                            }
                        }
                    }
                    PDFKeywordsCoordinatesFinder stripper = new PDFKeywordsCoordinatesFinder(this.reportDocument, this.diagramNames);
                    Map<Map<PDPage, String>, float[]> objCoordinates = stripper.getObjCoordinates();
                    for (Map.Entry<Map<PDPage, String>, float[]> entry : objCoordinates.entrySet()) {
                        float[] quads = entry.getValue();
                        String diagramName = "";
                        PDPage page = null;
                        Map<PDPage, String> key = entry.getKey();
                        for (Map.Entry<PDPage, String> e : key.entrySet()) {
                            page = e.getKey();
                            diagramName = e.getValue();
                        }
                        if (quads == null) continue;
                        PDAnnotationLink linkToDiagramPage = null;
                        if (this.actionsMap.size() == 0) {
                            linkToDiagramPage = new PDAnnotationLink();
                            PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
                            borderULine.setWidth(0.0f);
                            linkToDiagramPage.setBorderStyle(borderULine);
                            PDPageXYZDestination dest = new PDPageXYZDestination();
                            dest.setPage((PDPage)diagramNameToPageMap.get(diagramName));
                            PDActionGoTo action = new PDActionGoTo();
                            action.setDestination((PDDestination)dest);
                            linkToDiagramPage.setDestination((PDDestination)dest);
                            PDRectangle rect = new PDRectangle();
                            rect.setLowerLeftX(quads[0]);
                            rect.setLowerLeftY(quads[5]);
                            rect.setUpperRightX(quads[2]);
                            rect.setUpperRightY(quads[1]);
                            linkToDiagramPage.setRectangle(rect);
                            if (page == null) continue;
                            page.getAnnotations().add(linkToDiagramPage);
                            continue;
                        }
                        PDDestinationOrAction destinationOrAction = this.actionsMap.get(diagramName);
                        if (destinationOrAction == null) continue;
                        linkToDiagramPage = new PDAnnotationLink();
                        PDBorderStyleDictionary borderULine = new PDBorderStyleDictionary();
                        borderULine.setWidth(0.0f);
                        linkToDiagramPage.setBorderStyle(borderULine);
                        if (destinationOrAction instanceof PDDestination) {
                            linkToDiagramPage.setDestination((PDDestination)destinationOrAction);
                        }
                        PDRectangle rect = new PDRectangle();
                        rect.setLowerLeftX(quads[0]);
                        rect.setLowerLeftY(quads[5]);
                        rect.setUpperRightX(quads[2]);
                        rect.setUpperRightY(quads[1]);
                        linkToDiagramPage.setRectangle(rect);
                        if (page == null) continue;
                        page.getAnnotations().add(linkToDiagramPage);
                    }
                    this.reportDocument.save(this.reportFile);
                }
                catch (Exception e) {
                    LOGGER.error("PDFReportEditor.createDiagramsHyperlinks() " + e);
                    ApplicationView.log("Error when embedding diagrams in the PDF report. \nPlease see the log file for details.");
                }
                finally {
                    if (this.reportDocument != null) {
                        try {
                            this.reportDocument.close();
                        }
                        catch (Exception e) {
                            LOGGER.error("PDFReportEditor.createDiagramsHyperlinks() Unable to close the report document " + e);
                        }
                    }
                    for (Map.Entry entry : diagamDocumentsMap.entrySet()) {
                        String dName = (String)entry.getKey();
                        try {
                            PDDocument diagramDocument = (PDDocument)entry.getValue();
                            diagramDocument.close();
                        }
                        catch (IOException e) {
                            LOGGER.error("PDFReportEditor.createDiagramsHyperlinks() Unable to close diagram document " + dName + " " + e);
                        }
                    }
                }
            }
        }
    }

    private void groupObjectsBySchema() {
        PDOutlineItem objectsMenuItem = null;
        objectsMenuItem = new PDOutlineItem();
        objectsMenuItem.setTitle("Objects");
        this.bookmarks.addLast(objectsMenuItem);
        ArrayList<String> objectsWithSchema = new ArrayList<String>();
        if (this.schemaNames.size() > 1) {
            for (String schemaName : this.schemaNames) {
                PDOutlineItem schemaItem = new PDOutlineItem();
                schemaItem.setTitle(schemaName);
                objectsMenuItem.addLast(schemaItem);
                for (Map.Entry<String, PDDestinationOrAction> entry : this.actionsMap.entrySet()) {
                    String objectName = entry.getKey();
                    PDActionGoTo objectAction = (PDActionGoTo)entry.getValue();
                    PDOutlineItem objectItem = new PDOutlineItem();
                    objectItem.setAction((PDAction)objectAction);
                    if (!objectName.contains(schemaName)) continue;
                    objectItem.setTitle(objectName.replace(schemaName + ".", ""));
                    schemaItem.addLast(objectItem);
                    objectsWithSchema.add(objectName);
                }
            }
            for (Map.Entry<String, PDDestinationOrAction> entry : this.actionsMap.entrySet()) {
                String objectName = entry.getKey();
                PDActionGoTo objectAction = (PDActionGoTo)entry.getValue();
                if (objectsWithSchema.contains(objectName)) continue;
                PDOutlineItem objectItem = new PDOutlineItem();
                objectItem.setAction((PDAction)objectAction);
                objectItem.setTitle(objectName);
                objectsMenuItem.addLast(objectItem);
            }
        } else {
            for (Map.Entry<String, PDDestinationOrAction> entry : this.actionsMap.entrySet()) {
                String objectName = entry.getKey();
                PDActionGoTo objectAction = (PDActionGoTo)entry.getValue();
                if (objectsWithSchema.contains(objectName)) continue;
                PDOutlineItem objectItem = new PDOutlineItem();
                objectItem.setAction((PDAction)objectAction);
                objectItem.setTitle(objectName);
                objectsMenuItem.addLast(objectItem);
            }
        }
    }

    private void groupObjects() {
        PDOutlineItem objectsMenuItem = new PDOutlineItem();
        objectsMenuItem.setTitle("Objects");
        this.bookmarks.addLast(objectsMenuItem);
        for (Map.Entry<String, PDDestinationOrAction> entry : this.actionsMap.entrySet()) {
            String objectName = entry.getKey();
            PDActionGoTo objectAction = (PDActionGoTo)entry.getValue();
            PDOutlineItem objectItem = new PDOutlineItem();
            objectItem.setAction((PDAction)objectAction);
            objectItem.setTitle(objectName);
            objectsMenuItem.addLast(objectItem);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void arrangeObjects(boolean closeReportDocument, boolean createObjectsGroup, boolean diagramsAreEmbedded) {
        boolean closeDoc = closeReportDocument;
        if (!diagramsAreEmbedded && !this.appView.getSettings().isGroupBySchemaNameInReports()) {
            if (closeDoc && this.reportDocument != null) {
                try {
                    this.reportDocument.close();
                }
                catch (Exception e) {
                    LOGGER.error("PDFReportEditor.createSchemaGroups() Unable to close the report document " + e);
                }
            }
            return;
        }
        try {
            if (this.bookmarks != null) {
                for (PDOutlineItem item = this.bookmarks.getFirstChild(); item != null; item = item.getNextSibling()) {
                    this.actionsMap.put(item.getTitle(), (PDDestinationOrAction)item.getAction());
                }
                this.reportDocument.getDocumentCatalog().setDocumentOutline(null);
                this.reportDocument.getDocumentCatalog().setDocumentOutline(new PDDocumentOutline());
                this.bookmarks = this.reportDocument.getDocumentCatalog().getDocumentOutline();
                if (diagramsAreEmbedded) {
                    if (this.appView.getSettings().isGroupBySchemaNameInReports()) {
                        this.groupObjectsBySchema();
                    } else {
                        this.groupObjects();
                    }
                } else if (this.appView.getSettings().isGroupBySchemaNameInReports()) {
                    this.groupObjectsBySchema();
                }
            }
            this.reportDocument.save(this.reportFile);
        }
        catch (Exception e) {
            LOGGER.error("PDFReportEditor.createSchemaGroups()" + e);
            ApplicationView.log("Error when grouping objects by schema in the PDF report. \nPlease see the log file for details.");
        }
        finally {
            if (closeDoc && this.reportDocument != null) {
                try {
                    this.reportDocument.close();
                }
                catch (Exception e) {
                    LOGGER.error("PDFReportEditor.createSchemaGroups() Unable to close the report document " + e);
                }
            }
        }
    }
}

