/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import oracle.dbtools.crest.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.text.TextPosition;
import org.apache.pdfbox.util.Matrix;

public class PDFKeywordsCoordinatesFinder
extends PDFTextStripper {
    private float verticalTolerance = 0.0f;
    private float heightModifier = 1.25f;
    private PDDocument document;
    private List seekList = new ArrayList();
    private static Map<Map<PDPage, String>, float[]> objCoordinates;
    private TextCache textCache;
    private static final Logger LOGGER;
    private boolean inParagraph;

    public PDFKeywordsCoordinatesFinder(PDDocument document, List<String> seekList) throws IOException {
        super.setSortByPosition(true);
        this.document = document;
        this.seekList = seekList;
        objCoordinates = new HashMap<Map<PDPage, String>, float[]>();
        this.run();
    }

    private void run() {
        try {
            this.setLineSeparator(" ");
            this.initialize();
            for (String keyword : this.seekList) {
                this.getCoordinates(Pattern.compile(keyword));
            }
        }
        catch (Exception e) {
            LOGGER.error("PDFKeywordsCoordinatesFinder " + e);
        }
    }

    public List<PDRectangle> getTextBoundingBoxes(List<TextPosition> positions) {
        ArrayList<PDRectangle> boundingBoxes = new ArrayList<PDRectangle>();
        float lowerLeftX = -1.0f;
        float lowerLeftY = -1.0f;
        float upperRightX = -1.0f;
        float upperRightY = -1.0f;
        boolean first = true;
        for (int i = 0; i < positions.size(); ++i) {
            TextPosition position = positions.get(i);
            if (position == null) continue;
            Matrix textPos = position.getTextMatrix();
            float height = position.getHeight() * this.getHeightModifier();
            if (first) {
                lowerLeftX = textPos.getXPosition();
                upperRightX = lowerLeftX + position.getWidth();
                lowerLeftY = textPos.getYPosition();
                upperRightY = lowerLeftY + height;
                first = false;
                continue;
            }
            if (Math.abs(textPos.getYPosition() - lowerLeftY) <= this.getVerticalTolerance()) {
                upperRightX = textPos.getXPosition() + position.getWidth();
                upperRightY = textPos.getYPosition() + height;
                continue;
            }
            PDRectangle boundingBox = this.boundingBox(lowerLeftX, lowerLeftY, upperRightX, upperRightY);
            boundingBoxes.add(boundingBox);
            lowerLeftX = textPos.getXPosition();
            upperRightX = lowerLeftX + position.getWidth();
            lowerLeftY = textPos.getYPosition();
            upperRightY = lowerLeftY + height;
        }
        if (lowerLeftX != -1.0f || lowerLeftY != -1.0f || upperRightX != -1.0f || upperRightY != -1.0f) {
            PDRectangle boundingBox = this.boundingBox(lowerLeftX, lowerLeftY, upperRightX, upperRightY);
            boundingBoxes.add(boundingBox);
        }
        return boundingBoxes;
    }

    private PDRectangle boundingBox(float lowerLeftX, float lowerLeftY, float upperRightX, float upperRightY) {
        PDRectangle boundingBox = new PDRectangle();
        boundingBox.setLowerLeftX(lowerLeftX);
        boundingBox.setLowerLeftY(lowerLeftY);
        boundingBox.setUpperRightX(upperRightX);
        boundingBox.setUpperRightY(upperRightY);
        return boundingBox;
    }

    private void getCoordinates(Pattern pattern) throws IOException {
        if (this.textCache == null || this.document == null) {
            throw new IllegalArgumentException("TextCache was not initilized");
        }
        int i = 1;
        for (PDPage page : this.document.getPages()) {
            HashMap<PDPage, String> m = new HashMap<PDPage, String>();
            m.put(page, pattern.toString());
            List<Match> matches = this.textCache.match(i, pattern);
            Iterator<Match> iterator = matches.iterator();
            if (iterator.hasNext()) {
                Match match = iterator.next();
                List<PDRectangle> textBoundingBoxes = this.getTextBoundingBoxes(match.positions);
                if (textBoundingBoxes.size() > 0) {
                    float[] quads = this.getQuads(textBoundingBoxes);
                    objCoordinates.put(m, quads);
                }
            }
            ++i;
        }
    }

    public float[] getQuads(List<PDRectangle> rects) {
        float[] quads = new float[8 * rects.size()];
        int cursor = 0;
        for (PDRectangle rect : rects) {
            float[] tmp = this.getQuads(rect);
            for (int i = 0; i < tmp.length; ++i) {
                quads[cursor + i] = tmp[i];
            }
            cursor += 8;
        }
        return quads;
    }

    public float[] getQuads(PDRectangle rect) {
        float[] quads;
        quads = new float[]{rect.getLowerLeftX(), rect.getUpperRightY(), rect.getUpperRightX(), quads[1], quads[0], rect.getLowerLeftY(), quads[2], quads[5]};
        return quads;
    }

    public float getVerticalTolerance() {
        return this.verticalTolerance;
    }

    public void setVerticalTolerance(float tolerance) {
        this.verticalTolerance = tolerance;
    }

    public float getHeightModifier() {
        return this.heightModifier;
    }

    public void setHeightModifier(float heightModifier) {
        this.heightModifier = heightModifier;
    }

    public void initialize() throws IOException {
        this.resetEngine();
        this.textCache = new TextCache();
        if (this.getAddMoreFormatting()) {
            this.setParagraphEnd(this.getLineSeparator());
            this.setPageStart(this.getLineSeparator());
            this.setArticleStart(this.getLineSeparator());
            this.setArticleEnd(this.getLineSeparator());
        }
        try {
            this.startDocument(this.document);
            this.processPages(this.document.getDocumentCatalog().getPages());
            this.endDocument(this.document);
        }
        catch (Exception e) {
            LOGGER.error("PDFKeywordsCoordinatesFinder.initialize() " + e);
        }
    }

    public void resetEngine() {
        this.textCache = null;
    }

    protected void startArticle(boolean isltr) throws IOException {
        String articleStart = this.getArticleStart();
        this.textCache.append(articleStart, null);
    }

    protected void endArticle() throws IOException {
        String articleEnd = this.getArticleEnd();
        this.textCache.append(articleEnd, null);
    }

    protected void writeLineSeparator() {
        String lineSeparator = this.getLineSeparator();
        this.textCache.append(lineSeparator, null);
    }

    protected void writeWordSeparator() {
        String wordSeparator = this.getWordSeparator();
        this.textCache.append(wordSeparator, null);
    }

    protected void writeCharacters(TextPosition text) {
        String character = text.getUnicode();
        this.textCache.append(character, text);
    }

    protected void writeString(String text, List<TextPosition> textPositions) {
        for (TextPosition textPosition : textPositions) {
            this.writeCharacters(textPosition);
        }
    }

    protected void writeParagraphSeparator() {
        this.writeParagraphEnd();
        this.writeParagraphStart();
    }

    protected void writeParagraphStart() {
        if (this.inParagraph) {
            this.writeParagraphEnd();
            this.inParagraph = false;
        }
        String paragraphStart = this.getParagraphStart();
        this.textCache.append(paragraphStart, null);
        this.inParagraph = true;
    }

    protected void writeParagraphEnd() {
        String paragraphEnd = this.getParagraphEnd();
        this.textCache.append(paragraphEnd, null);
        this.inParagraph = false;
    }

    protected void writePageStart() {
        String pageStart = this.getPageStart();
        this.textCache.append(pageStart, null);
    }

    protected void writePageEnd() {
        String pageEnd = this.getPageEnd();
        this.textCache.append(pageEnd, null);
    }

    public static Map<Map<PDPage, String>, float[]> getObjCoordinates() {
        return objCoordinates;
    }

    static {
        LOGGER = new Logger(PDFKeywordsCoordinatesFinder.class);
    }

    private class TextCache {
        private Map<Integer, StringBuilder> texts = new HashMap<Integer, StringBuilder>();
        private Map<Integer, ArrayList<TextPosition>> positions = new HashMap<Integer, ArrayList<TextPosition>>();

        private TextCache() {
        }

        private StringBuilder obtainStringBuilder(Integer pageNo) {
            StringBuilder sb = this.texts.get(pageNo);
            if (sb == null) {
                sb = new StringBuilder();
                this.texts.put(pageNo, sb);
            }
            return sb;
        }

        private ArrayList<TextPosition> obtainTextPositions(Integer pageNo) {
            ArrayList<Object> textPositions = this.positions.get(pageNo);
            if (textPositions == null) {
                textPositions = new ArrayList();
                this.positions.put(pageNo, textPositions);
            }
            return textPositions;
        }

        public String getText(Integer pageNo) {
            return this.obtainStringBuilder(pageNo).toString();
        }

        public List<TextPosition> getTextPositions(Integer pageNo) {
            return this.obtainTextPositions(pageNo);
        }

        public void append(String str, TextPosition pos) {
            int currentPage = PDFKeywordsCoordinatesFinder.this.getCurrentPageNo();
            ArrayList<TextPosition> positions = this.obtainTextPositions(currentPage);
            StringBuilder sb = this.obtainStringBuilder(currentPage);
            for (int i = 0; i < str.length(); ++i) {
                sb.append(str.charAt(i));
                positions.add(pos);
            }
        }

        public List<Match> match(Integer pageNo, Pattern pattern) {
            Matcher matcher = pattern.matcher(this.getText(pageNo));
            ArrayList<Match> matches = new ArrayList<Match>();
            while (matcher.find()) {
                List<TextPosition> elements = this.getTextPositions(pageNo).subList(matcher.start(), matcher.end());
                matches.add(new Match(matcher.group(), elements));
            }
            return matches;
        }
    }

    private class Match {
        public String str;
        public List<TextPosition> positions;

        public Match(String str, List<TextPosition> positions) {
            this.str = str;
            this.positions = positions;
        }
    }
}

