/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.reports;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.Messages;
import oracle.dbtools.crest.swingui.wizards.reports.ReportTemplatesPersistence;
import oracle.dbtools.crest.swingui.wizards.reports.ReportUtils;
import oracle.dbtools.crest.swingui.wizards.reports.ReportsGenerator;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplatesDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SortedComboBoxModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.ide.Ide;
import oracle.jdbc.OracleBfile;

public abstract class BaseReportsGenerationDialog
extends CustomDialog {
    protected static final String EMPTY = "";
    protected static String[] arrTrue = new String[]{"", "Y", "YES", "y", "yes"};
    protected static String[] arrFalse = new String[]{"", "N", "NO", "n", "no"};
    protected static StandardReportTemplate blankRT = new StandardReportTemplate(" ", null, "0", true);
    protected static CustomReportTemplate blankCRT = new CustomReportTemplate(" ", null, "", "");
    protected static String defaultVMOptions = "-Xmx768M";
    private static boolean trLoaded = false;
    protected JComboBox cmbOutFormat;
    protected JTextField txtVMOptions;
    protected JPanel mainPanel;
    protected JButton btnManageStandardTemplates;
    protected JButton btnManageStandardReport;
    protected JComboBox cmbStandardTemplates;
    protected String saxonPath;
    protected JPanel reportsPanel;
    protected JLabel lblOutFormat;
    protected JLabel lblVMOptions;
    protected JPanel standardReportsTemplatesPanel;
    protected boolean result = false;
    protected ApplicationView appView;
    protected ProgressDialog monitor;
    protected File rawXMLFile;
    protected File outputFile = null;
    protected String reportsPath;
    protected OracleBfile bfile;
    protected JDialog dialog;
    protected JPanel buttonsPanel;
    protected JTabbedPane templatesTabbedPane;
    public JButton btnGenerate;
    public JButton btnClose;
    public JButton btnHelp;
    protected List objectsList;
    protected HashMap<String, Object> extraParams;
    protected ReportTemplatesPersistence reportTemplatesPersistence;
    protected JTextField txtReportTtitle;
    protected JTextField txtReportFileName;
    protected JLabel lblTtitle;
    protected JLabel lblFileName;
    protected ReportsGenerator g = null;
    protected SortedComboBoxModel cmbFormatsmodel;
    protected JComboBox cmbCustomTemplates;
    protected static boolean ctrLoaded = false;
    private static final Logger LOGGER = new Logger(BaseReportsGenerationDialog.class);

    public BaseReportsGenerationDialog(ApplicationView appView, List objects, HashMap extraParams) {
        super(appView);
        this.appView = appView;
        this.objectsList = objects;
        this.extraParams = extraParams;
        this.saxonPath = appView.getSettings().getDefaultSaxonPath();
        this.reportsPath = ReportUtils.getReportsPath(appView);
        this.reportTemplatesPersistence = new ReportTemplatesPersistence(appView);
        this.mainPanel = new JPanel(new BorderLayout());
        this.mainPanel.setPreferredSize(new Dimension(460, 110));
        this.initNorthPanel();
        this.initButtonsPanel();
        this.add((Component)this.mainPanel, "Center");
    }

    private void initNorthPanel() {
        this.reportsPanel = new JPanel(new SpringLayout());
        this.reportsPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("ReportsGenerationDialog.Reports")));
        this.reportsPanel.setPreferredSize(new Dimension(400, 100));
        this.lblOutFormat = new JLabel(Messages.getString("ReportsGenerationDialog.ReportsOutFormat"));
        this.lblOutFormat.setPreferredSize(new Dimension(120, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblOutFormat, 5, 5);
        this.cmbFormatsmodel = new SortedComboBoxModel(this.getOutputFormats());
        this.cmbOutFormat = new JComboBox(this.cmbFormatsmodel);
        this.cmbOutFormat.setSelectedItem("HTML");
        this.cmbOutFormat.setPreferredSize(new Dimension(46, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.cmbOutFormat, 140, 5);
        this.cmbOutFormat.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (BaseReportsGenerationDialog.this.cmbOutFormat.getSelectedItem().equals("PDF")) {
                    BaseReportsGenerationDialog.this.txtVMOptions.setEnabled(true);
                    if (BaseReportsGenerationDialog.this.txtVMOptions.getText().equals(BaseReportsGenerationDialog.EMPTY)) {
                        BaseReportsGenerationDialog.this.txtVMOptions.setText(defaultVMOptions);
                    }
                } else {
                    BaseReportsGenerationDialog.this.txtVMOptions.setEnabled(false);
                    BaseReportsGenerationDialog.this.txtVMOptions.setText(BaseReportsGenerationDialog.EMPTY);
                }
            }
        });
        this.reportsPanel.add(this.lblOutFormat);
        this.reportsPanel.add(this.cmbOutFormat);
        this.lblVMOptions = new JLabel(Messages.getString("ReportsGenerationDialog.VMOptions"));
        this.lblVMOptions.setPreferredSize(new Dimension(150, 20));
        CommonUtil.setLabelConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblVMOptions, 200, 5);
        this.txtVMOptions = new JTextField();
        this.txtVMOptions.setPreferredSize(new Dimension(100, 20));
        this.txtVMOptions.setToolTipText(Messages.getString("ReportsGenerationDialog.VMOptionsToolTip"));
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtVMOptions, 300, 3);
        this.txtVMOptions.setEnabled(false);
        this.reportsPanel.add(this.lblVMOptions);
        this.reportsPanel.add(this.txtVMOptions);
        this.lblTtitle = new JLabel("Report Title");
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblTtitle, 5, 30);
        this.txtReportTtitle = new JTextField();
        this.txtReportTtitle.setPreferredSize(new Dimension(290, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportTtitle, 140, 30);
        this.reportsPanel.add(this.lblTtitle);
        this.reportsPanel.add(this.txtReportTtitle);
        this.lblFileName = new JLabel("Report File Name");
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.lblFileName, 5, 55);
        this.txtReportFileName = new JTextField();
        this.txtReportFileName.setPreferredSize(new Dimension(290, 20));
        CommonUtil.setObjectConstraints((SpringLayout)this.reportsPanel.getLayout(), this.txtReportFileName, 140, 55);
        this.reportsPanel.add(this.lblFileName);
        this.reportsPanel.add(this.txtReportFileName);
        this.mainPanel.add((Component)this.reportsPanel, "North");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private void initButtonsPanel() {
        this.buttonsPanel = new JPanel(new FlowLayout(1));
        this.btnGenerate = new JButton(Messages.getString("ReportsGenerationDialog.GenerateReports"));
        this.btnGenerate.setPreferredSize(new Dimension(160, 23));
        this.btnGenerate.addActionListener(new GenerateAction());
        this.btnGenerate.setMnemonic(71);
        this.buttonsPanel.add(this.btnGenerate);
        this.btnClose = new JButton(Messages.getString("ReportsGenerationDialog.Close"));
        this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnClose.addActionListener(new CloseAction());
        this.btnClose.setMnemonic(67);
        this.buttonsPanel.add(this.btnClose);
        this.btnHelp = new JButton(this.getHelpAction());
        this.btnHelp.setMnemonic(72);
        this.btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.buttonsPanel.add(this.btnHelp);
        this.mainPanel.add((Component)this.buttonsPanel, "South");
    }

    private ArrayList getOutputFormats() {
        ArrayList<String> outFormatsList = new ArrayList<String>();
        outFormatsList.add("RTF");
        outFormatsList.add("HTML");
        outFormatsList.add("PDF");
        return outFormatsList;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("ReportsGenerationDialog.Reports"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return this.result;
    }

    @Override
    protected String getHelpIndex() {
        return "GENERATE_REPORT_DIALOG";
    }

    protected abstract void generateReport();

    protected void loadReportTemplates() {
        if (!trLoaded) {
            this.reportTemplatesPersistence.loadReportTemplates(this.appView);
            trLoaded = true;
        }
    }

    protected String getErrorMsg() {
        return Messages.getString("ReportsGenerationDialog.ReportGenerationErrMsg");
    }

    protected String getMsgHeader() {
        return Messages.getString("ReportsGenerationDialog.ReportGenerationRes");
    }

    class CustomComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        CustomComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = " ";
            if (value != null) {
                text = ((CustomReportTemplate)value).getName();
            }
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class StandardComboBoxRenderer
    extends JLabel
    implements ListCellRenderer {
        StandardComboBoxRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = " ";
            if (value != null) {
                text = ((StandardReportTemplate)value).getName();
            }
            this.setText(text);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            return this;
        }
    }

    class ManageTemplatesAction
    implements ActionListener {
        private Class clazz;

        ManageTemplatesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            StandardReportTemplatesDialog dialog = new StandardReportTemplatesDialog(BaseReportsGenerationDialog.this.appView, BaseReportsGenerationDialog.this, this.clazz, BaseReportsGenerationDialog.this.reportTemplatesPersistence);
            dialog.showDialog();
        }

        public void setClazz(Class clazz) {
            this.clazz = clazz;
        }
    }

    private class GenerateAction
    implements ActionListener {
        private GenerateAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int choice;
            boolean go = true;
            String filePath = ReportUtils.getReportsPath(BaseReportsGenerationDialog.this.appView) + "/" + BaseReportsGenerationDialog.this.txtReportFileName.getText() + "." + ((String)BaseReportsGenerationDialog.this.cmbOutFormat.getSelectedItem()).toLowerCase();
            File f = new File(filePath);
            if (f.exists() && (choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), "The file " + f.getAbsolutePath() + " already exists! Are you sure you want to overwrite?", "Overwrite confirmation", 0, 3)) == 1) {
                go = false;
            }
            if (go) {
                BaseReportsGenerationDialog.this.generateReport();
            }
        }
    }

    private class CloseAction
    implements ActionListener {
        private CloseAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            BaseReportsGenerationDialog.this.close();
        }
    }
}

