/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.db2;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.imports.metadata.AbstractDBMExtractionHandler;
import oracle.dbtools.crest.imports.metadata.DBObject;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.swingui.wizards.metadata.AbstractDBMExtractionWizardImpl;
import oracle.dbtools.crest.swingui.wizards.metadata.DBMExtractionWizard;

public class DBMExtractionWizardDB2
extends AbstractDBMExtractionWizardImpl {
    private static DBMExtractionWizardDB2 impl;
    protected JTable tbAliases;
    protected JTable tbAuxTables;
    protected JTable tbDatabases;
    protected JTable tbTablespaces;
    protected JTable tbOwners;
    protected JTable tbStorageGroups;
    protected JTable tbProcedures;
    protected JTable tbDatatypes;
    protected List aliases = new ArrayList();
    protected List auxTables = new ArrayList();
    protected List databases = new ArrayList();
    protected List tablespaces = new ArrayList();
    protected List owners = new ArrayList();
    protected List storageGroups = new ArrayList();
    protected List procedures = new ArrayList();
    protected List datatypes = new ArrayList();

    public DBMExtractionWizardDB2(DBMExtractionWizard wizard) {
        super(wizard);
    }

    public static AbstractDBMExtractionWizardImpl getInstance(DBMExtractionWizard wizard) {
        if (impl == null) {
            impl = new DBMExtractionWizardDB2(wizard);
        }
        return impl;
    }

    public static void clearInstance() {
        impl = null;
    }

    @Override
    public JPanel getSecondTab() {
        JPanel jpanel = new JPanel(new BorderLayout());
        this.lsSchemas = new ArrayList();
        this.tbSchemas = new JTable(new SchemasModel());
        this.tbSchemas.setAutoCreateRowSorter(true);
        TableColumn column = this.tbSchemas.getColumnModel().getColumn(1);
        column.setPreferredWidth(300);
        JScrollPane sp = new JScrollPane(this.tbSchemas);
        jpanel.add((Component)sp, "Center");
        JPanel pn1 = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = DBMExtractionWizardDB2.createSelectAllButton();
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardDB2.this.checkAll(DBMExtractionWizardDB2.this.tbSchemas, DBMExtractionWizardDB2.this.lsSchemas, true);
            }
        });
        JButton bnDeselectAll = DBMExtractionWizardDB2.createDeselectAllButton();
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DBMExtractionWizardDB2.this.checkAll(DBMExtractionWizardDB2.this.tbSchemas, DBMExtractionWizardDB2.this.lsSchemas, false);
            }
        });
        this.chAllSelected = new JCheckBox(Messages.getString("DBMExtractionWizardDB2.AllSelected"));
        this.chAllSelected.setSelected(AbstractDBMExtractionHandler.isAllSelected());
        this.chAllSelected.setToolTipText(Messages.getString("DBMExtractionWizardDB2.DefaultSelectionStatus"));
        this.chAllSelected.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AbstractDBMExtractionHandler.setAllSelected(DBMExtractionWizardDB2.this.chAllSelected.isSelected());
            }
        });
        pn1.add(this.createFilterPanel(this.secondTabFilterText, this.tbSchemas, bnSelectAll, bnDeselectAll));
        pn1.add(this.chAllSelected);
        jpanel.add((Component)pn1, "South");
        return jpanel;
    }

    @Override
    protected void selectAll(JTable table, List<DBObject> objects, boolean selected) {
        for (DBObject object : objects) {
            object.setSelected(selected);
        }
    }

    @Override
    protected List getCurrentList() {
        int tab = this.getTabbedPane().getSelectedIndex();
        switch (tab) {
            case 0: {
                return this.lsTables;
            }
            case 1: {
                return this.lsViews;
            }
            case 2: {
                return this.aliases;
            }
            case 3: {
                return this.auxTables;
            }
            case 4: {
                return this.databases;
            }
            case 5: {
                return this.tablespaces;
            }
            case 6: {
                return this.owners;
            }
            case 7: {
                return this.storageGroups;
            }
            case 8: {
                return this.procedures;
            }
            case 9: {
                return this.datatypes;
            }
        }
        return this.lsTables;
    }

    @Override
    protected void addTabs() {
        this.tbTables = this.addTab(this.tbTables, this.lsTables, Messages.getString("DBMExtractionWizardDB2.Tables"));
        this.tbViews = this.addTab(this.tbViews, this.lsViews, Messages.getString("DBMExtractionWizardDB2.Views"));
        this.tbAliases = this.addTab(this.tbAliases, this.aliases, Messages.getString("DBMExtractionWizardDB2.Aliases"));
        this.tbAuxTables = this.addTab(this.tbAuxTables, this.auxTables, Messages.getString("DBMExtractionWizardDB2.AuxTables"));
        this.tbDatabases = this.addTab(this.tbDatabases, this.databases, Messages.getString("DBMExtractionWizardDB2.Databases"));
        this.tbTablespaces = this.addTab(this.tbTablespaces, this.tablespaces, Messages.getString("DBMExtractionWizardDB2.Tablespaces"));
        this.tbOwners = this.addOwnerTab(this.tbOwners, this.owners, Messages.getString("DBMExtractionWizardDB2.Owners"));
        this.tbStorageGroups = this.addTab(this.tbStorageGroups, this.storageGroups, Messages.getString("DBMExtractionWizardDB2.StorageGroups"));
        this.tbProcedures = this.addTab(this.tbProcedures, this.procedures, Messages.getString("DBMExtractionWizardDB2.Procedures"));
        this.tbDatatypes = this.addTab(this.tbDatatypes, this.datatypes, Messages.getString("DBMExtractionWizardDB2.Datatypes"));
    }

    protected JTable addOwnerTab(JTable table, List list, String name) {
        table = new JTable(new OwnerModel(list));
        TableColumn column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(50);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(250);
        JScrollPane sp = new JScrollPane(table);
        this.getTabbedPane().addTab(name, sp);
        return table;
    }

    @Override
    protected void updateTables() {
        this.tbTables.updateUI();
        this.tbViews.updateUI();
        this.tbAliases.updateUI();
        this.tbAuxTables.updateUI();
        this.tbDatabases.updateUI();
        this.tbTablespaces.updateUI();
        this.tbOwners.updateUI();
        this.tbStorageGroups.updateUI();
        this.tbProcedures.updateUI();
        this.tbDatatypes.updateUI();
    }

    @Override
    public List getSelectedObjects() {
        ArrayList<DBObject> list = new ArrayList<DBObject>();
        for (DBObject dbo : this.lsTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.lsViews) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.aliases) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.auxTables) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.databases) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.tablespaces) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.owners) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.storageGroups) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.procedures) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        for (DBObject dbo : this.datatypes) {
            if (!dbo.isSelected()) continue;
            list.add(dbo);
        }
        return list;
    }

    @Override
    protected void clearAll() {
        this.lsTables.clear();
        this.lsViews.clear();
        this.aliases.clear();
        this.auxTables.clear();
        this.databases.clear();
        this.tablespaces.clear();
        this.owners.clear();
        this.storageGroups.clear();
        this.procedures.clear();
        this.datatypes.clear();
    }

    @Override
    protected void initSpecificObjects(List dbObjects) {
        this.clearAll();
        for (DBObject dbo : dbObjects) {
            String type = dbo.getType();
            if (type.equalsIgnoreCase("TABLE")) {
                this.lsTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("VIEW")) {
                this.lsViews.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("ALIAS")) {
                this.aliases.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("AUX TABLE")) {
                this.auxTables.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DATABASE")) {
                this.databases.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("TABLESPACE")) {
                this.tablespaces.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("STORAGE GROUP")) {
                this.storageGroups.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("PROCEDURE")) {
                this.procedures.add(dbo);
                continue;
            }
            if (type.equalsIgnoreCase("DATATYPE")) {
                this.datatypes.add(dbo);
                continue;
            }
            if (!type.equalsIgnoreCase("OWNER")) continue;
            this.owners.add(dbo);
        }
    }

    class OwnerModel
    extends AbstractTableModel {
        List list;

        public OwnerModel(List list) {
            this.list = list;
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardDB2.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardDB2.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardDB2.Owner");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)this.list.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)this.list.get(rowIndex);
                DBMExtractionWizardDB2.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }

    class SchemasModel
    extends AbstractTableModel {
        List list;

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DBMExtractionWizardDB2.this.lsSchemas.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DBMExtractionWizardDB2.Selected");
            }
            if (column == 1) {
                return Messages.getString("DBMExtractionWizardDB2.Owner");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DBObject dbo = (DBObject)DBMExtractionWizardDB2.this.lsSchemas.get(row);
            switch (col) {
                case 0: {
                    return dbo.isSelected();
                }
                case 1: {
                    return dbo.getName();
                }
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DBObject dbo = (DBObject)DBMExtractionWizardDB2.this.lsSchemas.get(rowIndex);
                DBMExtractionWizardDB2.this.setSelected(dbo, (Boolean)aValue);
            }
        }
    }
}

