/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.connection;

import java.sql.Connection;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.CopyOnWriteArrayList;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.wizards.Messages;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.config.DBConfig;
import oracle.dbtools.raptor.connections.ConnectionDialog;
import oracle.dbtools.raptor.connections.ConnectionPropertiesUpdater;
import oracle.dbtools.raptor.connections.impexp.ImpExpEngine;
import oracle.ide.dialogs.ProgressRunnable;
import oracle.ide.net.URLPath;
import oracle.jdeveloper.db.ConnectionInfo;
import oracle.jdeveloper.db.DatabaseConnectionStores;
import oracle.jdeveloper.db.DatabaseConnections;

public class FCPConnectionDialog {
    private static List<Class<? extends ConnectionPropertiesUpdater>> s_updaters = new CopyOnWriteArrayList<Class<? extends ConnectionPropertiesUpdater>>();
    private static final Logger LOGGER = new Logger(FCPConnectionDialog.class);

    public static ConnectionInfo showConnectionDialog() {
        return FCPConnectionDialog.showConnectionDialog(null, false);
    }

    public static ConnectionInfo showConnectionDialog(boolean oracleOnly) {
        return FCPConnectionDialog.showConnectionDialog(null, oracleOnly);
    }

    public static ConnectionInfo showConnectionDialog(String connName, boolean oracleOnly) {
        ConnectionInfo ci = null;
        try {
            Connection connection;
            if (Extension.isDataModeler()) {
                if (oracleOnly) {
                    DBConfig.getInstance().setThirdPartyPath(new URLPath());
                } else {
                    DBConfig.getInstance().setThirdPartyPath(ApplicationView.getInstance().getSettings().getJDBCDriversPath());
                }
            }
            if ((ci = ConnectionDialog.launch((DatabaseConnections)DatabaseConnections.getInstance(), (String)connName)) != null && (connection = ci.getConnection()) != null) {
                connection.close();
            }
        }
        catch (Throwable th) {
            LOGGER.error("FCPConnectionDialog.showConnectionDialog()", th);
        }
        return ci;
    }

    public static void testConnection(Properties cd) {
        FCPConnectionDialog.testConnection(cd, true);
    }

    public static void testConnection(final Properties cd, boolean oracleOnly) {
        try {
            if (cd != null) {
                if (Extension.isDataModeler()) {
                    if (oracleOnly) {
                        DBConfig.getInstance().setThirdPartyPath(new URLPath());
                    } else {
                        DBConfig.getInstance().setThirdPartyPath(ApplicationView.getInstance().getSettings().getJDBCDriversPath());
                    }
                }
                ConnectRunnable pr = new ConnectRunnable(){

                    protected Object doWork() throws Exception {
                        DatabaseConnections.getInstance().testConnection(cd);
                        return null;
                    }
                };
                pr.setTitle(Messages.getString("FCPConnectionDialog.TestingConnection"));
                pr.start(true);
                if (!pr.isCanceled()) {
                    MessageDialogs.showMessage(ApplicationView.frame, Messages.getString("FCPConnectionDialog.ConnectionSuccessfull"));
                }
            }
        }
        catch (Exception ex) {
            MessageDialogs.showErrorMessage(ApplicationView.frame, ex.getMessage());
        }
    }

    public static void importNewConnections() {
        DatabaseConnections store = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        if (store != null) {
            ImpExpEngine engine = ImpExpEngine.createImportEngine((DatabaseConnections)store);
            engine.invoke();
        }
    }

    public static void exportNewConnections() {
        DatabaseConnections store = DatabaseConnectionStores.getInstance().getStore("IdeConnections");
        if (store != null) {
            ImpExpEngine engine = ImpExpEngine.createExportEngine((DatabaseConnections)store);
            engine.invoke();
        }
    }

    public static boolean importConnections() {
        FCPConnectionDialog.importNewConnections();
        return true;
    }

    public static boolean exportConnections() {
        FCPConnectionDialog.exportNewConnections();
        return true;
    }

    public static void registerPropertiesUpdater(Class<? extends ConnectionPropertiesUpdater> updater) {
        s_updaters.add(updater);
    }

    public static abstract class ConnectRunnable
    extends ProgressRunnable {
        boolean m_canceled;

        protected void doCancel() {
            super.doCancel();
            this.m_canceled = true;
        }

        public boolean isCanceled() {
            return this.m_canceled;
        }
    }
}

