/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.wizards.metadata.connection;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.thirdparty.db2.DMDB2ConnectionPanel;
import oracle.dbtools.thirdparty.jdbc.DMJDBCBasicPanel;
import oracle.dbtools.thirdparty.udb.DMUDBConnectionPanel;
import oracle.jdeveloper.db.DatabaseConnections;

public abstract class ConnectionInfo {
    public static final String ORACLE_TYPE = "Oracle";
    public static final int TYPE_JDBC = 0;
    public static final int TYPE_ORACLE = 1;
    public static final int TYPE_SQL_SERVER = 2;
    public static final int TYPE_DB2 = 3;
    public static final int TYPE_UDB = 4;
    private static final Logger LOGGER = new Logger(ConnectionInfo.class);

    public static String getConnectionName(Properties cd) {
        return cd.getProperty("ConnName");
    }

    public static String getConnectionUserName(Properties cd) {
        return cd.getProperty("user");
    }

    public static void listConnectionProperties(Properties cd) {
        Enumeration<Object> en = cd.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            System.out.println(key + " - " + cd.getProperty((String)key));
        }
    }

    public static int getConnectionType(Properties cd) {
        int type = ConnectionInfo.getConnectionTypeImpl(cd);
        if (type == 0) {
            String dbType = cd.getProperty("DB_TYPE");
            if (dbType != null) {
                for (int i = 0; i < DMJDBCBasicPanel.DB_TYPES.length; ++i) {
                    String next = DMJDBCBasicPanel.DB_TYPES[i];
                    if (!dbType.equalsIgnoreCase(next)) continue;
                    return i;
                }
            }
            return type;
        }
        return type;
    }

    private static int getConnectionTypeImpl(Properties cd) {
        String type = cd.getProperty("RaptorConnectionType");
        if (type != null) {
            if (ORACLE_TYPE.equalsIgnoreCase(type)) {
                return 1;
            }
            if ("Microsoft SQL Server".equalsIgnoreCase(type)) {
                return 2;
            }
            if (DMDB2ConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(type)) {
                return 3;
            }
            if (DMUDBConnectionPanel.CONNECTION_TYPE.equalsIgnoreCase(type)) {
                return 4;
            }
        }
        return 0;
    }

    public static int getDBMajorVersion(Connection conn) {
        if (conn != null) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                return dbmd.getDatabaseMajorVersion();
            }
            catch (Exception e) {
                System.out.println(e.getMessage());
            }
        }
        return -1;
    }

    public static List<Properties> getAllConnections(DatabaseConnections store, boolean oracleOnly) {
        ArrayList<Properties> ret = new ArrayList<Properties>();
        try {
            Collection connNames = oracleOnly ? store.listConnections(true) : store.listConnections();
            String[] names = connNames.toArray(new String[0]);
            Arrays.sort(names, String.CASE_INSENSITIVE_ORDER);
            for (String name : names) {
                Properties props = store.getProperties(name);
                props.setProperty("ConnName", name);
                ret.add(props);
            }
        }
        catch (Exception e) {
            LOGGER.error("FCPConnectionDialog.showConnectionDialog(store)", e);
        }
        return ret;
    }
}

