/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.process;

import java.awt.Color;
import java.awt.event.MouseEvent;
import java.util.Map;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.process.Event;
import oracle.dbtools.crest.model.design.process.Flow;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectableObjectMultiple;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;
import oracle.dbtools.crest.swingui.diagram.process.FlowEdge;
import oracle.dbtools.crest.swingui.diagram.process.FlowView;
import oracle.dbtools.crest.swingui.process.AbstractDataFlowTV;

public class TVFlow
extends TVConnector {
    private FlowSelection selectionWrapper = new FlowSelection();

    public TVFlow(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public boolean isConnection() {
        return true;
    }

    @Override
    public DesignPartView getDesignPartView() {
        if (this.dpv == null) {
            return this.getApplicationView().getCurrentDPV();
        }
        return this.dpv;
    }

    public void remove() {
        this.remove(true);
    }

    public void remove(boolean removeModel) {
        if (removeModel) {
            this.getModel().remove();
            this.getDesignPartView().getWorkSpace().repaint();
        }
    }

    public Flow getFlow() {
        return (Flow)this.getModel();
    }

    public DefaultEdge addConnection() {
        if (this.edge == null) {
            AbstractDataFlowTV sourceTV = this.getFlow().getSourceTV(this.getDesignPartView());
            AbstractDataFlowTV targetTV = this.getFlow().getTargetTV(this.getDesignPartView());
            if (sourceTV.getCellView() != null && targetTV.getCellView() != null) {
                DFDiagramCell source = (DFDiagramCell)sourceTV.getCellView().getCell();
                DFDiagramCell target = (DFDiagramCell)targetTV.getCellView().getCell();
                this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, Color.MAGENTA);
                this.edge.setTopView(this);
                this.setCellView(this.edge.getCellView());
                this.setEdge(this.edge);
                this.displayLabels();
                if (!ApplicationView.loading && source != target) {
                    this.edge.straightLine();
                }
            }
        }
        return this.edge;
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge.getDiagram().getDesignPartView().showLabels()) {
            if (this.edge != null && this.edge.getTopView() != null) {
                if (!"".equalsIgnoreCase(((FlowEdge)this.edge).getName())) {
                    this.displayLabel(((FlowEdge)this.edge).getName(), this.getLabelBounds(), 1);
                } else {
                    this.removeLabel(1);
                }
            }
        } else {
            this.removeLabel(1);
        }
    }

    public boolean isSelected() {
        return this.selectionWrapper == this.getDesignPartView().getCurrentSelection();
    }

    @Override
    public SelectableObject getSelectableObject() {
        return this.selectionWrapper;
    }

    @Override
    public Object getLayerConstraint() {
        return RELATION_LAYER;
    }

    @Override
    public String toString() {
        return this.getModel().getName();
    }

    public void oneClick(MouseEvent e) {
        this.getDesignPartView().setCurrentSelection(this.selectionWrapper, this);
    }

    public FlowView getFlowView() {
        return (FlowView)this.getCellView();
    }

    @Override
    public void changed(DesignObject object, ObjectChangeEvent event) {
    }

    public void setEdge(DefaultEdge edge) {
        this.edge = edge;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Process Flow").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Process Flow").getWidth();
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, true);
        }
    }

    public void resetEdgeParams(boolean repaint) {
        if (this.edge != null) {
            this.resetEdgeParams(this.edge, repaint);
        }
    }

    private void resetEdgeParams(DefaultEdge edge, boolean repaint) {
        Event event = ((Flow)this.getModel()).getEvent();
        if (event != null) {
            if (edge != null) {
                Map edgeAttributes = edge.getAttributes();
                DiagramConstants.setLineEnd(edgeAttributes, 9);
                edge.setAttributes(edgeAttributes);
                EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
                cv.update();
            }
        } else if (edge != null) {
            Map edgeAttributes = edge.getAttributes();
            DiagramConstants.setLineEnd(edgeAttributes, 1);
            edge.setAttributes(edgeAttributes);
            EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
            cv.update();
        }
    }

    class FlowSelection
    implements SelectableObject {
        FlowSelection() {
        }

        @Override
        public Object[] getSelectedContainedObject() {
            return null;
        }

        @Override
        public Object getSelectedObject() {
            return this.getSelectedDesignObject();
        }

        @Override
        public DesignObject getSelectedDesignObject() {
            return TVFlow.this.getModel();
        }

        @Override
        public boolean hasContainedArray() {
            return false;
        }

        @Override
        public boolean isMultiple() {
            return false;
        }

        @Override
        public SelectableObjectMultiple asMultiple() {
            throw new ClassCastException("Not a SelectableObjectMultiple");
        }
    }
}

