/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.multidimensional;

import java.awt.Rectangle;
import java.util.List;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.CalculatedAttribute;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Link;
import oracle.dbtools.crest.model.design.multidimensional.RollupLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.multidimensional.AbstractMDTV;
import oracle.dbtools.crest.swingui.multidimensional.DPVCompactMultidimentional;

public class TVLevel
extends AbstractMDTV {
    public TVLevel(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    protected ContainerView createViewSynonim(ApplicationView appv, DesignPartView dpv) {
        return new TVLevel(appv, dpv);
    }

    @Override
    protected void doPrivateActions() {
        this.fireChange(ObjectChangeEvent.TOPVIEW_REMOVED);
    }

    @Override
    protected void hideRelations() {
    }

    @Override
    public Rectangle getCalculatedBounds() {
        if (this.dpv instanceof DPVCompactMultidimentional) {
            Rectangle rec = super.getCalculatedBounds();
            int nameLength = this.getModel().getName().length() * 7;
            rec.width = nameLength >= 40 ? nameLength + 40 : 80;
            rec.height = 30;
            return rec;
        }
        Level level = (Level)this.getModel();
        Rectangle bounds = this.getCellView() != null ? this.getCellView().getBounds().getBounds() : this.getBounds();
        int w = 35;
        int h = 42;
        List mlist = level.getAllAttributes();
        int mCount = mlist.size();
        h += mCount * 14;
        if (level.getOutgoingLinks().size() > 0) {
            h += this.numberOfRefAttributes(level) * 14;
        }
        if (level.getParentKey().size() > 0) {
            h += level.getParentKey().size() * 20;
        }
        int colLength = 1;
        int dtLength = 1;
        if (level.getLevelEntity() != null) {
            mlist.add(level.getLevelEntity());
            ++mCount;
        }
        for (int i = 0; i < mCount; ++i) {
            DesignObject element = (DesignObject)mlist.get(i);
            int cl = element.getName().length() * 7;
            if (element instanceof CalculatedAttribute) {
                cl += Math.min(10, ((CalculatedAttribute)element).getFunction().length()) * 7;
            }
            int dtl = 6;
            colLength = Math.max(cl, colLength);
            dtLength = Math.max(dtl, dtLength);
        }
        if (colLength == 1) {
            colLength = level.getName().length() * 7;
        }
        List outlinks = level.getOutgoingLinks();
        for (int i = 0; i < outlinks.size(); ++i) {
            Link link = (Link)outlinks.get(i);
            RollupLink rlink = link.getRollupLink();
            if (rlink.getChildToParentAttributes().size() <= 0 || rlink.getParentLevel() == null) continue;
            int dtl = rlink.getParentLevel().getName().length() * 7;
            dtLength = Math.max(dtl, dtLength);
        }
        return new Rectangle(bounds.x, bounds.y, w + colLength + dtLength, h);
    }

    private int numberOfRefAttributes(Level level) {
        Object[] links = level.getOutgoingLinks().toArray();
        int result = 0;
        if (links.length > 0) {
            int i;
            boolean hasAttributes = false;
            for (i = 0; i < links.length; ++i) {
                Link link = (Link)links[i];
                if (link.getRollupLink().getChildToParentAttributes().size() <= 0) continue;
                hasAttributes = true;
                break;
            }
            if (hasAttributes) {
                for (i = 0; i < links.length; ++i) {
                    RollupLink rlink = ((Link)links[i]).getRollupLink();
                    result += rlink.getChildToParentAttributes().size();
                }
            }
        }
        return result;
    }
}

