/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.udb.v81;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.udb.v81.StagingTableUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.udb.AbstractUDBPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.udb.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class StagingTablePropertyDialogUDBv81
extends AbstractUDBPropertyDialog {
    protected StagingTableUDBv81 staging;
    protected JTextField tfMQTable;
    protected JComboBox cbGenerateSIC;
    protected JCheckBox chbDefineColumnNames;
    private JTable columnsTable;

    public StagingTablePropertyDialogUDBv81(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.staging = (StagingTableUDBv81)object;
        this.setHeight(400);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("StagingTablePropertyDialogUDBv81.StagingTableProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initMQTable();
        this.initGenerateSIC();
        this.initDefineColumnNames();
        this.initColumnNames();
    }

    private void initMQTable() {
        JLabel label = new JLabel(Messages.getString("StagingTablePropertyDialogUDBv81.MQTable"));
        this.general.add(label);
        this.tfMQTable = new JTextField("", 26);
        this.tfMQTable.setEnabled(false);
        this.general.add(this.tfMQTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfMQTable, 50);
    }

    private void initGenerateSIC() {
        JLabel label = new JLabel(Messages.getString("StagingTablePropertyDialogUDBv81.GenerateSIC"));
        this.general.add(label);
        this.cbGenerateSIC = new JComboBox<String>(YES_NO);
        this.setBG(this.cbGenerateSIC);
        this.cbGenerateSIC.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbGenerateSIC);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbGenerateSIC, 80);
    }

    private void initDefineColumnNames() {
        this.chbDefineColumnNames = new JCheckBox(Messages.getString("StagingTablePropertyDialogUDBv81.DefineColumnNames"));
        this.chbDefineColumnNames.addActionListener(new DefineColumnNamesListener());
        this.general.add(this.chbDefineColumnNames);
        this.setObjectConstraints(this.chbDefineColumnNames, 5, 120);
    }

    private void initColumnNames() {
        this.columnsTable = new ColumnsTable();
        JScrollPane pane = new JScrollPane(this.columnsTable);
        pane.setPreferredSize(new Dimension(395, 210));
        this.setBG(this.columnsTable);
        this.general.add(pane);
        this.setObjectConstraints(pane, 10, 150);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.staging.getName());
        this.tfName.setText(this.staging.getName());
        this.tfMQTable.setText(this.staging.getTable().getName());
        this.cbGenerateSIC.setSelectedItem(StagingTablePropertyDialogUDBv81.translateYesNoForDisplay(this.staging.getGenerateSIC()));
        this.chbDefineColumnNames.setSelected(this.staging.getDefineColumnNames());
        if (this.staging.getDefineColumnNames()) {
            ColumnsModel model = (ColumnsModel)this.columnsTable.getModel();
            if (this.chbDefineColumnNames.isSelected()) {
                if (this.staging.getColumnSet().size() > 0) {
                    for (int i = 0; i < this.staging.getColumnSet().size(); ++i) {
                        model.addRow(new Object[]{this.staging.getColumnSet().elementAt(i)});
                    }
                } else {
                    for (int i = 0; i < this.staging.getTableColumnNames().size(); ++i) {
                        model.addRow(new Object[]{this.staging.getTableColumnNames().get(i)});
                    }
                }
            } else {
                int rows = model.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    model.removeRow(0);
                }
            }
        }
        this.taComments.setText(this.staging.getCommentInRDBMS());
    }

    @Override
    protected void setProperties() {
        if (this.staging != null) {
            this.staging.setName(this.tfName.getText());
            this.staging.setGenerateSIC(StagingTablePropertyDialogUDBv81.translateYesNoForStorage((String)this.cbGenerateSIC.getSelectedItem()));
            this.staging.setDefineColumnNames(this.chbDefineColumnNames.isSelected());
            if (this.chbDefineColumnNames.isSelected()) {
                this.staging.clear();
                ColumnsModel model = (ColumnsModel)this.columnsTable.getModel();
                for (int i = 0; i < model.getRowCount(); ++i) {
                    this.staging.setColumns((String)model.getValueAt(i, 0));
                }
            } else {
                this.staging.clear();
            }
            this.staging.setCommentInRDBMS(this.taComments.getText());
        }
    }

    private class DefineColumnNamesListener
    implements ActionListener {
        private DefineColumnNamesListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ColumnsModel model = (ColumnsModel)StagingTablePropertyDialogUDBv81.this.columnsTable.getModel();
            if (StagingTablePropertyDialogUDBv81.this.chbDefineColumnNames.isSelected()) {
                if (StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().size() > 0) {
                    for (int i = 0; i < StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().size(); ++i) {
                        model.addRow(new Object[]{StagingTablePropertyDialogUDBv81.this.staging.getColumnSet().elementAt(i)});
                    }
                } else {
                    for (int i = 0; i < StagingTablePropertyDialogUDBv81.this.staging.getTableColumnNames().size(); ++i) {
                        model.addRow(new Object[]{StagingTablePropertyDialogUDBv81.this.staging.getTableColumnNames().get(i)});
                    }
                }
            } else {
                int rows = model.getRowCount();
                for (int i = 0; i < rows; ++i) {
                    model.removeRow(0);
                }
            }
        }
    }

    class ColumnsModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("StagingTablePropertyDialogUDBv81.ColumnNames")};

        ColumnsModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return true;
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }

    class ColumnsCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ColumnsCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            this.setBackground(table.getBackground());
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    class ColumnsTable
    extends JTable {
        ColumnsModel dataModel;

        public ColumnsTable() {
            this.dataModel = new ColumnsModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            tableColumn.getColumn(0).setCellRenderer(new ColumnsCellRenderer());
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }
    }
}

