/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.sqlserver.v2k5;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.StorageObjectCollection;
import oracle.dbtools.crest.model.design.storage.sqlserver.FileGroupSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.PartitionSchemeSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.TableProxySqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.DataBaseSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.IndexProxySqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.PartitionFunctionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.storage.PropertiesPropagationDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.AbstractSqlServerPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.sqlserver.Messages;
import oracle.dbtools.crest.util.gui.swing.ColumnsSortOrderModel;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.string.StringUtilities;

public class IndexPropertyDialogSqlServerv2k5
extends AbstractSqlServerPropertyDialog {
    private IndexProxySqlServerv2k5 indexProxy;
    private String comment = "";
    private String commentInRDBMS = "";
    private JTextField tfTable;
    private JTextField tfUnique;
    private JComboBox cbClustered;
    private JComboBox cbFilegroup;
    private JComboBox cbPadIndex;
    private JComboBox cbRecomputeStatistics;
    private JComboBox cbSortInTempDB;
    private JComboBox cbIgnoreDupKey;
    private JIntegerField ifFillFactor;
    private JPanel columns;
    private JList columnList;
    private DefaultListModel columnListModel;
    private JPanel panelExtProperties;
    private JTable extProperties;
    private JButton bnAddProperty;
    private JButton bnRemoveProperty;
    private ExtPropertiesModel model;
    private JPanel columnsView;
    private JTable columnsTable;
    private ColumnsSortOrderModel sortModel;
    private JTextArea taCommentsInRDBMS;
    private JScrollPane spCommentsInRDBMS;
    private JComboBox cbAllowRowLocks;
    private JComboBox cbAllowPageLocks;
    private JIntegerField ifMaxdop;
    private JTextField tfIndexType;
    private JComboBox cbPartitionScheme;
    private JPanel panelIncludeColumns;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel = new DefaultListModel();
    private JList allColumnsList;
    private DefaultListModel selectedColumnsModel = new DefaultListModel();
    private JButton btnUp;
    private JButton btnDown;
    private JButton btnAddColumns;
    private int preferredIconSize = 16;
    private JButton btnRemoveColumns;
    private JComboBox cbOnline;
    private JComboBox cbPartitioningColumn;
    private JComboBox cbDropExisting;

    public IndexPropertyDialogSqlServerv2k5(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.indexProxy = (IndexProxySqlServerv2k5)object;
        this.setHeight(640);
        this.initCommentsView(250);
        this.initCommentsInRDBMS();
        this.initColumnsView(this.getPane().getPreferredSize().height - 130);
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("IndexPropertyDialogSqlServerv2k5.IndexProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initIndexType();
        this.initUnique();
        this.initClustered();
        this.initFileGroup();
        this.initPartitionScheme();
        this.initPartitioningColumn();
        this.initPadIndex();
        this.initFillFactor();
        this.initRecomputeStatistics();
        this.initSortInTempDB();
        this.initIgnoreDupKey();
        this.initAllowRowLocks();
        this.initAllowPageLocks();
        this.initMaxdop();
        this.initOnline();
        this.initDropExisting();
        if (this.isEditable()) {
            this.initPropagatePropsButton();
        }
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initIndexType() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.IndexType"));
        this.general.add(label);
        this.tfIndexType = new JTextField("", 26);
        this.tfIndexType.setEditable(false);
        this.general.add(this.tfIndexType);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfIndexType, 80);
    }

    private void initUnique() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Unique"));
        this.general.add(label);
        this.tfUnique = new JTextField("", 26);
        this.tfUnique.setEditable(false);
        this.general.add(this.tfUnique);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfUnique, 110);
    }

    private void initClustered() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Clustered"));
        this.general.add(label);
        this.cbClustered = new JComboBox<String>(YES_NO);
        this.setBG(this.cbClustered);
        this.cbClustered.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbClustered);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbClustered, 140);
    }

    private void initFileGroup() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Filegroup"));
        this.general.add(label);
        this.cbFilegroup = new JComboBox();
        this.setBG(this.cbFilegroup);
        this.cbFilegroup.setPreferredSize(this.tfName.getPreferredSize());
        this.cbFilegroup.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionSchemeWillBeTaken"));
        this.general.add(this.cbFilegroup);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbFilegroup, 170);
    }

    private void initPartitionScheme() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionScheme"));
        this.general.add(label);
        this.cbPartitionScheme = new JComboBox();
        this.setBG(this.cbPartitionScheme);
        this.cbPartitionScheme.setPreferredSize(this.tfName.getPreferredSize());
        this.cbPartitionScheme.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitionSchemeWillBeTaken"));
        this.general.add(this.cbPartitionScheme);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbPartitionScheme, 200);
    }

    private void initPartitioningColumn() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PartitioningColumn"));
        this.general.add(label);
        this.cbPartitioningColumn = new JComboBox();
        this.setBG(this.cbPartitioningColumn);
        this.cbPartitioningColumn.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPartitioningColumn);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.cbPartitioningColumn, 230);
    }

    private void initPadIndex() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.PadIndex"));
        this.general.add(label);
        this.cbPadIndex = new JComboBox<String>(YES_NO);
        this.setBG(this.cbPadIndex);
        this.cbPadIndex.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbPadIndex);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.cbPadIndex, 260);
    }

    private void initFillFactor() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.FillFactor"));
        this.general.add(label);
        this.ifFillFactor = new JIntegerField(0, 26);
        this.general.add(this.ifFillFactor);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.ifFillFactor, 290);
    }

    private void initRecomputeStatistics() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.RecomputeStat"));
        this.general.add(label);
        this.cbRecomputeStatistics = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbRecomputeStatistics);
        this.cbRecomputeStatistics.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbRecomputeStatistics);
        this.setLabelConstraints(label, 320);
        this.setObjectConstraints(this.cbRecomputeStatistics, 320);
    }

    private void initSortInTempDB() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.SortInTempDB"));
        this.general.add(label);
        this.cbSortInTempDB = new JComboBox<String>(YES_NO);
        this.setBG(this.cbSortInTempDB);
        this.cbSortInTempDB.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSortInTempDB);
        this.setLabelConstraints(label, 350);
        this.setObjectConstraints(this.cbSortInTempDB, 350);
    }

    private void initIgnoreDupKey() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.IgnoreDupKey"));
        this.general.add(label);
        this.cbIgnoreDupKey = new JComboBox<String>(YES_NO);
        this.setBG(this.cbIgnoreDupKey);
        this.cbIgnoreDupKey.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbIgnoreDupKey);
        this.setLabelConstraints(label, 380);
        this.setObjectConstraints(this.cbIgnoreDupKey, 380);
    }

    private void initAllowRowLocks() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.AllowRowLocks"));
        this.general.add(label);
        this.cbAllowRowLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowRowLocks);
        this.cbAllowRowLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowRowLocks);
        this.setLabelConstraints(label, 410);
        this.setObjectConstraints(this.cbAllowRowLocks, 410);
    }

    private void initAllowPageLocks() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.AllowPageLocks"));
        this.general.add(label);
        this.cbAllowPageLocks = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbAllowPageLocks);
        this.cbAllowPageLocks.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbAllowPageLocks);
        this.setLabelConstraints(label, 440);
        this.setObjectConstraints(this.cbAllowPageLocks, 440);
    }

    private void initMaxdop() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.MaxDop"));
        this.general.add(label);
        this.ifMaxdop = new JIntegerField(0, 26);
        this.general.add(this.ifMaxdop);
        this.setLabelConstraints(label, 470);
        this.setObjectConstraints(this.ifMaxdop, 470);
    }

    private void initOnline() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.Online"));
        this.general.add(label);
        this.cbOnline = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbOnline);
        this.cbOnline.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOnline);
        this.setLabelConstraints(label, 500);
        this.setObjectConstraints(this.cbOnline, 500);
    }

    private void initDropExisting() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.DropExisting"));
        this.general.add(label);
        this.cbDropExisting = new JComboBox<String>(IndexProxySqlServerv2k5.ON_OFF_CHOICES);
        this.setBG(this.cbDropExisting);
        this.cbDropExisting.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbDropExisting);
        this.setLabelConstraints(label, 530);
        this.setObjectConstraints(this.cbDropExisting, 530);
    }

    private void initPropagatePropsButton() {
        JButton bnPropagateProps = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.PropagateProperties"));
        bnPropagateProps.setIcon(this.getAppView().getConfiguration().getIcon("PROPS_PROPAGATION", 16));
        bnPropagateProps.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ArrayList list = new ArrayList();
                list.addAll(IndexPropertyDialogSqlServerv2k5.this.getStorageDesign().getIndexProxySet().getElements());
                list.remove(IndexPropertyDialogSqlServerv2k5.this.indexProxy);
                new PropertiesPropagationDialog(IndexPropertyDialogSqlServerv2k5.this.getAppView(), IndexPropertyDialogSqlServerv2k5.this.indexProxy, list).showDialog();
            }
        });
        this.general.add(bnPropagateProps);
        this.setObjectConstraints(bnPropagateProps, 10, 560);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initExtProperties();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 550));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getExtPropertiesLayout() {
        return (SpringLayout)this.panelExtProperties.getLayout();
    }

    private void initExtProperties() {
        this.initAllExtProperties();
        this.initExtPropertiesButtons();
    }

    private void initExtPropertiesButtons() {
        this.bnAddProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.Add"));
        this.bnAddProperty.setEnabled(this.isEditable());
        this.bnRemoveProperty = new JButton(Messages.getString("IndexPropertyDialogSqlServerv2k5.Remove"));
        this.bnRemoveProperty.setEnabled(this.isEditable());
        this.bnAddProperty.addActionListener(new AddExtPropertyActionListener());
        this.panelExtProperties.add(this.bnAddProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnAddProperty, 5, 540);
        this.bnRemoveProperty.addActionListener(new RemoveExtPropertyActionListener());
        this.panelExtProperties.add(this.bnRemoveProperty);
        this.setObjectConstraints(this.getExtPropertiesLayout(), this.bnRemoveProperty, 70, 540);
        IndexPropertyDialogSqlServerv2k5.equalizeButtonSizes(this.bnAddProperty, this.bnRemoveProperty);
    }

    private void initAllExtProperties() {
        this.panelExtProperties = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.ExtendedProperties"), this.panelExtProperties);
        this.extProperties = new ExtProperties();
        this.extProperties.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.extProperties.setPreferredScrollableViewportSize(new Dimension(416, 530));
        JScrollPane pane = new JScrollPane(this.extProperties);
        pane.setPreferredSize(new Dimension(416, 530));
        this.model = (ExtPropertiesModel)this.extProperties.getModel();
        this.setBG(this.extProperties);
        this.panelExtProperties.add(pane);
    }

    private void initCommentsInRDBMS() {
        JLabel label = new JLabel(Messages.getString("IndexPropertyDialogSqlServerv2k5.CommentsInRDBMS"));
        this.comments.add(label);
        this.setLabelConstraints(this.getCommentsLayout(), label, 10, 270);
        this.taCommentsInRDBMS = new JTextArea();
        this.spCommentsInRDBMS = new JScrollPane(this.taCommentsInRDBMS);
        this.spCommentsInRDBMS.setPreferredSize(new Dimension(395, 270));
        this.spCommentsInRDBMS.setBorder(BorderFactory.createEtchedBorder(0));
        this.taCommentsInRDBMS.setLineWrap(true);
        this.comments.add(this.spCommentsInRDBMS);
        this.setObjectConstraints(this.getCommentsLayout(), this.spCommentsInRDBMS, 10, 290);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.indexProxy.getName());
        this.tfName.setText(this.indexProxy.getName());
        ColumnProxy[] proxies = this.indexProxy.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        this.tfTable.setText(this.indexProxy.getTableName());
        this.tfUnique.setText(this.indexProxy.getUnique());
        if (this.indexProxy.isClustered()) {
            this.cbClustered.setSelectedItem(YES);
        } else {
            this.cbClustered.setSelectedItem(NO);
        }
        this.cbFilegroup.addItem(null);
        this.cbPartitionScheme.addItem(null);
        DataBaseSqlServerv2k5 db = (DataBaseSqlServerv2k5)((TableProxySqlServer)this.indexProxy.getTableProxy()).getDatabase();
        if (db != null) {
            for (FileGroupSqlServer fg : (StorageObjectCollection)db.getChild(0)) {
                this.cbFilegroup.addItem(fg);
            }
            this.cbFilegroup.setSelectedItem(this.indexProxy.getFilegroup());
            for (PartitionFunctionSqlServerv2k5 partFunc : db.getPartitionFunction()) {
                Iterator partSchemeIt = partFunc.getPartitionScheme().iterator();
                while (partSchemeIt.hasNext()) {
                    this.cbPartitionScheme.addItem(partSchemeIt.next());
                }
            }
            this.cbPartitionScheme.setSelectedItem(this.indexProxy.getPartitionScheme());
        }
        if (this.indexProxy.getExtPropsSet() != null) {
            Object[] props = this.indexProxy.getExtPropsSet().toArray();
            for (int i = 0; i < props.length; ++i) {
                String p = (String)props[i];
                String pplus = (String)props[++i];
                Object[] obj = new Object[]{p, pplus};
                this.model.addRow(obj);
            }
        }
        this.cbPadIndex.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getPadIndex()));
        this.ifFillFactor.setValue((long)this.indexProxy.getFillFactor());
        this.cbRecomputeStatistics.setSelectedItem(this.indexProxy.getRecomputeStatistics());
        this.cbSortInTempDB.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getSortInTempDB()));
        this.cbIgnoreDupKey.setSelectedItem(IndexPropertyDialogSqlServerv2k5.translateYesNoForDisplay(this.indexProxy.getIgnoreDupKey()));
        this.tfIndexType.setText(this.indexProxy.getIndexType());
        if (this.indexProxy.getUnique().equalsIgnoreCase("NO")) {
            this.cbIgnoreDupKey.setEnabled(false);
        }
        this.comment = this.indexProxy.getObject().getComment();
        this.commentInRDBMS = this.indexProxy.getObject().getCommentInRDBMS();
        if (this.indexProxy.isCommentChanged()) {
            this.getCommentsList().insert(this.indexProxy.getComment(), 0);
        } else {
            this.getCommentsList().insert(this.comment, 0);
        }
        if (this.indexProxy.isCommentInRDBMSChanged()) {
            this.taCommentsInRDBMS.insert(this.indexProxy.getCommentInRDBMS(), 0);
        } else {
            this.taCommentsInRDBMS.insert(this.commentInRDBMS, 0);
        }
        this.fillComboItems(this.indexProxy.getTableProxy().getColumnProxies(), this.cbPartitioningColumn);
        this.cbPartitioningColumn.setSelectedItem(this.indexProxy.getPartitioningColumn());
        this.initColumnsSortOrder();
        this.cbAllowRowLocks.setSelectedItem(this.indexProxy.getAllowRowLocks());
        this.cbAllowPageLocks.setSelectedItem(this.indexProxy.getAllowPageLocks());
        this.ifMaxdop.setValue((long)this.indexProxy.getMaxdop());
        this.cbOnline.setSelectedItem(this.indexProxy.getOnlineChoise());
        this.cbDropExisting.setSelectedItem(this.indexProxy.getDropExisting());
        this.cbDropExisting.setEnabled(this.indexProxy.isPrimaryXmlIndex());
        Index index = (Index)this.indexProxy.getObject();
        Column[] columns = (Column[])this.indexProxy.getTable().getElements();
        for (int i = 0; i < columns.length; ++i) {
            if (!this.indexProxy.getIncludeColumnsSet().contains(columns[i].getObjectID())) continue;
            this.selectedColumnsModel.addElement(columns[i]);
        }
        ContainedObject[] cols = this.indexProxy.getTable().getElements();
        List<ContainedObject> indexCols = Arrays.asList(index.getElements());
        for (int i = 0; i < cols.length; ++i) {
            if (this.selectedColumnsModel.contains(cols[i]) || indexCols.contains(cols[i])) continue;
            this.allColumnsModel.addElement(cols[i]);
        }
        this.initIncludeColumnsView();
        this.setEnableComponent(!this.indexProxy.isPrimaryXmlIndex());
    }

    @Override
    protected void setProperties() {
        if (this.indexProxy != null) {
            this.indexProxy.setName(this.tfName.getText());
            if (((String)this.cbClustered.getSelectedItem()).equalsIgnoreCase(YES)) {
                this.indexProxy.setClustered(true);
            } else {
                this.indexProxy.setClustered(false);
            }
            this.indexProxy.setFilegroup((FileGroupSqlServer)this.cbFilegroup.getSelectedItem());
            this.indexProxy.setPadIndex(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbPadIndex.getSelectedItem()));
            this.indexProxy.setRecomputeStatistics((String)this.cbRecomputeStatistics.getSelectedItem());
            this.indexProxy.setSortInTempDB(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbSortInTempDB.getSelectedItem()));
            this.indexProxy.setIgnoreDupKey(IndexPropertyDialogSqlServerv2k5.translateYesNoForStorage((String)this.cbIgnoreDupKey.getSelectedItem()));
            this.indexProxy.setFillFactor(this.ifFillFactor.getIntValue());
            this.ifFillFactor.setValue((long)this.indexProxy.getFillFactor());
            this.indexProxy.setAllowRowLocks((String)this.cbAllowRowLocks.getSelectedItem());
            this.indexProxy.setAllowPageLocks((String)this.cbAllowPageLocks.getSelectedItem());
            this.indexProxy.setMaxdop(this.ifMaxdop.getIntValue());
            this.indexProxy.setPartitionScheme((PartitionSchemeSqlServer)this.cbPartitionScheme.getSelectedItem());
            this.indexProxy.setOnlineChoise((String)this.cbOnline.getSelectedItem());
            this.indexProxy.setPartitioningColumn((ColumnProxy)this.cbPartitioningColumn.getSelectedItem());
            this.indexProxy.setDropExisting((String)this.cbDropExisting.getSelectedItem());
            Object[] propSet = this.model.getRows();
            this.indexProxy.clear();
            String name = null;
            String value = null;
            for (int i = 0; i < propSet.length; ++i) {
                Object pr = propSet[i];
                if (!(pr instanceof String)) continue;
                StringTokenizer st = new StringTokenizer(pr.toString(), ",");
                if (st.hasMoreTokens()) {
                    name = st.nextToken().trim();
                }
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken().trim();
                this.indexProxy.setProps(name);
                this.indexProxy.setProps(value);
            }
            this.applyColumnsSortOrder();
            String commentText = this.getCommentsList().getText();
            if (StringUtilities.isNotEmpty(commentText) && !this.comment.equalsIgnoreCase(commentText)) {
                this.indexProxy.setComment(commentText);
                this.indexProxy.setCommentChanged(true);
            } else {
                this.indexProxy.setComment("");
                this.indexProxy.setCommentChanged(false);
            }
            String commentInRDBMSText = this.taCommentsInRDBMS.getText();
            if (StringUtilities.isNotEmpty(commentInRDBMSText) && !this.commentInRDBMS.equalsIgnoreCase(commentInRDBMSText)) {
                this.indexProxy.setCommentInRDBMS(commentInRDBMSText);
                this.indexProxy.setCommentInRDBMSChanged(true);
            } else {
                this.indexProxy.setCommentInRDBMS("");
                this.indexProxy.setCommentInRDBMSChanged(false);
            }
            this.indexProxy.clear();
            Object[] selectedColumns = this.selectedColumnsModel.toArray();
            for (int i = 0; i < selectedColumns.length; ++i) {
                if (!(selectedColumns[i] instanceof Column)) continue;
                Column col = (Column)selectedColumns[i];
                this.indexProxy.setIncludeColumns(col.getObjectID());
            }
        }
    }

    protected void initColumnsView(int height) {
        this.columnsView = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.ColumnsSortOrder"), this.columnsView);
        this.columnsTable = new JTable();
        SimpleAttributeSet as = new SimpleAttributeSet();
        StyleConstants.setAlignment(as, 0);
        JScrollPane sp = new JScrollPane(this.columnsTable);
        sp.setPreferredSize(new Dimension(395, height));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columnsView.add(sp);
    }

    protected void initColumnsSortOrder() {
        this.sortModel = new ColumnsSortOrderModel((Index)this.indexProxy.getObject());
        this.columnsTable.setModel(this.sortModel);
        this.sortModel.setUpSortOrderColumn(this.columnsTable.getColumnModel().getColumn(1));
    }

    protected void applyColumnsSortOrder() {
        Collection colNodes = this.sortModel.getColumnsSortOrederColl();
        Iterator it = colNodes.iterator();
        Index ind = (Index)this.indexProxy.getObject();
        while (it.hasNext()) {
            ColumnsSortOrderModel.ColumnNode cn = (ColumnsSortOrderModel.ColumnNode)it.next();
            Column col = (Column)ind.getElementByID(cn.objectId);
            if (col == null) continue;
            ind.setColumnSortOrder(col, cn.sortOrder);
        }
    }

    private void initIncludeColumnsView() {
        this.panelIncludeColumns = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("IndexPropertyDialogSqlServerv2k5.IncludeColumns"), this.panelIncludeColumns);
        this.initIncludeColumns();
    }

    private void initIncludeColumns() {
        this.initAllColumnsList();
        if (this.isEditable()) {
            this.initColumnsButtons();
        }
        this.initSelectedColumnsList();
    }

    private void initAllColumnsList() {
        JPanel columnList = new JPanel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(180, 550));
        columnList.add(sp);
        this.panelIncludeColumns.add((Component)columnList, "West");
    }

    private void initSelectedColumnsList() {
        JPanel selectedList = new JPanel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(180, 550));
        selectedList.add(sp);
        this.panelIncludeColumns.add((Component)selectedList, "East");
    }

    private void initColumnsButtons() {
        JPanel buttonsPanel = new JPanel();
        JToolBar toolBar = new JToolBar(1);
        toolBar.setFloatable(false);
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddColumns = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddColumns.addActionListener(new AddColumnsActionListener());
        this.btnAddColumns.setEnabled(false);
        this.btnAddColumns.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.Add"));
        this.btnRemoveColumns = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveColumns.setEnabled(false);
        this.btnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveColumns.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.Remove"));
        this.btnUp = new JButton(configuration.getIcon("MOVE_UP_ICON", this.getPreferredIconSize()));
        this.btnUp.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.MoveUp"));
        this.btnUp.addActionListener(new MoveUpAction());
        this.btnDown = new JButton(configuration.getIcon("MOVE_DOWN_ICON", this.getPreferredIconSize()));
        this.btnDown.setToolTipText(Messages.getString("IndexPropertyDialogSqlServerv2k5.MoveDown"));
        this.btnDown.addActionListener(new MoveDownAction());
        this.btnUp.setEnabled(false);
        this.btnDown.setEnabled(false);
        toolBar.add(this.btnAddColumns);
        toolBar.add(this.btnRemoveColumns);
        toolBar.addSeparator();
        toolBar.add(this.btnUp);
        toolBar.add(this.btnDown);
        buttonsPanel.add(toolBar);
        buttonsPanel.setPreferredSize(new Dimension(32, 350));
        this.panelIncludeColumns.add((Component)buttonsPanel, "Center");
    }

    public boolean moveToIndex(Object object, int index) {
        if (this.selectedColumnsModel.contains(object) && this.selectedColumnsModel.size() > index && index >= 0) {
            this.selectedColumnsModel.removeElement(object);
            this.selectedColumnsModel.add(index, object);
            return true;
        }
        return false;
    }

    public int getPreferredIconSize() {
        return this.preferredIconSize;
    }

    private List getComponentsList() {
        ArrayList<JComponent> list = new ArrayList<JComponent>();
        list.add(this.tfUnique);
        list.add(this.cbClustered);
        list.add(this.cbFilegroup);
        list.add(this.cbPartitionScheme);
        list.add(this.cbPartitioningColumn);
        list.add(this.panelIncludeColumns);
        return list;
    }

    private void setEnableComponent(boolean enabled) {
        for (JComponent component : this.getComponentsList()) {
            int index = this.getPane().indexOfComponent(component);
            if (index > -1) {
                this.getPane().setEnabledAt(index, enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
    }

    private class MoveDownAction
    implements ActionListener {
        private MoveDownAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[selection.length - 1]) < IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.size() - 1) {
                for (int i = selection.length - 1; i > -1; --i) {
                    objectNumber = selection[i];
                    Object obj = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.get(objectNumber);
                    IndexPropertyDialogSqlServerv2k5.this.moveToIndex(obj, objectNumber + 1);
                    selection[i] = objectNumber + 1;
                }
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.setSelectedIndices(selection);
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class MoveUpAction
    implements ActionListener {
        private MoveUpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber;
            int[] selection = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndices();
            if (selection.length > 0 && (objectNumber = selection[0]) > 0) {
                for (int i = 0; i < selection.length; ++i) {
                    objectNumber = selection[i];
                    Object obj = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.get(objectNumber);
                    IndexPropertyDialogSqlServerv2k5.this.moveToIndex(obj, objectNumber - 1);
                    selection[i] = objectNumber - 1;
                }
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.setSelectedIndices(selection);
                IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.updateUI();
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.contains(ob)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.addElement(ob);
                    IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogSqlServerv2k5.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogSqlServerv2k5.this.btnRemoveColumns.setEnabled(false);
                    IndexPropertyDialogSqlServerv2k5.this.btnUp.setEnabled(false);
                    IndexPropertyDialogSqlServerv2k5.this.btnDown.setEnabled(false);
                } else {
                    IndexPropertyDialogSqlServerv2k5.this.btnRemoveColumns.setEnabled(true);
                    IndexPropertyDialogSqlServerv2k5.this.btnUp.setEnabled(true);
                    IndexPropertyDialogSqlServerv2k5.this.btnDown.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = IndexPropertyDialogSqlServerv2k5.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.contains(ob)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.allColumnsModel.addElement(ob);
                    IndexPropertyDialogSqlServerv2k5.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (IndexPropertyDialogSqlServerv2k5.this.isEditable() && !e.getValueIsAdjusting()) {
                if (IndexPropertyDialogSqlServerv2k5.this.allColumnsList.getSelectedIndex() == -1) {
                    IndexPropertyDialogSqlServerv2k5.this.btnAddColumns.setEnabled(false);
                } else {
                    IndexPropertyDialogSqlServerv2k5.this.btnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveExtPropertyActionListener
    implements ActionListener {
        private RemoveExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() >= 1) {
                for (int i = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1; i >= 0; --i) {
                    if (!IndexPropertyDialogSqlServerv2k5.this.extProperties.isRowSelected(i)) continue;
                    IndexPropertyDialogSqlServerv2k5.this.model.removeRow(i);
                }
                IndexPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            }
        }
    }

    private class AddExtPropertyActionListener
    implements ActionListener {
        private AddExtPropertyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String propertyName = "";
            String propertyValue = "";
            IndexPropertyDialogSqlServerv2k5.this.model.addRow(new Object[]{propertyName, propertyValue});
            IndexPropertyDialogSqlServerv2k5.this.extProperties.updateUI();
            IndexPropertyDialogSqlServerv2k5.this.extProperties.changeSelection(IndexPropertyDialogSqlServerv2k5.this.model.getRowCount() - 1, 0, false, false);
            IndexPropertyDialogSqlServerv2k5.this.extProperties.requestFocus();
        }
    }

    class ExtPropertiesCellRenderer
    extends JLabel
    implements TableCellRenderer {
        ExtPropertiesCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setOpaque(true);
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
                this.setForeground(table.getSelectionForeground());
            } else {
                this.setBackground(table.getBackground());
                this.setForeground(table.getForeground());
            }
            this.setHorizontalAlignment(2);
            this.setText(value == null ? "" : "  " + value.toString());
            return this;
        }
    }

    class ExtProperties
    extends JTable {
        ExtPropertiesModel dataModel;

        public ExtProperties() {
            this.dataModel = new ExtPropertiesModel();
            this.setModel(this.dataModel);
            TableColumnModel tableColumn = this.getColumnModel();
            for (int i = 0; i < 2; ++i) {
                tableColumn.getColumn(i).setCellRenderer(new ExtPropertiesCellRenderer());
            }
            this.initColumnSizes();
        }

        public void clearTable() {
            int rows = this.dataModel.getRowCount();
            for (int i = rows - 1; i > -1; --i) {
                this.dataModel.removeRow(i);
            }
        }

        public JTableHeader getHeader() {
            return this.tableHeader;
        }

        private void initColumnSizes() {
            TableColumn column = null;
            for (int i = 0; i < 2; ++i) {
                column = this.getColumnModel().getColumn(i);
                if (i == 0) {
                    column.setPreferredWidth(50);
                    continue;
                }
                if (i != 1) continue;
                column.setPreferredWidth(150);
            }
        }
    }

    class ExtPropertiesModel
    extends DefaultTableModel {
        String[] cNames = new String[]{Messages.getString("IndexPropertyDialogSqlServerv2k5.PropertyName"), Messages.getString("IndexPropertyDialogSqlServerv2k5.PropertyValue")};

        ExtPropertiesModel() {
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return IndexPropertyDialogSqlServerv2k5.this.isEditable();
        }

        @Override
        public String getColumnName(int column) {
            return this.cNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.cNames.length;
        }

        @Override
        public int getRowCount() {
            if (this.dataVector == null) {
                return 0;
            }
            return this.dataVector.size();
        }

        public void setData(Vector data) {
            this.dataVector = data;
        }

        public Vector getData() {
            return this.dataVector;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public Object[] getColumnData(int column) {
            int rowCount = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                data[i] = this.getValueAt(i, column);
            }
            return data;
        }

        public Object[] getPropertyNameColumn() {
            int rowCount = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            return data;
        }

        public Object[] getRows() {
            int rowCount = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                String couple = (String)this.getValueAt(i, 0) + "," + (String)this.getValueAt(i, 1);
                data[i] = couple;
            }
            return data;
        }

        public Object[] getPropertyValueColumn() {
            int rowCount = IndexPropertyDialogSqlServerv2k5.this.model.getRowCount();
            Object[] data = new Object[rowCount];
            for (int i = 0; i < rowCount; ++i) {
                if (this.getValueAt(i, 2) == null || ((String)this.getValueAt(i, 2)).trim().equalsIgnoreCase("")) continue;
                data[i] = this.getValueAt(i, 2);
            }
            return data;
        }

        public void tableChanged(TableModelEvent e) {
            this.fireTableChanged(e);
        }
    }
}

