/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListSelectionModel;
import javax.swing.SpringLayout;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.Trigger;
import oracle.dbtools.crest.model.design.storage.oracle.TriggerOracle;
import oracle.dbtools.crest.model.design.storage.oracle.UserOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.StorageDesignOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.ColumnProxyOraclev9i;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.TriggerOraclev9i;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.SQLSyntaxTextArea;
import oracle.dbtools.crest.util.options.Settings;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;

public class TriggerPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private TriggerOraclev9i trigger;
    private JComboBox cbOwner;
    private JComboBox cbTriggeringTime;
    private JComboBox cbScope;
    private JComboBox cbState;
    private JComboBox cbCrossEdition = null;
    private JTextField tfTable;
    private JTextField tfCondition;
    private JTextField tfRef_OLD_AS;
    private JTextField tfRef_NEW_AS;
    private JTextField tfRef_PARENT_AS;
    private JPanel panelColumns;
    private JPanel panelBody = new JPanel(new SpringLayout());
    private JList allColumnsList;
    private JList selectedColumnsList;
    private DefaultListModel allColumnsModel;
    private DefaultListModel selectedColumnsModel;
    private JButton bnAddColumns;
    private JButton bnRemoveColumns;
    private RSyntaxTextArea bodyArea;
    private JLabel tableLabel;
    private JCheckBox chbInsert;
    private JCheckBox chbUpdate;
    private JCheckBox chbDelete;

    public TriggerPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.trigger = (TriggerOraclev9i)object;
        this.setHeight(400);
        this.initCommentsView();
        int w = 505;
        int h = 480;
        Settings.DialogSettings ds = this.getAppView().getSettings().getDialogSettings(this.getClass().getName());
        if (ds == null) {
            this.setSize(w, h);
            CommonUtil.centerOnScreen(this);
        } else {
            w = Math.max(w, (int)ds.rec.getSize().getWidth());
            h = Math.max(h, (int)ds.rec.getSize().getHeight());
            this.setSize(w, h);
            this.setLocation(ds.rec.getLocation());
        }
        this.initProperties();
    }

    @Override
    protected int getDialogWidth() {
        return 490;
    }

    @Override
    public String getCaption() {
        return Messages.getString("TriggerPropertyDialogOraclev9i.TriggerProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initOwner();
        this.initAction();
        this.initTriggeringTime();
        this.initScope();
        this.initState();
        this.initRef_OLD_AS();
        this.initRef_NEW_AS();
        this.initRef_PARENT_AS();
    }

    @Override
    protected void addTabs() {
        this.initBodyView();
    }

    private void initColumnsView() {
        this.panelColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogOraclev9i.UpdateColumns"), this.panelColumns);
        this.initColumns();
    }

    private void initColumns() {
        this.initAllColumnsList();
        this.initSelectedColumnsList();
        this.initColumnsButtons();
    }

    private void initAllColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.AllColumns"));
        this.panelColumns.add(label);
        this.allColumnsModel = new DefaultListModel();
        this.allColumnsList = new JList(this.allColumnsModel);
        ListSelectionModel listSelectionModel = this.allColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allColumnsList);
        sp.setPreferredSize(new Dimension(144, 300));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 12, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 38);
    }

    private void initSelectedColumnsList() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.SelectedColumns"));
        this.panelColumns.add(label);
        this.selectedColumnsModel = new DefaultListModel();
        this.selectedColumnsList = new JList(this.selectedColumnsModel);
        ListSelectionModel listSelectionModel = this.selectedColumnsList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedColumnsList);
        sp.setPreferredSize(new Dimension(145, 300));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelColumns.add(sp);
        this.setLabelConstraints(this.getColumnsLayout(), label, 292, 20);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 290, 38);
    }

    private void initColumnsButtons() {
        this.bnAddColumns = new JButton(Messages.getString("TriggerPropertyDialogOraclev9i.Add"));
        this.bnAddColumns.addActionListener(new AddColumnsActionListener());
        this.bnAddColumns.setEnabled(false);
        this.panelColumns.add(this.bnAddColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnAddColumns, 175, 135);
        this.bnRemoveColumns = new JButton(Messages.getString("TriggerPropertyDialogOraclev9i.Remove"));
        this.bnRemoveColumns.setEnabled(false);
        this.bnRemoveColumns.addActionListener(new RemoveColumnsActionListener());
        this.panelColumns.add(this.bnRemoveColumns);
        this.setObjectConstraints(this.getColumnsLayout(), this.bnRemoveColumns, 175, 165);
        TriggerPropertyDialogOraclev9i.equalizeButtonSizes(this.bnAddColumns, this.bnRemoveColumns);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.panelColumns.getLayout();
    }

    protected SpringLayout getBodyLayout() {
        return (SpringLayout)this.panelBody.getLayout();
    }

    private void initBodyView() {
        this.panelBody = new JPanel(new BorderLayout());
        this.getPane().addTab(Messages.getString("TriggerPropertyDialogOraclev9i.TriggerBody"), this.panelBody);
        this.initBody();
    }

    private void initBody() {
        this.bodyArea = new SQLSyntaxTextArea(false);
        RTextScrollPane sp = new RTextScrollPane((RTextArea)this.bodyArea);
        sp.setPreferredSize(new Dimension(420, 330));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.panelBody.add((Component)sp);
    }

    private void initTable() {
        this.tableLabel = new JLabel();
        this.general.add(this.tableLabel);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEnabled(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(this.tableLabel, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initOwner() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.User"));
        this.general.add(label);
        this.cbOwner = new JComboBox();
        this.setBG(this.cbOwner);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getUserSet().toArray(), this.cbOwner);
        }
        this.cbOwner.removeItem(this.getStorageDesign().getUserSet().getByName("PUBLIC"));
        this.cbOwner.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbOwner);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.cbOwner, 80);
    }

    private void initAction() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Action"));
        this.general.add(label);
        this.setLabelConstraints(label, 110);
        this.chbInsert = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.INSERT"));
        this.chbUpdate = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.UPDATE"));
        this.chbDelete = new JCheckBox(Messages.getString("TriggerPropertyDialogOraclev9i.DELETE"));
        this.general.add(this.chbInsert);
        this.general.add(this.chbUpdate);
        this.general.add(this.chbDelete);
        this.setObjectConstraints(this.chbInsert, 122, 105);
        this.setObjectConstraints(this.chbUpdate, 220, 105);
        this.setObjectConstraints(this.chbDelete, 320, 105);
    }

    private void initTriggeringTime() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.TriggeringTime"));
        this.general.add(label);
        this.cbTriggeringTime = new JComboBox<String>(TriggerOracle.getTriggerTimes());
        this.setBG(this.cbTriggeringTime);
        this.cbTriggeringTime.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTriggeringTime);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbTriggeringTime, 140);
    }

    private void initScope() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Scope"));
        this.general.add(label);
        this.cbScope = new JComboBox<String>(TriggerOracle.SCOPE_TYPES);
        this.setBG(this.cbScope);
        this.cbScope.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbScope);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbScope, 170);
    }

    private void initState() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.State"));
        this.general.add(label);
        this.cbState = new JComboBox<String>(TriggerOracle.STATE_TYPES);
        this.setBG(this.cbState);
        this.cbState.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbState);
        this.setLabelConstraints(label, 200);
        this.setObjectConstraints(this.cbState, 200);
    }

    private void initRef_OLD_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefOLDAS"));
        this.general.add(label);
        this.tfRef_OLD_AS = new JTextField("", 26);
        this.general.add(this.tfRef_OLD_AS);
        this.setLabelConstraints(label, 230);
        this.setObjectConstraints(this.tfRef_OLD_AS, 230);
    }

    private void initRef_NEW_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefNEWAS"));
        this.general.add(label);
        this.tfRef_NEW_AS = new JTextField("", 26);
        this.general.add(this.tfRef_NEW_AS);
        this.setLabelConstraints(label, 260);
        this.setObjectConstraints(this.tfRef_NEW_AS, 260);
    }

    private void initRef_PARENT_AS() {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.RefPARENTAS"));
        this.general.add(label);
        this.tfRef_PARENT_AS = new JTextField("", 26);
        this.general.add(this.tfRef_PARENT_AS);
        this.setLabelConstraints(label, 290);
        this.setObjectConstraints(this.tfRef_PARENT_AS, 290);
    }

    private void initCrossEdition(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.CrossEdition"));
        this.general.add(label);
        this.cbCrossEdition = new JComboBox<String>(TriggerOracle.getCrossEditions());
        this.setBG(this.cbCrossEdition);
        this.cbCrossEdition.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCrossEdition);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbCrossEdition, yCoord);
    }

    private void initCondition(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TriggerPropertyDialogOraclev9i.Condition"));
        this.general.add(label);
        this.tfCondition = new JTextField("", 26);
        this.general.add(this.tfCondition);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfCondition, yCoord);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.trigger.getName());
        this.tfName.setText(this.trigger.getName());
        this.tfTable.setText(this.trigger.getTable() != null ? this.trigger.getTable().getName() : this.trigger.getView().getName());
        this.cbOwner.setSelectedItem(this.trigger.getOwner());
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[0])) {
            this.chbInsert.setSelected(true);
        } else {
            this.chbInsert.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[1])) {
            this.chbUpdate.setSelected(true);
        } else {
            this.chbUpdate.setSelected(false);
        }
        if (this.trigger.getActionSet().contains(Trigger.ACTION_TYPES[2])) {
            this.chbDelete.setSelected(true);
        } else {
            this.chbDelete.setSelected(false);
        }
        this.initDifferences();
        if (!(this.storageDesign instanceof StorageDesignOraclev11g)) {
            this.cbTriggeringTime.removeItem("COMPOUND");
        }
        this.cbTriggeringTime.setSelectedItem(this.trigger.getTriggerTime());
        this.cbScope.setSelectedItem(this.trigger.getScope());
        this.cbState.setSelectedItem(this.trigger.getState());
        this.tfRef_OLD_AS.setText(this.trigger.getRef_OLD_AS());
        this.tfRef_NEW_AS.setText(this.trigger.getRef_NEW_AS());
        this.tfRef_PARENT_AS.setText(this.trigger.getRef_PARENT_AS());
        this.tfCondition.setText(this.trigger.getCondition());
        this.bodyArea.setText(this.trigger.getBody());
        this.bodyArea.setCaretPosition(0);
        this.getCommentsList().insert(this.trigger.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.trigger != null) {
            this.trigger.setOwner((UserOracle)this.cbOwner.getSelectedItem());
            this.trigger.setName(this.tfName.getText());
            this.setDifferences();
            this.trigger.clearActions();
            if (this.chbInsert.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[0]);
            }
            if (this.chbUpdate.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[1]);
            }
            if (this.chbDelete.isSelected()) {
                this.trigger.setActions(Trigger.ACTION_TYPES[2]);
            }
            this.trigger.setTriggerTime((String)this.cbTriggeringTime.getSelectedItem());
            this.trigger.setScope((String)this.cbScope.getSelectedItem());
            this.trigger.setState((String)this.cbState.getSelectedItem());
            this.trigger.setRef_OLD_AS(this.tfRef_OLD_AS.getText());
            this.trigger.setRef_NEW_AS(this.tfRef_NEW_AS.getText());
            this.trigger.setRef_PARENT_AS(this.tfRef_PARENT_AS.getText());
            if (this.cbCrossEdition != null) {
                this.trigger.setCrossEdition(TriggerPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbCrossEdition.getSelectedItem()));
            }
            this.trigger.setBody(this.bodyArea.getText());
            this.trigger.setCondition(this.tfCondition.getText());
            this.trigger.setComment(this.getCommentsList().getText());
        }
    }

    private void initDifferences() {
        int yCoord = 320;
        if (this.trigger.getTable() != null) {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogOraclev9i.Table"));
            this.chbUpdate.addActionListener(new UpdateListener());
            this.initColumnsView();
            ColumnProxy[] columnSet = this.trigger.getTable().getColumnProxies();
            block0: for (String colId : this.trigger.getColumnSet()) {
                for (int i = 0; i < columnSet.length; ++i) {
                    ColumnProxy col = columnSet[i];
                    if (!col.getObjectID().equals(colId)) continue;
                    this.selectedColumnsModel.addElement(col);
                    continue block0;
                }
            }
            for (int i = 0; i < columnSet.length; ++i) {
                ColumnProxy column = columnSet[i];
                if (this.selectedColumnsModel.contains(column)) continue;
                this.allColumnsModel.addElement(column);
            }
            this.allColumnsList.setEnabled(this.chbUpdate.isSelected());
            this.selectedColumnsList.setEnabled(this.chbUpdate.isSelected());
            if (!this.chbUpdate.isSelected()) {
                this.allColumnsList.setSelectedIndices(new int[0]);
                this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
            if (this.storageDesign instanceof StorageDesignOraclev11g) {
                this.initCrossEdition(yCoord);
                yCoord += 30;
                this.cbCrossEdition.setSelectedItem(TriggerPropertyDialogOraclev9i.translateYesNoForDisplay(this.trigger.getCrossEdition()));
            }
            this.cbTriggeringTime.removeItem("INSTEAD OF");
        } else {
            this.tableLabel.setText(Messages.getString("TriggerPropertyDialogOraclev9i.View"));
        }
        this.initCondition(yCoord);
    }

    private void setDifferences() {
        if (this.trigger.getTable() != null) {
            Object[] columnSet = this.selectedColumnsModel.toArray();
            this.trigger.clear();
            for (int i = 0; i < columnSet.length; ++i) {
                Object ob = columnSet[i];
                if (!(ob instanceof ColumnProxyOraclev9i)) continue;
                this.trigger.setColumns(((ColumnProxyOraclev9i)ob).getObjectID());
            }
        }
    }

    @Override
    protected boolean allowName(String newName) {
        Object selectedUser = this.cbOwner.getSelectedItem();
        if (selectedUser instanceof UserOracle) {
            newName = ((UserOracle)selectedUser).getName() + '.' + newName;
        }
        return this.getStorageObject().allowName(newName, true);
    }

    public class UpdateListener
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            TriggerPropertyDialogOraclev9i.this.allColumnsList.setEnabled(TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected());
            TriggerPropertyDialogOraclev9i.this.selectedColumnsList.setEnabled(TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected());
            if (!TriggerPropertyDialogOraclev9i.this.chbUpdate.isSelected()) {
                TriggerPropertyDialogOraclev9i.this.allColumnsList.setSelectedIndices(new int[0]);
                TriggerPropertyDialogOraclev9i.this.selectedColumnsList.setSelectedIndices(new int[0]);
            }
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogOraclev9i.this.bnRemoveColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogOraclev9i.this.bnRemoveColumns.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogOraclev9i.this.selectedColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogOraclev9i.this.allColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogOraclev9i.this.allColumnsModel.addElement(ob);
                    TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.removeElement(ob);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (TriggerPropertyDialogOraclev9i.this.isEditable() && !e.getValueIsAdjusting()) {
                if (TriggerPropertyDialogOraclev9i.this.allColumnsList.getSelectedIndex() == -1) {
                    TriggerPropertyDialogOraclev9i.this.bnAddColumns.setEnabled(false);
                } else {
                    TriggerPropertyDialogOraclev9i.this.bnAddColumns.setEnabled(true);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!TriggerPropertyDialogOraclev9i.this.allColumnsModel.isEmpty()) {
                Object[] selectedObjects = TriggerPropertyDialogOraclev9i.this.allColumnsList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.contains(ob)) continue;
                    TriggerPropertyDialogOraclev9i.this.selectedColumnsModel.addElement(ob);
                    TriggerPropertyDialogOraclev9i.this.allColumnsModel.removeElement(ob);
                }
            }
        }
    }
}

