/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v9i;

import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.IndexGlobalPartitionOracle;
import oracle.dbtools.crest.model.design.storage.oracle.SegmentOracle;
import oracle.dbtools.crest.model.design.storage.oracle.TableSpaceOracle;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.oracle.AbstractOraclePropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;

public class PartitionPropertyDialogOraclev9i
extends AbstractOraclePropertyDialog {
    private IndexGlobalPartitionOracle partition;
    private JTextField tfValueList;
    private JIntegerField ifPosition;
    private JComboBox cbTableSpace;
    private JComboBox cbLogging;
    private JComboBox cbSegment;

    public PartitionPropertyDialogOraclev9i(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.partition = (IndexGlobalPartitionOracle)object;
        this.setHeight(230);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("PartitionPropertyDialogOraclev9i.GlobalPartitionProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initValueList();
        this.initPosition();
        this.initTableSpace();
        this.initLogging();
        this.initSegment();
    }

    private void initValueList() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyDialogOraclev9i.ValueList"));
        this.general.add(label);
        this.tfValueList = new JTextField("", 26);
        this.general.add(this.tfValueList);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfValueList, 50);
    }

    private void initPosition() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyDialogOraclev9i.Position"));
        this.general.add(label);
        this.ifPosition = new JIntegerField(0, 26);
        this.general.add(this.ifPosition);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.ifPosition, 80);
    }

    private void initTableSpace() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyDialogOraclev9i.TableSpace"));
        this.general.add(label);
        this.cbTableSpace = new JComboBox();
        this.setBG(this.cbTableSpace);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getTableSpaceSet().toArray(), this.cbTableSpace);
        }
        this.cbTableSpace.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbTableSpace);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.cbTableSpace, 110);
    }

    private void initLogging() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyDialogOraclev9i.Logging"));
        this.general.add(label);
        this.cbLogging = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbLogging);
        this.cbLogging.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbLogging);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbLogging, 140);
    }

    private void initSegment() {
        JLabel label = new JLabel(Messages.getString("PartitionPropertyDialogOraclev9i.Segment"));
        this.general.add(label);
        this.cbSegment = new JComboBox();
        this.setBG(this.cbSegment);
        if (this.getStorageDesign() != null) {
            this.fillComboItems(this.getStorageDesign().getSegmentSet().toArray(), this.cbSegment);
        }
        this.cbSegment.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbSegment);
        this.setLabelConstraints(label, 170);
        this.setObjectConstraints(this.cbSegment, 170);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.partition.getName());
        this.tfName.setText(this.partition.getName());
        this.tfValueList.setText(this.partition.getValueList());
        this.ifPosition.setValue((long)this.partition.getPosition());
        this.selectObject(this.cbTableSpace, this.partition.getTableSpace());
        this.cbLogging.setSelectedItem(PartitionPropertyDialogOraclev9i.translateYesNoForDisplay(this.partition.getLogging()));
        this.selectObject(this.cbSegment, this.partition.getSegment());
        this.getCommentsList().insert(this.partition.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.partition != null) {
            this.partition.setName(this.tfName.getText());
            this.partition.setValueList(this.tfValueList.getText());
            this.partition.setPosition(this.ifPosition.getIntValue());
            Object selected = this.cbTableSpace.getSelectedItem();
            if (selected instanceof TableSpaceOracle) {
                this.partition.setTableSpace((TableSpaceOracle)selected);
            } else {
                this.partition.setTableSpace(null);
            }
            this.partition.setLogging(PartitionPropertyDialogOraclev9i.translateYesNoForStorage((String)this.cbLogging.getSelectedItem()));
            selected = this.cbSegment.getSelectedItem();
            if (selected instanceof SegmentOracle) {
                this.partition.setSegment((SegmentOracle)selected);
            } else {
                this.partition.setSegment(null);
            }
            this.partition.setComment(this.getCommentsList().getText());
        }
    }
}

