/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.TableProxyOraclev11g;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.StorageDesignOraclev12c;
import oracle.dbtools.crest.model.design.storage.oracle.v12c.TableProxyOraclev12c;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.TablePropertyDialogOraclev10g;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v11g.PartitionPropertyTabOraclev11g;

public class TablePropertyDialogOraclev11g
extends TablePropertyDialogOraclev10g {
    private JComboBox cbCompressionType;
    private JPanel inMemoryPropsPanel;
    private JComboBox cbInMemory;
    private JComboBox cbInMemoryCompression;
    private JComboBox cbInMemoryPriority;
    private JComboBox cbInMemoryDistribute;
    private JComboBox cbInMemoryDuplicate;

    public TablePropertyDialogOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
    }

    @Override
    protected int initCompressionType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.CompressionType"));
        this.general.add(label);
        String[] compressionTypeValues = this.storageDesign instanceof StorageDesignOraclev12c ? TableProxyOraclev11g.getCompressionTypeValues12c() : TableProxyOraclev11g.getCompressionTypeValues();
        this.cbCompressionType = new JComboBox<String>(compressionTypeValues);
        this.setBG(this.cbCompressionType);
        this.cbCompressionType.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbCompressionType);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbCompressionType, yCoord);
        this.cbDataSegmentCompression.addActionListener(new CompressionListener());
        return yCoord + 30;
    }

    @Override
    protected JPanel initPartitioningView() {
        this.partitionPropertyTab = new PartitionPropertyTabOraclev11g(this.getAppView(), this.getStorageDesign(), this.getStorageObject(), this);
        return this.partitionPropertyTab.addTab(this.getPane());
    }

    @Override
    protected int initAllowAnySchema(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllowAnySchema"));
        this.xmlTypeProperties.add(label);
        this.cbAllowAnySchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowAnySchema);
        this.cbAllowAnySchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeProperties.add(this.cbAllowAnySchema);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbAllowAnySchema, yCoord);
        return yCoord + 30;
    }

    @Override
    protected int initAllowNonSchema(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.AllowNonSchema"));
        this.xmlTypeProperties.add(label);
        this.cbAllowNonSchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowNonSchema);
        this.cbAllowNonSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeProperties.add(this.cbAllowNonSchema);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbAllowNonSchema, yCoord);
        return yCoord + 30;
    }

    @Override
    protected int initLobStorageType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.LobStorageType"));
        this.xmlTypeProperties.add(label);
        this.cbLobStorageType = new JComboBox<String>(TableProxyOraclev11g.getLobStorageTypeValues());
        this.setBG(this.cbLobStorageType);
        this.cbLobStorageType.setPreferredSize(this.tfXmlSchemaUrl.getPreferredSize());
        this.xmlTypeProperties.add(this.cbLobStorageType);
        this.setLabelConstraints(this.getXMLTypePropertiesLayout(), label, yCoord);
        this.setObjectConstraints(this.getXMLTypePropertiesLayout(), this.cbLobStorageType, yCoord);
        return yCoord + 30;
    }

    @Override
    protected void initInMemoryPropsPane() {
        if (this.storageDesign instanceof StorageDesignOraclev12c) {
            this.inMemoryPropsPanel = new JPanel(new SpringLayout());
            this.getPane().addTab(Messages.getString("TablePropertyDialogOracle.InMemoryProperties"), this.inMemoryPropsPanel);
            this.initInMemory(this.inMemoryPropsPanel);
            this.initInMemoryCompression(this.inMemoryPropsPanel);
            this.initInMemoryPriority(this.inMemoryPropsPanel);
            this.initInMemoryDistribute(this.inMemoryPropsPanel);
            this.initInMemoryDuplicate(this.inMemoryPropsPanel);
        }
    }

    private void initInMemory(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemory"));
        panel.add(label);
        this.cbInMemory = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbInMemory);
        this.cbInMemory.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbInMemory);
        this.setLabelConstraints(this.getInMemoryPropertiesLayout(), label, 20);
        this.setObjectConstraints(this.getInMemoryPropertiesLayout(), this.cbInMemory, 20);
        this.cbInMemory.addActionListener(new InMemoryListener());
    }

    private void initInMemoryCompression(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryCompression"));
        panel.add(label);
        this.cbInMemoryCompression = new JComboBox<String>(TableProxyOraclev12c.getInMemoryCompressionValues());
        this.setBG(this.cbInMemoryCompression);
        this.cbInMemoryCompression.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbInMemoryCompression);
        this.setLabelConstraints(this.getInMemoryPropertiesLayout(), label, 50);
        this.setObjectConstraints(this.getInMemoryPropertiesLayout(), this.cbInMemoryCompression, 50);
    }

    private void initInMemoryPriority(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryPriority"));
        panel.add(label);
        this.cbInMemoryPriority = new JComboBox<String>(TableProxyOraclev12c.getInMemoryPriorityValues());
        this.setBG(this.cbInMemoryPriority);
        this.cbInMemoryPriority.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbInMemoryPriority);
        this.setLabelConstraints(this.getInMemoryPropertiesLayout(), label, 80);
        this.setObjectConstraints(this.getInMemoryPropertiesLayout(), this.cbInMemoryPriority, 80);
    }

    private void initInMemoryDistribute(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryDistribute"));
        panel.add(label);
        this.cbInMemoryDistribute = new JComboBox<String>(TableProxyOraclev12c.getInMemoryDistributeValues());
        this.setBG(this.cbInMemoryDistribute);
        this.cbInMemoryDistribute.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbInMemoryDistribute);
        this.setLabelConstraints(this.getInMemoryPropertiesLayout(), label, 110);
        this.setObjectConstraints(this.getInMemoryPropertiesLayout(), this.cbInMemoryDistribute, 110);
    }

    private void initInMemoryDuplicate(JPanel panel) {
        JLabel label = new JLabel(Messages.getString("TablePropertyDialogOracle.InMemoryDuplicate"));
        panel.add(label);
        this.cbInMemoryDuplicate = new JComboBox<String>(TableProxyOraclev12c.getInMemoryDuplicateValues());
        this.setBG(this.cbInMemoryDuplicate);
        this.cbInMemoryDuplicate.setPreferredSize(this.tfName.getPreferredSize());
        panel.add(this.cbInMemoryDuplicate);
        this.setLabelConstraints(this.getInMemoryPropertiesLayout(), label, 140);
        this.setObjectConstraints(this.getInMemoryPropertiesLayout(), this.cbInMemoryDuplicate, 140);
    }

    protected SpringLayout getInMemoryPropertiesLayout() {
        return (SpringLayout)this.inMemoryPropsPanel.getLayout();
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.cbCompressionType.setSelectedItem(((TableProxyOraclev11g)this.table).getCompressionType());
        this.cbAllowAnySchema.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(((TableProxyOraclev11g)this.table).getAllowAnySchema()));
        this.cbAllowNonSchema.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(((TableProxyOraclev11g)this.table).getAllowNonSchema()));
        this.cbLobStorageType.setSelectedItem(((TableProxyOraclev11g)this.table).getLobStorageType());
        if (this.table instanceof TableProxyOraclev12c) {
            TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)this.table;
            this.cbInMemory.setSelectedItem(TablePropertyDialogOraclev11g.translateYesNoForDisplay(tableProxy12c.getInMemory()));
            this.cbInMemoryCompression.setSelectedItem(tableProxy12c.getInMemoryCompression());
            this.cbInMemoryPriority.setSelectedItem(tableProxy12c.getInMemoryPriority());
            this.cbInMemoryDistribute.setSelectedItem(tableProxy12c.getInMemoryDistribute());
            this.cbInMemoryDuplicate.setSelectedItem(tableProxy12c.getInMemoryDuplicate());
        }
    }

    @Override
    protected void setProperties() {
        if (this.table != null) {
            super.setProperties();
            if (this.cbCompressionType.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setCompressionType((String)this.cbCompressionType.getSelectedItem());
            }
            if (this.cbAllowAnySchema.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setAllowAnySchema(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowAnySchema.getSelectedItem()));
                ((TableProxyOraclev11g)this.table).setAllowNonSchema(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowNonSchema.getSelectedItem()));
            }
            if (this.cbLobStorageType.isEnabled()) {
                ((TableProxyOraclev11g)this.table).setLobStorageType((String)this.cbLobStorageType.getSelectedItem());
            }
            if (this.table instanceof TableProxyOraclev12c) {
                TableProxyOraclev12c tableProxy12c = (TableProxyOraclev12c)this.table;
                tableProxy12c.setInMemory(TablePropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbInMemory.getSelectedItem()));
                tableProxy12c.setInMemoryCompression((String)this.cbInMemoryCompression.getSelectedItem());
                tableProxy12c.setInMemoryPriority((String)this.cbInMemoryPriority.getSelectedItem());
                tableProxy12c.setInMemoryDistribute((String)this.cbInMemoryDistribute.getSelectedItem());
                tableProxy12c.setInMemoryDuplicate((String)this.cbInMemoryDuplicate.getSelectedItem());
            }
        }
    }

    private class InMemoryListener
    implements ActionListener {
        private InMemoryListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            boolean inMemoryEnabled = TablePropertyDialogOraclev11g.this.cbInMemory.getSelectedItem().equals(AbstractPropertyDialog.YES);
            TablePropertyDialogOraclev11g.this.cbInMemoryCompression.setEnabled(inMemoryEnabled);
            TablePropertyDialogOraclev11g.this.cbInMemoryPriority.setEnabled(inMemoryEnabled);
            TablePropertyDialogOraclev11g.this.cbInMemoryDistribute.setEnabled(inMemoryEnabled);
            TablePropertyDialogOraclev11g.this.cbInMemoryDuplicate.setEnabled(inMemoryEnabled);
        }
    }

    private class CompressionListener
    implements ActionListener {
        private CompressionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TablePropertyDialogOraclev11g.this.cbCompressionType.setEnabled(TablePropertyDialogOraclev11g.this.cbDataSegmentCompression.getSelectedItem().equals(AbstractPropertyDialog.YES));
        }
    }
}

