/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.oracle.v11g;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.oracle.v11g.ColumnProxyOraclev11g;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.AbstractPropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.oracle.Messages;
import oracle.dbtools.crest.swingui.editor.storage.oracle.v10g.ColumnPropertyDialogOraclev10g;

public class ColumnPropertyDialogOraclev11g
extends ColumnPropertyDialogOraclev10g {
    private ColumnProxyOraclev11g column;
    private JTextField tfComputed;
    private JTextField tfColumnExpression;
    private JComboBox cbEncrypt;
    protected JPanel encryption;
    private JComboBox cbEncryptionAlgorithm;
    private JComboBox cbIntegrityAlgorithm;
    private JComboBox cbUseSalt;
    private boolean computed;
    private String expressionText;

    public ColumnPropertyDialogOraclev11g(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.column = (ColumnProxyOraclev11g)object;
    }

    @Override
    protected Integer getRDBMSType() {
        return this.storageDesign.getRDBMSType().getType();
    }

    @Override
    protected int initComputed(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.Computed"));
        this.general.add(label);
        this.tfComputed = new JTextField("", 26);
        this.tfComputed.setEnabled(false);
        this.general.add(this.tfComputed);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfComputed, yCoord);
        return 30;
    }

    @Override
    protected int initColumnExpression(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.ColumnExpression"));
        this.general.add(label);
        this.tfColumnExpression = new JTextField("", 26);
        this.tfColumnExpression.setEnabled(false);
        this.general.add(this.tfColumnExpression);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.tfColumnExpression, yCoord);
        return 30;
    }

    @Override
    protected int initEncrypt(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.Encrypt"));
        this.general.add(label);
        this.cbEncrypt = new JComboBox<String>(EMPTY_YES_NO);
        this.cbEncrypt.addActionListener(new EncryptListener());
        this.setBG(this.cbEncrypt);
        this.cbEncrypt.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEncrypt);
        this.setLabelConstraints(label, yCoord);
        this.setObjectConstraints(this.cbEncrypt, yCoord);
        return 30;
    }

    @Override
    protected void addTabs() {
        super.addTabs();
        this.initEncryptionView();
    }

    private void initEncryptionView() {
        this.encryption = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("ColumnPropertyDialogOraclev11g.Encryption"), this.encryption);
        this.initEncryptionAlgorithm(20);
        this.initIntegrityAlgorithm(50);
        this.initUseSalt(80);
    }

    protected SpringLayout getEncryptionLayout() {
        return (SpringLayout)this.encryption.getLayout();
    }

    protected void initEncryptionAlgorithm(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.EncryptionAlgorithm"));
        this.encryption.add(label);
        this.cbEncryptionAlgorithm = new JComboBox<String>(ColumnProxyOraclev11g.getEncryptionAlgorithmChoices());
        this.setBG(this.cbEncryptionAlgorithm);
        this.cbEncryptionAlgorithm.setPreferredSize(this.tfName.getPreferredSize());
        this.encryption.add(this.cbEncryptionAlgorithm);
        this.setLabelConstraints(this.getEncryptionLayout(), label, yCoord);
        this.setObjectConstraints(this.getEncryptionLayout(), this.cbEncryptionAlgorithm, yCoord);
    }

    protected void initIntegrityAlgorithm(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.IntegrityAlgorithm"));
        this.encryption.add(label);
        this.cbIntegrityAlgorithm = new JComboBox<String>(ColumnProxyOraclev11g.getIntegrityAlgorithmChoices());
        this.setBG(this.cbIntegrityAlgorithm);
        this.cbIntegrityAlgorithm.setPreferredSize(this.tfName.getPreferredSize());
        this.encryption.add(this.cbIntegrityAlgorithm);
        this.setLabelConstraints(this.getEncryptionLayout(), label, yCoord);
        this.setObjectConstraints(this.getEncryptionLayout(), this.cbIntegrityAlgorithm, yCoord);
    }

    protected void initUseSalt(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.UseSALT"));
        this.encryption.add(label);
        this.cbUseSalt = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbUseSalt);
        this.cbUseSalt.setPreferredSize(this.tfName.getPreferredSize());
        this.encryption.add(this.cbUseSalt);
        this.setLabelConstraints(this.getEncryptionLayout(), label, yCoord);
        this.setObjectConstraints(this.getEncryptionLayout(), this.cbUseSalt, yCoord);
    }

    @Override
    protected int initLobStorageType(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.LobStorageType"));
        this.xmlTypeOptions.add(label);
        this.cbLobStorageType = new JComboBox<String>(ColumnProxyOraclev11g.getLobStorageValues11g());
        this.setBG(this.cbLobStorageType);
        this.cbLobStorageType.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbLobStorageType);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbLobStorageType, yCoord);
        return yCoord + 30;
    }

    @Override
    protected int initAllowAnySchema(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.AllowAnySchema"));
        this.xmlTypeOptions.add(label);
        this.cbAllowAnySchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowAnySchema);
        this.cbAllowAnySchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbAllowAnySchema);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbAllowAnySchema, yCoord);
        return yCoord + 30;
    }

    @Override
    protected int initAllowNonSchema(int yCoord) {
        JLabel label = new JLabel(Messages.getString("ColumnPropertyDialogOraclev11g.AllowNonSchema"));
        this.xmlTypeOptions.add(label);
        this.cbAllowNonSchema = new JComboBox<String>(EMPTY_YES_NO);
        this.setBG(this.cbAllowNonSchema);
        this.cbAllowNonSchema.setPreferredSize(this.tfName.getPreferredSize());
        this.xmlTypeOptions.add(this.cbAllowNonSchema);
        this.setLabelConstraints(this.getXmlTypeLayout(), label, yCoord);
        this.setObjectConstraints(this.getXmlTypeLayout(), this.cbAllowNonSchema, yCoord);
        return yCoord + 30;
    }

    @Override
    public void initProperties() {
        super.initProperties();
        this.computed = this.column.isComputed();
        this.tfComputed.setText(this.computed ? YES : NO);
        this.expressionText = this.computed ? this.column.getColumnExpression() : "";
        this.tfColumnExpression.setText(this.expressionText);
        this.tfColumnExpression.setEnabled(this.computed);
        this.cbEncrypt.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getEncrypt()));
        this.cbAllowAnySchema.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getAllowAnySchema()));
        this.cbAllowNonSchema.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getAllowNonSchema()));
        this.cbLobStorageType.setSelectedItem(this.column.getLobStorageType());
        this.cbEncryptionAlgorithm.setSelectedItem(this.column.getEncryptionAlgorithm());
        this.cbIntegrityAlgorithm.setSelectedItem(this.column.getIntegrityAlgorithm());
        this.cbUseSalt.setSelectedItem(ColumnPropertyDialogOraclev11g.translateYesNoForDisplay(this.column.getUseSalt()));
    }

    @Override
    protected void setProperties() {
        if (this.column != null) {
            super.setProperties();
            if (!this.expressionText.equals(this.tfColumnExpression.getText())) {
                this.expressionText = this.tfColumnExpression.getText();
                this.column.setColumnExpression(this.expressionText);
                this.column.setExpressionChanged(true);
            }
            this.column.setEncrypt(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbEncrypt.getSelectedItem()));
            JTabbedPane pane = this.getPane();
            int xmlTypeOptionsTabIndex = pane.indexOfComponent(this.xmlTypeOptions);
            if (xmlTypeOptionsTabIndex > -1 && pane.isEnabledAt(xmlTypeOptionsTabIndex)) {
                if (this.cbLobStorageType.isEnabled()) {
                    this.column.setLobStorageType((String)this.cbLobStorageType.getSelectedItem());
                }
                if (this.cbAllowAnySchema.isEnabled()) {
                    this.column.setAllowAnySchema(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowAnySchema.getSelectedItem()));
                    this.column.setAllowNonSchema(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbAllowNonSchema.getSelectedItem()));
                }
            }
            this.column.setEncryptionAlgorithm((String)this.cbEncryptionAlgorithm.getSelectedItem());
            this.column.setIntegrityAlgorithm((String)this.cbIntegrityAlgorithm.getSelectedItem());
            this.column.setUseSalt(ColumnPropertyDialogOraclev11g.translateYesNoForStorage((String)this.cbUseSalt.getSelectedItem()));
        }
    }

    private class EncryptListener
    implements ActionListener {
        private EncryptListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTabbedPane pane = ColumnPropertyDialogOraclev11g.this.getPane();
            int encryptionTabIndex = pane.indexOfComponent(ColumnPropertyDialogOraclev11g.this.encryption);
            if (encryptionTabIndex > -1) {
                pane.setEnabledAt(encryptionTabIndex, ColumnPropertyDialogOraclev11g.this.cbEncrypt.getSelectedItem().equals(AbstractPropertyDialog.YES));
            }
        }
    }
}

