/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage.db2.v80;

import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.ColumnProxy;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.model.design.storage.db2.FKProxyDB2;
import oracle.dbtools.crest.model.design.storage.db2.v80.FKProxyDB2v80;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.db2.AbstractDB2PropertyDialog;
import oracle.dbtools.crest.swingui.editor.storage.db2.Messages;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKPropertyDialogDB2v80
extends AbstractDB2PropertyDialog {
    private FKProxyDB2v80 fkey;
    private JTextField tfTable;
    private JTextField tfRefTable;
    private JTextField tfDeleteRule;
    private JComboBox cbEnforced;
    private JPanel columns;
    private JPanel refColumns;
    private JList columnList;
    private JList refColumnsList;
    private DefaultListModel columnListModel;
    private DefaultListModel refColumnsListModel;

    public FKPropertyDialogDB2v80(ApplicationView view, StorageDesign storageDesign, StorageObject object) {
        super(view, storageDesign, object);
        this.fkey = (FKProxyDB2v80)object;
        this.setHeight(200);
        this.initCommentsView();
        this.pack();
        CommonUtil.centerOnScreen(this);
        this.initProperties();
    }

    @Override
    public String getCaption() {
        return Messages.getString("FKPropertyDialogDB2v80.FKProperties");
    }

    @Override
    protected void initGeneralView() {
        super.initGeneralView();
        this.initTable();
        this.initRefTable();
        this.initDeleteRule();
        this.initEnforced();
    }

    private void initTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogDB2v80.Table"));
        this.general.add(label);
        this.tfTable = new JTextField("", 26);
        this.tfTable.setEditable(false);
        this.general.add(this.tfTable);
        this.setLabelConstraints(label, 50);
        this.setObjectConstraints(this.tfTable, 50);
    }

    private void initRefTable() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogDB2v80.RefTable"));
        this.general.add(label);
        this.tfRefTable = new JTextField("", 26);
        this.tfRefTable.setEditable(false);
        this.general.add(this.tfRefTable);
        this.setLabelConstraints(label, 80);
        this.setObjectConstraints(this.tfRefTable, 80);
    }

    private void initDeleteRule() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogDB2v80.DeleteRule"));
        this.general.add(label);
        this.tfDeleteRule = new JTextField();
        this.setBG(this.tfDeleteRule);
        this.tfDeleteRule.setPreferredSize(this.tfName.getPreferredSize());
        this.tfDeleteRule.setEnabled(false);
        this.general.add(this.tfDeleteRule);
        this.setLabelConstraints(label, 110);
        this.setObjectConstraints(this.tfDeleteRule, 110);
    }

    private void initEnforced() {
        JLabel label = new JLabel(Messages.getString("FKPropertyDialogDB2v80.Enforced"));
        this.general.add(label);
        this.cbEnforced = new JComboBox<String>(FKProxyDB2.getYesNoChoices());
        this.setBG(this.cbEnforced);
        this.cbEnforced.setPreferredSize(this.tfName.getPreferredSize());
        this.general.add(this.cbEnforced);
        this.setLabelConstraints(label, 140);
        this.setObjectConstraints(this.cbEnforced, 140);
    }

    @Override
    protected void addTabs() {
        this.initColumnsView();
        this.initRefColumnsView();
    }

    private void initColumnsView() {
        this.columns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogDB2v80.Columns"), this.columns);
        this.initColumns();
    }

    private void initColumns() {
        this.columnListModel = new DefaultListModel();
        this.columnList = new JList(this.columnListModel);
        this.columnList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.columnList);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.columns.add(sp);
        this.setObjectConstraints(this.getColumnsLayout(), sp, 10, 12);
    }

    protected SpringLayout getColumnsLayout() {
        return (SpringLayout)this.columns.getLayout();
    }

    protected SpringLayout getRefColumnsLayout() {
        return (SpringLayout)this.refColumns.getLayout();
    }

    private void initRefColumnsView() {
        this.refColumns = new JPanel(new SpringLayout());
        this.getPane().addTab(Messages.getString("FKPropertyDialogDB2v80.ReferencedColumns"), this.refColumns);
        this.initRefColumns();
    }

    private void initRefColumns() {
        this.refColumnsListModel = new DefaultListModel();
        this.refColumnsList = new JList(this.refColumnsListModel);
        this.refColumnsList.setEnabled(false);
        JScrollPane sp = new JScrollPane(this.refColumnsList);
        sp.setPreferredSize(new Dimension(395, 150));
        sp.setBorder(BorderFactory.createEtchedBorder(0));
        this.refColumns.add(sp);
        this.setObjectConstraints(this.getRefColumnsLayout(), sp, 10, 12);
    }

    @Override
    public void initProperties() {
        this.initCaption(this.fkey.getName());
        this.tfName.setText(this.fkey.getName());
        this.tfTable.setText(this.fkey.getTable().getName());
        this.tfRefTable.setText(this.fkey.getReferenceTable());
        ColumnProxy[] proxies = this.fkey.getColumnProxies();
        for (int i = 0; i < proxies.length; ++i) {
            ColumnProxy proxy = proxies[i];
            this.columnListModel.addElement(proxy);
        }
        ContainedObject[] cols = this.fkey.getRefColumns();
        for (int i = 0; i < cols.length; ++i) {
            FKElement column = (FKElement)cols[i];
            this.refColumnsListModel.addElement(column);
        }
        String deleteRule = ((Index)this.fkey.getObject()).getFKAssociation().getDeleteRule();
        if (deleteRule.equalsIgnoreCase("SET DEFAULT")) {
            deleteRule = ((Index)this.fkey.getObject()).getFKAssociation().isMandatory() ? "RESTRICT" : "SET NULL";
        }
        this.tfDeleteRule.setText(deleteRule);
        this.cbEnforced.setSelectedItem(this.fkey.getEnforced());
        this.getCommentsList().insert(this.fkey.getComment(), 0);
    }

    @Override
    protected void setProperties() {
        if (this.fkey != null) {
            this.fkey.setName(this.tfName.getText());
            this.fkey.setEnforced((String)this.cbEnforced.getSelectedItem());
            this.fkey.setComment(this.getCommentsList().getText());
        }
    }
}

