/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.propertymap.PropertiesPropagator;
import oracle.dbtools.crest.util.propertymap.PropertyWrapper;

public class PropertiesPropagationDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel generalPanel;
    private JTable tbProps;
    private JTable tbObjects;
    private List propsList;
    private List objectsList;
    private PropertiesPropagator propagator;

    public PropertiesPropagationDialog(ApplicationView appView, PropertiesPropagator propagator, List toObjects) {
        super(appView);
        this.propagator = propagator;
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(new Dimension(450, 550));
        this.init();
        this.addObjects(toObjects);
        this.add((Component)this.generalPanel, "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private void init() {
        this.generalPanel.add((Component)this.getPropertiesPanel(), "North");
        this.generalPanel.add((Component)this.getObjectsPanel(), "Center");
    }

    private void addObjects(List toObjects) {
        for (ModelIDObject next : toObjects) {
            this.objectsList.add(new ObjectItem(next));
        }
    }

    private JPanel getPropertiesPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Properties")));
        this.propsList = new ArrayList();
        this.propsList.addAll(this.propagator.getPropertyWrapperList());
        this.tbProps = new JTable(new PropertiesModel());
        this.tbProps.setSelectionMode(0);
        this.tbProps.setFont(this.tbProps.getFont().deriveFont(1));
        this.tbProps.setForeground(Color.BLUE);
        TableColumn column = this.tbProps.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.tbProps.getColumnModel().getColumn(1);
        column.setPreferredWidth(70);
        JPanel pnTable = new JPanel(new BorderLayout());
        pnTable.add((Component)this.tbProps.getTableHeader(), "North");
        pnTable.add((Component)this.tbProps, "Center");
        jpanel.add(pnTable);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        popup.add(menuItem);
        this.tbProps.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel buttonPnl = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = new JButton(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        JButton bnDeselectAll = new JButton(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (PropertyWrapper pr : PropertiesPropagationDialog.this.propsList) {
                    pr.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbProps.updateUI();
            }
        });
        buttonPnl.add(bnSelectAll);
        buttonPnl.add(bnDeselectAll);
        jpanel.add((Component)buttonPnl, "South");
        return jpanel;
    }

    private JPanel getObjectsPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        jpanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("PropertiesPropagationDialog.Objects")));
        this.objectsList = new ArrayList();
        this.tbObjects = new JTable(new ObjectModel());
        this.tbObjects.setSelectionMode(0);
        this.tbObjects.setFont(this.tbObjects.getFont().deriveFont(1));
        TableColumn column = this.tbObjects.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.tbObjects.getColumnModel().getColumn(1);
        column.setPreferredWidth(235);
        JScrollPane sp = new JScrollPane(this.tbObjects);
        jpanel.add(sp);
        final JPopupMenu popup = new JPopupMenu();
        JMenuItem menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        popup.add(menuItem);
        menuItem = new JMenuItem(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        menuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        popup.add(menuItem);
        this.tbObjects.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    popup.show(e.getComponent(), e.getX(), e.getY());
                }
            }
        });
        JPanel buttonPnl = new JPanel(new FlowLayout(0));
        JButton bnSelectAll = new JButton(Messages.getString("PropertiesPropagationDialog.SelectAll"));
        bnSelectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnSelectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(true);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        JButton bnDeselectAll = new JButton(Messages.getString("PropertiesPropagationDialog.DeselectAll"));
        bnDeselectAll.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnDeselectAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ObjectItem objItem : PropertiesPropagationDialog.this.objectsList) {
                    objItem.setSelected(false);
                }
                PropertiesPropagationDialog.this.tbObjects.updateUI();
            }
        });
        buttonPnl.add(bnSelectAll);
        buttonPnl.add(bnDeselectAll);
        jpanel.add((Component)buttonPnl, "South");
        return jpanel;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("PropertiesPropagationDialog.PropertiesPropagation"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("PropertiesPropagationDialog.OK"));
        ok.setMnemonic(79);
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesPropagationDialog.this.setProperties();
                PropertiesPropagationDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("PropertiesPropagationDialog.Cancel"));
        cancel.setMnemonic(67);
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PropertiesPropagationDialog.this.close();
            }
        });
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        return buttonPanel;
    }

    private void setProperties() {
        try {
            if (this.propagator instanceof StorageObject) {
                ((StorageObject)((Object)this.propagator)).getStorageDesign().setLoading(true);
            }
            for (PropertyWrapper pr : this.propsList) {
                if (!pr.isSelected()) continue;
                pr.init();
            }
            for (ObjectItem objItem : this.objectsList) {
                if (!objItem.isSelected()) continue;
                this.applyTo(objItem.getObject());
            }
        }
        finally {
            if (this.propagator instanceof StorageObject) {
                ((StorageObject)((Object)this.propagator)).getStorageDesign().setLoading(false);
            }
        }
    }

    private void applyTo(Object obj) {
        for (PropertyWrapper pr : this.propsList) {
            if (!pr.isSelected()) continue;
            pr.setValue(obj);
        }
    }

    private class ObjectItem {
        private ModelIDObject object;
        private boolean selected = false;

        public ObjectItem(ModelIDObject object) {
            this.object = object;
        }

        public boolean isSelected() {
            return this.selected;
        }

        public void setSelected(boolean selected) {
            this.selected = selected;
        }

        public String getName() {
            return this.object.getName();
        }

        public ModelIDObject getObject() {
            return this.object;
        }
    }

    public class ObjectModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.objectsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ObjectItem objItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(row);
            if (col == 0) {
                return objItem.isSelected();
            }
            if (col == 1) {
                return objItem.getName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            ObjectItem objItem = (ObjectItem)PropertiesPropagationDialog.this.objectsList.get(row);
            if (col == 0) {
                objItem.setSelected((Boolean)aValue);
            }
        }
    }

    public class PropertiesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return PropertiesPropagationDialog.this.propsList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("PropertiesPropagationDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("PropertiesPropagationDialog.Name");
            }
            if (column == 2) {
                return Messages.getString("PropertiesPropagationDialog.Value");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            PropertyWrapper pw = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(row);
            if (col == 0) {
                return pw.isSelected();
            }
            if (col == 1) {
                return pw.getName();
            }
            if (col == 2) {
                return pw.getValueString();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            PropertyWrapper pw = (PropertyWrapper)PropertiesPropagationDialog.this.propsList.get(row);
            if (col == 0) {
                pw.setSelected((Boolean)aValue);
            }
        }
    }
}

