/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.storage;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SpringLayout;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.relational.DB2_To_Oracle_CTLFileGenerator;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.storage.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFilter;

public class DB2_To_Oracle_CTLFilesDialog
extends CustomDialog {
    private JDialog dialog;
    private JButton bnCancel;
    private JButton bnOK;
    private static final int FIELD_WIDTH = 150;
    private static final int FIELD_HEIGHT = 20;
    private Dimension prefDimension = new Dimension(180, 20);
    private Dimension filePrefDimension = new Dimension(150, 20);
    protected Design design;
    protected JComboBox cbRelDes;
    protected String allRelational = Messages.getString("DB2_To_Oracle_CTLFilesDialog.AllOpenRelationalModels");
    protected JTextField tfCTLDir;
    protected JTextField tfDataDir;
    protected JTextField tfFileMap;
    protected JTextField tfSeparator;
    protected String title = Messages.getString("DB2_To_Oracle_CTLFilesDialog.GenerateOracleLoadFilesForDB2Data");
    private static File lastFolder = null;
    private static File lastOutFolder = null;
    private static final Logger LOGGER = new Logger(DB2_To_Oracle_CTLFilesDialog.class);

    public DB2_To_Oracle_CTLFilesDialog(ApplicationView appView) {
        super(appView);
        this.design = appView.getCurrentDesign();
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.setPreferredSize(new Dimension(380, 180));
        mainPanel.add((Component)this.initGeneralPanel(), "Center");
        mainPanel.add((Component)this.initButtonsPanel(), "South");
        this.add(mainPanel);
    }

    private JPanel initGeneralPanel() {
        JPanel jpanel = new JPanel(new BorderLayout());
        JPanel optionsPanel = new JPanel(new SpringLayout());
        JLabel lbRelD = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.RelationalModel"));
        lbRelD.setPreferredSize(this.prefDimension);
        ArrayList<Object> rlist = new ArrayList<Object>();
        rlist.add(this.allRelational);
        for (RelationalDesign pd : this.design.getRelationalDesigns()) {
            if (!pd.isLoaded()) continue;
            rlist.add(pd);
        }
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbRelD, 5, 5);
        this.cbRelDes = new JComboBox<Object>(rlist.toArray());
        this.cbRelDes.setPreferredSize(new Dimension(200, 20));
        if (rlist.size() > 1) {
            this.cbRelDes.setSelectedItem(this.allRelational);
        }
        this.cbRelDes.setFont(this.cbRelDes.getFont().deriveFont(0));
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.cbRelDes, 180, 5);
        optionsPanel.add(lbRelD);
        optionsPanel.add(this.cbRelDes);
        JLabel lbfFileName = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.CTLFilesDirectory"));
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbfFileName, 5, 35);
        lbfFileName.setPreferredSize(this.prefDimension);
        lbfFileName.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.ParentDirForDirectoriesWithOracleLoader"));
        this.tfCTLDir = new JTextField("");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.tfCTLDir, 180, 35);
        this.tfCTLDir.setPreferredSize(this.filePrefDimension);
        this.tfCTLDir.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.ParentDirForDirectoriesWithOracleLoader"));
        JButton button = new JButton("...");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), button, 335, 35);
        button.setPreferredSize(new Dimension(20, 20));
        button.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectDirectory"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DB2_To_Oracle_CTLFilesDialog.this.getOutputDirName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DirectoryForControlFiles"), DB2_To_Oracle_CTLFilesDialog.this.tfCTLDir);
            }
        });
        optionsPanel.add(lbfFileName);
        optionsPanel.add(this.tfCTLDir);
        optionsPanel.add(button);
        lbfFileName = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DataFilesDirectory"));
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbfFileName, 5, 65);
        lbfFileName.setPreferredSize(this.prefDimension);
        lbfFileName.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.LocationOfDataFiles"));
        this.tfDataDir = new JTextField("");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.tfDataDir, 180, 65);
        this.tfDataDir.setPreferredSize(this.filePrefDimension);
        this.tfDataDir.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.LocationOfDataFiles"));
        button = new JButton("...");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), button, 335, 65);
        button.setPreferredSize(new Dimension(20, 20));
        button.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectDirectory"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DB2_To_Oracle_CTLFilesDialog.this.getOutputDirName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.DirectoryWithDataFiles"), DB2_To_Oracle_CTLFilesDialog.this.tfDataDir);
            }
        });
        optionsPanel.add(lbfFileName);
        optionsPanel.add(this.tfDataDir);
        optionsPanel.add(button);
        lbfFileName = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FileWithTableFileMappings"));
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbfFileName, 5, 95);
        lbfFileName.setPreferredSize(this.prefDimension);
        lbfFileName.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFileWithTableFileMappings"));
        this.tfFileMap = new JTextField("");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.tfFileMap, 180, 95);
        this.tfFileMap.setPreferredSize(this.filePrefDimension);
        this.tfFileMap.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFileWithTableFileMappings"));
        button = new JButton("...");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), button, 335, 95);
        button.setPreferredSize(new Dimension(20, 20));
        button.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.SelectFile"));
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DB2_To_Oracle_CTLFilesDialog.this.getInputFileName(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FileWithTableFileMappings"), DB2_To_Oracle_CTLFilesDialog.this.tfFileMap);
            }
        });
        optionsPanel.add(lbfFileName);
        optionsPanel.add(this.tfFileMap);
        optionsPanel.add(button);
        lbfFileName = new JLabel(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparator"));
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), lbfFileName, 5, 125);
        lbfFileName.setPreferredSize(this.prefDimension);
        lbfFileName.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparatorForTableNameFileName"));
        this.tfSeparator = new JTextField(";");
        CommonUtil.setObjectConstraints((SpringLayout)optionsPanel.getLayout(), this.tfSeparator, 180, 125);
        this.tfSeparator.setPreferredSize(new Dimension(10, 20));
        this.tfSeparator.setToolTipText(Messages.getString("DB2_To_Oracle_CTLFilesDialog.FieldSeparatorForTableNameFileName"));
        optionsPanel.add(lbfFileName);
        optionsPanel.add(this.tfSeparator);
        jpanel.add(optionsPanel);
        return jpanel;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), this.title, false);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setContentPane(this);
            this.dialog.getRootPane().setDefaultButton(this.bnOK);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setResizable(false);
            this.dialog.setModal(true);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }

    public Action createOKButton() {
        AbstractAction action = new AbstractAction(Messages.getString("DB2_To_Oracle_CTLFilesDialog.Generate")){

            @Override
            public void actionPerformed(ActionEvent e) {
                if ("".equals(DB2_To_Oracle_CTLFilesDialog.this.tfCTLDir.getText().trim()) || "".equals(DB2_To_Oracle_CTLFilesDialog.this.tfDataDir.getText().trim()) || "".equals(DB2_To_Oracle_CTLFilesDialog.this.tfSeparator.getText().trim())) {
                    JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), Messages.getString("DB2_To_Oracle_CTLFilesDialog.IncompleteData"), Messages.getString("DB2_To_Oracle_CTLFilesDialog.IncompleteData"), 0, 0, null, new String[]{Messages.getString("DB2_To_Oracle_CTLFilesDialog.Ok")}, Messages.getString("DB2_To_Oracle_CTLFilesDialog.Ok"));
                    return;
                }
                DB2_To_Oracle_CTLFilesDialog.this.generate();
            }
        };
        return action;
    }

    public Action createCancelButton() {
        AbstractAction action = new AbstractAction(Messages.getString("DB2_To_Oracle_CTLFilesDialog.Exit")){

            @Override
            public void actionPerformed(ActionEvent e) {
                DB2_To_Oracle_CTLFilesDialog.this.close();
            }
        };
        return action;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    private JPanel initButtonsPanel() {
        JPanel pnButtons = new JPanel(new FlowLayout(1));
        this.bnOK = new JButton(this.createOKButton());
        this.bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.createCancelButton());
        this.bnCancel.setMnemonic(67);
        pnButtons.add(this.bnOK);
        pnButtons.add(this.bnCancel);
        this.bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        return pnButtons;
    }

    public void generate() {
        Object obj = this.cbRelDes.getSelectedItem();
        String ctlDir = this.tfCTLDir.getText().trim();
        String dataDir = this.tfDataDir.getText().trim();
        String fileMapFile = this.tfFileMap.getText().trim();
        char delimiter = this.tfSeparator.getText().trim().charAt(0);
        if (obj == this.allRelational) {
            for (RelationalDesign phdes : this.design.getRelationalDesigns()) {
                if (!phdes.isLoaded()) continue;
                DB2_To_Oracle_CTLFileGenerator gen = new DB2_To_Oracle_CTLFileGenerator(phdes, ctlDir, dataDir, fileMapFile, delimiter);
                try {
                    gen.exportFiles();
                }
                catch (Exception e) {}
            }
        } else {
            RelationalDesign phdes = (RelationalDesign)this.cbRelDes.getSelectedItem();
            DB2_To_Oracle_CTLFileGenerator gen = new DB2_To_Oracle_CTLFileGenerator(phdes, ctlDir, dataDir, fileMapFile, delimiter);
            gen.exportFiles();
        }
    }

    private String getInputFileName(String title, JTextField textField) {
        try {
            File file;
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".txt") || file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("DB2_To_Oracle_CTLFilesDialog.TextFiles");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_OpenDesign");
            if (lastFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultImportPath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            String filename = textField.getText();
            fileChooser.setFileNameURL(filename);
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), Messages.getString("DB2_To_Oracle_CTLFilesDialog.OpenFileWithTableFileMappings"));
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastFolder = file.getParentFile();
                textField.setText(file.toString());
                return file.toString();
            }
            return textField.getText();
        }
        catch (Exception e) {
            LOGGER.error("Error DB2_To_Oracle_CTLFilesDialog ", e);
            return "";
        }
    }

    private String getOutputDirName(String title, JTextField textField) {
        try {
            File file;
            URLFilter ddlFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.isDirectory();
                }

                public String toString() {
                    return Messages.getString("DB2_To_Oracle_CTLFilesDialog.Directory");
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(1);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(ddlFilter);
            fileChooser.setPathContext("dataModeler_OpenDesign");
            if (lastOutFolder != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((File)lastOutFolder));
            } else {
                String lastDir = this.getApplicationView().getSettings().getDefaultSavePath();
                if (lastDir != null && lastDir.length() > 0) {
                    fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
                } else {
                    URL url = this.getApplicationView().getUserHomeDirectory();
                    if (url != null) {
                        fileChooser.setSelectedURL(url);
                    }
                }
            }
            String filename = textField.getText();
            fileChooser.setFileNameURL(filename);
            int status = fileChooser.showOpenDialog((Component)Ide.getMainWindow(), title);
            if (status == 0 && (file = new File(fileChooser.getSelectedURL().getPath())) != null) {
                lastOutFolder = file.getParentFile();
                textField.setText(file.toString());
                return file.toString();
            }
            return textField.getText();
        }
        catch (Exception e) {
            LOGGER.error("Error get output directory namee ", e);
            return "";
        }
    }
}

