/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;
import net.miginfocom.layout.CC;
import net.miginfocom.swing.MigLayout;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.TopViewCollection;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.compare.CompareTreeNavigationDesign;
import oracle.dbtools.crest.model.design.impact.ImpA_FKAssociation;
import oracle.dbtools.crest.model.design.relational.FKContainer;
import oracle.dbtools.crest.model.design.relational.FKElement;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.ViewIndex;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.undo.relational.FKUpdateEdit;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.ContainerView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsCellEditor;
import oracle.dbtools.crest.swingui.editor.relational.FKColumnsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.FKUtilities;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.swingui.impact.ImpactTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;

public class ForeignKeyPropertiesDialogEx
extends AbstractPropertiesDialog {
    private static final long serialVersionUID = 6498069064076573019L;
    private FKIndexAssociation oldFKIass;
    private KeyObject oldKey;
    private JTextField tfLongName;
    private JTextField tfDiscrValue;
    private JComboBox cbIndexPkUk;
    private JComboBox cbDeleteRule;
    private JComboBox cbDiscrimanatorCiolumn;
    private JComboBox cbSourceTableSynonym;
    private JComboBox cbTargetTableSynonym;
    private JCheckBox chMarkGenerate;
    private JCheckBox chMandatory;
    private JCheckBox chTransferable;
    private JCheckBox chInArc;
    private FKElement[] fkColumns;
    private JTable columnsTable;
    private JTable columnsDependencyConstraintTable;
    private JPanel pnColumns;
    private JPanel pnColumnsDependencyConstraint;
    private JTree tree;
    private FKIndexAssociation.FKMemento mem;
    private FKIndexAssociation.FKMemento memBackup;
    private static final Dimension defaultSize = new Dimension(200, 20);
    private List dependantColumnsList;
    private DesignObject obj;
    private JTextField txtCDCName;
    private JCheckBox chCDCGenerateInDDL;
    private JCheckBox chbDeprecated;
    private JComboBox cbRely;
    private static final Logger LOGGER = new Logger(ForeignKeyPropertiesDialogEx.class);
    private KeyObject currentKey = null;
    private Action statusChanged = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent e) {
            StorageDesign sd = ((RelationalDesign)ForeignKeyPropertiesDialogEx.this.oldFKIass.getDesignPart()).getStorageDesign();
            Object object = ForeignKeyPropertiesDialogEx.this.cbDeleteRule.getSelectedItem();
            ForeignKeyPropertiesDialogEx.this.cbDeleteRule.removeAllItems();
            if (!ForeignKeyPropertiesDialogEx.this.chTransferable.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("CASCADE".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("CASCADE");
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                }
            } else if (ForeignKeyPropertiesDialogEx.this.chMandatory.isSelected()) {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRulesMandatory(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                if ("SET NULL".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem("RESTRICT");
                } else if ("SET DEFAULT".equalsIgnoreCase((String)object)) {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule("SET DEFAULT"));
                } else {
                    ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule((String)object));
                }
            } else {
                ForeignKeyPropertiesDialogEx.this.fillComboItems(sd.getFKDeleteRules(), ForeignKeyPropertiesDialogEx.this.cbDeleteRule, false);
                ForeignKeyPropertiesDialogEx.this.cbDeleteRule.setSelectedItem(sd.getValidFKRule((String)object));
            }
        }
    };

    public ForeignKeyPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
        this.initGeneral();
        this.obj = object;
    }

    public ForeignKeyPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object, FKIndexAssociation.FKMemento mem) {
        super(owner, view, mem.fk);
        this.initGeneral();
        this.obj = object;
        this.mem = mem;
    }

    @Override
    public String getCaption() {
        return Messages.getString("ForeignKeyPropertiesDialogEx.ForeignKeyProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof FKIndexAssociation) {
            this.oldFKIass = (FKIndexAssociation)object;
            this.oldKey = this.oldFKIass.getKeyObject();
            this.obj.setShowForFirstTime(true);
            if (this.oldFKIass.showForFirstTime()) {
                this.oldFKIass.resetMandatoryUsingColumns();
            }
            this.memBackup = this.oldFKIass.getFKMemento(this.oldFKIass.getTopView().getDesignPartView());
            this.mem = this.oldFKIass.getFKMemento(this.oldFKIass.getTopView().getDesignPartView());
            this.initDefaults(false);
            this.initSummaryExtras();
            this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getLongName());
            ArrayList<Object> pkukList = new ArrayList<Object>();
            pkukList.addAll(Arrays.asList(((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK()));
            pkukList.addAll(Arrays.asList(((RelationalDesign)this.oldFKIass.getDesignPart()).getAllViewsPKUK()));
            Object[] keys = pkukList.toArray();
            Arrays.sort(keys, ModelObjectSet.LONG_NAME_COMPARATOR);
            this.fillComboItems(keys, this.cbIndexPkUk, false);
            this.cbIndexPkUk.setSelectedItem(this.oldFKIass.getKeyObject());
            this.currentKey = this.oldFKIass.getKeyObject();
            this.cbIndexPkUk.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    KeyObject key = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                    if (ForeignKeyPropertiesDialogEx.this.currentKey != key) {
                        ForeignKeyPropertiesDialogEx.this.currentKey = key;
                        ForeignKeyPropertiesDialogEx.this.initParentChildColumns(key);
                        ((AbstractTableModel)ForeignKeyPropertiesDialogEx.this.columnsTable.getModel()).fireTableDataChanged();
                        TopView tv = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                        TopViewCollection col = key.getContainerWithKeyObject().getViewsForDPV(tv.getDesignPartView());
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
                        if (col.size() > 0) {
                            ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(col.get(0));
                        }
                    }
                }
            });
            StorageDesign sd = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
            if (!this.oldFKIass.isTransferable()) {
                this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
            } else if (this.oldFKIass.isMandatory()) {
                this.fillComboItems(sd.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
            } else {
                this.fillComboItems(sd.getFKDeleteRules(), this.cbDeleteRule, false);
            }
            this.cbDeleteRule.setSelectedItem(sd.getValidFKRule(this.oldFKIass.getDeleteRule()));
            DesignPartView dpv = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getRemoteTable().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getRemoteTable().getViewsForDPV(dpv).toArray(), this.cbSourceTableSynonym, false);
            this.cbSourceTableSynonym.setSelectedItem(this.oldFKIass.getSourceTV(dpv));
            dpv = this.getAppView().getCurrentDPV();
            if (this.oldFKIass.getContainerWithKeyObject().getDesignPart() != dpv.getDesignPart()) {
                dpv = this.oldFKIass.getContainerWithKeyObject().getDesignPart().getMainView();
            }
            this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(dpv).toArray(), this.cbTargetTableSynonym, false);
            this.cbTargetTableSynonym.setSelectedItem(this.oldFKIass.getTargetTV(dpv));
            this.chMarkGenerate.setSelected(this.oldFKIass.getLocalFKIndex().isMarkedGenerate());
            this.chMandatory.setSelected(this.oldFKIass.isMandatory());
            this.chTransferable.setSelected(this.oldFKIass.isTransferable());
            this.chbDeprecated.setSelected(this.oldFKIass.isDeprecated());
            this.chInArc.setSelected(this.oldFKIass.isInArc());
            if (this.oldFKIass.getArc() != null) {
                this.chInArc.setText(this.oldFKIass.getArc().getName());
            }
            this.initParentChildColumns();
            if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
                this.chMandatory.setEnabled(false);
            }
            this.chMandatory.addActionListener(this.statusChanged);
            this.chTransferable.addActionListener(this.statusChanged);
            this.fillComboItems(this.oldFKIass.getRemoteTable().getElements(), this.cbDiscrimanatorCiolumn, true);
            this.cbDiscrimanatorCiolumn.setSelectedItem(this.oldFKIass.getDiscriminatorColumn());
            this.cbRely.setSelectedItem(this.oldFKIass.isRely() ? YES : NO);
            if (this.oldFKIass.getRemoteTable() instanceof Table && !(this.oldFKIass.getLocalFKIndex() instanceof ViewIndex)) {
                this.cbRely.setEnabled(false);
            }
            this.initDynamicProperties();
            this.txtCDCName.setText(this.oldFKIass.getColumnDependencyConstraintGenerateName());
            this.chCDCGenerateInDDL.setSelected(this.oldFKIass.isColumnDependencyConstraintGenerateInDDL());
        }
    }

    private void initDefaults(FKIndexAssociation.FKMemento mem) {
        this.tfName.setText(mem.name);
        if (mem.name_fixed) {
            this.tfName.setEnabled(false);
            this.tfName.setToolTipText(NAME_IS_FROZEN);
        }
        this.taComments.setText(mem.comments);
        this.taNotes.setText(mem.notes);
        this.tfObjectID.setText(mem.id);
        this.tfCreationTime.setText(this.oldFKIass.getCreationTime());
        this.tfCreator.setText(this.oldFKIass.getCreator().getName());
        this.tfDesign.setText(this.oldFKIass.getOwnerDesignName());
        if (this.oldFKIass.getGenerator() != null) {
            this.tfGeneratorName.setText(this.oldFKIass.getGeneratorLongName());
        } else {
            this.tfGeneratorName.setText(NONE);
        }
        this.tfLastChangedBy.setText(this.oldFKIass.getChanger().getName());
        this.tfLastChangedTime.setText(this.oldFKIass.getChangeTime());
    }

    public void initProperties(FKIndexAssociation.FKMemento mem) {
        this.oldFKIass = mem.fk;
        this.oldKey = this.oldFKIass.getKeyObject();
        this.mem = mem;
        FKIndexAssociation fKIndexAssociation = mem.fk;
        fKIndexAssociation.getClass();
        this.memBackup = fKIndexAssociation.new FKIndexAssociation.FKMemento(mem.fk);
        mem.copyTo(this.memBackup);
        this.obj.setShowForFirstTime(false);
        this.initDefaults(mem);
        this.initSummaryExtras();
        this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getLongName());
        ArrayList<Object> pkukList = new ArrayList<Object>();
        pkukList.addAll(Arrays.asList(((RelationalDesign)this.oldFKIass.getDesignPart()).getGlobalIndexSet().getPKUK()));
        pkukList.addAll(Arrays.asList(((RelationalDesign)this.oldFKIass.getDesignPart()).getAllViewsPKUK()));
        Object[] keys = pkukList.toArray();
        Arrays.sort(keys, ModelObjectSet.LONG_NAME_COMPARATOR);
        this.fillComboItems(keys, this.cbIndexPkUk, false);
        this.cbIndexPkUk.setSelectedItem(mem.remoteKey);
        this.currentKey = mem.remoteKey;
        this.cbIndexPkUk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                KeyObject key = (KeyObject)ForeignKeyPropertiesDialogEx.this.cbIndexPkUk.getSelectedItem();
                if (ForeignKeyPropertiesDialogEx.this.currentKey != key) {
                    ForeignKeyPropertiesDialogEx.this.currentKey = key;
                    ForeignKeyPropertiesDialogEx.this.initParentChildColumns(key);
                    ((AbstractTableModel)ForeignKeyPropertiesDialogEx.this.columnsTable.getModel()).fireTableDataChanged();
                    TopView tv = (TopView)ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.getSelectedItem();
                    TopViewCollection col = key.getContainerWithKeyObject().getViewsForDPV(tv.getDesignPartView());
                    ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setModel(new DefaultComboBoxModel<Object>(col.toArray()));
                    if (col.size() > 0) {
                        ForeignKeyPropertiesDialogEx.this.cbSourceTableSynonym.setSelectedItem(col.get(0));
                    }
                }
            }
        });
        StorageDesign sd = ((RelationalDesign)this.oldFKIass.getDesignPart()).getStorageDesign();
        if (!mem.transferable) {
            this.fillComboItems(sd.getFKDeleteRulesNonTransferable(), this.cbDeleteRule, false);
        } else if (this.oldFKIass.isMandatory()) {
            this.fillComboItems(sd.getFKDeleteRulesMandatory(), this.cbDeleteRule, false);
        } else {
            this.fillComboItems(sd.getFKDeleteRules(), this.cbDeleteRule, false);
        }
        this.cbDeleteRule.setSelectedItem(sd.getValidFKRule(mem.deleteRule));
        DesignPartView dpv = this.getAppView().getCurrentDPV();
        FKContainer oldRemoteTable = this.oldFKIass.getRemoteTable();
        if (dpv != null && oldRemoteTable != null && this.oldFKIass.getRemoteTable().getDesignPart() != dpv.getDesignPart() || dpv == null) {
            dpv = this.oldFKIass.getRemoteTable().getDesignPart().getMainView();
        }
        if (mem.remoteTable != null) {
            this.fillComboItems(mem.remoteTable.getViewsForDPV(dpv).toArray(), this.cbSourceTableSynonym, false);
        }
        this.cbSourceTableSynonym.setSelectedItem(mem.sourceTV);
        this.fillComboItems(this.oldFKIass.getContainerWithKeyObject().getViewsForDPV(dpv).toArray(), this.cbTargetTableSynonym, false);
        this.cbTargetTableSynonym.setSelectedItem(mem.targetTV);
        this.chMarkGenerate.setSelected(mem.generate_in_DDL);
        this.chMandatory.setSelected(mem.mandatory);
        this.chTransferable.setSelected(mem.transferable);
        this.chInArc.setSelected(mem.arc != null);
        if (mem.arc != null) {
            this.chInArc.setText(mem.arc.getName());
        }
        this.chbDeprecated.setSelected(mem.cdcDeprecated);
        this.initParentChildColumns();
        if (this.oldFKIass.isInArc() || FKUtilities.hasPKColumnsOnly(this.oldFKIass)) {
            this.chMandatory.setEnabled(false);
        }
        this.chMandatory.addActionListener(this.statusChanged);
        this.chTransferable.addActionListener(this.statusChanged);
        if (this.oldFKIass.getRemoteTable() != null) {
            this.fillComboItems(this.oldFKIass.getRemoteTable().getElements(), this.cbDiscrimanatorCiolumn, true);
        }
        this.cbDiscrimanatorCiolumn.setSelectedItem(mem.discrColumn);
        this.tfDiscrValue.setText(mem.discrValue);
        this.cbRely.setSelectedItem(mem.rely ? YES : NO);
        if (this.oldFKIass.getRemoteTable() instanceof Table && !(this.oldFKIass.getLocalFKIndex() instanceof ViewIndex)) {
            this.cbRely.setEnabled(false);
        }
        this.initDynamicProperties();
        FKContainer table = (FKContainer)this.oldFKIass.getContainerWithKeyObject();
        for (FKElement fKElement : Arrays.asList(table.getElements())) {
            if (Arrays.asList(this.fkColumns).contains(fKElement)) continue;
            this.dependantColumnsList.add(fKElement);
        }
        CDCTableModel cDCTableModel = new CDCTableModel((FKIndexAssociation)this.obj);
        this.columnsDependencyConstraintTable.setModel(cDCTableModel);
        TableColumn col1 = this.columnsDependencyConstraintTable.getColumnModel().getColumn(1);
        col1.setMinWidth(90);
        col1.setMaxWidth(90);
        col1.setPreferredWidth(90);
        TableColumn col2 = this.columnsDependencyConstraintTable.getColumnModel().getColumn(2);
        col2.setMinWidth(90);
        col2.setMaxWidth(90);
        col2.setPreferredWidth(90);
        this.txtCDCName.setText(mem.cdcName);
        this.chCDCGenerateInDDL.setSelected(mem.cdcGenerateInDDL);
    }

    private void initParentChildColumns() {
        if (this.mem != null) {
            this.fkColumns = FKUtilities.getFKColumns(this.mem);
            KeyObject ind = this.mem.fk.getRemoteIndex();
            if (ind != null && ind.getElementsCollection().size() != this.fkColumns.length) {
                FKElement[] oldFKColumns = this.fkColumns;
                this.fkColumns = new FKElement[ind.getElementsCollection().size()];
                for (int i = 0; i < oldFKColumns.length && i < this.fkColumns.length; ++i) {
                    this.fkColumns[i] = oldFKColumns[i];
                }
            }
        } else {
            FKElement[] cols = (FKElement[])this.oldFKIass.getLocalFKIndex().getElements();
            KeyObject remoteIndex = this.oldFKIass.getRemoteIndex();
            int noOfCols = remoteIndex != null ? remoteIndex.size() : cols.length;
            this.fkColumns = new FKElement[noOfCols];
            for (int i = 0; i < noOfCols && i < cols.length; ++i) {
                this.fkColumns[i] = cols[i];
            }
        }
        this.refreshColumnsPanel();
    }

    private void initParentChildColumns(KeyObject newKey) {
        int noOfCols = newKey.getElementsCollection().size();
        this.fkColumns = new FKElement[noOfCols];
        this.refreshColumnsPanel();
    }

    public boolean changed() {
        return this.mem != null && !this.mem.equals(this.memBackup);
    }

    @Override
    protected void setProperties() {
        try {
            ForeignKeyPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
            if (this.mem != null) {
                if (this.obj != null) {
                    this.mem.fk = (FKIndexAssociation)this.obj;
                }
                this.mem.name = this.tfName.getText();
                this.mem.comments = this.taComments.getText();
                this.mem.notes = this.taNotes.getText();
                this.mem.remoteKey = (KeyObject)this.cbIndexPkUk.getSelectedItem();
                this.mem.deleteRule = (String)this.cbDeleteRule.getSelectedItem();
                this.mem.sourceTV = (ContainerView)this.cbSourceTableSynonym.getSelectedItem();
                this.mem.targetTV = (ContainerView)this.cbTargetTableSynonym.getSelectedItem();
                this.mem.generate_in_DDL = this.chMarkGenerate.isSelected();
                this.mem.mandatory = this.chMandatory.isSelected();
                this.mem.transferable = this.chTransferable.isSelected();
                this.mem.columns.clear();
                for (int i = 0; i < this.fkColumns.length; ++i) {
                    FKElement el = this.fkColumns[i];
                    this.mem.columns.add(el.getObjectID());
                    if (el.getTempMandatory() == null) continue;
                    boolean mand = el.getTempMandatory();
                    if (el.isMandatory() != mand) {
                        // empty if block
                    }
                    el.setMandatory(mand);
                    el.getContainer().setDirty(true);
                }
                this.tfLongName.setText(this.oldFKIass.getContainerWithKeyObject().getName());
                this.mem.discrColumn = (FKElement)this.cbDiscrimanatorCiolumn.getSelectedItem();
                this.mem.discrValue = this.tfDiscrValue.getText();
                this.mem.cdcName = this.txtCDCName.getText();
                this.mem.cdcGenerateInDDL = this.chCDCGenerateInDDL.isSelected();
                this.mem.cdcDeprecated = this.chbDeprecated.isSelected();
                this.mem.rely = this.cbRely.getSelectedItem() == YES;
                this.mem.fk.clearProperties();
                for (DynamicProperty dp : this.dynamicPropertiesList) {
                    this.mem.fk.setProperty(dp.getName(), dp.getValue());
                }
                this.mem.fk.resetFromMemento(this.mem);
                FKUpdateEdit edit = new FKUpdateEdit(this.mem.fk, this.mem);
                edit.applyUpdates();
                this.mem.fk.getDesignPart().postUndoableEdit(edit);
                this.mem.fk.updateRemoteObjectListeners();
            } else {
                FKIndexAssociation newFK = (FKIndexAssociation)this.obj;
                newFK.setName(this.tfName.getText());
                newFK.setComment(this.taComments.getText());
                newFK.setNotes(this.taNotes.getText());
                newFK.setKeyObject((KeyObject)this.cbIndexPkUk.getSelectedItem());
                newFK.setDeleteRule((String)this.cbDeleteRule.getSelectedItem());
                newFK.setSourceTopView((ContainerView)this.cbSourceTableSynonym.getSelectedItem());
                newFK.setTargetTopView((ContainerView)this.cbTargetTableSynonym.getSelectedItem());
                newFK.setMarkedGenerate(this.chMarkGenerate.isSelected());
                newFK.setDeprecated(this.chbDeprecated.isSelected());
                newFK.setMandatory(this.chMandatory.isSelected());
                newFK.setTransferable(this.chTransferable.isSelected());
                newFK.changeKeyObject((KeyObject)this.cbIndexPkUk.getSelectedItem(), this.fkColumns);
                newFK.setDiscriminatorColumn((FKElement)this.cbDiscrimanatorCiolumn.getSelectedItem());
                newFK.setDiscriminatorValue(this.tfDiscrValue.getText());
                newFK.setColumnDependencyConstraintGenerateName(this.txtCDCName.getText());
                newFK.setColumnDependencyConstraintGenerateInDDL(this.chCDCGenerateInDDL.isSelected());
                newFK.setRely(this.cbRely.getSelectedItem() == YES);
                newFK.clearProperties();
                for (DynamicProperty dp : this.dynamicPropertiesList) {
                    newFK.setProperty(dp.getName(), dp.getValue());
                }
                FKUpdateEdit edit = new FKUpdateEdit(newFK, this.mem);
                edit.apply();
                newFK.getDesignPart().postUndoableEdit(edit);
                newFK.updateRemoteObjectListeners();
            }
        }
        catch (Exception e) {
            LOGGER.error("Error setting FK's properties!", e);
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getColumnsDependencyConstraintPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getNotesPanel());
        this.addToTree(root, this.getImpactAnalysisPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "FOREIGN_KEY_PROPERTIES_DIALOG";
    }

    @Override
    protected Dimension getDefaultSize() {
        return defaultSize;
    }

    @Override
    protected JPanel getGeneralPanel() {
        if (this.pnGeneral == null) {
            this.pnGeneral = this.createPage(this.generalPanelName);
            this.contentPanel = new JPanel((LayoutManager)new MigLayout("fill", "[140!][grow, 150:150:]10[140!][grow, 150:150:]", "[]10[]"));
            this.pnGeneral.add((Component)this.contentPanel, "Center");
            this.lbName = new JLabel(LB_NAME);
            this.tfName = new JTextField();
            this.tfName.setEnabled(this.isEditable());
        }
        return this.pnGeneral;
    }

    private void initGeneral() {
        JLabel lbLongName = new JLabel(LB_TABLE);
        this.tfLongName = new JTextField();
        this.tfLongName.setEditable(false);
        JLabel lbIndexPkUk = new JLabel(LB_INDEX_PK_UK);
        this.cbIndexPkUk = new JComboBox();
        this.cbIndexPkUk.setMaximumRowCount(20);
        JLabel lbDeleteRule = new JLabel(LB_DELETE_RULE);
        this.cbDeleteRule = new JComboBox();
        this.cbDeleteRule.setMaximumRowCount(8);
        JLabel lbSourceTableSynonym = new JLabel(LB_SOURCE_TABLE_SYNONYM);
        this.cbSourceTableSynonym = new JComboBox();
        this.cbSourceTableSynonym.setMaximumRowCount(8);
        JLabel lbTargetTableSynonym = new JLabel(LB_TARGET_TABLE_SYNONYM);
        this.cbTargetTableSynonym = new JComboBox();
        this.cbTargetTableSynonym.setMaximumRowCount(8);
        JLabel lbMandatory = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Mandatory1"));
        this.chMandatory = new JCheckBox();
        JLabel lbTransferable = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.TransferableUpdatable"));
        this.chTransferable = new JCheckBox();
        JLabel lbMarkGenerate = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.GenerateInDDL"));
        this.chMarkGenerate = new JCheckBox();
        JLabel lbInArc = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.InArc"));
        this.chInArc = new JCheckBox();
        this.chInArc.setEnabled(false);
        JLabel lbDeprecated = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Deprecated"));
        this.chbDeprecated = new JCheckBox();
        JLabel lbDiscrimanatorCiolumn = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorColumn1"));
        this.cbDiscrimanatorCiolumn = new JComboBox();
        this.cbDiscrimanatorCiolumn.setMaximumRowCount(8);
        JLabel lbDiscriminatorValue = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.DiscriminatorValue1"));
        this.tfDiscrValue = new JTextField();
        JLabel lbRely = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.Rely"));
        this.cbRely = new JComboBox<String>(YES_NO);
        this.cbRely.setMaximumRowCount(8);
        this.pnColumns = new JPanel((LayoutManager)new MigLayout("fill", "grow", ""));
        this.pnColumns.setBorder(BorderFactory.createTitledBorder(Messages.getString("ForeignKeyPropertiesDialogEx.AssociatedColumns")));
        this.contentPanel.add(this.lbName);
        this.contentPanel.add((Component)this.tfName, new CC().growX());
        this.contentPanel.add(lbLongName);
        this.contentPanel.add((Component)this.tfLongName, new CC().growX().wrap());
        this.contentPanel.add(lbIndexPkUk);
        this.contentPanel.add((Component)this.cbIndexPkUk, new CC().width("120:120:").growX());
        this.contentPanel.add(lbDeleteRule);
        this.contentPanel.add((Component)this.cbDeleteRule, new CC().width("100:100:").wrap());
        this.contentPanel.add(lbSourceTableSynonym);
        this.contentPanel.add((Component)this.cbSourceTableSynonym, new CC().width("120:120:").growX());
        this.contentPanel.add(lbTargetTableSynonym);
        this.contentPanel.add((Component)this.cbTargetTableSynonym, new CC().width("120:120:").growX().wrap());
        this.contentPanel.add(lbMandatory);
        this.contentPanel.add(this.chMandatory);
        this.contentPanel.add(lbDeprecated);
        this.contentPanel.add((Component)this.chbDeprecated, new CC().wrap());
        this.contentPanel.add(lbTransferable);
        this.contentPanel.add(this.chTransferable);
        this.contentPanel.add(lbMarkGenerate);
        this.contentPanel.add((Component)this.chMarkGenerate, new CC().wrap());
        this.contentPanel.add(lbInArc);
        JPanel arcPanel = new JPanel((LayoutManager)new MigLayout("fill", "0[]10[grow]0", "0[]0"));
        arcPanel.add(this.chInArc);
        this.contentPanel.add((Component)arcPanel, new CC().growX());
        this.contentPanel.add(lbRely);
        this.contentPanel.add((Component)this.cbRely, new CC().width("50:50:").wrap());
        this.contentPanel.add(lbDiscrimanatorCiolumn);
        this.contentPanel.add((Component)this.cbDiscrimanatorCiolumn, new CC().width("120:120:").growX());
        this.contentPanel.add(lbDiscriminatorValue);
        this.contentPanel.add((Component)this.tfDiscrValue, new CC().growX().wrap());
        this.pnColumns.add((Component)new JScrollPane(this.getColumnsTable()), new CC().grow());
        this.contentPanel.add((Component)this.pnColumns, new CC().grow().spanX(4).wrap());
        CommonUtil.centerOnScreen(this);
    }

    protected JTable getColumnsTable() {
        FKColumnsTableModel fkColumnsTableModel = new FKColumnsTableModel();
        fkColumnsTableModel.init(this.fkColumns, this.currentKey, this.chMandatory);
        this.columnsTable = new JTable(fkColumnsTableModel);
        this.columnsTable.getTableHeader().setReorderingAllowed(false);
        FKColumnsCellEditor fkColumnsCellEditor = new FKColumnsCellEditor();
        if (this.oldFKIass != null) {
            fkColumnsCellEditor.init(this.fkColumns, this.currentKey, this.oldFKIass.getContainerWithKeyObject().getElementsAndNestedElementsCollection());
        } else {
            fkColumnsCellEditor.init(this.fkColumns, this.currentKey, null);
        }
        this.columnsTable.getColumnModel().getColumn(1).setCellEditor(fkColumnsCellEditor);
        this.columnsTable.getColumnModel().getColumn(2).setMinWidth(80);
        this.columnsTable.getColumnModel().getColumn(2).setMaxWidth(80);
        this.columnsTable.setEnabled(this.isEditable());
        return this.columnsTable;
    }

    private void refreshColumnsPanel() {
        this.columnsTable = this.getColumnsTable();
        this.pnColumns.remove(this.pnColumns.getComponentCount() - 1);
        this.pnColumns.add((Component)new JScrollPane(this.getColumnsTable()), new CC().grow());
        this.pnColumns.validate();
    }

    protected JPanel getColumnsDependencyConstraintPanel() {
        if (this.pnColumnsDependencyConstraint == null) {
            this.pnColumnsDependencyConstraint = this.createPage(Messages.getString("ForeignKeyPropertiesDialogEx.DependantColumnsConstraint"));
            JPanel jpanel = new JPanel(new BorderLayout());
            JPanel pnGrid = new JPanel(new GridLayout(2, 2, 10, 10));
            JLabel lblCName = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.ConstraintName"));
            lblCName.setPreferredSize(this.getDefaultSize());
            this.txtCDCName = new JTextField();
            this.txtCDCName.setPreferredSize(this.getDefaultSize());
            JLabel lbGenerateInDDL = new JLabel(Messages.getString("ForeignKeyPropertiesDialogEx.GenerateInDDL"));
            lbGenerateInDDL.setPreferredSize(this.getDefaultSize());
            this.chCDCGenerateInDDL = new JCheckBox();
            this.chCDCGenerateInDDL.setPreferredSize(this.getDefaultSize());
            pnGrid.add(this.createRow(lblCName, this.txtCDCName));
            pnGrid.add(this.createRow(lbGenerateInDDL, this.chCDCGenerateInDDL));
            jpanel.add((Component)pnGrid, "North");
            JScrollPane jsp = new JScrollPane(this.getColumnsDependencyConstraintTable());
            jsp.setBorder(BorderFactory.createTitledBorder(Messages.getString("ForeignKeyPropertiesDialogEx.Columns")));
            jpanel.add((Component)jsp, "Center");
            this.pnColumnsDependencyConstraint.add(jpanel);
        }
        return this.pnColumnsDependencyConstraint;
    }

    protected JTable getColumnsDependencyConstraintTable() {
        if (this.columnsDependencyConstraintTable == null) {
            this.dependantColumnsList = new ArrayList();
            this.columnsDependencyConstraintTable = new JTable();
        }
        return this.columnsDependencyConstraintTable;
    }

    public boolean hasColumnWithAllowNulls() {
        for (int i = 0; i < this.fkColumns.length; ++i) {
            if (this.fkColumns[i] == null || !this.fkColumns[i].getNullsAllowed()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected boolean canExit() {
        if (super.canExit()) {
            return FKUtilities.checkRequiredProperties(this, this.fkColumns, this.oldFKIass, this.chMandatory.isSelected(), this.chTransferable.isSelected());
        }
        return false;
    }

    private JPanel getImpactAnalysisPanel() {
        JPanel pnImpact = this.createPage(IMPACT_ANALYSIS);
        this.tree = new JTree();
        this.tree.setToggleClickCount(50);
        this.tree.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                TreePath path;
                Object last;
                if (e.getClickCount() == 2 && (last = (path = ForeignKeyPropertiesDialogEx.this.tree.getClosestPathForLocation(e.getPoint().x, e.getPoint().y)).getLastPathComponent()) instanceof ModelIdObjectSelection) {
                    ModelIDObject obj = ((ModelIdObjectSelection)last).getObject();
                    if (obj != null) {
                        e.consume();
                        obj.showPropertyDialog();
                    } else {
                        if (ForeignKeyPropertiesDialogEx.this.tree.isCollapsed(path)) {
                            ForeignKeyPropertiesDialogEx.this.tree.expandPath(path);
                        } else {
                            ForeignKeyPropertiesDialogEx.this.tree.collapsePath(path);
                        }
                        e.consume();
                    }
                }
            }
        });
        JScrollPane scrollPane = new JScrollPane(this.tree);
        pnImpact.add((Component)scrollPane, "Center");
        return pnImpact;
    }

    @Override
    protected JTree initImpactAnalysisTreeModel() {
        this.tree.addTreeWillExpandListener(this);
        CompareTreeNavigationDesign treeDesign = new CompareTreeNavigationDesign(new ImpA_FKAssociation(this.getFK_ForIA(), null, true), false);
        ImpactTreeRenderer renderer = new ImpactTreeRenderer();
        this.tree.setModel(treeDesign);
        this.tree.setCellRenderer(renderer);
        return this.tree;
    }

    private FKIndexAssociation getFK_ForIA() {
        String id = this.oldFKIass.getObjectID();
        FKIndexAssociation fk = (FKIndexAssociation)((RelationalDesign)this.oldFKIass.getDesignPart()).getFKIndexAssociationSet().getObjectByID(id);
        if (fk == null) {
            fk = this.oldFKIass;
        }
        return fk;
    }

    @Override
    protected int getMinimumHeight() {
        return 550;
    }

    @Override
    protected int getMinimumWidth() {
        return 860;
    }

    public FKIndexAssociation.FKMemento getFKMemento() {
        return this.mem;
    }

    @Override
    protected void onCancel() {
        if (this.obj != null && this.obj.showForFirstTime()) {
            try {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(true);
                }
                this.obj.remove();
            }
            finally {
                if (this.obj instanceof FKIndexAssociation) {
                    ((FKIndexAssociation)this.obj).setSilentRemove(false);
                }
            }
        }
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    class CDCTableModel
    extends AbstractTableModel {
        private FKIndexAssociation fk;
        final String[] COL_NAMES = new String[]{Messages.getString("ForeignKeyPropertiesDialogEx.ColumnCol"), Messages.getString("ForeignKeyPropertiesDialogEx.Depend"), Messages.getString("ForeignKeyPropertiesDialogEx.AsMandatory")};

        CDCTableModel(FKIndexAssociation fk) {
            this.fk = fk;
        }

        @Override
        public int getRowCount() {
            return ForeignKeyPropertiesDialogEx.this.dependantColumnsList.size();
        }

        @Override
        public int getColumnCount() {
            return this.COL_NAMES.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.COL_NAMES[col];
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            FKElement column = (FKElement)ForeignKeyPropertiesDialogEx.this.dependantColumnsList.get(rowIndex);
            if (columnIndex == 0) {
                return column.getName();
            }
            if (columnIndex == 1) {
                return column.getDependOnForeignKey() != null;
            }
            if (columnIndex == 2) {
                return column.isDependOnFK_AsMandatory();
            }
            return Messages.getString("ForeignKeyPropertiesDialogEx.8");
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            FKElement column = (FKElement)ForeignKeyPropertiesDialogEx.this.dependantColumnsList.get(row);
            if (col == 1) {
                if (((Boolean)value).booleanValue()) {
                    column.setDependOnForeignKey(this.fk);
                } else {
                    column.setDependOnForeignKeyID("");
                    column.setDependOnForeignKey(null);
                }
            } else if (col == 2) {
                column.setDependOnFK_AsMandatory((Boolean)value);
            }
        }
    }
}

