/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.relational;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKDiscoverer;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.relational.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class FKDiscovererDialog
extends CustomDialog {
    private JDialog dialog;
    private JPanel generalPanel;
    private String title = "Create discovered foreign keys";
    private boolean cancelled = true;
    private FKDiscoverer fkDiscoverer;
    private JTable fkTable;
    private FKmodel model;
    private Dimension dimension = new Dimension(800, 550);
    private static String REFERRED_TABLE = "Referred Table";
    private static String REFERRED_KEY = "Referred Key";
    private static String TABLE = "Table";
    private static String COLUMNS = "Columns";
    private static String[] COLUMN_CHOICES = new String[]{REFERRED_TABLE, REFERRED_KEY, TABLE, COLUMNS};
    private static String NP_REFERRED = "Referred Column";
    private static String NP_TEMPLATE = "FK Column Template";
    private static String NP_REF_AND_TEMPLATE = "Referred and Template";
    private static String NP_TEMPLATE_AND_REF = "Template and Referred";
    private static String[] POLICY_CHOICES = new String[]{NP_REFERRED, NP_TEMPLATE, NP_REF_AND_TEMPLATE, NP_TEMPLATE_AND_REF};
    private static String SCAN_AGAIN = "Scan Again";
    private static String COLUMN_TO_ONEFK_LABEL = " Single use of FK column:";
    private static String COLUMN_TO_ONEFK_HINT = "Restricts column to be bound to maximum one foreign key";
    private static String NAME_POLICY_LABEL = "   FK Column name policy:";
    private static String NAME_POLICY_HINT = "Set how name of column from referred key is matched to column in child table";
    private static String SCAN_AGAIN_HINT = "Clears current result and discover foreign keys using current settings";
    private JComboBox cbChoices;
    private JComboBox cbNameMatch;
    private JTextField filterText;
    private JCheckBox chbOneFK;

    public FKDiscovererDialog(ApplicationView appView, FKDiscoverer fkDiscoverer) {
        super(appView);
        this.generalPanel = new JPanel(new BorderLayout());
        this.generalPanel.setPreferredSize(this.dimension);
        this.generalPanel.setMinimumSize(this.dimension);
        this.fkDiscoverer = fkDiscoverer;
        this.init();
        this.add((Component)this.generalPanel, "Center");
        this.generalPanel.add((Component)this.getToolbar(), "North");
        this.generalPanel.add((Component)this.getOptionsPanel(), "South");
        this.add((Component)this.getButtonPanel(), "South");
    }

    private JToolBar getToolbar() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        JButton bnSelectAll = new JButton(configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        bnSelectAll.addActionListener(new SelectAllAction());
        bnSelectAll.setToolTipText(Messages.getString("FKDiscovererDialog.SelectAll"));
        JButton bnDeselectAll = new JButton(configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        bnDeselectAll.addActionListener(new DeselectAllAction());
        bnDeselectAll.setToolTipText(Messages.getString("FKDiscovererDialog.DeselectAll"));
        JLabel cblabel = new JLabel("  " + Messages.getString("FKDiscovererDialog.ColumnToFilter"), 11);
        cblabel.setLabelFor(this.cbChoices);
        this.cbChoices = new JComboBox<String>(new DefaultComboBoxModel<String>(COLUMN_CHOICES));
        this.cbChoices.setSelectedItem(TABLE);
        this.cbChoices.setPreferredSize(new Dimension(125, MessageDialogs.BUTTON_SIZE_EX.height));
        this.cbChoices.setMaximumSize(new Dimension(125, MessageDialogs.BUTTON_SIZE_EX.height));
        JLabel flabel = new JLabel("   " + Messages.getString("FKDiscovererDialog.Filter"), 11);
        this.filterText = new JTextField();
        this.filterText.setPreferredSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.setMaximumSize(new Dimension(200, MessageDialogs.BUTTON_SIZE_EX.height));
        this.filterText.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                FKDiscovererDialog.this.newFilter();
            }
        });
        flabel.setLabelFor(this.filterText);
        toolBar.add(bnSelectAll);
        toolBar.add(bnDeselectAll);
        toolBar.addSeparator();
        toolBar.add(cblabel);
        toolBar.add(this.cbChoices);
        toolBar.add(flabel);
        toolBar.add(this.filterText);
        return toolBar;
    }

    private JPanel getOptionsPanel() {
        JPanel optionsPanel = new JPanel(new FlowLayout(0));
        JLabel chLabel = new JLabel(COLUMN_TO_ONEFK_LABEL);
        this.chbOneFK = new JCheckBox();
        chLabel.setLabelFor(this.chbOneFK);
        this.chbOneFK.setSelected(FKDiscoverer.IN_ONE_FK_ONLY);
        this.chbOneFK.setToolTipText(COLUMN_TO_ONEFK_HINT);
        chLabel.setToolTipText(COLUMN_TO_ONEFK_HINT);
        JLabel chbLabel = new JLabel(NAME_POLICY_LABEL);
        chbLabel.setToolTipText(NAME_POLICY_HINT);
        this.cbNameMatch = new JComboBox<String>(new DefaultComboBoxModel<String>(POLICY_CHOICES));
        chbLabel.setLabelFor(this.cbNameMatch);
        this.cbNameMatch.setSelectedIndex(FKDiscoverer.NAME_POLICY);
        this.cbNameMatch.setToolTipText(NAME_POLICY_HINT);
        JLabel emptyLabel = new JLabel("     ");
        JButton scan = new JButton(SCAN_AGAIN);
        scan.setToolTipText(SCAN_AGAIN_HINT);
        optionsPanel.add(chLabel);
        optionsPanel.add(this.chbOneFK);
        optionsPanel.add(chbLabel);
        optionsPanel.add(this.cbNameMatch);
        optionsPanel.add(emptyLabel);
        optionsPanel.add(scan);
        optionsPanel.setBorder(BorderFactory.createRaisedBevelBorder());
        this.chbOneFK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscoverer.IN_ONE_FK_ONLY = FKDiscovererDialog.this.chbOneFK.isSelected();
            }
        });
        this.cbNameMatch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscoverer.NAME_POLICY = FKDiscovererDialog.this.cbNameMatch.getSelectedIndex();
            }
        });
        scan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.fkDiscoverer.rescane();
                FKDiscovererDialog.this.model.fireTableDataChanged();
            }
        });
        return optionsPanel;
    }

    private void init() {
        this.model = new FKmodel(this.fkDiscoverer);
        this.fkTable = new JTable(this.model);
        TableColumn tcol = this.fkTable.getColumnModel().getColumn(0);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        tcol = this.fkTable.getColumnModel().getColumn(1);
        tcol.setPreferredWidth(40);
        tcol.setMaxWidth(40);
        this.fkTable.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(this.fkTable, 4);
        JScrollPane sp = new JScrollPane(this.fkTable);
        this.generalPanel.add(sp);
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public boolean showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
        return !this.cancelled;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), this.title);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.dialog.setResizable(true);
            this.dialog.setMinimumSize(this.dimension);
            this.dialog.setModal(true);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "FK_DISCOVERER_DIALOG";
    }

    private void setProperties() {
    }

    private JPanel getButtonPanel() {
        JPanel buttonPanel = new JPanel(new FlowLayout(2));
        JButton ok = new JButton(Messages.getString("FKDiscovererDialog.OK"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.setProperties();
                FKDiscovererDialog.this.cancelled = false;
                FKDiscovererDialog.this.close();
            }
        });
        JButton cancel = new JButton(Messages.getString("FKDiscovererDialog.Cancel"));
        cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FKDiscovererDialog.this.cancelled = true;
                FKDiscovererDialog.this.close();
            }
        });
        JButton btnHelp = new JButton(this.getHelpAction());
        btnHelp.setMnemonic(72);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(btnHelp);
        return buttonPanel;
    }

    private void newFilter() {
        RowFilter rf = null;
        JTable current = this.fkTable;
        if (current != null) {
            if (!"".equals(this.filterText.getText())) {
                try {
                    int col = this.cbChoices.getSelectedIndex();
                    rf = RowFilter.regexFilter("(?i)" + this.filterText.getText(), col + 2);
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(rf);
            } else {
                current.clearSelection();
                ((DefaultRowSorter)current.getRowSorter()).setRowFilter(null);
            }
        }
    }

    static /* synthetic */ String access$900() {
        return REFERRED_TABLE;
    }

    static /* synthetic */ String access$1000() {
        return REFERRED_KEY;
    }

    static /* synthetic */ String access$1100() {
        return TABLE;
    }

    static /* synthetic */ String access$1200() {
        return COLUMNS;
    }

    private class SelectAllAction
    implements ActionListener {
        private SelectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = FKDiscovererDialog.this.fkTable;
            if (table != null) {
                if (table.getRowCount() != table.getModel().getRowCount()) {
                    int count = table.getRowCount();
                    List list = FKDiscovererDialog.this.fkDiscoverer.getPrepareList();
                    for (int i = 0; i < count; ++i) {
                        int index = table.convertRowIndexToModel(i);
                        if (index <= -1 || index >= list.size()) continue;
                        FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)list.get(index);
                        fkp.selected = true;
                    }
                } else {
                    for (FKDiscoverer.FKPrepare fkp : FKDiscovererDialog.this.fkDiscoverer.getPrepareList()) {
                        fkp.selected = true;
                    }
                }
                table.updateUI();
            }
        }
    }

    private class DeselectAllAction
    implements ActionListener {
        private DeselectAllAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JTable table = FKDiscovererDialog.this.fkTable;
            if (table != null) {
                if (table.getRowCount() != table.getModel().getRowCount()) {
                    int count = table.getRowCount();
                    List list = FKDiscovererDialog.this.fkDiscoverer.getPrepareList();
                    for (int i = 0; i < count; ++i) {
                        int index = table.convertRowIndexToModel(i);
                        if (index <= -1 || index >= list.size()) continue;
                        FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)list.get(index);
                        fkp.selected = false;
                    }
                } else {
                    for (FKDiscoverer.FKPrepare fkp : FKDiscovererDialog.this.fkDiscoverer.getPrepareList()) {
                        fkp.selected = false;
                    }
                }
                table.updateUI();
            }
        }
    }

    class FKmodel
    extends DefaultTableModel {
        final String[] columns = new String[]{"", "", FKDiscovererDialog.access$900(), FKDiscovererDialog.access$1000(), FKDiscovererDialog.access$1100(), FKDiscovererDialog.access$1200()};
        FKDiscoverer fkd;

        FKmodel(FKDiscoverer fkDiscoverer) {
            this.fkd = fkDiscoverer;
        }

        @Override
        public int getColumnCount() {
            return this.columns.length;
        }

        @Override
        public String getColumnName(int column) {
            return this.columns[column];
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (row < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(row);
                if (column == 0) {
                    int trow = FKDiscovererDialog.this.fkTable.convertRowIndexToView(row);
                    return trow + 1;
                }
                if (column == 1) {
                    return fkp.selected;
                }
                if (column == 2) {
                    return fkp.parentTable.getLongName();
                }
                if (column == 3) {
                    return fkp.referredKey.getName();
                }
                if (column == 4) {
                    return fkp.childTable.getLongName();
                }
                if (column == 5) {
                    String cols = "";
                    for (Column col : fkp.childColumns) {
                        if ("".equals(cols)) {
                            cols = cols + col.getName();
                            continue;
                        }
                        cols = cols + ", " + col.getName();
                    }
                    return cols;
                }
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1;
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if (column == 1 && row < this.fkd.getPrepareList().size()) {
                FKDiscoverer.FKPrepare fkp = (FKDiscoverer.FKPrepare)this.fkd.getPrepareList().get(row);
                fkp.selected = (Boolean)aValue;
            }
        }

        @Override
        public int getRowCount() {
            if (this.fkd == null) {
                return 0;
            }
            return this.fkd.getPrepareList().size();
        }

        public Class getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 1) {
                return Boolean.class;
            }
            return String.class;
        }
    }
}

