/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.multidimensional;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.ModelObjectSet;
import oracle.dbtools.crest.model.design.ContainedObject;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.logical.Entity;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.SlowChangingAttribute;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.multidimensional.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.options.Settings;

public class SelectDescriptiveAttributesDialog
extends CustomDialog
implements AbstractEditorConstants {
    private List aList;
    private JList selectedAttributesList;
    private JList allAttributesList;
    private DefaultListModel allAttributesModel;
    private DefaultListModel selectedAttributesModel;
    private JButton btnAddAttributes;
    private JButton btnRemoveAttributes;
    protected JPanel generalPanel;
    private ContainerObject selectedEntity;
    private Level level;
    protected JDialog dialog;
    List copyList = new ArrayList();

    public SelectDescriptiveAttributesDialog(ApplicationView view, List aList, ContainerObject selectedEntity, Level level) {
        super(view);
        this.level = level;
        this.selectedEntity = selectedEntity;
        this.aList = aList;
        this.generalPanel = new JPanel(new GridBagLayout());
        this.allAttributesModel = new DefaultListModel();
        this.selectedAttributesModel = new DefaultListModel();
        this.init();
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
        this.getDialog().setVisible(true);
    }

    private SlowChangingAttribute getSCAforAttr(List list, ContainedObject attr) {
        for (SlowChangingAttribute sca : list) {
            if (sca.getAttribute() != attr) continue;
            return sca;
        }
        return null;
    }

    private boolean containsAttribute(ContainedObject attribute) {
        for (SlowChangingAttribute scha : this.aList) {
            if (scha.getAttribute() != attribute) continue;
            return true;
        }
        return false;
    }

    private void init() {
        this.initAllAttributesList();
        this.initAttributesButtons();
        this.initSelectedAttributesList();
        this.fillLists();
    }

    private void fillLists() {
        Iterator it = this.aList.iterator();
        while (it.hasNext()) {
            SlowChangingAttribute scha = (SlowChangingAttribute)it.next();
            if (scha.getAttribute() == null) continue;
            this.selectedAttributesModel.addElement(new AttributeItem(scha.getAttribute()));
        }
        ArrayList list = new ArrayList();
        if (this.selectedEntity != null) {
            if (this.selectedEntity instanceof Entity) {
                list.addAll(((Entity)this.selectedEntity).getHierarchicalAttributes());
            } else {
                list.addAll(this.selectedEntity.getElementsCollection());
            }
            Collections.sort(list, ModelObjectSet.NAME_COMPARATOR);
            it = list.iterator();
        } else if (this.level != null) {
            list.addAll(this.level.getMultidimensionalDesign().getAttributes());
            Collections.sort(list, ModelObjectSet.LONG_NAME_COMPARATOR);
            it = list.iterator();
        }
        if (it != null) {
            while (it.hasNext()) {
                ContainedObject next = (ContainedObject)it.next();
                if (this.containsAttribute(next)) continue;
                this.allAttributesModel.addElement(new AttributeItem(next));
            }
        }
    }

    private void initAllAttributesList() {
        JPanel attributesList = new JPanel(new GridBagLayout());
        attributesList.setPreferredSize(new Dimension(100, 100));
        attributesList.setMinimumSize(new Dimension(100, 100));
        attributesList.setMaximumSize(new Dimension(100, 100));
        attributesList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDescriptiveAttributesDialog.Available")));
        this.allAttributesList = new JList(this.allAttributesModel);
        this.allAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.doClick();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.allAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new AllColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.allAttributesList);
        attributesList.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)attributesList, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    private void initSelectedAttributesList() {
        JPanel selectedList = new JPanel(new GridBagLayout());
        selectedList.setPreferredSize(new Dimension(100, 100));
        selectedList.setMinimumSize(new Dimension(100, 100));
        selectedList.setMaximumSize(new Dimension(100, 100));
        selectedList.setBorder(BorderFactory.createTitledBorder(Messages.getString("SelectDescriptiveAttributesDialog.Selected")));
        this.selectedAttributesList = new JList(this.selectedAttributesModel);
        this.selectedAttributesList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                JList list = (JList)evt.getSource();
                if (evt.getClickCount() == 2) {
                    int index = list.locationToIndex(evt.getPoint());
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.doClick();
                }
            }
        });
        ListSelectionModel listSelectionModel = this.selectedAttributesList.getSelectionModel();
        listSelectionModel.addListSelectionListener(new SelectedColumnsListSelectionHandler());
        JScrollPane sp = new JScrollPane(this.selectedAttributesList);
        selectedList.add((Component)sp, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.generalPanel.add((Component)selectedList, new GridBagConstraints(2, 0, 1, 1, 1.0, 1.0, 11, 1, new Insets(2, 2, 2, 2), 0, 0));
    }

    protected int getPreferredIconSize() {
        return 16;
    }

    private void initAttributesButtons() {
        GUIConfiguration configuration = GUIConfiguration.getInstance();
        this.btnAddAttributes = new JButton(configuration.getIcon("MOVE_RIGHT_ICON", this.getPreferredIconSize()));
        this.btnAddAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnAddAttributes.addActionListener(new AddColumnsActionListener());
        this.btnAddAttributes.setEnabled(false);
        this.btnAddAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Add"));
        this.btnRemoveAttributes = new JButton(configuration.getIcon("MOVE_LEFT_ICON", this.getPreferredIconSize()));
        this.btnRemoveAttributes.setPreferredSize(new Dimension(32, 32));
        this.btnRemoveAttributes.setEnabled(false);
        this.btnRemoveAttributes.addActionListener(new RemoveColumnsActionListener());
        this.btnRemoveAttributes.setToolTipText(Messages.getString("SelectDescriptiveAttributesDialog.Remove"));
        Box buttonsPanel = Box.createVerticalBox();
        buttonsPanel.setPreferredSize(new Dimension(32, 32));
        buttonsPanel.setMinimumSize(new Dimension(32, 32));
        buttonsPanel.setMaximumSize(new Dimension(32, 32));
        buttonsPanel.add(Box.createVerticalGlue());
        buttonsPanel.add(this.btnAddAttributes);
        buttonsPanel.add(this.btnRemoveAttributes);
        buttonsPanel.add(Box.createVerticalGlue());
        this.generalPanel.add((Component)buttonsPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("SelectDescriptiveAttributesDialog.SelectDescriptiveAttributes"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = SelectDescriptiveAttributesDialog.this.dialog.getWidth();
                    int h = SelectDescriptiveAttributesDialog.this.dialog.getHeight();
                    w = Math.max(500, w);
                    h = Math.max(410, h);
                    SelectDescriptiveAttributesDialog.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = 500;
                int h = 410;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(500, (int)ds.rec.getSize().getWidth());
                int h = Math.max(410, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.getDialog().dispose();
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    private void sortAttributes(DefaultListModel model) {
        ArrayList col = new ArrayList();
        Enumeration e = model.elements();
        while (e.hasMoreElements()) {
            col.add(e.nextElement());
        }
        Collections.sort(col, new AttrComparator());
        model.clear();
        Iterator it = col.iterator();
        while (it.hasNext()) {
            model.addElement(it.next());
        }
    }

    class AttrComparator
    implements Comparator {
        AttrComparator() {
        }

        public int compare(Object o1, Object o2) {
            AttributeItem a1 = (AttributeItem)o1;
            AttributeItem a2 = (AttributeItem)o2;
            return a1.getAttribute().getName().compareTo(a2.getAttribute().getName());
        }
    }

    private class SelectedColumnsListSelectionHandler
    implements ListSelectionListener {
        private SelectedColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnRemoveAttributes.setEnabled(true);
                }
            }
        }
    }

    private class AllColumnsListSelectionHandler
    implements ListSelectionListener {
        private AllColumnsListSelectionHandler() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedIndex() == -1) {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(false);
                } else {
                    SelectDescriptiveAttributesDialog.this.btnAddAttributes.setEnabled(true);
                }
            }
        }
    }

    private class RemoveColumnsActionListener
    implements ActionListener {
        private RemoveColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectDescriptiveAttributesDialog.this.selectedAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectDescriptiveAttributesDialog.this.selectedAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectDescriptiveAttributesDialog.this.allAttributesModel.contains(ob)) continue;
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.addElement(ob);
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.removeElement(ob);
                }
            }
        }
    }

    private class AddColumnsActionListener
    implements ActionListener {
        private AddColumnsActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (!SelectDescriptiveAttributesDialog.this.allAttributesModel.isEmpty()) {
                Object[] selectedObjects = SelectDescriptiveAttributesDialog.this.allAttributesList.getSelectedValues();
                for (int i = 0; i < selectedObjects.length; ++i) {
                    Object ob = selectedObjects[i];
                    if (SelectDescriptiveAttributesDialog.this.selectedAttributesModel.contains(ob)) continue;
                    SelectDescriptiveAttributesDialog.this.selectedAttributesModel.addElement(ob);
                    SelectDescriptiveAttributesDialog.this.allAttributesModel.removeElement(ob);
                }
                SelectDescriptiveAttributesDialog.this.sortAttributes(SelectDescriptiveAttributesDialog.this.selectedAttributesModel);
            }
        }
    }

    private class AttributeItem {
        private ContainedObject attribute = null;

        public AttributeItem(ContainedObject attribute) {
            this.attribute = attribute;
        }

        public ContainedObject getAttribute() {
            return this.attribute;
        }

        public String toString() {
            if (this.attribute != null) {
                return this.attribute.getLongName();
            }
            return "";
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDescriptiveAttributesDialog.this.getDialog().dispose();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SelectDescriptiveAttributesDialog.this.copyList.clear();
            SelectDescriptiveAttributesDialog.this.copyList.addAll(SelectDescriptiveAttributesDialog.this.aList);
            SelectDescriptiveAttributesDialog.this.aList.clear();
            for (int i = 0; i < SelectDescriptiveAttributesDialog.this.selectedAttributesModel.size(); ++i) {
                AttributeItem item = (AttributeItem)SelectDescriptiveAttributesDialog.this.selectedAttributesModel.getElementAt(i);
                SlowChangingAttribute sca = SelectDescriptiveAttributesDialog.this.getSCAforAttr(SelectDescriptiveAttributesDialog.this.copyList, item.getAttribute());
                if (sca == null) {
                    sca = new SlowChangingAttribute(SelectDescriptiveAttributesDialog.this.level, item.getAttribute());
                }
                SelectDescriptiveAttributesDialog.this.aList.add(sca);
            }
            SelectDescriptiveAttributesDialog.this.close();
        }
    }
}

