/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor.businessinfo;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.editor.AbstractPropertiesDialog;
import oracle.dbtools.crest.swingui.editor.DynamicProperty;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddEmailDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddLocationDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddPhoneDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.AddUrlDialog;
import oracle.dbtools.crest.swingui.editor.businessinfo.EmailPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.LocationPropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.Messages;
import oracle.dbtools.crest.swingui.editor.businessinfo.PhonePropertiesDialogEx;
import oracle.dbtools.crest.swingui.editor.businessinfo.UrlPropertiesDialogEx;

public class ContactPropertiesDialogEx
extends AbstractPropertiesDialog {
    private BIContact contact;
    private JTable eTable;
    private List eList;
    private JTable lTable;
    private List lList;
    private JTable pTable;
    private List pList;
    private JTable tTable;
    private List tList;
    private JTable uTable;
    private List uList;
    private JPanel pnEmails;
    private JPanel pnLocations;
    private JPanel pnParties;
    private JPanel pnPhones;
    private JPanel pnUrls;

    public ContactPropertiesDialogEx(ApplicationView view, DesignObject object) {
        super(view, object);
    }

    public ContactPropertiesDialogEx(Dialog owner, ApplicationView view, DesignObject object) {
        super(owner, view, object);
    }

    @Override
    public String getCaption() {
        return Messages.getString("ContactPropertiesDialogEx.ContactProperties");
    }

    @Override
    public void initProperties(DesignObject object) {
        if (object instanceof BIContact) {
            this.contact = (BIContact)object;
            this.tfName.setText(this.contact.getName());
            this.lList.addAll(this.contact.getLocations());
            this.eList.addAll(this.contact.getEmails());
            this.pList.addAll(this.contact.getParties());
            this.tList.addAll(this.contact.getPhones());
            this.uList.addAll(this.contact.getUrls());
            this.taComments.setText(this.contact.getComment());
            this.tfObjectID.setText(this.contact.getObjectID());
            this.tfCreationTime.setText(this.contact.getCreationTime());
            this.tfCreator.setText(this.contact.getCreator().getName());
            this.tfDesign.setText(this.contact.getOwnerDesignName());
            if (this.contact.getGenerator() != null) {
                this.tfGeneratorName.setText(this.contact.getGeneratorLongName());
            } else {
                this.tfGeneratorName.setText(NONE);
            }
            this.tfLastChangedBy.setText(this.contact.getChanger().getName());
            this.tfLastChangedTime.setText(this.contact.getChangeTime());
            this.initDynamicProperties();
        }
    }

    @Override
    protected void setProperties() {
        this.contact.setName(this.tfName.getText());
        this.contact.setComment(this.taComments.getText());
        this.contact.clearEmails();
        for (DesignObject object : this.eList) {
            this.contact.addEmail((BIEmail)object);
        }
        this.contact.clearLocations();
        for (DesignObject object : this.lList) {
            this.contact.addLocation((BILocation)object);
        }
        this.contact.clearPhones();
        for (DesignObject object : this.tList) {
            this.contact.addPhone((BIPhone)object);
        }
        this.contact.clearUrls();
        for (DesignObject object : this.uList) {
            this.contact.addUrl((BIResourceLocator)object);
        }
        ContactPropertiesDialogEx.stopCellEditing(this.dynamicPropertiesTable);
        this.contact.clearProperties();
        for (DynamicProperty dp : this.dynamicPropertiesList) {
            this.contact.setProperty(dp.getName(), dp.getValue());
        }
    }

    @Override
    protected void initTree(DefaultMutableTreeNode root) {
        this.addToTree(root, this.getGeneralPanel());
        this.addToTree(root, this.getEmailsPanel());
        this.addToTree(root, this.getLocationsPanel());
        this.addToTree(root, this.getPartiesPanel());
        this.addToTree(root, this.getPhonesPanel());
        this.addToTree(root, this.getUrlsPanel());
        this.addToTree(root, this.getCommentsPanel());
        this.addToTree(root, this.getDynamicPropertiesPanel());
        this.addToTree(root, this.getSummaryPanel());
    }

    @Override
    protected String getHelpIndex() {
        return "CONTACT_PROPERTIES_DIALOG";
    }

    private JPanel getEmailsPanel() {
        if (this.pnEmails == null) {
            this.pnEmails = this.createPage(Messages.getString("ContactPropertiesDialogEx.Emails"));
            this.eList = new ArrayList();
            this.eTable = new JTable(new EmailTableModel());
            this.eTable.setSelectionMode(0);
            this.eTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ContactPropertiesDialogEx.this.eTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && row < ContactPropertiesDialogEx.this.eList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.eList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        EmailPropertiesDialogEx dialog = new EmailPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.eTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(BTN_PROPERTIES);
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ContactPropertiesDialogEx.this.eTable.getSelectedRow();
                    if (row != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && row < ContactPropertiesDialogEx.this.eList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.eList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        EmailPropertiesDialogEx dialog = new EmailPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(BTN_ADD);
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddEmailDialog dialog = new AddEmailDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.eList);
                        dialog.show();
                        ContactPropertiesDialogEx.this.eTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(BTN_REMOVE);
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ContactPropertiesDialogEx.this.eTable.getSelectedRow();
                        if (objectNumber != -1 && ContactPropertiesDialogEx.this.eList.size() > 0 && objectNumber < ContactPropertiesDialogEx.this.eList.size()) {
                            ContactPropertiesDialogEx.this.eList.remove(objectNumber);
                            ContactPropertiesDialogEx.this.eTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnEmails.add(pPanel);
        }
        return this.pnEmails;
    }

    private JPanel getLocationsPanel() {
        if (this.pnLocations == null) {
            this.pnLocations = this.createPage(Messages.getString("ContactPropertiesDialogEx.Locations"));
            this.lList = new ArrayList();
            this.lTable = new JTable(new LocationTableModel());
            this.lTable.setSelectionMode(0);
            this.lTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ContactPropertiesDialogEx.this.lTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && row < ContactPropertiesDialogEx.this.lList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.lList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        LocationPropertiesDialogEx dialog = new LocationPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.lTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ContactPropertiesDialogEx.this.lTable.getSelectedRow();
                    if (row != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && row < ContactPropertiesDialogEx.this.lList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.lList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        LocationPropertiesDialogEx dialog = new LocationPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddLocationDialog dialog = new AddLocationDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.lList);
                        dialog.show();
                        ContactPropertiesDialogEx.this.lTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ContactPropertiesDialogEx.this.lTable.getSelectedRow();
                        if (objectNumber != -1 && ContactPropertiesDialogEx.this.lList.size() > 0 && objectNumber < ContactPropertiesDialogEx.this.lList.size()) {
                            ContactPropertiesDialogEx.this.lList.remove(objectNumber);
                            ContactPropertiesDialogEx.this.lTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnLocations.add(pPanel);
        }
        return this.pnLocations;
    }

    private JPanel getPartiesPanel() {
        if (this.pnParties == null) {
            this.pnParties = this.createPage(Messages.getString("ContactPropertiesDialogEx.ResponsibleParties"));
            this.pList = new ArrayList();
            this.pTable = new JTable(new PartyTableModel());
            this.pTable.setSelectionMode(0);
            this.pTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ContactPropertiesDialogEx.this.pTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.pList.size() > 0 && row < ContactPropertiesDialogEx.this.pList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.pList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.pTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ContactPropertiesDialogEx.this.pTable.getSelectedRow();
                    if (row != -1 && ContactPropertiesDialogEx.this.pList.size() > 0 && row < ContactPropertiesDialogEx.this.pList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.pList.get(row);
                        object.showPropertyDialog();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnParties.add(pPanel);
        }
        return this.pnParties;
    }

    private JPanel getPhonesPanel() {
        if (this.pnPhones == null) {
            this.pnPhones = this.createPage(Messages.getString("ContactPropertiesDialogEx.Telephones"));
            this.tList = new ArrayList();
            this.tTable = new JTable(new PhoneTableModel());
            this.tTable.setSelectionMode(0);
            this.tTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ContactPropertiesDialogEx.this.tTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && row < ContactPropertiesDialogEx.this.tList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.tList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        PhonePropertiesDialogEx dialog = new PhonePropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.tTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ContactPropertiesDialogEx.this.tTable.getSelectedRow();
                    if (row != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && row < ContactPropertiesDialogEx.this.tList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.tList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        PhonePropertiesDialogEx dialog = new PhonePropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddPhoneDialog dialog = new AddPhoneDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.tList);
                        dialog.show();
                        ContactPropertiesDialogEx.this.tTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ContactPropertiesDialogEx.this.tTable.getSelectedRow();
                        if (objectNumber != -1 && ContactPropertiesDialogEx.this.tList.size() > 0 && objectNumber < ContactPropertiesDialogEx.this.tList.size()) {
                            ContactPropertiesDialogEx.this.tList.remove(objectNumber);
                            ContactPropertiesDialogEx.this.tTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnPhones.add(pPanel);
        }
        return this.pnPhones;
    }

    private JPanel getUrlsPanel() {
        if (this.pnUrls == null) {
            this.pnUrls = this.createPage(Messages.getString("ContactPropertiesDialogEx.Urls"));
            this.uList = new ArrayList();
            this.uTable = new JTable(new UrlTableModel());
            this.uTable.setSelectionMode(0);
            this.uTable.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    int row;
                    if (e.getClickCount() == 2 && (row = ContactPropertiesDialogEx.this.uTable.getSelectedRow()) != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && row < ContactPropertiesDialogEx.this.uList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.uList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        UrlPropertiesDialogEx dialog = new UrlPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JScrollPane scrollpane = new JScrollPane(this.uTable);
            JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
            buttonGeneral.setPreferredSize(new Dimension(325, 30));
            GUIConfiguration configuration = GUIConfiguration.getInstance();
            JButton btnProperties = new JButton(configuration.getIcon("EDIT_ICON", this.getPreferredIconSize()));
            btnProperties.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Properties"));
            btnProperties.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int row = ContactPropertiesDialogEx.this.uTable.getSelectedRow();
                    if (row != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && row < ContactPropertiesDialogEx.this.uList.size()) {
                        DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.uList.get(row);
                        object.showModal = ((ContactPropertiesDialogEx)ContactPropertiesDialogEx.this).contact.showModal || ContactPropertiesDialogEx.this.contact.showForFirstTime();
                        UrlPropertiesDialogEx dialog = new UrlPropertiesDialogEx((Dialog)ContactPropertiesDialogEx.this, ContactPropertiesDialogEx.this.getAppView(), object);
                        dialog.initProperties(object);
                        dialog.show();
                    }
                }
            });
            JToolBar toolBar = new JToolBar(0);
            toolBar.setFloatable(false);
            toolBar.add(btnProperties);
            if (this.isEditable()) {
                JButton btnAdd = new JButton(configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
                btnAdd.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Add"));
                btnAdd.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        AddUrlDialog dialog = new AddUrlDialog(ContactPropertiesDialogEx.this.getAppView(), ContactPropertiesDialogEx.this.contact.getDesign(), ContactPropertiesDialogEx.this.uList);
                        dialog.show();
                        ContactPropertiesDialogEx.this.uTable.updateUI();
                    }
                });
                JButton btnRemove = new JButton(configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
                btnRemove.setToolTipText(Messages.getString("ContactPropertiesDialogEx.Remove"));
                btnRemove.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int objectNumber = ContactPropertiesDialogEx.this.uTable.getSelectedRow();
                        if (objectNumber != -1 && ContactPropertiesDialogEx.this.uList.size() > 0 && objectNumber < ContactPropertiesDialogEx.this.uList.size()) {
                            ContactPropertiesDialogEx.this.uList.remove(objectNumber);
                            ContactPropertiesDialogEx.this.uTable.updateUI();
                        }
                    }
                });
                toolBar.addSeparator();
                toolBar.add(btnAdd);
                toolBar.add(btnRemove);
            }
            buttonGeneral.add(toolBar);
            scrollpane.setPreferredSize(new Dimension(325, 180));
            JPanel pPanel = new JPanel(new BorderLayout());
            pPanel.add((Component)buttonGeneral, "North");
            pPanel.add(scrollpane);
            this.pnUrls.add(pPanel);
        }
        return this.pnUrls;
    }

    private static void stopCellEditing(JTable table) {
        int icol = table.getEditingColumn();
        int irow = table.getEditingRow();
        if (icol > -1 && irow > -1) {
            table.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private class UrlTableModel
    extends AbstractTableModel {
        private UrlTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.uList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Urls");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.uList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class PhoneTableModel
    extends AbstractTableModel {
        private PhoneTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.tList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Telephones");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.tList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class PartyTableModel
    extends AbstractTableModel {
        private PartyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.pList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ContactPropertiesDialogEx.ResponsibleParties");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.pList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class LocationTableModel
    extends AbstractTableModel {
        private LocationTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.lList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Locations");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.lList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }

    private class EmailTableModel
    extends AbstractTableModel {
        private EmailTableModel() {
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return ContactPropertiesDialogEx.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("ContactPropertiesDialogEx.Emails");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DesignObject object = (DesignObject)ContactPropertiesDialogEx.this.eList.get(row);
            if (col == 0) {
                return object.getName();
            }
            return new Integer(row * col);
        }
    }
}

