/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.editor.UDPLibrary;
import oracle.dbtools.crest.swingui.editor.UserDefinedProperty;
import oracle.dbtools.crest.swingui.editor.UserDefinedPropertyGroup;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.string.StringUtilities;
import oracle.ide.Ide;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class UDPLibrariesPersistence {
    private static final Logger LOGGER = new Logger(UDPLibrariesPersistence.class);
    StringBuffer buffer = null;

    public void save(UDPLibrary library, boolean showMessage, String path) {
        StringBuffer buffer = new StringBuffer(MDConfiguration.getDefaultInstance().get("xml.documenttype"));
        buffer.append("\n");
        buffer.append("<").append("udp_library").append('>');
        buffer.append("\n");
        buffer.append("\t").append("<").append("udp_groups").append('>');
        for (UserDefinedPropertyGroup group : library.getUDPGroups()) {
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("group").append(" ");
            buffer.append("name").append("=\"").append(group.getName()).append("\" ");
            buffer.append("id").append("=\"").append(group.getId()).append("\" ");
            buffer.append("/>");
        }
        buffer.append("\n");
        buffer.append("\t").append("</").append("udp_groups").append(">");
        buffer.append("\n");
        buffer.append("\t").append("<").append("properties").append(">");
        for (UserDefinedProperty property : library.getPropertiesList()) {
            buffer.append("\n");
            buffer.append("\t\t").append("<").append("property").append(' ');
            buffer.append("name=\"").append(StringUtilities.encodeAttributeValue(property.getName())).append("\"").append(' ');
            buffer.append("dispalay_name=\"").append(StringUtilities.encodeAttributeValue(property.getDisplayName())).append("\"").append(' ');
            buffer.append("type=\"").append(property.getType()).append("\"").append(' ');
            buffer.append("group_id=\"").append(property.getGroup() != null ? property.getGroup().getId() : "").append("\"").append(' ');
            buffer.append("default_value=\"").append(property.getDefaultValue()).append("\"").append('>');
            if (property.getDescription() != null && !property.getDescription().trim().equals("")) {
                buffer.append("\n");
                buffer.append("\t\t").append("<").append("description").append('>');
                buffer.append("\n");
                buffer.append("\t\t\t").append("<![CDATA[").append(StringUtilities.encodeAttributeValue(property.getDescription())).append("]]>");
                buffer.append("\n");
                buffer.append("\t\t").append("</").append("description").append(">");
            }
            if (property.getObjectsVisibilityMap().size() > 0) {
                buffer.append("\n");
                buffer.append("\t\t\t").append("<").append("objects").append('>');
                for (Map.Entry<Class, Boolean> entry : property.getObjectsVisibilityMap().entrySet()) {
                    Class clz = entry.getKey();
                    Boolean visible = entry.getValue();
                    buffer.append("\n");
                    buffer.append("\t\t\t\t").append("<").append("object").append(' ');
                    buffer.append("class=\"").append(clz.getCanonicalName()).append("\"").append(' ');
                    buffer.append("visible=\"").append(visible).append("\"");
                    Integer color = property.getObjectsColorMap().get(clz);
                    if (color != null) {
                        buffer.append(' ').append("color=\"").append(color).append("\"");
                    }
                    buffer.append("/>");
                }
                buffer.append("\n");
                buffer.append("\t\t\t").append("</").append("objects").append(">");
            }
            if (property.getLovMap().size() > 0) {
                buffer.append("\n");
                buffer.append("\t\t\t").append("<").append("list_of_values").append('>');
                for (Map.Entry<Object, Boolean> entry : property.getLovMap().entrySet()) {
                    String value = (String)entry.getKey();
                    Boolean def = entry.getValue();
                    buffer.append("\n");
                    buffer.append("\t\t\t\t").append("<").append("item").append(' ');
                    buffer.append("value=\"").append(StringUtilities.encodeAttributeValue(value)).append("\"").append(' ');
                    buffer.append("default=\"").append(def).append("\"").append("/>");
                }
                buffer.append("\n");
                buffer.append("\t\t\t").append("</").append("list_of_values").append(">");
            }
            buffer.append("\n");
            buffer.append("\t\t").append("</").append("property").append(">");
        }
        buffer.append("\n");
        buffer.append("\t").append("</").append("properties").append(">");
        buffer.append("\n");
        buffer.append("</").append("udp_library").append(">");
        this.saveFile(buffer, library, showMessage, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(StringBuffer buffer, UDPLibrary library, boolean showMessage, String path) {
        OutputStreamWriter osw = null;
        try {
            String p = path + File.separator + library.getFileName();
            File f = new File(p);
            FileOutputStream fos = new FileOutputStream(f);
            osw = new OutputStreamWriter((OutputStream)fos, "UTF-8");
            osw.write(buffer.toString());
            osw.close();
            if (Extension.isSVNExtensionLoaded()) {
                File d = new File(path);
                if (SVNClientHelper.getInstance().isVersioned(d) && !SVNClientHelper.getInstance().isVersioned(f)) {
                    SVNClientHelper.getInstance().doAdd(f, false);
                }
            }
            if (showMessage) {
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.LibrarySaved"), library.getFileName()), Messages.getString("UDPLibrariesPersistence.UDPLibrary"), 1);
            }
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("UDPLibraryPropertiesDialog.LibraryNotSaved"), library.getFileName()), Messages.getString("UDPLibrariesPersistence.UDPLibrary"), 1);
            LOGGER.error("Unable to save user defined properties library file : " + library.getFileName(), e);
        }
        finally {
            if (osw != null) {
                try {
                    osw.close();
                }
                catch (IOException e) {
                    LOGGER.error("Unable to save user defined properties library: ", e);
                }
            }
        }
    }

    public void load(Design design, ApplicationView appView) {
        this.load(design, appView, false);
    }

    public void load(Design design, ApplicationView appView, boolean loadFromFilesDir) {
        int i;
        File file;
        File[] files;
        ArrayList<File> allLibraries = new ArrayList<File>();
        if (loadFromFilesDir) {
            files = design.getAdditionalFilesDirectory().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return name.endsWith(".udposdm");
                }
            });
            if (files != null) {
                file = null;
                for (i = 0; i < files.length; ++i) {
                    file = files[i];
                    allLibraries.add(file);
                }
            } else {
                LOGGER.error("Problem with design /files directory /n" + design.getAdditionalFilesDirectory().getPath());
            }
        }
        if ((files = new File(appView.getDefaultSystemTypesPath()).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".udposdm");
            }
        })) != null) {
            file = null;
            for (i = 0; i < files.length; ++i) {
                file = files[i];
                allLibraries.add(file);
            }
        } else {
            LOGGER.error("Problem with System Data Types directory - probably doesn't exist/n" + appView.getDefaultSystemTypesPath());
        }
        File file2 = null;
        Iterator it = allLibraries.iterator();
        try {
            while (it.hasNext()) {
                file2 = (File)it.next();
                FileInputStream fis = new FileInputStream(file2);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                this.loadData(file2, doc, design);
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load user defined properties file : " + file2.getAbsolutePath(), e);
        }
    }

    private void loadData(File file, Document doc, Design design) {
        boolean addLib = true;
        for (UDPLibrary lib : design.getUserDefinedLibraries()) {
            if (!lib.getFileName().equals(file.getName())) continue;
            addLib = false;
            break;
        }
        if (!addLib) {
            return;
        }
        try {
            NodeList nodes;
            ArrayList<UserDefinedPropertyGroup> groups = new ArrayList<UserDefinedPropertyGroup>();
            NodeList groupsN = doc.getElementsByTagName("group");
            int nodesLength = groupsN.getLength();
            if (nodesLength > 0) {
                for (int i = 0; i < nodesLength; ++i) {
                    Element elm = (Element)groupsN.item(i);
                    UserDefinedPropertyGroup g = new UserDefinedPropertyGroup(elm.getAttribute("id"), elm.getAttribute("name"));
                    groups.add(g);
                }
            }
            if ((nodesLength = (nodes = doc.getElementsByTagName("property")).getLength()) > 0) {
                UDPLibrary library = new UDPLibrary();
                library.setFileName(file.getName());
                String dir = file.getParent();
                if (dir == null) {
                    dir = "";
                }
                library.setDirectory(dir);
                library.getUDPGroups().addAll(groups);
                for (int i = 0; i < nodesLength; ++i) {
                    NodeList lovs;
                    int nlLOVS;
                    NodeList objects;
                    int nlObjects;
                    NodeList descNL;
                    Element elm = (Element)nodes.item(i);
                    UserDefinedProperty property = new UserDefinedProperty(library, elm.getAttribute("name"), elm.getAttribute("type"));
                    property.setDisplayName(StringUtilities.decodeAttributeValue(elm.getAttribute("dispalay_name")));
                    property.setDefaultValue(StringUtilities.decodeAttributeValue(elm.getAttribute("default_value")));
                    String groupID = elm.getAttribute("group_id");
                    if (groupID != null && !groupID.equals("")) {
                        for (UserDefinedPropertyGroup g : library.getUDPGroups()) {
                            if (!g.getId().equals(groupID)) continue;
                            property.setGroup(g);
                            break;
                        }
                    }
                    if ((descNL = elm.getElementsByTagName("description")) != null && descNL.getLength() > 0) {
                        String desc = descNL.item(0).getTextContent();
                        desc = StringUtilities.decodeAttributeValue(desc).trim();
                        property.setDescription(desc);
                    }
                    if ((nlObjects = (objects = elm.getElementsByTagName("object")).getLength()) > 0) {
                        for (int j = 0; j < nlObjects; ++j) {
                            Element object = (Element)objects.item(j);
                            property.getObjectsVisibilityMap().put(Class.forName(object.getAttribute("class")), Boolean.valueOf(object.getAttribute(StringUtilities.decodeAttributeValue("visible"))));
                            String color = object.getAttribute("color");
                            if (color.equals("")) continue;
                            property.getObjectsColorMap().put(Class.forName(object.getAttribute("class")), Integer.valueOf(color));
                        }
                    }
                    if ((nlLOVS = (lovs = elm.getElementsByTagName("item")).getLength()) > 0) {
                        for (int j = 0; j < nlLOVS; ++j) {
                            Element lov = (Element)lovs.item(j);
                            property.getLovMap().put(StringUtilities.decodeAttributeValue(lov.getAttribute("value")), Boolean.valueOf(lov.getAttribute(StringUtilities.decodeAttributeValue("default"))));
                        }
                    }
                    library.getPropertiesList().add(property);
                }
                if (addLib) {
                    design.getUserDefinedLibraries().add(library);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to load user defined properties file : " + file.getAbsolutePath(), e);
        }
    }

    public void merge(UDPLibrary newLibrary, String dirPath) {
        String filePath = XMLTransformationManager.getDefaultSystemTypesPath() + File.separator + newLibrary.getFileName();
        File file = new File(filePath);
        if (!file.exists()) {
            this.save(newLibrary, false, dirPath);
        } else {
            UDPLibrary oldLibrary = null;
            try {
                NodeList nodes;
                int nodesLength;
                FileInputStream fis = new FileInputStream(file);
                InputStreamReader isr = new InputStreamReader((InputStream)fis, "UTF-8");
                InputSource inputSource = new InputSource(isr);
                DocumentBuilderFactory builderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = builderFactory.newDocumentBuilder();
                Document doc = builder.parse(inputSource);
                ArrayList<UserDefinedPropertyGroup> existingGroups = new ArrayList<UserDefinedPropertyGroup>();
                NodeList groupsNodes = doc.getElementsByTagName("group");
                int groupsLength = groupsNodes.getLength();
                if (groupsLength > 0) {
                    for (int i = 0; i < groupsLength; ++i) {
                        Element elm = (Element)groupsNodes.item(i);
                        UserDefinedPropertyGroup g = new UserDefinedPropertyGroup(elm.getAttribute("id"), elm.getAttribute("name"));
                        existingGroups.add(g);
                    }
                }
                if ((nodesLength = (nodes = doc.getElementsByTagName("property")).getLength()) > 0) {
                    oldLibrary = new UDPLibrary();
                    oldLibrary.setFileName(file.getName());
                    oldLibrary.getUDPGroups().addAll(existingGroups);
                    for (int i = 0; i < nodesLength; ++i) {
                        NodeList lovs;
                        int nlLOVS;
                        NodeList objects;
                        int nlObjects;
                        NodeList descNL;
                        Element elm = (Element)nodes.item(i);
                        UserDefinedProperty property = new UserDefinedProperty(oldLibrary, elm.getAttribute("name"), elm.getAttribute("type"));
                        property.setDisplayName(StringUtilities.decodeAttributeValue(elm.getAttribute("dispalay_name")));
                        property.setDefaultValue(StringUtilities.decodeAttributeValue(elm.getAttribute("default_value")));
                        String groupId = elm.getAttribute("group_id");
                        if (groupId != null && !groupId.equals("")) {
                            for (UserDefinedPropertyGroup g : existingGroups) {
                                if (!groupId.equals(g.getId())) continue;
                                property.setGroup(g);
                                break;
                            }
                        }
                        if ((descNL = elm.getElementsByTagName("description")) != null && descNL.getLength() > 0) {
                            String desc = descNL.item(0).getTextContent();
                            desc = StringUtilities.decodeAttributeValue(desc).trim();
                            property.setDescription(desc);
                        }
                        if ((nlObjects = (objects = elm.getElementsByTagName("object")).getLength()) > 0) {
                            for (int j = 0; j < nlObjects; ++j) {
                                Element object = (Element)objects.item(j);
                                property.getObjectsVisibilityMap().put(Class.forName(object.getAttribute("class")), Boolean.valueOf(object.getAttribute(StringUtilities.decodeAttributeValue("visible"))));
                                String color = object.getAttribute("color");
                                if (color.equals("")) continue;
                                property.getObjectsColorMap().put(Class.forName(object.getAttribute("class")), Integer.valueOf(color));
                            }
                        }
                        if ((nlLOVS = (lovs = elm.getElementsByTagName("item")).getLength()) > 0) {
                            for (int j = 0; j < nlLOVS; ++j) {
                                Element lov = (Element)lovs.item(j);
                                property.getLovMap().put(StringUtilities.decodeAttributeValue(lov.getAttribute("value")), Boolean.valueOf(lov.getAttribute(StringUtilities.decodeAttributeValue("default"))));
                            }
                        }
                        oldLibrary.getPropertiesList().add(property);
                    }
                }
                if (oldLibrary != null) {
                    for (UserDefinedProperty newProperty : newLibrary.getPropertiesList()) {
                        UserDefinedPropertyGroup g2;
                        boolean found = false;
                        for (UserDefinedProperty oldProperty : oldLibrary.getPropertiesList()) {
                            if (!newProperty.getName().equals(oldProperty.getName())) continue;
                            this.mergeObjects(oldProperty, newProperty);
                            found = true;
                            break;
                        }
                        if (found) continue;
                        oldLibrary.getPropertiesList().add(newProperty);
                        if (newProperty.getGroup() == null) continue;
                        boolean gFound = false;
                        for (UserDefinedPropertyGroup g2 : existingGroups) {
                            if (!newProperty.getGroup().getId().equals(g2.getId())) continue;
                            gFound = true;
                            break;
                        }
                        if (gFound) continue;
                        g2 = new UserDefinedPropertyGroup(newProperty.getGroup().getName());
                        oldLibrary.getUDPGroups().add(g2);
                    }
                }
                this.save(oldLibrary, false, dirPath);
            }
            catch (Exception e) {
                LOGGER.error("Unable to merge user defined properties file : " + file.getAbsolutePath(), e);
            }
        }
    }

    private void mergeObjects(UserDefinedProperty oldProperty, UserDefinedProperty newProperty) {
        for (Map.Entry<Class, Boolean> pairs : newProperty.getObjectsVisibilityMap().entrySet()) {
            Class clz = pairs.getKey();
            boolean found = false;
            for (Map.Entry<Class, Boolean> pairs1 : oldProperty.getObjectsVisibilityMap().entrySet()) {
                Class clz1 = pairs1.getKey();
                if (clz != clz1) continue;
                found = true;
                break;
            }
            if (found) continue;
            oldProperty.getObjectsVisibilityMap().put(clz, true);
        }
    }
}

