/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class TextEditDialog
extends CustomDialog {
    private JEditorPane editorPane;
    private JPanel buttonsPanel;
    private JDialog dialog;
    private String oldText;
    private String editedText;
    private boolean readOnly = false;
    private Dialog parent;

    public TextEditDialog(Dialog parent, ApplicationView appView, String text, boolean readOnly) {
        super(appView);
        this.parent = parent;
        this.oldText = text;
        this.editedText = text;
        this.readOnly = readOnly;
        this.editorPane = this.getEditorPane();
        this.initProperties();
        JScrollPane scrollPane = new JScrollPane(this.editorPane);
        this.add((Component)scrollPane, "Center");
        JPanel bottomPanel = this.getButtonPanel();
        this.add((Component)bottomPanel, "South");
    }

    public void initProperties() {
        this.editorPane.setText(this.oldText);
    }

    public void setProperties() {
        this.editedText = this.editorPane.getText();
    }

    public JEditorPane getEditorPane() {
        if (this.editorPane == null) {
            this.editorPane = new JEditorPane();
            this.editorPane.setContentType("text/plain");
            this.editorPane.setPreferredSize(new Dimension(500, 300));
            this.editorPane.setEditable(!this.readOnly);
        }
        return this.editorPane;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonsPanel == null) {
            this.buttonsPanel = new JPanel();
            if (!this.readOnly) {
                JButton ok = new JButton(Messages.getString("TextEditDialog.OK"));
                ok.setMnemonic(79);
                ok.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        TextEditDialog.this.setProperties();
                        TextEditDialog.this.close();
                    }
                });
                ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
                this.buttonsPanel.add(ok);
            }
            JButton cancel = new JButton(this.readOnly ? Messages.getString("TextEditDialog.Close") : Messages.getString("TextEditDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    TextEditDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonsPanel.add(cancel);
        }
        return this.buttonsPanel;
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.parent);
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.setTitle(Messages.getString("TextEditDialog.EditConstraint"));
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public String getText() {
        return this.editedText;
    }

    public void setText(String text) {
        this.editedText = text;
    }

    @Override
    protected String getHelpIndex() {
        return "";
    }
}

