/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.DefaultCellEditor;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableModel;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.editor.relational.ColumnGroupsTableModel;
import oracle.dbtools.crest.swingui.editor.relational.Messages;

public class TFCellEditor
extends DefaultCellEditor
implements FocusListener {
    private static final long serialVersionUID = -1238416927237741284L;
    private JTextField tf;
    private String val;
    private JTable tab;

    public TFCellEditor(JTextField tf) {
        super(tf);
        this.tf = tf;
        tf.addFocusListener(this);
        super.setClickCountToStart(1);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.tf.setText(value.toString());
        this.tf.selectAll();
        this.tf.setBorder(null);
        this.val = this.tf.getText();
        this.tab = table;
        return this.tf;
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.tf.selectAll();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public boolean stopCellEditing() {
        JTextField tf = (JTextField)this.getComponent();
        String newValue = tf.getText().trim();
        if (newValue.length() == 0) {
            JOptionPane.showMessageDialog(null, Messages.getString("TablePropertiesDialogEx.NameNotNull"), Messages.getString("TFCellEditor.TFCellEditor.Warning"), 2);
            tf.setText(this.val);
            tf.setBorder(new LineBorder(Color.black));
            tf.requestFocusInWindow();
            return false;
        }
        TableModel currentTableModel = this.tab.getModel();
        if (currentTableModel instanceof ColumnGroupsTableModel) {
            int dCount = 0;
            for (Table.ColumnGroup cg : ((ColumnGroupsTableModel)this.tab.getModel()).getColumnGroupList()) {
                if (!cg.getName().equals(newValue) || newValue.equals(this.val)) continue;
                ++dCount;
                JOptionPane.showMessageDialog(null, Messages.getString("TablePropertiesDialogEx.ColumnGrNameExists"), Messages.getString("TFCellEditor.TFCellEditor.Warning"), 2);
                tf.setText(this.val);
                tf.setBorder(new LineBorder(Color.black));
                tf.requestFocusInWindow();
                return false;
            }
        }
        return super.stopCellEditing();
    }
}

