/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.EmptyFieldException;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class NewRepositoryDesignDialog
extends CustomDialog
implements AbstractEditorConstants {
    private String name;
    private String description = "";
    private JDialog dialog;
    private JPanel buttonPanel;
    private JTextField tfName;
    private JTextField tfDescription;
    private Dimension defaultLBSize = new Dimension(70, 20);
    private Dimension defaultSize = new Dimension(200, 20);

    public NewRepositoryDesignDialog(ApplicationView appView, String name) {
        super(appView);
        this.name = name;
        this.add((Component)this.initMainPanel(), "Center");
        this.add((Component)this.getButtonPanel(), "South");
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("NewRepositoryDesignDialog.SetDesignDetails"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
            CommonUtil.centerOnScreen(this.dialog);
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    @Override
    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    private JPanel initMainPanel() {
        JPanel pnMain = new JPanel();
        pnMain.setPreferredSize(new Dimension(290, 70));
        pnMain.setBorder(BorderFactory.createEtchedBorder());
        JPanel jpanel = new JPanel(new BorderLayout(10, 10));
        JPanel pnGeneralGrid = new JPanel(new GridLayout(0, 1, 10, 10));
        JLabel lbName = new JLabel(LB_NAME);
        lbName.setPreferredSize(this.defaultLBSize);
        this.tfName = new JTextField(this.name);
        this.tfName.setPreferredSize(this.defaultSize);
        pnGeneralGrid.add(this.createRow(lbName, this.tfName));
        JLabel lbDescription = new JLabel(LB_DESCRIPTION);
        lbDescription.setPreferredSize(this.defaultLBSize);
        this.tfDescription = new JTextField(this.description);
        this.tfDescription.setPreferredSize(this.defaultSize);
        pnGeneralGrid.add(this.createRow(lbDescription, this.tfDescription));
        jpanel.add((Component)pnGeneralGrid, "North");
        pnMain.add(jpanel);
        return pnMain;
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new FlowLayout(2));
            JButton ok = new JButton(Messages.getString("DesignPropertiesDialog.OK"));
            ok.setMnemonic(79);
            ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        if ("".equalsIgnoreCase(NewRepositoryDesignDialog.this.tfName.getText())) {
                            NewRepositoryDesignDialog.this.tfName.requestFocus();
                            throw new EmptyFieldException(Messages.getString("NewRepositoryDesignDialog.NotEmptyName"));
                        }
                        NewRepositoryDesignDialog.this.name = NewRepositoryDesignDialog.this.tfName.getText();
                        NewRepositoryDesignDialog.this.description = NewRepositoryDesignDialog.this.tfDescription.getText();
                        NewRepositoryDesignDialog.this.close();
                    }
                    catch (EmptyFieldException exp) {
                        JOptionPane.showMessageDialog(NewRepositoryDesignDialog.this, exp.getMessage(), Messages.getString("NewRepositoryDesignDialog.Error"), 0);
                    }
                }
            });
            ok.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(ok);
            JButton cancel = new JButton(Messages.getString("NewRepositoryDesignDialog.Cancel"));
            cancel.setMnemonic(67);
            cancel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    NewRepositoryDesignDialog.this.close();
                }
            });
            cancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.buttonPanel.add(cancel);
        }
        return this.buttonPanel;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }
}

