/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.editor;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import oracle.dbtools.crest.model.ChangeRequest;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.editor.AbstractEditorConstants;
import oracle.dbtools.crest.swingui.editor.Messages;
import oracle.dbtools.crest.swingui.search.JSearchTextField;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;

public class AddChangeRequestDialog
extends CustomDialog
implements AbstractEditorConstants {
    private DesignObject desObject;
    private List sList;
    private JPanel generalPanel;
    private List allList = new ArrayList();
    private JTable allTable;
    private JRadioButton rbNew;
    private JRadioButton rbAll;
    private int counter = 0;
    private static boolean changeRequestAdded = false;
    private JSearchTextField filterField;
    private TableRowSorter allTableSorter;
    protected JDialog dialog;

    public AddChangeRequestDialog(ApplicationView view, DesignObject desObject, List sList) {
        super(view);
        this.desObject = desObject;
        this.sList = sList;
        this.generalPanel = new JPanel(new BorderLayout());
        JPanel pnTop = new JPanel(new GridLayout(0, 1));
        pnTop.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.SelectRequest")));
        RadioListener listener = new RadioListener();
        this.rbNew = new JRadioButton(Messages.getString("AddChangeRequestDialog.NewChangeRequest"));
        this.rbNew.addActionListener(listener);
        this.rbNew.setMnemonic(78);
        this.rbAll = new JRadioButton(Messages.getString("AddChangeRequestDialog.AvailableChangeRequests"));
        this.rbAll.addActionListener(listener);
        this.rbAll.setMnemonic(65);
        this.rbNew.setSelected(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.rbNew);
        group.add(this.rbAll);
        pnTop.add(this.rbNew);
        pnTop.add(this.rbAll);
        this.generalPanel.add((Component)pnTop, "North");
        this.generalPanel.setPreferredSize(new Dimension(325, 330));
        JPanel pnList = new JPanel(new BorderLayout());
        pnList.setBorder(BorderFactory.createTitledBorder(Messages.getString("AddChangeRequestDialog.AllChangeRequests")));
        this.filterField = new JSearchTextField(true, true, "Name");
        this.filterField.setEnabled(false);
        this.filterField.getDocument().addDocumentListener(new FilterListener());
        this.filterField.setPreferredSize(new Dimension(150, 20));
        this.filterField.setMinimumSize(new Dimension(150, 20));
        this.filterField.setMaximumSize(new Dimension(150, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setPreferredSize(new Dimension(160, 25));
        toolBar.setFloatable(false);
        toolBar.setRollover(true);
        toolBar.setBorder(null);
        toolBar.add(this.filterField);
        this.allList.addAll(this.getAllRequests());
        this.allTable = new JTable(new AllRequestsModel());
        this.allTable.setSelectionMode(0);
        this.allTable.getTableHeader().setReorderingAllowed(false);
        this.allTableSorter = new TableRowSorter<TableModel>(this.allTable.getModel());
        this.allTableSorter.setSortsOnUpdates(true);
        TableColumn col1 = this.allTable.getColumnModel().getColumn(1);
        col1.setMinWidth(100);
        col1.setMaxWidth(100);
        JScrollPane scrollpane = new JScrollPane(this.allTable);
        scrollpane.setPreferredSize(new Dimension(320, 220));
        pnList.add((Component)toolBar, "North");
        pnList.add((Component)scrollpane, "Center");
        this.generalPanel.add(pnList);
        this.enableControls(!this.rbNew.isSelected());
        JPanel bottomPanel = new JPanel();
        JButton bnOK = new JButton(BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        JButton bnCancel = new JButton(BTN_CANCEL);
        bnCancel.setMnemonic(67);
        bnCancel.addActionListener(new CancelAction());
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bottomPanel.add(bnOK);
        bottomPanel.add(bnCancel);
        this.generalPanel.add((Component)bottomPanel, "South");
        this.add((Component)this.generalPanel, "Center");
    }

    private void enableControls(boolean enable) {
        this.allTable.setEnabled(enable);
        this.filterField.setEnabled(enable);
        this.allTable.clearSelection();
        if (!enable) {
            this.allTable.setBackground(Color.LIGHT_GRAY);
        } else {
            this.allTable.setBackground(Color.WHITE);
        }
        if (enable) {
            this.allTable.setRowSorter(this.allTableSorter);
            this.allTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.allTable, 0);
        } else {
            this.allTable.setAutoCreateRowSorter(false);
            this.allTable.setRowSorter(null);
        }
    }

    private List getAllRequests() {
        ArrayList<ChangeRequest> list = new ArrayList<ChangeRequest>();
        int length = this.desObject.getDesign().getChangeRequestSet().size();
        for (int i = 0; i < length; ++i) {
            ChangeRequest request = (ChangeRequest)this.desObject.getDesign().getChangeRequestSet().getElement(i);
            if (this.sList.contains(request)) continue;
            list.add(request);
        }
        return list;
    }

    protected String generateRequestName() {
        String m = Messages.getString("AddChangeRequestDialog.Request");
        int newNumber = 0;
        int lastNumber = this.sList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        String mName = m.concat("_").concat(Integer.toString(newNumber));
        while (this.requestExists(mName)) {
            newNumber = ++this.counter;
            mName = m.concat("_").concat(Integer.toString(newNumber));
        }
        return mName;
    }

    private boolean requestExists(String name) {
        for (int i = 0; i < this.sList.size(); ++i) {
            ChangeRequest req = (ChangeRequest)this.sList.get(i);
            if (!name.equalsIgnoreCase(req.getName())) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.getApplicationView().getFrame(), Messages.getString("AddChangeRequestDialog.AddChangeRequest"));
            this.dialog.setDefaultCloseOperation(2);
            this.dialog.getContentPane().add(this);
            this.setDefaultActions(this.dialog);
            this.dialog.pack();
            this.dialog.setModal(true);
            this.dialog.setResizable(false);
        }
        return this.dialog;
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        this.getDialog().setVisible(true);
    }

    @Override
    protected String getHelpIndex() {
        return null;
    }

    public static boolean isChangeRequestAdded() {
        return changeRequestAdded;
    }

    private void reFilter() {
        RowFilter rf = null;
        if (this.allTable != null) {
            if (!"".equals(this.filterField.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + this.filterField.getText(), this.allTable.convertColumnIndexToModel(0));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)this.allTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)this.allTable.getRowSorter()).setRowFilter(null);
                this.allTable.clearSelection();
            }
        }
    }

    private class FilterListener
    implements DocumentListener {
        private FilterListener() {
        }

        @Override
        public void changedUpdate(DocumentEvent arg0) {
            AddChangeRequestDialog.this.reFilter();
        }

        @Override
        public void insertUpdate(DocumentEvent arg0) {
            AddChangeRequestDialog.this.reFilter();
        }

        @Override
        public void removeUpdate(DocumentEvent arg0) {
            AddChangeRequestDialog.this.reFilter();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddChangeRequestDialog.this.close();
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (AddChangeRequestDialog.this.rbNew.isSelected()) {
                ChangeRequest request = AddChangeRequestDialog.this.desObject.getDesign().getChangeRequestSet().createChangeRequest(null);
                request.setObject(AddChangeRequestDialog.this.desObject);
                AddChangeRequestDialog.this.sList.add(request);
            } else {
                int row = AddChangeRequestDialog.this.allTable.getSelectedRow();
                if (row != -1) {
                    ChangeRequest request = (ChangeRequest)AddChangeRequestDialog.this.allList.get(AddChangeRequestDialog.this.allTable.convertRowIndexToModel(row));
                    AddChangeRequestDialog.this.sList.add(request);
                }
            }
            changeRequestAdded = true;
            AddChangeRequestDialog.this.close();
        }
    }

    private class AllRequestsModel
    extends AbstractTableModel {
        private AllRequestsModel() {
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return AddChangeRequestDialog.this.allList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("AddChangeRequestDialog.ChangeRequestName");
            }
            if (column == 1) {
                return "Status";
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            ChangeRequest request = (ChangeRequest)AddChangeRequestDialog.this.allList.get(row);
            if (col == 0) {
                return request.getName();
            }
            if (col == 1) {
                return request.getStatus();
            }
            return new Integer(row * col);
        }
    }

    private class RadioListener
    implements ActionListener {
        private RadioListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AddChangeRequestDialog.this.enableControls(!AddChangeRequestDialog.this.rbNew.isSelected());
        }
    }
}

