/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.relational;

import java.awt.Color;
import java.awt.Font;
import oracle.dbtools.crest.model.ClassificationType;
import oracle.dbtools.crest.model.design.EditableFonts;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.swingui.diagram.graph.ContainerRenderer;
import oracle.dbtools.crest.util.options.format.DefaultFontAndColor;

public class TableRenderer
extends ContainerRenderer {
    public static final Color DEFAULT_FOREGROUND = Color.BLACK;
    public static final Color DEFAULT_BACKGROUND = new Color(255, 255, 180);
    public static final Color DEFAULT_DATATYPE_COLOR = new Color(0, 128, 0);
    public static final Color DEFAULT_ALLOW_NULL_COLOR = Color.RED;

    public TableRenderer() {
        this.defaultForeground = DEFAULT_FOREGROUND;
        this.defaultBackground = DEFAULT_BACKGROUND;
        this.datatypeColor = DEFAULT_DATATYPE_COLOR;
        this.allowNullColor = DEFAULT_ALLOW_NULL_COLOR;
    }

    private ClassificationType getClassificationType() {
        Table table = (Table)this.container;
        return table.getDesign().getDesignLevelSettings().getClassificationTypeByID(table.getTypeID());
    }

    @Override
    protected Color getBackgroundColor() {
        if (this.container instanceof Table && this.getTopView() != null) {
            if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
                ClassificationType cf = this.getClassificationType();
                if (cf != null) {
                    return cf.getTypeColor();
                }
                DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Table");
                if (dfc != null) {
                    return dfc.getBackgroundColor();
                }
            } else {
                return this.getTopView().getBackgroundColor();
            }
        }
        return this.defaultBackground;
    }

    @Override
    public Color getForegroundColor() {
        if (this.getTopView() != null) {
            if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
                ClassificationType cf = this.getClassificationType();
                if (cf != null) {
                    return cf.getForegroundColor();
                }
                DefaultFontAndColor dfc = this.container.getDesign().getDesignLevelSettings().getDefaultFCObject("Table");
                if (dfc != null) {
                    return dfc.getForegroundColor();
                }
                return this.getForeground();
            }
            return this.getTopView().getForegroundColor();
        }
        return this.defaultForeground;
    }

    @Override
    protected Color getTitleColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_TITLE).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_TITLE).getColor();
        }
        return super.getTitleColor();
    }

    @Override
    protected Font getTitleFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_TITLE).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_TITLE).getFont();
        }
        return super.getTitleFont();
    }

    @Override
    protected Color getElementsColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_ELEMENT).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getColor();
        }
        return super.getElementsColor();
    }

    @Override
    protected Font getElementsFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_ELEMENT).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COLUMN).getFont();
        }
        return super.getElementsFont();
    }

    @Override
    protected Color getDatatypeColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_DATATYPE).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_DATATYPE).getColor();
        }
        return super.getDatatypeColor();
    }

    @Override
    protected Color getPKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_PK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_PK).getColor();
        }
        return super.getPKColor();
    }

    @Override
    protected Color getUKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_UK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_UK).getColor();
        }
        return super.getUKColor();
    }

    @Override
    protected Color getFKColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_FK).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_FK).getColor();
        }
        return super.getFKColor();
    }

    @Override
    protected Color getNotNullColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_NOT_NULL).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_NOT_NULL).getColor();
        }
        return super.getNotNullColor();
    }

    @Override
    protected Font getKeysFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_KEY).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_KEY).getFont();
        }
        return super.getKeysFont();
    }

    @Override
    protected Color getKeyColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_KEY).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_KEY).getColor();
        }
        return super.getKeyColor();
    }

    @Override
    protected Font getCommentsFont() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_COMMENTS).getFont();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COMMENTS).getFont();
        }
        return super.getCommentsFont();
    }

    @Override
    protected Color getCommentsColor() {
        if (this.getTopView() != null) {
            ClassificationType cf;
            if (this.getTopView().useDefaultColor() && (cf = this.getClassificationType()) != null) {
                return cf.getDefaultFCObject().getFontObject(EditableFonts.FO_COMMENTS).getColor();
            }
            return this.getTopView().getFontObject(EditableFonts.FO_COMMENTS).getColor();
        }
        return super.getKeyColor();
    }

    @Override
    protected String getType() {
        String type;
        if (this.container instanceof Table && (type = ((Table)this.container).getDesign().getDesignLevelSettings().getClassificationTypeNameByID(((Table)this.container).getTypeID())) != null && type.length() > 0) {
            return type.substring(0, 1);
        }
        return null;
    }
}

