/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.process;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import oracle.dbtools.crest.model.design.process.AbstractProcessObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.AbstractDiagram;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellViewRenderer;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.process.DFDView;
import oracle.dbtools.crest.swingui.diagram.process.DFDiagramCell;

public class DFDRenderer
extends JLabel
implements CellViewRenderer {
    public static final int TITLE_PADDING = 3;
    public static final int ROW_SPACING = 3;
    protected transient AbstractDiagram diagram;
    protected transient boolean hasFocus;
    protected transient boolean selected;
    protected transient boolean preview;
    protected transient boolean opaque;
    protected transient Color defaultForeground = Color.BLACK;
    protected transient Color defaultBackground = Color.WHITE;
    protected transient Color bordercolor;
    protected transient int borderWidth;
    protected transient AbstractProcessObject processObject;
    protected String title = "";
    protected CellView view;

    public Color getBackgroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getBackgroundColor() == null) {
            return super.getBackground();
        }
        return this.getTopView().getBackgroundColor();
    }

    public Color getBorderColor() {
        return this.getForegroundColor();
    }

    public Color getWhiteColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            return Color.WHITE;
        }
        return this.getTopView().getForegroundColor();
    }

    public Color getForegroundColor() {
        if (this.getTopView().useDefaultColor() || this.getTopView().getForegroundColor() == null) {
            return this.getForeground();
        }
        return this.getTopView().getForegroundColor();
    }

    @Override
    public Color getBGColor() {
        return this.getBackgroundColor();
    }

    @Override
    public Color getFGColor() {
        return this.getForegroundColor();
    }

    protected DesignPartView getDesignPartView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView().getDesignPartView();
        }
        return null;
    }

    protected TopView getTopView() {
        if (this.view != null) {
            return ((DefaultDiagramCell)this.view.getCell()).getTopView();
        }
        if (this.processObject != null) {
            return this.processObject.getTopView();
        }
        return null;
    }

    @Override
    public Component getRendererComponent(AbstractDiagram diagram, CellView view, boolean sel, boolean focus, boolean preview) {
        if (view instanceof DFDView) {
            DFDiagramCell dfCell = (DFDiagramCell)view.getCell();
            this.processObject = dfCell.getProcessObject();
            if (dfCell.getTopView() != null) {
                this.title = dfCell.getTopView().toString();
            }
            this.diagram = diagram;
            this.hasFocus = focus;
            this.selected = sel;
            this.preview = preview;
            this.setComponentOrientation(diagram.getComponentOrientation());
            if (view.isLeaf()) {
                this.installAttributes(view);
            } else {
                this.setBorder(null);
                this.setOpaque(false);
            }
            this.view = view;
            return this;
        }
        return null;
    }

    protected void installAttributes(CellView view) {
        Color foreground;
        Map map = view.getAllAttributes();
        this.setOpaque(DiagramConstants.isOpaque(map));
        this.setBorder(DiagramConstants.getBorder(map));
        this.bordercolor = DiagramConstants.getBorderColor(map);
        this.borderWidth = Math.max(1, Math.round(DiagramConstants.getLineWidth(map)));
        if (this.getBorder() == null && this.bordercolor != null) {
            this.setBorder(BorderFactory.createLineBorder(this.bordercolor, this.borderWidth));
        }
        this.setForeground((foreground = DiagramConstants.getForeground(map)) != null ? foreground : this.defaultForeground);
        Color background = DiagramConstants.getBackground(map);
        this.setBackground(background != null ? background : this.defaultBackground);
        this.setFont(this.diagram.getFont());
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Dimension dim = this.getSize();
        int width = dim.width;
        int height = dim.height;
        g2.setPaint(this.getBackgroundColor());
        g.fillRoundRect(0, 0, width - 1, height - 1, 40, 40);
        g.setColor(this.getBorderColor());
        g.drawRoundRect(0, 0, width - 1, height - 1, 40, 40);
        FontMetrics fm = g.getFontMetrics();
        Font normalFont = this.diagram.getFont();
        Font titleFont = normalFont.deriveFont(1);
        int colTextHeight = fm.getMaxAscent() - fm.getMaxDescent() + 3;
        int yCursor = colTextHeight + 3;
        int xCursor = (width - fm.stringWidth(this.title)) / 2;
        BasicStroke lineStroke = new BasicStroke(this.borderWidth);
        BasicStroke textStroke = new BasicStroke(1.0f);
        g2.setStroke(textStroke);
        g.setColor(this.getBorderColor());
        g.setFont(titleFont);
        g.drawString(this.title, xCursor, yCursor);
        g2.setStroke(lineStroke);
        g.drawLine(0, yCursor += 3 + this.borderWidth, width - 2, yCursor);
        g.setColor(this.getForegroundColor());
        g2.setStroke(textStroke);
        g.setFont(normalFont);
    }

    public Point2D getPerimeterPoint(DFDView view, Point2D source, Point2D p, boolean simple) {
        Rectangle2D bounds = view.getBounds();
        double x = bounds.getX();
        double y = bounds.getY();
        double width = bounds.getWidth();
        double height = bounds.getHeight();
        double xCenter = x + width / 2.0;
        double yCenter = y + height / 2.0;
        double dx = p.getX() - xCenter;
        double dy = p.getY() - yCenter;
        double alpha = Math.atan2(dy, dx);
        double xout = 0.0;
        double yout = 0.0;
        double pi = Math.PI;
        double t = Math.atan2(height, width);
        if (alpha < -pi + t || alpha > pi - t) {
            xout = x;
            yout = yCenter;
        } else if (alpha < -t) {
            yout = y;
            xout = xCenter;
        } else if (alpha < t) {
            xout = x + width;
            yout = yCenter;
        } else {
            yout = y + height;
            xout = xCenter;
        }
        return DiagramConstants.createPoint(xout, yout);
    }

    @Override
    public void validate() {
    }

    @Override
    public void revalidate() {
    }

    @Override
    public void repaint(long tm, int x, int y, int width, int height) {
    }

    @Override
    public void repaint(Rectangle r) {
    }

    @Override
    protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, char oldValue, char newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, short oldValue, short newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, int oldValue, int newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, long oldValue, long newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, float oldValue, float newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, double oldValue, double newValue) {
    }

    @Override
    public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
    }

    public static String[] wrapText(String text, int length) {
        if (length > 0) {
            Pattern wrapRE = Pattern.compile("([\\S\\S&&[^\\p{Punct}]]{" + length + ",}|.{1," + length + "})(\\p{Punct}+|\\s+|$)");
            LinkedList<String> list = new LinkedList<String>();
            Matcher m = wrapRE.matcher(text);
            while (m.find()) {
                list.add(m.group());
            }
            return list.toArray(new String[list.size()]);
        }
        return new String[]{text};
    }

    public static int getMaxChars(String text, FontMetrics fm, int length) {
        for (int i = 0; i < text.length(); ++i) {
            String subStr = text.substring(0, i);
            int s1 = fm.stringWidth(subStr);
            if (s1 <= length) continue;
            return i;
        }
        return text.length();
    }
}

