/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.RaggedHLink;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class RaggedHLinkEdge
extends DefaultEdge {
    private JPopupMenu menu;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    private void showProperty() {
        this.getTopView().getModel().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        this.point.setLocation(pt);
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RaggedHLinkEdge.this.deleteLink();
                    }
                });
                this.menu.addSeparator();
                this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RaggedHLinkEdge.this.straightenLine();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RaggedHLinkEdge.this.format();
                    }
                });
                this.menu.addSeparator();
                this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RaggedHLinkEdge.this.addBreakpoint(RaggedHLinkEdge.this.point);
                    }
                });
                this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RaggedHLinkEdge.this.removeBreakpoint(RaggedHLinkEdge.this.point);
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    RaggedHLinkEdge.this.showProperty();
                }
            });
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }

    public RaggedHLink getLink() {
        return (RaggedHLink)this.getTopView().getModel();
    }

    public void deleteLink() {
        RaggedHLink raggedHlink = this.getLink();
        TVConnector connector = (TVConnector)this.getTopView();
        if (connector.remove(raggedHlink)) {
            ApplicationView.log(MessageFormat.format(Messages.getString("RaggedHLinkEdge.RemoveRaggedHierarhyLink"), this.getLink().getName()));
        }
    }

    public String getSourceName() {
        return this.getLink().getChildLevel().getName();
    }

    public String getTargetName() {
        return this.getLink().getParentLevel().getName();
    }

    @Override
    public void deleteSelected() {
        this.deleteLink();
    }
}

