/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.multidimensional;

import java.awt.Point;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.model.design.multidimensional.AbstractMDObject;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.multidimensional.MDDiagramCell;
import oracle.dbtools.crest.swingui.multidimensional.TVDimension;

public class DimensionDiagramCell
extends MDDiagramCell {
    private JPopupMenu menu;

    public DimensionDiagramCell(AbstractMDObject mdObject) {
        super(mdObject);
    }

    public DimensionDiagramCell(AbstractMDObject mdObject, Map attributeMap) {
        super(mdObject, attributeMap);
    }

    private void showProperty() {
        this.getMDObject().showPropertyDialog();
    }

    @Override
    public void doubleClick() {
        this.showProperty();
    }

    @Override
    public void showPopupMenu(Point pt) {
        JPopupMenu menu = this.getPopupMenu();
        menu.show(this.getDiagram(), pt.x, pt.y);
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.menu.add(new AbstractAction(DELETE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.deleteDimension();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.format();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(SEND_TO_BACK){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        DimensionDiagramCell.this.getTopView().sendToBack();
                    }
                });
                this.menu.addSeparator();
            }
            this.menu.add(new AbstractAction(PROPERTIES){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DimensionDiagramCell.this.showProperty();
                }
            });
        }
        return this.menu;
    }

    public void deleteDimension() {
        Diagram d = this.getDiagram();
        ApplicationView view = d.getAppView();
        ApplicationView.log(MessageFormat.format(Messages.getString("DimensionDiagramCell.DeleteDimension"), this.getMDObject().getName()));
        TVDimension tv = (TVDimension)this.getTopView();
        tv.remove(true);
    }

    @Override
    public void deleteSelected() {
        this.deleteDimension();
    }
}

