/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.graph;

import java.awt.Point;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.ConnectionInterface;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TVConnector;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.diagram.Messages;
import oracle.dbtools.crest.swingui.diagram.graph.AbstractCellView;
import oracle.dbtools.crest.swingui.diagram.graph.CellView;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultDiagramCell;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.Edge;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;
import oracle.dbtools.crest.swingui.diagram.graph.PortView;
import oracle.dbtools.crest.swingui.editor.FormatLineDialog;

public class DefaultEdge
extends DefaultDiagramCell
implements Edge {
    protected static final int center = 500;
    protected static final Point defaultLabel = new Point(500, 500);
    protected static final Point defaultSLabel = new Point(-1, -1);
    protected static final Point defaultTLabel = new Point(-1, -1);
    public static final ArrayList defaultPoints = new ArrayList();
    private int offset = 10;
    protected Object source;
    protected Object target;

    public DefaultEdge() {
        this(null);
    }

    public DefaultEdge(Object userObject) {
        this(userObject, false);
    }

    public DefaultEdge(Object userObject, boolean allowsChildren) {
        super(userObject, allowsChildren);
        DiagramConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        DiagramConstants.setLabelPosition(this.attributes, defaultLabel);
        DiagramConstants.setSourceLabelPosition(this.attributes, defaultSLabel);
        DiagramConstants.setTargetLabelPosition(this.attributes, defaultTLabel);
    }

    @Override
    public Map changeAttributes(Map change) {
        Map undo = super.changeAttributes(change);
        List points = DiagramConstants.getPoints(this.attributes);
        if (points == null) {
            DiagramConstants.setPoints(this.attributes, new ArrayList(defaultPoints));
        }
        return undo;
    }

    @Override
    public Object getSource() {
        return this.source;
    }

    @Override
    public Object getTarget() {
        return this.target;
    }

    @Override
    public void setSource(Object port) {
        this.source = port;
    }

    @Override
    public void setTarget(Object port) {
        this.target = port;
    }

    @Override
    public Object clone() {
        DefaultEdge c = (DefaultEdge)super.clone();
        c.source = null;
        c.target = null;
        return c;
    }

    public String getName() {
        return "";
    }

    @Override
    public void format() {
        if (this.getTopView() != null) {
            new FormatLineDialog(this.getTopView().getDesignPartView().getSelectedTVConnectors()).setVisible(true);
            this.getCellView().getDiagram().repaint();
        }
    }

    public void addBreakpoint(Point point) {
        try {
            Point2D.Double pt = new Point2D.Double(point.getX(), point.getY());
            this.getDiagram().fromScreen(pt);
            AbstractCellView cellView = this.getCellView();
            if (cellView != null && cellView instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)cellView;
                int index = 0;
                double min = Double.MAX_VALUE;
                double dist = 0.0;
                for (int i = 0; i < edgeView.getPointCount() - 1; ++i) {
                    Point2D p1;
                    Point2D p = edgeView.getPoint(i);
                    dist = new Line2D.Double(p, p1 = edgeView.getPoint(i + 1)).ptLineDistSq(pt);
                    if (!(dist < min)) continue;
                    min = dist;
                    index = i + 1;
                }
                edgeView.addPoint(index, pt);
                edgeView.updatePoints();
                edgeView.getEdgeRenderer().repaint();
            }
        }
        catch (Exception e) {
            System.out.println("Error: DefaultEdge.addBreakpoint");
        }
    }

    public void removeBreakpoint(Point pt) {
        block3: {
            try {
                Point2D.Double point = new Point2D.Double(pt.getX(), pt.getY());
                this.getDiagram().fromScreen(point);
                AbstractCellView cellView = this.getCellView();
                if (cellView == null || !(cellView instanceof EdgeView)) break block3;
                EdgeView edgeView = (EdgeView)cellView;
                int n = edgeView.getPointCount();
                int handlesize = this.getDiagram().getHandleSize();
                boolean canDelete = this.canDeleteBreakpoint();
                if (!canDelete) break block3;
                for (int i = n - 2; i >= 1; --i) {
                    Point2D p = edgeView.getPoint(i);
                    Rectangle2D.Double r = new Rectangle2D.Double(p.getX() - (double)handlesize, p.getY() - (double)handlesize, 2 * handlesize, 2 * handlesize);
                    if (!r.contains(((Point2D)point).getX(), ((Point2D)point).getY())) continue;
                    edgeView.removePoint(i);
                    edgeView.updatePoints();
                    break;
                }
            }
            catch (Exception e) {
                System.out.println("Error: DefaultEdge.removeBreakpoint");
            }
        }
    }

    public boolean canDeleteBreakpoint() {
        AbstractCellView cellView = this.getCellView();
        if (cellView != null && cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            return edgeView.canDeleteBreakpoint();
        }
        return false;
    }

    public boolean hasBreakpointAt(Point pt) {
        Point2D.Double point = new Point2D.Double(pt.getX(), pt.getY());
        this.getDiagram().fromScreen(point);
        AbstractCellView cellView = this.getCellView();
        if (cellView != null && cellView instanceof EdgeView) {
            EdgeView edgeView = (EdgeView)cellView;
            int n = edgeView.getPointCount();
            int handlesize = this.getDiagram().getHandleSize();
            if (n > 2) {
                for (int i = n - 2; i >= 1; --i) {
                    Point2D p = edgeView.getPoint(i);
                    Rectangle2D.Double r = new Rectangle2D.Double(p.getX() - (double)handlesize, p.getY() - (double)handlesize, 2 * handlesize, 2 * handlesize);
                    if (!r.contains(((Point2D)point).getX(), ((Point2D)point).getY())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public void straightLine() {
        this.straightLine(true);
    }

    public void straightLine(boolean checkChanges) {
        this.straightLine(checkChanges, true);
    }

    public void straightLine(boolean checkChanges, boolean deletePoints) {
        try {
            AbstractCellView cellView;
            if (DiagramConstants.getRouting(this.getTopView().getCellView().getAllAttributes()) == null && (cellView = this.getTopView().getCellView()) != null && cellView instanceof EdgeView) {
                EdgeView edgeView = (EdgeView)cellView;
                if (edgeView.isSelfReference()) {
                    this.createDefaultSelfReferencePoints(edgeView);
                    edgeView.updatePoints();
                    edgeView.refreshLabels();
                    return;
                }
                int n = edgeView.getPointCount();
                if (!deletePoints && n > 2) {
                    return;
                }
                if (n > 2) {
                    for (int i = n - 2; i >= 1; --i) {
                        edgeView.removePoint(i);
                    }
                }
                CellView source = edgeView.getSource();
                CellView target = edgeView.getTarget();
                if (source != null && target != null && source != target && source instanceof PortView && target instanceof PortView) {
                    Rectangle2D sr = ((DefaultDiagramCell)source.getParentView().getCell()).getTopView().getCellView().getBounds();
                    Rectangle2D tr = ((DefaultDiagramCell)target.getParentView().getCell()).getTopView().getCellView().getBounds();
                    if (sr.getY() <= tr.getMaxY() && sr.getY() >= tr.getY() || tr.getY() <= sr.getMaxY() && tr.getY() >= sr.getY()) {
                        double min = Math.max(sr.getY(), tr.getY());
                        double my = Math.min(sr.getMaxY(), tr.getMaxY());
                        double y = (min + my) / 2.0;
                        PortView pvs = (PortView)source;
                        PortView pvt = (PortView)target;
                        Point2D ps = pvs.getPoint();
                        Point2D pt = pvt.getPoint();
                        if (!checkChanges || ps.getY() != pt.getY() || ps.getY() < min || ps.getY() > my) {
                            if (ps == null) {
                                ps = new Point2D.Double();
                            }
                            if (pt == null) {
                                pt = new Point2D.Double();
                            }
                            if (sr.getX() >= tr.getX()) {
                                ps.setLocation(sr.getX(), y);
                            } else {
                                ps.setLocation(sr.getMaxX(), y);
                            }
                            if (tr.getX() >= sr.getX()) {
                                pt.setLocation(tr.getX(), y);
                            } else {
                                pt.setLocation(tr.getMaxX(), y);
                            }
                            double lt = y;
                            double lb = y;
                            while (pvs.getOtherPortAt(ps) != null && lb + (double)this.offset <= my && lt - (double)this.offset >= min) {
                                ps.setLocation(ps.getX(), lb + (double)this.offset);
                                lb = ps.getY();
                                if (pvs.getOtherPortAt(ps) == null) continue;
                                ps.setLocation(ps.getX(), lt - (double)this.offset);
                                lt = ps.getY();
                            }
                            pt.setLocation(pt.getX(), ps.getY());
                            lb = lt = pt.getY();
                            while (pvt.getOtherPortAt(pt) != null && lb + (double)this.offset <= my && lt - (double)this.offset >= min) {
                                pt.setLocation(pt.getX(), lb + (double)this.offset);
                                lb = pt.getY();
                                if (pvt.getOtherPortAt(pt) == null) continue;
                                pt.setLocation(pt.getX(), lt - (double)this.offset);
                                lt = pt.getY();
                            }
                            ps.setLocation(ps.getX(), pt.getY());
                            pvs.setPoint(ps);
                            pvt.setPoint(pt);
                        }
                    } else if (sr.getX() <= tr.getMaxX() && sr.getX() >= tr.getX() || tr.getX() <= sr.getMaxX() && tr.getX() >= sr.getX()) {
                        double min = Math.max(sr.getX(), tr.getX());
                        double mx = Math.min(sr.getMaxX(), tr.getMaxX());
                        double x = (min + mx) / 2.0;
                        PortView pvs = (PortView)source;
                        PortView pvt = (PortView)target;
                        Point2D ps = pvs.getPoint();
                        Point2D pt = pvt.getPoint();
                        if (!checkChanges || ps.getX() != pt.getX() || ps.getX() < min || ps.getX() > mx) {
                            if (ps == null) {
                                ps = new Point2D.Double();
                            }
                            if (pt == null) {
                                pt = new Point2D.Double();
                            }
                            if (sr.getY() >= tr.getY()) {
                                ps.setLocation(x, sr.getY());
                            } else {
                                ps.setLocation(x, sr.getMaxY());
                            }
                            if (tr.getY() >= sr.getY()) {
                                pt.setLocation(x, tr.getY());
                            } else {
                                pt.setLocation(x, tr.getMaxY());
                            }
                            double ll = x;
                            double lr = x;
                            while (pvs.getOtherPortAt(ps) != null && lr + (double)this.offset <= mx && ll - (double)this.offset >= min) {
                                ps.setLocation(lr + (double)this.offset, ps.getY());
                                lr = ps.getX();
                                if (pvs.getOtherPortAt(ps) == null) continue;
                                ps.setLocation(ll - (double)this.offset, ps.getY());
                                ll = ps.getX();
                            }
                            pt.setLocation(ps.getX(), pt.getY());
                            lr = ll = pt.getX();
                            while (pvt.getOtherPortAt(pt) != null && lr + (double)this.offset <= mx && ll - (double)this.offset >= min) {
                                pt.setLocation(lr + (double)this.offset, pt.getY());
                                lr = pt.getX();
                                if (pvt.getOtherPortAt(pt) == null) continue;
                                pt.setLocation(ll - (double)this.offset, pt.getY());
                                ll = pt.getX();
                            }
                            ps.setLocation(pt.getX(), ps.getY());
                            pvs.setPoint(ps);
                            pvt.setPoint(pt);
                        }
                    } else {
                        PortView pvs = (PortView)source;
                        PortView pvt = (PortView)target;
                        pvs.setPoint(pvs.getSimpleLocation(edgeView));
                        pvt.setPoint(pvt.getSimpleLocation(edgeView));
                    }
                }
                edgeView.updatePoints();
                edgeView.refreshLabels();
            }
        }
        catch (Exception e) {
            System.out.println("Error: DefaultEdge.straightLine");
        }
    }

    public List createDefaultSelfReferencePoints() {
        return this.createDefaultSelfReferencePoints((EdgeView)this.getCellView());
    }

    public List createDefaultSelfReferencePoints(EdgeView edgeView) {
        if (edgeView != null) {
            List points = edgeView.getPoints();
            Point2D[] routed = null;
            Rectangle2D bounds = edgeView.getSource().getParentView().getBounds();
            AbstractCellView cellView = (AbstractCellView)edgeView.getSource().getParentView();
            double index = 25 * cellView.getSelfRefPos(edgeView);
            routed = new Point2D[]{DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() + index, bounds.getY() + bounds.getHeight() / 2.0), DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() + index, bounds.getY() + bounds.getHeight() + index), DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() + index)};
            for (int i = 0; i < routed.length; ++i) {
                if (points.size() > i + 2) {
                    points.set(i + 1, routed[i]);
                    continue;
                }
                points.add(i + 1, routed[i]);
            }
            while (points.size() > routed.length + 2) {
                points.remove(points.size() - 2);
            }
            return points;
        }
        return null;
    }

    protected boolean onlyEdgesAreSelected() {
        this.selectedObjects = this.getTopView().getDesignPartView().getSelectedObjects();
        if (this.selectedObjects.length > 1) {
            for (int i = 0; i < this.selectedObjects.length; ++i) {
                Object obj = this.selectedObjects[i];
                try {
                    if (obj instanceof DesignObject && ((DesignObject)obj).getFirstViewForDPV(this.getTopView().getDesignPartView()).getCellView().getCell() instanceof DefaultEdge) continue;
                    return false;
                }
                catch (Exception e2) {
                    return false;
                }
            }
        }
        return true;
    }

    public void straightenLine() {
        String name = Messages.getString("DefaultEdge.StraightenLinesForGroupOfObjects");
        DesignPartView dpv = this.getTopView().getDesignPartView();
        this.selectedObjects = dpv.getSelectedObjects();
        if (this.selectedObjects.length == 1) {
            Object obj = this.selectedObjects[0];
            name = MessageFormat.format(Messages.getString("DefaultEdge.StraightenLinesFor"), obj.toString());
        }
        dpv.startAutoLayoutEdit(name);
        if (this.selectedObjects.length > 1) {
            for (int i = 0; i < this.selectedObjects.length; ++i) {
                Object obj = this.selectedObjects[i];
                try {
                    TopView tv;
                    if (!(obj instanceof DesignObject) || (tv = ((DesignObject)obj).getFirstViewForDPV(dpv)) == null || !(tv.getCellView().getCell() instanceof DefaultEdge)) continue;
                    DefaultEdge edge = (DefaultEdge)tv.getCellView().getCell();
                    edge.straightLine();
                    continue;
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
        } else {
            this.straightLine();
        }
        dpv.stopAutoLayoutEdit();
    }

    public void clearLabels() {
        ((TVConnector)this.getTopView()).clearLabels();
    }

    public void hideRelation() {
        TVConnector connector = (TVConnector)this.getTopView();
        connector.hide();
    }

    public List getConnectors(Object[] objects) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            if (!(objects[i] instanceof ConnectionInterface)) continue;
            list.add(objects[i]);
        }
        return list;
    }

    public void hideRelations(List selectedConnectors) {
        if (this.getTopView() != null) {
            DesignPartView dpv = this.getTopView().getDesignPartView();
            for (ConnectionInterface ci : selectedConnectors) {
                TVConnector connector = (TVConnector)ci.getViewFor(dpv);
                if (connector == null) continue;
                connector.hide();
            }
        }
    }

    static {
        defaultPoints.add(DiagramConstants.createPoint(10.0, 10.0));
        defaultPoints.add(DiagramConstants.createPoint(20.0, 20.0));
    }

    public static class DefaultRouting
    implements Edge.Routing {
        @Override
        public void route(EdgeView edge, List points) {
            int n = points.size();
            Point2D from = edge.getPoint(0);
            if (edge.getSource() instanceof PortView) {
                from = ((PortView)edge.getSource()).getLocation(null);
            } else if (edge.getSource() != null) {
                Rectangle2D b = edge.getSource().getBounds();
                from = DiagramConstants.createPoint(b.getCenterX(), b.getCenterY());
            }
            Point2D to = edge.getPoint(n - 1);
            if (edge.getTarget() instanceof PortView) {
                to = ((PortView)edge.getTarget()).getLocation(null);
            } else if (edge.getTarget() != null) {
                Rectangle2D b = edge.getTarget().getBounds();
                to = DiagramConstants.createPoint(b.getCenterX(), b.getCenterY());
            }
            if (from != null && to != null) {
                Point2D[] routed = null;
                if (edge.isSelfReference()) {
                    Rectangle2D bounds = edge.getSource().getParentView().getBounds();
                    AbstractCellView cellView = (AbstractCellView)edge.getSource().getParentView();
                    double index = 25 * cellView.getSelfRefPos(edge);
                    routed = new Point2D[]{DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() + index, bounds.getY() + bounds.getHeight() / 2.0), DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() + index, bounds.getY() + bounds.getHeight() + index), DiagramConstants.createPoint(bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() + index)};
                } else {
                    double y2;
                    double x2;
                    double dx = Math.abs(from.getX() - to.getX());
                    double dy = Math.abs(from.getY() - to.getY());
                    Rectangle2D bs = null;
                    Rectangle2D bt = null;
                    if (edge.getSource() != null && edge.getTarget() != null) {
                        bs = edge.getSource().getParentView().getBounds();
                        bt = edge.getTarget().getParentView().getBounds();
                        x2 = bs.getX() + bs.getWidth() + (bt.getX() - (bs.getX() + bs.getWidth())) / 2.0;
                        y2 = bs.getY() + bs.getHeight() + (bt.getY() - (bs.getY() + bs.getHeight())) / 2.0;
                    } else {
                        x2 = from.getX() + (to.getX() - from.getX()) / 2.0;
                        y2 = from.getY() + (to.getY() - from.getY()) / 2.0;
                    }
                    routed = new Point2D[2];
                    double offcet = Math.max(edge.getSourceOffcet(), edge.getTargetOffcet());
                    if (dx > dy) {
                        double ys = from.getY() + edge.getSourceOffcet();
                        double yt = to.getY() + edge.getTargetOffcet();
                        if (bs != null) {
                            if (ys <= bs.getY()) {
                                ys = bs.getY() + 1.0;
                            } else if (ys >= bs.getY() + bs.getHeight()) {
                                ys = bs.getY() + bs.getHeight() - 1.0;
                            }
                        }
                        if (bt != null) {
                            if (yt <= bt.getY()) {
                                yt = bt.getY() + 1.0;
                            } else if (yt >= bt.getY() + bt.getHeight()) {
                                yt = bt.getY() + bt.getHeight() - 1.0;
                            }
                        }
                        routed[0] = DiagramConstants.createPoint(x2 - offcet, ys);
                        routed[1] = DiagramConstants.createPoint(x2 - offcet, yt);
                    } else {
                        double xs = from.getX() + edge.getSourceOffcet();
                        double xt = to.getX() + edge.getTargetOffcet();
                        if (bs != null) {
                            if (xs <= bs.getX()) {
                                xs = bs.getX() + 1.0;
                            } else if (xs >= bs.getX() + bs.getWidth()) {
                                xs = bs.getX() + bs.getWidth() - 1.0;
                            }
                        }
                        if (bt != null) {
                            if (xt <= bt.getX()) {
                                xt = bt.getX() + 1.0;
                            } else if (xt >= bt.getX() + bt.getWidth()) {
                                xt = bt.getX() + bt.getWidth() - 1.0;
                            }
                        }
                        routed[0] = DiagramConstants.createPoint(xs, y2 - offcet);
                        routed[1] = DiagramConstants.createPoint(xt, y2 - offcet);
                    }
                }
                for (int i = 0; i < routed.length; ++i) {
                    if (points.size() > i + 2) {
                        points.set(i + 1, routed[i]);
                        continue;
                    }
                    points.add(i + 1, routed[i]);
                }
                while (points.size() > routed.length + 2) {
                    points.remove(points.size() - 2);
                }
            }
        }
    }
}

