/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.event;

import java.util.EventObject;
import oracle.dbtools.crest.swingui.diagram.Messages;

public class DiagramSelectionEvent
extends EventObject {
    protected Object[] cells;
    protected boolean[] areNew;

    public DiagramSelectionEvent(Object source, Object[] cells, boolean[] areNew) {
        super(source);
        this.cells = cells;
        this.areNew = areNew;
    }

    public Object[] getCells() {
        int numCells = this.cells.length;
        Object[] retCells = new Object[numCells];
        System.arraycopy(this.cells, 0, retCells, 0, numCells);
        return retCells;
    }

    public Object getCell() {
        return this.cells[0];
    }

    public boolean isAddedCell() {
        return this.areNew[0];
    }

    public boolean isAddedCell(Object cell) {
        for (int counter = this.cells.length - 1; counter >= 0; --counter) {
            if (!this.cells[counter].equals(cell)) continue;
            return this.areNew[counter];
        }
        throw new IllegalArgumentException(Messages.getString("DiagramSelectionEvent.CellNotIdentifiedByDiagramSelectionEvent"));
    }

    public boolean isAddedCell(int index) {
        if (this.cells == null || index < 0 || index >= this.cells.length) {
            throw new IllegalArgumentException(Messages.getString("DiagramSelectionEvent.IndexBeyondRange"));
        }
        return this.areNew[index];
    }

    public Object cloneWithSource(Object newSource) {
        return new DiagramSelectionEvent(newSource, this.cells, this.areNew);
    }
}

