/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.diagram.datatypes;

import java.awt.Point;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;

public class InheritanceEdge
extends DefaultEdge {
    private JPopupMenu menu;
    private JMenuItem miStraightLine = null;
    private JMenuItem miAddBP = null;
    private JMenuItem miRemoveBP = null;
    private Point point = new Point();

    @Override
    public void showPopupMenu(Point pt) {
        if (this.isEditable()) {
            this.point.setLocation(pt);
            JPopupMenu menu = this.getPopupMenu();
            menu.show(this.getDiagram(), pt.x, pt.y);
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.menu == null) {
            this.menu = new JPopupMenu();
            if (this.isEditable()) {
                this.miStraightLine = this.menu.add(new AbstractAction(STRAIGHT_LINE){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InheritanceEdge.this.straightenLine();
                    }
                });
                this.menu.addSeparator();
                this.menu.add(new AbstractAction(FORMAT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InheritanceEdge.this.format();
                    }
                });
                this.menu.addSeparator();
                this.miAddBP = this.menu.add(new AbstractAction(ADD_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InheritanceEdge.this.addBreakpoint(InheritanceEdge.this.point);
                    }
                });
                this.miRemoveBP = this.menu.add(new AbstractAction(REMOVE_BREAKPOINT){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        InheritanceEdge.this.removeBreakpoint(InheritanceEdge.this.point);
                    }
                });
            }
        }
        if (this.miStraightLine != null) {
            this.miStraightLine.setEnabled(!this.getTopView().getDesignPartView().isAutoRoute());
        }
        if (this.miAddBP != null && this.miRemoveBP != null) {
            if (this.getTopView().getDesignPartView().isAutoRoute()) {
                this.miAddBP.setEnabled(false);
                this.miRemoveBP.setEnabled(false);
            } else {
                boolean b = this.hasBreakpointAt(this.point);
                this.miAddBP.setEnabled(!b);
                this.miRemoveBP.setEnabled(b && this.canDeleteBreakpoint());
            }
        }
        return this.menu;
    }
}

