/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.PatternSyntaxException;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.DefaultRowSorter;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableRowSorter;
import javax.swing.text.BadLocationException;
import oracle.dbtools.crest.exports.ddl.DDLException;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIDObjectSet;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.ModelObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignObjectSet;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxySet;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.design.storage.TableViewProxy;
import oracle.dbtools.crest.model.design.storage.db2.v70.StorageDesignDB2v70;
import oracle.dbtools.crest.model.design.storage.db2.v80.StorageDesignDB2v80;
import oracle.dbtools.crest.model.design.storage.oracle.StorageDesignOracle;
import oracle.dbtools.crest.model.design.storage.oracle.v10g.StorageDesignOraclev10g;
import oracle.dbtools.crest.model.design.storage.oracle.v9i.StorageDesignOraclev9i;
import oracle.dbtools.crest.model.design.storage.sqlserver.StorageDesignSqlServer;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k.StorageDesignSqlServerv2k;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k12.StorageDesignSqlServerv2k12;
import oracle.dbtools.crest.model.design.storage.sqlserver.v2k5.StorageDesignSqlServerv2k5;
import oracle.dbtools.crest.model.design.storage.udb.StorageDesignUDB;
import oracle.dbtools.crest.model.design.storage.udb.v81.StorageDesignUDBv81;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.WindowsTableHeader;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.DDLGenerationOptions;
import oracle.dbtools.crest.swingui.ddl.DDLSelectionPersistence;
import oracle.dbtools.crest.swingui.ddl.Messages;
import oracle.dbtools.crest.swingui.ddl.models.DDLCheckEditor;
import oracle.dbtools.crest.swingui.ddl.models.DDLNavigationTreeRenderer;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionDB2;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionLists;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionOraclev8i;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k12;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionSqlServerv2k5;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionTabs;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv71;
import oracle.dbtools.crest.swingui.ddl.models.DDLSelectionUDBv81;
import oracle.dbtools.crest.swingui.ddl.models.DDLTreeNavigationDesign;
import oracle.dbtools.crest.swingui.designrules.DDLTransformationScriptSet;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.editor.DDLExceptionPropertyDialog;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.SubstitutionPattern;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.javatools.editor.BasicEditorPane;

public class DDLSelectionDialog
extends CustomDialog {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private JTabbedPane selectionTabbedPane;
    String BTN_OK = Messages.getString("DDLSelectionDialog.OK");
    String BTN_APPLY = Messages.getString("DDLSelectionDialog.Apply");
    String BTN_CANCEL = Messages.getString("DDLSelectionDialog.Cancel");
    private JButton bnCancel;
    private JTree tree;
    private JPanel treePanel;
    private JPanel dropPanel;
    private DDLTreeNavigationDesign stdes;
    private StorageDesign storageDesign;
    private JFrame owner;
    private JCheckBox chIncludeComments;
    private JComboBox cbDDLType;
    private JCheckBox chGenerateDDLInFiles;
    private JCheckBox chGenerateRESTServices;
    private JButton bnDesRules;
    private DDLFileMakerEditor fileMakerEditor;
    private DefaultListModel dropableModel;
    public JList dropableList;
    private List drpList = new ArrayList();
    private JDialog dialog;
    private JPanel optionsPanel;
    private List eList;
    private JTable eTable;
    private int counter = 0;
    private JCheckBox chApplyNameSubstitution;
    private JPanel substPanel;
    private List substitutionList;
    public JTable tbSubstitution;
    private JButton bnAddColumn;
    private JButton bnRemoveColumn;
    private JButton bnSelectAll;
    private JButton bnDeselectAll;
    private List objectTypesList = new ArrayList();
    public JTable tbObjectTypes;
    private boolean saveSelection = true;
    private static final String BTN_ADD = Messages.getString("DDLSelectionDialog.Add");
    private static final String BTN_REMOVE = Messages.getString("DDLSelectionDialog.Remove");
    private List insertionList = new ArrayList();
    public JTable insertionTable;
    private JButton bnSelectAllTableScripts;
    private JButton bnDeselectAllTableScripts;
    private List triggerList = new ArrayList();
    private List packagesList = new ArrayList();
    private List packageBodiesList = new ArrayList();
    private List stProcList = new ArrayList();
    private List functionsList = new ArrayList();
    private List typeList = new ArrayList();
    private List aliasList = new ArrayList();
    private JTable tableDDLScriptTable;
    private List tableDDLScriptList;
    private JButton bnSelectAllDDLScripts;
    private JButton bnDeselectAllDDLScripts;
    private DefaultComboBoxModel cbActiveModel;
    private JComboBox cbActive;
    Object currenActiveSet;
    private GUIConfiguration configuration = GUIConfiguration.getInstance();
    private static final Logger LOGGER = new Logger(DDLSelectionDialog.class);
    private static DDLSelectionPersistence ddlSelectionPersistence = null;
    JToolBar dropBar;
    JCheckBox chbDropGenerated;
    JCheckBox chbUseDropDependency;
    private DesignLevelSettings settings;

    public DDLSelectionDialog(ApplicationView view, StorageDesign design, DDLFileMakerEditor fileMakerEditor) {
        super(view);
        this.fileMakerEditor = fileMakerEditor;
        this.owner = (JFrame)fileMakerEditor.getDialog();
        this.storageDesign = design;
        this.setLayout(new BorderLayout());
        JPanel jpanel = new JPanel(new BorderLayout());
        this.tabbedPane.setPreferredSize(new Dimension(750, 470));
        jpanel.add((Component)this.tabbedPane, "Center");
        jpanel.add((Component)this.getOptionsPanel(), "South");
        this.add((Component)jpanel, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton bnSaveSelection = new JButton(Messages.getString("DDLGenerationOptions.SaveConfiguration"));
        bnSaveSelection.setMnemonic(83);
        bnSaveSelection.addActionListener(new saveSelectionAction());
        JButton bnRestoreSelection = new JButton(Messages.getString("DDLGenerationOptions.RestoreConfiguration"));
        bnRestoreSelection.setMnemonic(76);
        bnRestoreSelection.addActionListener(new restoreSelectionAction());
        JButton bnOK = new JButton(this.BTN_OK);
        bnOK.addActionListener(new OKAction());
        bnOK.setMnemonic(79);
        this.bnCancel = new JButton(this.BTN_CANCEL);
        this.bnCancel.setMnemonic(67);
        this.bnCancel.addActionListener(new CancelAction());
        JButton bnHelp = new JButton(this.getHelpAction());
        bnHelp.setMnemonic(72);
        bnSaveSelection.setPreferredSize(MessageDialogs.BUTTON_SIZE_126);
        bnRestoreSelection.setPreferredSize(MessageDialogs.BUTTON_SIZE_126);
        bnOK.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.bnCancel.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        bnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.settings = this.getDesign().getDesignLevelSettings();
        bottomPanel.add(bnSaveSelection);
        bottomPanel.add(bnRestoreSelection);
        bottomPanel.add(bnOK);
        bottomPanel.add(this.bnCancel);
        bottomPanel.add(bnHelp);
        this.add((Component)bottomPanel, "South");
        this.initProperties();
    }

    public DDLFileMakerEditor getFileMakerEditor() {
        return this.fileMakerEditor;
    }

    public void setSaveSelection(boolean saveIt) {
        this.saveSelection = saveIt;
    }

    @Override
    public Design getDesign() {
        if (this.storageDesign != null) {
            return this.storageDesign.getDesign();
        }
        return super.getDesign();
    }

    @Override
    protected void close() {
        this.getDialog().dispose();
    }

    public void showDialog() {
        CommonUtil.centerOnScreen(this.getDialog());
        if (!this.storageDesign.getDesign().isOldRepositoryType() && this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions() && this.saveSelection) {
            this.stopTableEditing(this.tbSubstitution);
            this.stopTableEditing(this.insertionTable);
            this.setProperties();
            DDLSelectionDialog.getDDLSelectionPersistence().setSaveSelectionsBLPS(this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions());
            DDLSelectionDialog.getDDLSelectionPersistence().saveDDLSelectionForDesign(this.storageDesign.getDesign(), this.chIncludeComments.isSelected(), this.chApplyNameSubstitution.isSelected(), this.chbDropGenerated.isSelected(), this.chbUseDropDependency.isSelected(), this.insertionTable, this.tbSubstitution, this.tbObjectTypes, this.dropableList, this.chGenerateDDLInFiles.isSelected(), this.chGenerateRESTServices.isSelected(), this.fileMakerEditor, this.cbActive.getSelectedIndex());
            DDLSelectionDialog.getDDLSelectionPersistence().setSaveSelectionsBLPS(false);
        }
        this.getDialog().setVisible(true);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog((Frame)this.fileMakerEditor.getDialog(), this.getCaption());
            this.dialog.setModal(true);
            this.dialog.setSize(980, 600);
            this.dialog.setDefaultCloseOperation(2);
            this.setDefaultActions(this.dialog);
            this.dialog.getContentPane().add(this);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = DDLSelectionDialog.this.dialog.getWidth();
                    int h = DDLSelectionDialog.this.dialog.getHeight();
                    w = Math.max(980, w);
                    h = Math.max(600, h);
                    DDLSelectionDialog.this.dialog.setSize(w, h);
                }
            });
        }
        return this.dialog;
    }

    @Override
    protected String getHelpIndex() {
        return "DDL_GENERATION_OPTIONS_DIALOG";
    }

    public String getCaption() {
        return Messages.getString("DDLSelectionDialog.DDLGenerationOptions");
    }

    private void initProperties() {
        this.initTreePanel();
        this.initDropPanel();
        this.initNameSubstitutionPanel();
        this.initInsertionPanel();
        this.initTableDDLScriptsPanel();
        this.initDDLExceptionsPanel();
        this.tabbedPane.setEnabledAt(5, this.cbDDLType.getSelectedIndex() > 0);
    }

    private void initInsertionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.bnSelectAllTableScripts = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAllTableScripts.setToolTipText(Messages.getString("DDLSelectionDialog.SelectAll"));
        this.bnSelectAllTableScripts.addActionListener(new SelectAllTableScriptsAction());
        this.bnDeselectAllTableScripts = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAllTableScripts.setToolTipText(Messages.getString("DDLSelectionDialog.DeselectAll"));
        this.bnDeselectAllTableScripts.addActionListener(new DeselectAllTableScriptsAction());
        JLabel filterLabel = new JLabel(Messages.getString("DDLSelectionDialog.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        JTextField tableNamefilter = new JTextField();
        tableNamefilter.setPreferredSize(new Dimension(200, 20));
        tableNamefilter.setMinimumSize(new Dimension(200, 20));
        tableNamefilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.bnSelectAllTableScripts);
        toolBar.add(this.bnDeselectAllTableScripts);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(tableNamefilter);
        panel.add((Component)toolBar, "North");
        this.insertionList = new ArrayList();
        Iterator it = this.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            if (!this.checkForScripts(table)) continue;
            InsertionObject object = new InsertionObject(table, table.getShouldGenerateScript());
            this.insertionList.add(object);
        }
        InsertionModel insertionModel = new InsertionModel();
        this.insertionTable = new JTable(insertionModel);
        this.insertionTable.getTableHeader().setReorderingAllowed(false);
        tableNamefilter.getDocument().addDocumentListener(new FilterObjectListener(tableNamefilter, this.insertionTable, 1));
        this.insertionTable.setSelectionMode(0);
        this.insertionTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = DDLSelectionDialog.this.insertionTable.getSelectedColumn();
                    int row = DDLSelectionDialog.this.insertionTable.getSelectedRow();
                    if (row != -1 && col == 1 && DDLSelectionDialog.this.insertionList.size() > 0 && row < DDLSelectionDialog.this.insertionList.size()) {
                        InsertionObject insertionObj = (InsertionObject)DDLSelectionDialog.this.insertionList.get(row);
                        Table table = insertionObj.getObject();
                        table.showModal = true;
                        table.showPropertyDialog();
                        if (!DDLSelectionDialog.this.checkForScripts(table)) {
                            DDLSelectionDialog.this.insertionList.remove(insertionObj);
                        } else {
                            insertionObj.setObject(table);
                            insertionObj.setSelected(table.getShouldGenerateScript());
                        }
                        DDLSelectionDialog.this.insertionTable.updateUI();
                    }
                }
            }
        });
        TableRowSorter trSorter = new TableRowSorter();
        trSorter.setSortsOnUpdates(true);
        if (this.insertionList.size() > 0) {
            this.insertionTable.setRowSorter(trSorter);
            this.insertionTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.insertionTable, 1);
        }
        TableColumn column = this.insertionTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = this.insertionTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        JScrollPane scrollpane = new JScrollPane(this.insertionTable);
        panel.add((Component)scrollpane, "Center");
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.IncludeTableScripts"), panel);
    }

    private void initTableDDLScriptsPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.bnSelectAllDDLScripts = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAllDDLScripts.setToolTipText(Messages.getString("DDLSelectionDialog.SelectAll"));
        this.bnSelectAllDDLScripts.addActionListener(new SelectAllDDLScriptsAction());
        this.bnDeselectAllDDLScripts = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAllDDLScripts.setToolTipText(Messages.getString("DDLSelectionDialog.DeselectAll"));
        this.bnDeselectAllDDLScripts.addActionListener(new DeselectAllDDLScriptsAction());
        JLabel filterLabel = new JLabel(Messages.getString("DDLSelectionDialog.Filter"));
        filterLabel.setPreferredSize(new Dimension(50, 20));
        filterLabel.setMinimumSize(new Dimension(50, 20));
        filterLabel.setMaximumSize(new Dimension(50, 20));
        JTextField tableNamefilter = new JTextField();
        tableNamefilter.setPreferredSize(new Dimension(200, 20));
        tableNamefilter.setMinimumSize(new Dimension(200, 20));
        tableNamefilter.setMaximumSize(new Dimension(200, 20));
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(this.bnSelectAllDDLScripts);
        toolBar.add(this.bnDeselectAllDDLScripts);
        toolBar.addSeparator();
        toolBar.add(filterLabel);
        toolBar.add(tableNamefilter);
        panel.add((Component)toolBar, "North");
        JLabel lblActive = new JLabel(oracle.dbtools.crest.swingui.designrules.Messages.getString("DDLTransformationsScriptsDialog.ActiveScriptsSet"));
        lblActive.setPreferredSize(new Dimension(120, 20));
        lblActive.setPreferredSize(new Dimension(100, 20));
        this.cbActiveModel = new DefaultComboBoxModel();
        this.cbActive = new JComboBox(this.cbActiveModel);
        this.cbActive.setPreferredSize(new Dimension(150, 20));
        this.cbActive.setMaximumSize(new Dimension(150, 20));
        this.cbActive.setMaximumSize(new Dimension(150, 20));
        this.reloadSets();
        JLabel emptyLabel = new JLabel(":");
        emptyLabel.setMinimumSize(new Dimension(15, 20));
        emptyLabel.setMaximumSize(new Dimension(15, 20));
        toolBar.addSeparator();
        toolBar.add(lblActive);
        toolBar.add(emptyLabel);
        toolBar.add(this.cbActive);
        this.tableDDLScriptList = new ArrayList();
        Iterator it = this.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            InsertionObject object = new InsertionObject(table, table.isUseDDLTransformationScript());
            this.tableDDLScriptList.add(object);
        }
        TableDDLScriptModel tableDDLScriptModel = new TableDDLScriptModel();
        this.tableDDLScriptTable = new JTable(tableDDLScriptModel);
        this.tableDDLScriptTable.getTableHeader().setReorderingAllowed(false);
        this.tableDDLScriptTable.setSelectionMode(0);
        tableNamefilter.getDocument().addDocumentListener(new FilterObjectListener(tableNamefilter, this.tableDDLScriptTable, 1));
        this.tableDDLScriptTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    int col = DDLSelectionDialog.this.tableDDLScriptTable.getSelectedColumn();
                    int row = DDLSelectionDialog.this.tableDDLScriptTable.getSelectedRow();
                    if (row != -1 && col == 1 && DDLSelectionDialog.this.tableDDLScriptList.size() > 0 && row < DDLSelectionDialog.this.tableDDLScriptList.size()) {
                        InsertionObject insertionObj = (InsertionObject)DDLSelectionDialog.this.tableDDLScriptList.get(row);
                        Table table = insertionObj.getObject();
                        table.showModal = true;
                        table.showPropertyDialog();
                        insertionObj.setObject(table);
                        insertionObj.setSelected(table.isUseDDLTransformationScript());
                        DDLSelectionDialog.this.tableDDLScriptTable.updateUI();
                    }
                }
            }
        });
        TableRowSorter trSorter = new TableRowSorter();
        trSorter.setSortsOnUpdates(true);
        if (this.tableDDLScriptList.size() > 0) {
            this.tableDDLScriptTable.setRowSorter(trSorter);
            this.tableDDLScriptTable.setAutoCreateRowSorter(true);
            WindowsTableHeader.setSortedHeader(this.tableDDLScriptTable, 1);
        }
        TableColumn column = this.tableDDLScriptTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(100);
        column = this.tableDDLScriptTable.getColumnModel().getColumn(1);
        column.setPreferredWidth(200);
        JScrollPane scrollpane = new JScrollPane(this.tableDDLScriptTable);
        panel.add((Component)scrollpane, "Center");
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.IncludeTableDDLScripts"), panel);
    }

    private boolean checkForScripts(Table table) {
        return !table.getBeforeDrop().trim().equals("") || !table.getBeforeCreate().trim().equals("") || !table.getAfterCreate().trim().equals("") || !table.getEndOfScript().trim().equals("");
    }

    private void initNameSubstitutionPanel() {
        this.substPanel = new JPanel(new BorderLayout());
        JTabbedPane substPane = new JTabbedPane();
        JPanel substitutionPanel = this.createSubstitutionPanel();
        JPanel typesPanel = this.createObjectTypesPanel();
        substPane.add(Messages.getString("DDLSelectionDialog.NameSubstitution"), substitutionPanel);
        substPane.add(Messages.getString("DDLSelectionDialog.ObjectTypes"), typesPanel);
        this.substPanel.add(substPane);
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.NameSubstitution"), this.substPanel);
    }

    private JPanel createObjectTypesPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.objectTypesList = this.storageDesign.getNameSubstitutionTypesList();
        ObjectTypesModel objectTypeModel = new ObjectTypesModel();
        this.tbObjectTypes = new JTable(objectTypeModel);
        this.tbObjectTypes.setSelectionMode(0);
        TableColumn column = this.tbObjectTypes.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.tbObjectTypes.getColumnModel().getColumn(1);
        column.setPreferredWidth(400);
        JScrollPane scrollpane = new JScrollPane(this.tbObjectTypes);
        panel.add(scrollpane);
        return panel;
    }

    private void initTreePanel() {
        this.selectionTabbedPane = new JTabbedPane();
        this.selectionTabbedPane.setTabPlacement(3);
        this.treePanel = new JPanel(new BorderLayout());
        DesignPartView selectedSubView = this.getDesign().getSelectedSubView();
        if (selectedSubView == null || selectedSubView.equals(this.getRelationalDesign().getMainView())) {
            this.stdes = new DDLTreeNavigationDesign(this.storageDesign);
            selectedSubView = null;
        } else {
            this.stdes = new DDLTreeNavigationDesign(this.storageDesign, selectedSubView);
        }
        this.stdes.setSelectedSubView(selectedSubView);
        this.tree = new JTree(this.stdes);
        this.tree.setEditable(true);
        DDLNavigationTreeRenderer renderer = new DDLNavigationTreeRenderer();
        this.tree.setCellRenderer(renderer);
        DDLCheckEditor editor = new DDLCheckEditor();
        this.tree.setCellEditor(editor);
        JScrollPane jsp = new JScrollPane(this.tree);
        this.treePanel.add((Component)jsp, "Center");
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.TreeView"), this.treePanel);
        List tableList = ((DDLSelectionLists)this.stdes.getRoot()).getTableList();
        JPanel tablePanel = new JPanel(new BorderLayout());
        JTable tableTable = new JTable();
        this.initObjectTab(tablePanel, tableTable, tableList);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Tables"), tablePanel);
        List constraintList = ((DDLSelectionLists)this.stdes.getRoot()).getConstraintList();
        JPanel constraintPanel = new JPanel(new BorderLayout());
        JTable constraintTable = new JTable();
        this.initContainerTab(constraintPanel, constraintTable, constraintList);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.PKUKConstraints"), constraintPanel);
        List indexList = ((DDLSelectionLists)this.stdes.getRoot()).getIndexList();
        JPanel indexPanel = new JPanel(new BorderLayout());
        JTable indexTable = new JTable();
        this.initContainerTab(indexPanel, indexTable, indexList);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Indexes"), indexPanel);
        List fkList = ((DDLSelectionLists)this.stdes.getRoot()).getFkList();
        JPanel fkPanel = new JPanel(new BorderLayout());
        JTable fkTable = new JTable();
        this.initContainerTab(fkPanel, fkTable, fkList);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.ForeignKeys"), fkPanel);
        List viewList = ((DDLSelectionLists)this.stdes.getRoot()).getViewList();
        JPanel viewPanel = new JPanel(new BorderLayout());
        JTable viewTable = new JTable();
        this.initObjectTab(viewPanel, viewTable, viewList);
        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Views"), viewPanel);
        if (this.storageDesign.isOpen()) {
            if (this.storageDesign instanceof StorageDesignUDB || this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                if (this.storageDesign instanceof StorageDesignUDB) {
                    this.aliasList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getAliasList();
                } else if (this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                    this.aliasList = ((DDLSelectionDB2)this.stdes.getRoot()).getAliasList();
                }
                JPanel aliasPanel = new JPanel(new BorderLayout());
                JTable aliasTable = new JTable();
                this.initObjectTab(aliasPanel, aliasTable, this.aliasList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Aliases"), aliasPanel);
                if (this.storageDesign instanceof StorageDesignDB2v70 || this.storageDesign instanceof StorageDesignDB2v80) {
                    List auxTableList = ((DDLSelectionDB2)this.stdes.getRoot()).getAuxTableList();
                    JPanel auxTablePanel = new JPanel(new BorderLayout());
                    JTable auxTableTbl = new JTable();
                    this.initObjectTab(auxTablePanel, auxTableTbl, auxTableList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.AuxTables"), auxTablePanel);
                    this.stProcList = ((DDLSelectionDB2)this.stdes.getRoot()).getStoredProcedureList();
                    JPanel stProcPanel = new JPanel(new BorderLayout());
                    JTable stProcTable = new JTable();
                    this.initObjectTab(stProcPanel, stProcTable, this.stProcList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), stProcPanel);
                }
            }
            if (this.storageDesign instanceof StorageDesignOracle || this.storageDesign instanceof StorageDesignUDB) {
                if (this.storageDesign instanceof StorageDesignOracle) {
                    this.triggerList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getTriggerList();
                    this.packagesList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getPackagesList();
                    this.packageBodiesList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getPackageBodiesList();
                    this.stProcList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getStoredProceduresList();
                    this.functionsList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getFunctionsList();
                    this.typeList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getTypeList();
                    List clusterList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getClusterList();
                    JPanel clusterPanel = new JPanel(new BorderLayout());
                    JTable clusterTable = new JTable();
                    this.initObjectTab(clusterPanel, clusterTable, clusterList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Clusters"), clusterPanel);
                    List dimensionList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getDimensionList();
                    JPanel dimensionPanel = new JPanel(new BorderLayout());
                    JTable dimensionTable = new JTable();
                    this.initObjectTab(dimensionPanel, dimensionTable, dimensionList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Dimensions"), dimensionPanel);
                    List snapshotList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSnapshotList();
                    JPanel snapshotPanel = new JPanel(new BorderLayout());
                    JTable snapshotTable = new JTable();
                    this.initObjectTab(snapshotPanel, snapshotTable, snapshotList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Snapshots"), snapshotPanel);
                    List synonymList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSynonymList();
                    JPanel synonymPanel = new JPanel(new BorderLayout());
                    JTable synonymTable = new JTable();
                    this.initObjectModelTab(synonymPanel, synonymTable, synonymList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Synonyms"), synonymPanel);
                    List sequenceList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getSequenceList();
                    JPanel sequencePanel = new JPanel(new BorderLayout());
                    JTable sequenceTable = new JTable();
                    this.initObjectTab(sequencePanel, sequenceTable, sequenceList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Sequences"), sequencePanel);
                    if (this.storageDesign instanceof StorageDesignOraclev9i || this.storageDesign instanceof StorageDesignOraclev10g) {
                        List bjList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getBjList();
                        JPanel bjPanel = new JPanel(new BorderLayout());
                        JTable bjTable = new JTable();
                        this.initContainerTab(bjPanel, bjTable, bjList);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.BitmapJoinIndexes"), bjPanel);
                        List extTableList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getExtTableList();
                        JPanel extTablePanel = new JPanel(new BorderLayout());
                        JTable extTblTable = new JTable();
                        this.initObjectTab(extTablePanel, extTblTable, extTableList);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.ExternalTables"), extTablePanel);
                        List collTypeList = ((DDLSelectionOraclev8i)this.stdes.getRoot()).getCollTypeList();
                        JPanel collTypePanel = new JPanel(new BorderLayout());
                        JTable collTypeTable = new JTable();
                        this.initObjectTab(collTypePanel, collTypeTable, collTypeList);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.CollectionTypes"), collTypePanel);
                    }
                } else if (this.storageDesign instanceof StorageDesignUDB) {
                    this.triggerList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getTriggerList();
                    this.stProcList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getStoredProcedureList();
                    this.functionsList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getFunctionList();
                    this.typeList = ((DDLSelectionUDBv71)this.stdes.getRoot()).getTypeList();
                }
                JPanel triggerPanel = new JPanel(new BorderLayout());
                JTable triggerTable = new JTable();
                this.initContainerTab(triggerPanel, triggerTable, this.triggerList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Triggers"), triggerPanel);
                if (this.storageDesign instanceof StorageDesignOracle) {
                    JPanel packagesPanel = new JPanel(new BorderLayout());
                    JTable packagesTable = new JTable();
                    this.initObjectTab(packagesPanel, packagesTable, this.packagesList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Packages"), packagesPanel);
                    JPanel packageBodiesPanel = new JPanel(new BorderLayout());
                    JTable packageBodiesTable = new JTable();
                    this.initObjectTab(packageBodiesPanel, packageBodiesTable, this.packageBodiesList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.PackageBodies"), packageBodiesPanel);
                }
                JPanel stProcPanel = new JPanel(new BorderLayout());
                JTable stProcTable = new JTable();
                this.initObjectTab(stProcPanel, stProcTable, this.stProcList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), stProcPanel);
                JPanel functionsPanel = new JPanel(new BorderLayout());
                JTable functionsTable = new JTable();
                this.initObjectTab(functionsPanel, functionsTable, this.functionsList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Functions"), functionsPanel);
                JPanel typePanel = new JPanel(new BorderLayout());
                JTable typeTable = new JTable();
                this.initObjectTab(typePanel, typeTable, this.typeList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StructuredTypes"), typePanel);
                if (this.storageDesign instanceof StorageDesignUDBv81) {
                    List sequenceList = ((DDLSelectionUDBv81)this.stdes.getRoot()).getSequenceList();
                    JPanel sequencePanel = new JPanel(new BorderLayout());
                    JTable sequenceTable = new JTable();
                    this.initObjectTab(sequencePanel, sequenceTable, sequenceList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Sequences"), sequencePanel);
                }
            }
            if (this.storageDesign instanceof StorageDesignSqlServer) {
                DDLSelectionTabs tabObject;
                List dbList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getDatabaseList();
                JPanel dbPanel = new JPanel(new BorderLayout());
                JTable dbTable = new JTable();
                this.initObjectTab(dbPanel, dbTable, dbList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Databases"), dbPanel);
                this.triggerList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getTriggerList();
                JPanel triggerPanel = new JPanel(new BorderLayout());
                JTable triggerTable = new JTable();
                this.initContainerTab(triggerPanel, triggerTable, this.triggerList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Triggers"), triggerPanel);
                List defaultList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getDefaultList();
                JPanel defaultPanel = new JPanel(new BorderLayout());
                JTable defaultTable = new JTable();
                this.initObjectTab(defaultPanel, defaultTable, defaultList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Defaults"), defaultPanel);
                List roleList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getRoleList();
                JPanel rolePanel = new JPanel(new BorderLayout());
                JTable roleTable = new JTable();
                this.initObjectTab(rolePanel, roleTable, roleList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Roles"), rolePanel);
                List ruleList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getRuleList();
                JPanel rulePanel = new JPanel(new BorderLayout());
                JTable ruleTable = new JTable();
                this.initObjectTab(rulePanel, ruleTable, ruleList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Rules"), rulePanel);
                this.stProcList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getProcedureList();
                JPanel procPanel = new JPanel(new BorderLayout());
                JTable procTable = new JTable();
                this.initObjectTab(procPanel, procTable, this.stProcList);
                this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.StoredProcedures"), procPanel);
                List userList = ((DDLSelectionSqlServerv2k)this.stdes.getRoot()).getUserList();
                JPanel userPanel = new JPanel(new BorderLayout());
                JTable userTable = new JTable();
                DDLSelectionTabs dDLSelectionTabs = tabObject = new DDLSelectionTabs(userPanel, userTable, userList, this.getStorageDesign());
                dDLSelectionTabs.getClass();
                userTable.setModel(new DDLSelectionTabs.UserModel(dDLSelectionTabs, userList));
                this.setColumnWidth(userTable);
                if (this.storageDesign instanceof StorageDesignSqlServerv2k) {
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Users"), userPanel);
                } else if (this.storageDesign instanceof StorageDesignSqlServerv2k5 || this.storageDesign instanceof StorageDesignSqlServerv2k12) {
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Schemas"), userPanel);
                    List synonymList = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getSynonymList();
                    JPanel synonymPanel = new JPanel(new BorderLayout());
                    JTable synonymTable = new JTable();
                    this.initObjectModelTab(synonymPanel, synonymTable, synonymList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Synonyms"), synonymPanel);
                    List distTypeList = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getDistTypeList();
                    JPanel distPanel = new JPanel(new BorderLayout());
                    JTable distTable = new JTable();
                    this.initObjectTab(distPanel, distTable, distTypeList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.UDDTDistinctTypes"), distPanel);
                    List domainTypeList = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getDomainTypeList();
                    JPanel domainPanel = new JPanel(new BorderLayout());
                    JTable domainTable = new JTable();
                    this.initObjectTab(domainPanel, domainTable, domainTypeList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.UDDTDomains"), domainPanel);
                    List xmlCollList = ((DDLSelectionSqlServerv2k5)this.stdes.getRoot()).getCollTypeList();
                    JPanel xmlCollPanel = new JPanel(new BorderLayout());
                    JTable xmlCollTable = new JTable();
                    this.initObjectTab(xmlCollPanel, xmlCollTable, xmlCollList);
                    this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.XMLSchemaCollections"), xmlCollPanel);
                    if (this.storageDesign instanceof StorageDesignSqlServerv2k12) {
                        List sequenceList = ((DDLSelectionSqlServerv2k12)this.stdes.getRoot()).getSequenceList();
                        JPanel seqPanel = new JPanel(new BorderLayout());
                        JTable seqTable = new JTable();
                        this.initObjectTab(seqPanel, seqTable, sequenceList);
                        this.selectionTabbedPane.addTab(Messages.getString("DDLSelectionDialog.Sequences"), seqPanel);
                    }
                }
            }
        }
        this.tabbedPane.insertTab(Messages.getString("DDLSelectionDialog.CreateSelection"), null, this.selectionTabbedPane, null, 0);
    }

    private void initDropPanel() {
        this.dropBar = new JToolBar(0);
        this.dropBar.setFloatable(false);
        this.dropableModel = new DefaultListModel();
        this.chbDropGenerated = new JCheckBox(Messages.getString("DDLSelectionDialog.DropGeneratedObjectsOnly"));
        Design.DROP_GENERATED_OBJECTS_ONLY = true;
        this.chbDropGenerated.setSelected(Design.DROP_GENERATED_OBJECTS_ONLY);
        this.dropBar.add(this.chbDropGenerated);
        this.chbUseDropDependency = new JCheckBox(Messages.getString("DDLSelectionDialog.UseDropDependencies"));
        Design.USE_DROP_DEPENDENCY = true;
        this.chbUseDropDependency.setSelected(Design.USE_DROP_DEPENDENCY);
        this.dropBar.add(this.chbUseDropDependency);
        this.dropableList = new JList(this.dropableModel);
        List list = null;
        if (this.storageDesign.isOpen()) {
            list = this.storageDesign.getDropableSets();
        } else if (this.storageDesign.getPhysicalDesign() != null) {
            list = this.storageDesign.getPhysicalDesign().getDropableSets();
        }
        for (ModelObject obj : list) {
            Dropable drp = new Dropable(obj);
            this.drpList.add(drp);
        }
        this.dropableList.setListData(this.drpList.toArray());
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Object obj;
                if (!DDLSelectionDialog.this.dropableList.isEnabled()) {
                    return;
                }
                JList list = (JList)e.getSource();
                int index = list.locationToIndex(e.getPoint());
                Rectangle rect = list.getCellBounds(index, index);
                if (index > -1 && (obj = list.getModel().getElementAt(index)) != null && obj instanceof Dropable && rect.contains(e.getPoint())) {
                    Dropable drp = (Dropable)obj;
                    boolean selected = drp.selected;
                    drp.selected = !selected;
                    list.repaint(rect);
                }
            }
        };
        this.dropableList.setCellRenderer(new CBCellRenderer());
        this.dropableList.addMouseListener(mouseListener);
        this.dropPanel = new JPanel(new BorderLayout());
        JScrollPane jsp = new JScrollPane();
        jsp.getViewport().add((Component)this.dropableList, null);
        this.dropPanel.add((Component)this.dropBar, "North");
        this.dropPanel.add((Component)jsp, "Center");
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.DropSelection"), this.dropPanel);
    }

    private void initDDLExceptionsPanel() {
        JPanel pnExceptions = new JPanel(new BorderLayout());
        this.eList = new ArrayList<DDLException>(this.getApplicationView().getDDLExceptionList().getDDLExceptions());
        this.eTable = new JTable(new DDLExceptionsModel());
        this.eTable.setSelectionMode(0);
        TableColumn column = this.eTable.getColumnModel().getColumn(0);
        column.setPreferredWidth(5);
        column = this.eTable.getColumnModel().getColumn(2);
        column.setPreferredWidth(200);
        this.eTable.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                int row;
                if (e.getClickCount() == 2 && (row = DDLSelectionDialog.this.eTable.getSelectedRow()) != -1 && DDLSelectionDialog.this.eList.size() > 0 && row < DDLSelectionDialog.this.eList.size()) {
                    DDLException ddlException = (DDLException)DDLSelectionDialog.this.eList.get(row);
                    DDLExceptionPropertyDialog dialog = new DDLExceptionPropertyDialog(DDLSelectionDialog.this.getApplicationView(), ddlException, (JDialog)DDLSelectionDialog.this.getDialog());
                    dialog.initProperties();
                    dialog.showDialog();
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(this.eTable);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        JButton btnProperties = new JButton(this.configuration.getIcon("EDIT_ICON", 16));
        btnProperties.setToolTipText(Messages.getString("DDLSelectionDialog.ViewProperties"));
        btnProperties.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int row = DDLSelectionDialog.this.eTable.getSelectedRow();
                if (row != -1 && DDLSelectionDialog.this.eList.size() > 0 && row < DDLSelectionDialog.this.eList.size()) {
                    DDLException ddlException = (DDLException)DDLSelectionDialog.this.eList.get(row);
                    DDLExceptionPropertyDialog dialog = new DDLExceptionPropertyDialog(DDLSelectionDialog.this.getApplicationView(), ddlException, (JDialog)DDLSelectionDialog.this.getDialog());
                    dialog.initProperties();
                    dialog.showDialog();
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JButton bnAdd = new JButton(this.configuration.getIcon("ADD_ICON", 16));
        bnAdd.setToolTipText(Messages.getString("DDLSelectionDialog.AddDDLException"));
        bnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DDLException ddlException = new DDLException(DDLSelectionDialog.this.generateNumber(), "");
                if (DDLSelectionDialog.this.getApplicationView().getDDLExceptionList().addDDLException(ddlException)) {
                    DDLSelectionDialog.this.eList.add(ddlException);
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JButton bnRemove = new JButton(this.configuration.getIcon("REMOVE_ICON", 16));
        bnRemove.setToolTipText(Messages.getString("DDLSelectionDialog.RemoveDDLException"));
        bnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                int objectNumber = DDLSelectionDialog.this.eTable.getSelectedRow();
                if (objectNumber != -1 && DDLSelectionDialog.this.eList.size() > 0 && objectNumber < DDLSelectionDialog.this.eList.size()) {
                    DDLException ddlException = (DDLException)DDLSelectionDialog.this.eList.get(objectNumber);
                    DDLSelectionDialog.this.eList.remove(ddlException);
                    DDLSelectionDialog.this.getApplicationView().getDDLExceptionList().removeDDLException(ddlException);
                    DDLSelectionDialog.this.eTable.updateUI();
                }
            }
        });
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.add(btnProperties);
        toolBar.addSeparator();
        toolBar.add(bnAdd);
        toolBar.add(bnRemove);
        buttonGeneral.add(toolBar);
        JPanel columnsPanel = new JPanel(new BorderLayout());
        columnsPanel.add((Component)buttonGeneral, "North");
        columnsPanel.add(scrollpane);
        pnExceptions.add(columnsPanel);
        this.tabbedPane.add(Messages.getString("DDLSelectionDialog.OracleErrorsToMask"), pnExceptions);
    }

    @Override
    public GUIConfiguration getConfiguration() {
        return GUIConfiguration.getInstance();
    }

    private void setProperties() {
        Table table;
        Design.DROP_GENERATED_OBJECTS_ONLY = this.chbDropGenerated.isSelected();
        Design.USE_DROP_DEPENDENCY = this.chbUseDropDependency.isSelected();
        ModelIdObjectSelection root = (ModelIdObjectSelection)this.stdes.getRoot();
        root.applySelectionToObjects();
        for (Dropable drp : this.drpList) {
            Iterator dit = null;
            if (drp.collection instanceof ModelIDObjectSet) {
                dit = ((ModelIDObjectSet)drp.collection).iterator();
            } else if (drp.collection instanceof DesignObjectSet) {
                dit = ((DesignObjectSet)drp.collection).iterator();
            } else if (drp.collection instanceof RelationalObjectProxySet) {
                dit = ((RelationalObjectProxySet)drp.collection).iterator();
            }
            if (dit == null) continue;
            while (dit.hasNext()) {
                ModelIDObject mo = (ModelIDObject)dit.next();
                mo.setDropEnabled(drp.selected);
            }
        }
        for (InsertionObject obj : this.insertionList) {
            table = obj.getObject();
            table.setShouldGenerateScript(obj.isSelected);
        }
        for (InsertionObject obj : this.tableDDLScriptList) {
            table = obj.getObject();
            table.setUseDDLTransformationScript(obj.isSelected);
        }
    }

    public void refreshAllAfterDDLSelectionsLoading() {
        ModelIdObjectSelection root = (ModelIdObjectSelection)this.stdes.getRoot();
        DDLTreeNavigationDesign model = (DDLTreeNavigationDesign)this.tree.getModel();
        root.restoreSelectionToObjects(model);
        if (DDLSelectionDialog.getDDLSelectionPersistence().getSelectedSubViewChanged()) {
            this.tabbedPane.remove(this.selectionTabbedPane);
            this.initTreePanel();
            DDLSelectionDialog.getDDLSelectionPersistence().setSelectedSubViewChanged(false);
            this.tabbedPane.setSelectedIndex(0);
        }
        this.selectionTabbedPane.updateUI();
        this.tree.updateUI();
        this.chIncludeComments.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedIncludeCommentsSelection());
        this.chApplyNameSubstitution.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedApplyNamesSubstitutionSelection());
        this.chbDropGenerated.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedDropGeneratedObjectsOnly());
        this.chbUseDropDependency.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedUseDropDependencies());
        this.chGenerateDDLInFiles.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedGenerateDDLInFilesSelection());
        if (!(this.storageDesign instanceof StorageDesignOraclev10g)) {
            this.chGenerateRESTServices.setSelected(false);
        } else {
            this.chGenerateRESTServices.setSelected(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedGenerateRESTServicesSelection());
        }
        this.cbActive.setSelectedIndex(DDLSelectionDialog.getDDLSelectionPersistence().getPersistedActiveScriptSetCBIndex());
        this.insertionTable.updateUI();
        this.tbSubstitution.updateUI();
        this.tbObjectTypes.updateUI();
        this.tableDDLScriptList.clear();
        Iterator it = this.getRelationalDesign().getTableSet().iterator();
        while (it.hasNext()) {
            Table table = (Table)it.next();
            InsertionObject object = new InsertionObject(table, table.isUseDDLTransformationScript());
            this.tableDDLScriptList.add(object);
        }
        this.dropableList.updateUI();
    }

    public JPanel getOptionsPanel() {
        if (this.optionsPanel == null) {
            this.optionsPanel = new JPanel(new FlowLayout(0));
            this.optionsPanel.setBorder(BorderFactory.createEtchedBorder());
            this.bnDesRules = new JButton(Messages.getString("DDLSelectionDialog.DesignRules"));
            this.bnDesRules.setIcon(this.getConfiguration().getIcon("DESIGN_RULES_ICON", 16));
            this.bnDesRules.setMnemonic(82);
            this.bnDesRules.setPreferredSize(MessageDialogs.BUTTON_SIZE_180);
            this.bnDesRules.addActionListener(new DesignRulesAction());
            this.chIncludeComments = new JCheckBox(Messages.getString("DDLSelectionDialog.IncludeComments"));
            this.chIncludeComments.setSelected(false);
            this.cbDDLType = new JComboBox<Object>(DDLGenerationOptions.DDL_TYPES);
            this.cbDDLType.setEnabled(this.canSelect());
            this.cbDDLType.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    DDLSelectionDialog.this.tabbedPane.setEnabledAt(5, DDLSelectionDialog.this.cbDDLType.getSelectedIndex() > 0);
                    DDLGenerationOptions.setDDLType(DDLSelectionDialog.this.cbDDLType.getSelectedIndex());
                    DDLSelectionDialog.this.chGenerateDDLInFiles.setEnabled(DDLSelectionDialog.this.cbDDLType.getSelectedIndex() == 0);
                    if (DDLSelectionDialog.this.cbDDLType.getSelectedIndex() > 0) {
                        DDLSelectionDialog.this.chGenerateDDLInFiles.setSelected(false);
                    }
                }
            });
            this.chApplyNameSubstitution = new JCheckBox(Messages.getString("DDLSelectionDialog.ApplyNameSubstitution"));
            this.chApplyNameSubstitution.setSelected(false);
            this.chGenerateDDLInFiles = new JCheckBox(Messages.getString("DDLSelectionDialog.GenerateInFiles"));
            this.chGenerateRESTServices = new JCheckBox(Messages.getString("DDLSelectionDialog.GenerateRESTServices"));
            if (!(this.storageDesign instanceof StorageDesignOraclev10g)) {
                this.chGenerateRESTServices.setSelected(false);
                this.chGenerateRESTServices.setEnabled(false);
            }
            this.optionsPanel.add(this.bnDesRules);
            this.optionsPanel.add(this.chIncludeComments);
            this.optionsPanel.add(this.chApplyNameSubstitution);
            this.optionsPanel.add(this.cbDDLType);
            this.optionsPanel.add(this.chGenerateDDLInFiles);
            this.optionsPanel.add(this.chGenerateRESTServices);
        }
        return this.optionsPanel;
    }

    private boolean canSelect() {
        return this.storageDesign instanceof StorageDesignOracle;
    }

    public boolean is_chIncludeComments() {
        return this.chIncludeComments.isSelected();
    }

    public boolean is_chApplyNameSubstitution() {
        return this.chApplyNameSubstitution.isSelected();
    }

    public boolean is_chbDropGenerated() {
        return this.chbDropGenerated.isSelected();
    }

    public boolean is_chbUseDropDependency() {
        return this.chbUseDropDependency.isSelected();
    }

    private void cancelTableEditing(JTable jtable) {
        int icol = jtable.getEditingColumn();
        int irow = jtable.getEditingRow();
        if (icol > -1 && irow > -1) {
            jtable.getCellEditor(irow, icol).cancelCellEditing();
        }
    }

    private void stopTableEditing(JTable jtable) {
        int icol = jtable.getEditingColumn();
        int irow = jtable.getEditingRow();
        if (icol > -1 && irow > -1) {
            jtable.getCellEditor(irow, icol).stopCellEditing();
        }
    }

    private void showDesignRules() {
        ArrayList<DesignObject> objList = new ArrayList<DesignObject>();
        for (ModelIdObjectSelection obj : ((DDLSelectionLists)this.stdes.getRoot()).getTableList()) {
            if (obj.getObject() instanceof Table) {
                objList.add((DesignObject)obj.getObject());
                continue;
            }
            if (!(obj.getObject() instanceof TableProxy)) continue;
            objList.add(((TableProxy)obj.getObject()).getObject());
        }
        for (ModelIdObjectSelection obj : ((DDLSelectionLists)this.stdes.getRoot()).getViewList()) {
            if (obj.getObject() instanceof TableView) {
                objList.add((TableView)obj.getObject());
                continue;
            }
            if (!(obj.getObject() instanceof TableViewProxy)) continue;
            objList.add(((TableViewProxy)obj.getObject()).getObject());
        }
        DesignRuleView designRuleView = new DesignRuleView(this.getApplicationView(), this.storageDesign.getPhysicalDesign(), objList);
        designRuleView.getDialog((JDialog)this.getDialog()).setVisible(true);
    }

    protected int generateNumber() {
        int newNumber = 0;
        int lastNumber = this.eList.size();
        if (lastNumber != 0) {
            newNumber = this.counter = lastNumber + 1;
        } else {
            ++this.counter;
            newNumber = this.counter;
        }
        while (this.numberExists(newNumber)) {
            newNumber = ++this.counter;
        }
        return newNumber;
    }

    private boolean numberExists(int number) {
        for (int i = 0; i < this.eList.size(); ++i) {
            DDLException ddlException = (DDLException)this.eList.get(i);
            if (number != ddlException.getNumber()) continue;
            return true;
        }
        return false;
    }

    private JPanel createSubstitutionPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBackground(Color.WHITE);
        this.createSubstitutionDefaultsPanel(panel);
        return panel;
    }

    private void createSubstitutionDefaultsPanel(JPanel pnMain) {
        this.substitutionList = new ArrayList();
        for (SubstitutionPattern substPattern : this.settings.getSubstitutionList()) {
            SubstitutionPattern newSubstPattern = new SubstitutionPattern(substPattern.getSourceString(), substPattern.getReplacementString(), substPattern.isSelected(), substPattern.isCaseSensitive(), substPattern.getComments());
            this.substitutionList.add(newSubstPattern);
        }
        SubstitutionModel substitutionModel = new SubstitutionModel();
        this.tbSubstitution = new JTable(substitutionModel);
        this.tbSubstitution.setSelectionMode(0);
        JScrollPane scrollpane = new JScrollPane(this.tbSubstitution);
        JPanel buttonGeneral = new JPanel(new GridLayout(1, 2));
        buttonGeneral.setPreferredSize(new Dimension(325, 35));
        this.bnAddColumn = new JButton(this.configuration.getIcon("ADD_ICON", this.getPreferredIconSize()));
        this.bnAddColumn.setToolTipText(BTN_ADD);
        this.bnAddColumn.addActionListener(new AddSubstitutionAction());
        this.bnRemoveColumn = new JButton(this.configuration.getIcon("REMOVE_ICON", this.getPreferredIconSize()));
        this.bnRemoveColumn.setToolTipText(BTN_REMOVE);
        this.bnRemoveColumn.addActionListener(new RemoveSubstitutionAction());
        this.bnSelectAll = new JButton(this.configuration.getIcon("SELECT_ALL", this.getPreferredIconSize()));
        this.bnSelectAll.setToolTipText(Messages.getString("DDLSelectionDialog.SelectAll"));
        this.bnSelectAll.addActionListener(new SelectAllSubstitutionAction());
        this.bnDeselectAll = new JButton(this.configuration.getIcon("DESELECT_ALL", this.getPreferredIconSize()));
        this.bnDeselectAll.setToolTipText(Messages.getString("DDLSelectionDialog.DeselectAll"));
        this.bnDeselectAll.addActionListener(new DeselectAllSubstitutionAction());
        JToolBar toolBar = new JToolBar(0);
        toolBar.setFloatable(false);
        toolBar.addSeparator();
        toolBar.add(this.bnAddColumn);
        toolBar.add(this.bnRemoveColumn);
        toolBar.addSeparator();
        toolBar.add(this.bnSelectAll);
        toolBar.add(this.bnDeselectAll);
        buttonGeneral.add(toolBar);
        JPanel substPanel = new JPanel(new BorderLayout());
        substPanel.add((Component)buttonGeneral, "North");
        substPanel.setPreferredSize(new Dimension(410, 261));
        substPanel.add(scrollpane);
        pnMain.add(substPanel);
    }

    private int getPreferredIconSize() {
        return 16;
    }

    private void initObjectTab(JPanel panel, JTable table, List list) {
        DDLSelectionTabs tabObject;
        DDLSelectionTabs dDLSelectionTabs = tabObject = new DDLSelectionTabs(panel, table, list, this.getStorageDesign());
        dDLSelectionTabs.getClass();
        table.setModel(new DDLSelectionTabs.TableViewSchemaModel(dDLSelectionTabs, list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table, 1);
        this.setColumnWidth(table);
    }

    private void initContainerTab(JPanel panel, JTable table, List list) {
        DDLSelectionTabs tabObject;
        DDLSelectionTabs dDLSelectionTabs = tabObject = new DDLSelectionTabs(panel, table, list, this.getStorageDesign());
        dDLSelectionTabs.getClass();
        table.setModel(new DDLSelectionTabs.ConstraintModel(dDLSelectionTabs, list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table, 1);
        this.setColumnWidth(table);
    }

    private void initObjectModelTab(JPanel panel, JTable table, List list) {
        DDLSelectionTabs tabObject;
        DDLSelectionTabs dDLSelectionTabs = tabObject = new DDLSelectionTabs(panel, table, list, this.getStorageDesign());
        dDLSelectionTabs.getClass();
        table.setModel(new DDLSelectionTabs.ObjectModel(dDLSelectionTabs, list));
        table.setAutoCreateRowSorter(true);
        WindowsTableHeader.setSortedHeader(table, 1);
        this.setColumnWidth(table);
    }

    private void setColumnWidth(JTable table) {
        TableColumn tableColumn = table.getColumnModel().getColumn(0);
        tableColumn.setPreferredWidth(60);
        if (table.getColumnModel().getColumnCount() > 2) {
            tableColumn = table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(300);
            tableColumn = table.getColumnModel().getColumn(2);
            tableColumn.setPreferredWidth(300);
        } else {
            tableColumn = table.getColumnModel().getColumn(1);
            tableColumn.setPreferredWidth(600);
        }
    }

    private void newFilter(JTextField filterText, JTable currentTable, int column) {
        RowFilter rf = null;
        if (currentTable != null && currentTable.getRowCount() > 0) {
            if (!"".equals(filterText.getText())) {
                try {
                    rf = RowFilter.regexFilter("(?i)" + filterText.getText(), currentTable.convertColumnIndexToModel(column));
                }
                catch (PatternSyntaxException e) {
                    return;
                }
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(rf);
            } else {
                ((DefaultRowSorter)currentTable.getRowSorter()).setRowFilter(null);
                currentTable.clearSelection();
            }
        }
    }

    private void reloadSets() {
        this.currenActiveSet = null;
        this.getApplicationView().loadCustomDRScripts();
        this.cbActiveModel.removeAllElements();
        this.cbActiveModel.addElement(" ");
        this.cbActive.setSelectedItem(" ");
        for (DDLTransformationScriptSet set : this.getApplicationView().getDdlTransformationScriptSets()) {
            this.cbActiveModel.addElement(set);
            if (!set.isActive()) continue;
            this.cbActive.setSelectedItem(set);
            this.currenActiveSet = set;
        }
    }

    public RelationalDesign getRelationalDesign() {
        return this.storageDesign.getPhysicalDesign();
    }

    public StorageDesign getStorageDesign() {
        return this.storageDesign;
    }

    public static DDLSelectionPersistence getDDLSelectionPersistence() {
        if (ddlSelectionPersistence == null) {
            ddlSelectionPersistence = new DDLSelectionPersistence();
        }
        return ddlSelectionPersistence;
    }

    private class FilterObjectListener
    implements DocumentListener {
        JTextField objectsFilter;
        JTable objectsTable;
        int column;

        FilterObjectListener(JTextField objectsFilter, JTable objectsTable, int column) {
            this.objectsFilter = objectsFilter;
            this.objectsTable = objectsTable;
            this.column = column;
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            DDLSelectionDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            DDLSelectionDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            DDLSelectionDialog.this.newFilter(this.objectsFilter, this.objectsTable, this.column);
        }
    }

    private class DeselectAllTableScriptsAction
    implements ActionListener {
        private DeselectAllTableScriptsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (InsertionObject obj : DDLSelectionDialog.this.insertionList) {
                obj.setSelected(false);
            }
            DDLSelectionDialog.this.insertionTable.updateUI();
        }
    }

    private class SelectAllTableScriptsAction
    implements ActionListener {
        private SelectAllTableScriptsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (InsertionObject obj : DDLSelectionDialog.this.insertionList) {
                obj.setSelected(true);
            }
            DDLSelectionDialog.this.insertionTable.updateUI();
        }
    }

    private class DeselectAllDDLScriptsAction
    implements ActionListener {
        private DeselectAllDDLScriptsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (InsertionObject obj : DDLSelectionDialog.this.tableDDLScriptList) {
                obj.setSelected(false);
            }
            DDLSelectionDialog.this.tableDDLScriptTable.updateUI();
        }
    }

    private class SelectAllDDLScriptsAction
    implements ActionListener {
        private SelectAllDDLScriptsAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            for (InsertionObject obj : DDLSelectionDialog.this.tableDDLScriptList) {
                obj.setSelected(true);
            }
            DDLSelectionDialog.this.tableDDLScriptTable.updateUI();
        }
    }

    class InsertionObject {
        Table object;
        boolean isSelected = false;

        public InsertionObject(Table object, boolean selected) {
            this.isSelected = selected;
            this.object = object;
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.isSelected = isSelected;
        }

        public Table getObject() {
            return this.object;
        }

        public void setObject(Table object) {
            this.object = object;
        }
    }

    public class ObjectTypesModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.objectTypesList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionDialog.Type");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            StorageDesign.ObjectType objectType = (StorageDesign.ObjectType)DDLSelectionDialog.this.objectTypesList.get(row);
            if (col == 0) {
                return objectType.isSelected();
            }
            if (col == 1) {
                return objectType.getTypeName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            StorageDesign.ObjectType objectType = (StorageDesign.ObjectType)DDLSelectionDialog.this.objectTypesList.get(row);
            if (col == 0) {
                objectType.setSelected((Boolean)aValue);
            }
        }
    }

    private class DeselectAllSubstitutionAction
    implements ActionListener {
        private DeselectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DDLSelectionDialog.this.substitutionList) {
                substPattern.setSelected(false);
            }
            DDLSelectionDialog.this.tbSubstitution.updateUI();
        }
    }

    private class SelectAllSubstitutionAction
    implements ActionListener {
        private SelectAllSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            for (SubstitutionPattern substPattern : DDLSelectionDialog.this.substitutionList) {
                substPattern.setSelected(true);
            }
            DDLSelectionDialog.this.tbSubstitution.updateUI();
        }
    }

    private class RemoveSubstitutionAction
    implements ActionListener {
        private RemoveSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int objectNumber = DDLSelectionDialog.this.tbSubstitution.getSelectedRow();
            if (objectNumber != -1 && DDLSelectionDialog.this.substitutionList.size() > 0 && objectNumber < DDLSelectionDialog.this.substitutionList.size()) {
                SubstitutionPattern substPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(objectNumber);
                DDLSelectionDialog.this.substitutionList.remove(substPattern);
                DDLSelectionDialog.this.tbSubstitution.updateUI();
            }
        }
    }

    private class AddSubstitutionAction
    implements ActionListener {
        private AddSubstitutionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            SubstitutionPattern substPattern = new SubstitutionPattern();
            DDLSelectionDialog.this.substitutionList.add(substPattern);
            int rows = DDLSelectionDialog.this.tbSubstitution.getRowCount() - 1;
            DDLSelectionDialog.this.tbSubstitution.changeSelection(rows, 0, false, false);
            DDLSelectionDialog.this.tbSubstitution.updateUI();
        }
    }

    public class TableDDLScriptModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLGenerationOptions.InsertScripts");
            }
            if (column == 1) {
                return Messages.getString("DDLGenerationOptions.Name");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.tableDDLScriptList.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InsertionObject obj = (InsertionObject)DDLSelectionDialog.this.tableDDLScriptList.get(row);
            if (col == 0) {
                return obj.isSelected;
            }
            if (col == 1) {
                return obj.getObject().getLongName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            InsertionObject obj = (InsertionObject)DDLSelectionDialog.this.tableDDLScriptList.get(row);
            if (col == 0) {
                obj.setSelected((Boolean)aValue);
            }
        }
    }

    public class InsertionModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionDialog.InsertScripts");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionDialog.Name");
            }
            return "";
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.insertionList.size();
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            InsertionObject obj = (InsertionObject)DDLSelectionDialog.this.insertionList.get(row);
            if (col == 0) {
                return obj.isSelected;
            }
            if (col == 1) {
                return obj.getObject().getLongName();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            InsertionObject obj = (InsertionObject)DDLSelectionDialog.this.insertionList.get(row);
            if (col == 0) {
                obj.setSelected((Boolean)aValue);
            }
        }
    }

    public class SubstitutionModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 5;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.substitutionList.size();
        }

        public List getSubstitutionList() {
            return DDLSelectionDialog.this.substitutionList;
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionDialog.CaseSensitive");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionDialog.Old");
            }
            if (column == 3) {
                return Messages.getString("DDLSelectionDialog.New");
            }
            if (column == 4) {
                return Messages.getString("DDLSelectionDialog.Comments");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return true;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(row);
            if (col == 0) {
                return substPattern.isSelected();
            }
            if (col == 1) {
                return substPattern.isCaseSensitive();
            }
            if (col == 2) {
                return substPattern.getSourceString();
            }
            if (col == 3) {
                return substPattern.getReplacementString();
            }
            if (col == 4) {
                return substPattern.getComments();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            SubstitutionPattern substPattern = (SubstitutionPattern)DDLSelectionDialog.this.substitutionList.get(row);
            if (col == 0) {
                substPattern.setSelected((Boolean)aValue);
            } else if (col == 1) {
                substPattern.setCaseSensitive((Boolean)aValue);
            } else if (col == 2) {
                substPattern.setSourceString(this.checkValue((String)aValue, true));
            } else if (col == 3) {
                substPattern.setReplacementString(this.checkValue((String)aValue, false));
            } else if (col == 4) {
                substPattern.setComments((String)aValue);
            }
        }

        private String checkValue(String value, boolean isSource) {
            return value;
        }
    }

    public class Dropable {
        public boolean selected = false;
        public ModelObject collection;

        Dropable(ModelObject set) {
            this.collection = set;
        }

        public String toString() {
            if (this.collection != null) {
                return this.collection.getName();
            }
            return "";
        }
    }

    class CBCellRenderer
    extends JCheckBox
    implements ListCellRenderer {
        CBCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String s = value.toString();
            this.setText(s);
            Dropable drp = (Dropable)value;
            this.setSelected(drp.selected);
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setBackground(list.getBackground());
            this.setForeground(list.getForeground());
            this.setOpaque(true);
            return this;
        }
    }

    private class DesignRulesAction
    implements ActionListener {
        private DesignRulesAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DDLSelectionDialog.this.showDesignRules();
        }
    }

    private class CancelAction
    implements ActionListener {
        private CancelAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            ((ModelIdObjectSelection)DDLSelectionDialog.this.stdes.getRoot()).restoreOldSelectionToObjects();
            DDLSelectionDialog.this.cancelTableEditing(DDLSelectionDialog.this.tbSubstitution);
            DDLSelectionDialog.this.cancelTableEditing(DDLSelectionDialog.this.insertionTable);
            if (DDLSelectionDialog.this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions()) {
                DDLSelectionDialog.getDDLSelectionPersistence().setSaveSelectionsBLPS(DDLSelectionDialog.this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions());
                DDLSelectionDialog.getDDLSelectionPersistence().setDDLGenerated(true);
            }
            DDLSelectionDialog.this.close();
        }
    }

    public class restoreSelectionAction
    implements ActionListener {
        @Override
        public void actionPerformed(ActionEvent e) {
            if (!DDLSelectionDialog.this.storageDesign.getDesign().isOldRepositoryType() && DDLSelectionDialog.getDDLSelectionPersistence().restoreDDLSelectionForDesign(DDLSelectionDialog.this.storageDesign.getDesign(), DDLSelectionDialog.this.fileMakerEditor, DDLSelectionDialog.this.insertionTable, DDLSelectionDialog.this.tbSubstitution, DDLSelectionDialog.this.tbObjectTypes, DDLSelectionDialog.this.dropableList)) {
                DDLSelectionDialog.getDDLSelectionPersistence().setDDLSelectionLoaded(true);
                DDLSelectionDialog.this.refreshAllAfterDDLSelectionsLoading();
            }
        }
    }

    private class saveSelectionAction
    implements ActionListener {
        private saveSelectionAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.tbSubstitution);
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.insertionTable);
            DDLSelectionDialog.this.setProperties();
            if (!DDLSelectionDialog.this.storageDesign.getDesign().isOldRepositoryType()) {
                DDLSelectionDialog.getDDLSelectionPersistence().saveDDLSelectionForDesign(DDLSelectionDialog.this.storageDesign.getDesign(), DDLSelectionDialog.this.chIncludeComments.isSelected(), DDLSelectionDialog.this.chApplyNameSubstitution.isSelected(), DDLSelectionDialog.this.chbDropGenerated.isSelected(), DDLSelectionDialog.this.chbUseDropDependency.isSelected(), DDLSelectionDialog.this.insertionTable, DDLSelectionDialog.this.tbSubstitution, DDLSelectionDialog.this.tbObjectTypes, DDLSelectionDialog.this.dropableList, DDLSelectionDialog.this.chGenerateDDLInFiles.isSelected(), DDLSelectionDialog.this.chGenerateRESTServices.isSelected(), DDLSelectionDialog.this.fileMakerEditor, DDLSelectionDialog.this.cbActive.getSelectedIndex());
            }
        }
    }

    private class OKAction
    implements ActionListener {
        private OKAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.tbSubstitution);
            DDLSelectionDialog.this.stopTableEditing(DDLSelectionDialog.this.insertionTable);
            DDLSelectionDialog.this.setProperties();
            DDLGenerationOptions.setIncludeComments(DDLSelectionDialog.this.chIncludeComments.isSelected());
            DDLGenerationOptions.setDDLType(DDLSelectionDialog.this.cbDDLType.getSelectedIndex());
            DDLGenerationOptions.setGenerateDDLInFiles(DDLSelectionDialog.this.chGenerateDDLInFiles.isSelected() && DDLSelectionDialog.this.cbDDLType.getSelectedIndex() == 0);
            DDLGenerationOptions.setGenerateRESTServices(DDLSelectionDialog.this.chGenerateRESTServices.isSelected());
            DDLSelectionDialog.this.settings.getSubstitutionList().clear();
            DDLSelectionDialog.this.settings.getSubstitutionList().addAll(DDLSelectionDialog.this.substitutionList);
            Object obj = DDLSelectionDialog.this.cbActive.getSelectedItem();
            if (obj != DDLSelectionDialog.this.currenActiveSet) {
                for (DDLTransformationScriptSet set : DDLSelectionDialog.this.getApplicationView().getDdlTransformationScriptSets()) {
                    set.setActive(false);
                }
                if (DDLSelectionDialog.this.cbActive.getSelectedItem() != null && DDLSelectionDialog.this.cbActive.getSelectedItem() instanceof DDLTransformationScriptSet) {
                    DDLTransformationScriptSet set;
                    set = (DDLTransformationScriptSet)DDLSelectionDialog.this.cbActive.getSelectedItem();
                    set.setActive(true);
                }
                DDLSelectionDialog.this.getApplicationView().saveCustomDRScripts();
            }
            DDLSelectionDialog.this.getRelationalDesign().getDesign().setApplyNameSubstitution(DDLSelectionDialog.this.chApplyNameSubstitution.isSelected());
            Thread thread = new Thread(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    DDLSelectionDialog.this.setCursor(Cursor.getPredefinedCursor(3));
                    try {
                        try {
                            ProgressDialog monitor = new ProgressDialog(DDLSelectionDialog.this.getApplicationView(), "", 0, 100);
                            monitor.setParentComponent(DDLSelectionDialog.this.owner);
                            try {
                                DDLSelectionDialog.this.fileMakerEditor.getEditor().setText("");
                                DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().generateDDLContent(monitor);
                                DDLSelectionDialog.this.fileMakerEditor.getScrollPane().setVisible(false);
                                BasicEditorPane editor = DDLSelectionDialog.this.fileMakerEditor.getEditor();
                                try {
                                    editor.getDocument().insertString(0, DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().getContent(), null);
                                }
                                catch (BadLocationException e) {
                                    LOGGER.error("DDLSelectionDialog.OKAction", e);
                                }
                                DDLSelectionDialog.this.fileMakerEditor.getScrollPane().setVisible(true);
                            }
                            finally {
                                monitor.close();
                                DDLSelectionDialog.this.fileMakerEditor.getDDLFileMaker().checkErrors(DDLSelectionDialog.this.fileMakerEditor);
                            }
                        }
                        finally {
                            DDLSelectionDialog.this.setCursor(Cursor.getPredefinedCursor(0));
                            DDLSelectionDialog.this.getRelationalDesign().getDesign().setApplyNameSubstitution(false);
                            if (DDLSelectionDialog.this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions()) {
                                ((DDLSelectionDialog)DDLSelectionDialog.this).fileMakerEditor.storageDesign = DDLSelectionDialog.this.storageDesign;
                                DDLSelectionDialog.getDDLSelectionPersistence().setSaveSelectionsBLPS(DDLSelectionDialog.this.storageDesign.getDesign().getDesignLevelSettings().isPreserveDDLGenerationOptions());
                                DDLSelectionDialog.getDDLSelectionPersistence().setDDLGenerated(true);
                            }
                        }
                    }
                    catch (Throwable error) {
                        LOGGER.error("DDLSelectionDialog.OKAction", error);
                    }
                }
            };
            thread.start();
            DDLSelectionDialog.this.close();
        }
    }

    public class DDLExceptionsModel
    extends AbstractTableModel {
        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return DDLSelectionDialog.this.eList.size();
        }

        @Override
        public String getColumnName(int column) {
            if (column == 0) {
                return Messages.getString("DDLSelectionDialog.Selected");
            }
            if (column == 1) {
                return Messages.getString("DDLSelectionDialog.Type");
            }
            if (column == 2) {
                return Messages.getString("DDLSelectionDialog.Description");
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public Object getValueAt(int row, int col) {
            DDLException ddlException = (DDLException)DDLSelectionDialog.this.eList.get(row);
            if (col == 0) {
                return ddlException.isSelected();
            }
            if (col == 1) {
                return String.valueOf(ddlException.getNumber());
            }
            if (col == 2) {
                return ddlException.getDescription();
            }
            return new Integer(row * col);
        }

        @Override
        public void setValueAt(Object aValue, int row, int col) {
            DDLException ddlException = (DDLException)DDLSelectionDialog.this.eList.get(row);
            if (col == 0) {
                ddlException.setSelected((Boolean)aValue);
            }
        }
    }
}

