/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl.models;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ModelIdObjectSelection;
import oracle.dbtools.crest.model.SubViewObjectSet;
import oracle.dbtools.crest.model.design.DesignObjectCollection;
import oracle.dbtools.crest.model.design.KeyObject;
import oracle.dbtools.crest.model.design.relational.Column;
import oracle.dbtools.crest.model.design.relational.FKIndexAssociation;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.storage.RelationalObjectProxy;
import oracle.dbtools.crest.model.design.storage.StorageObject;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.NavigationTreeRenderer;
import oracle.dbtools.crest.util.gui.swing.JSelectableLabel;

public class DDLNavigationTreeRenderer
implements TreeCellRenderer {
    private JSelectableLabel component = new JSelectableLabel();
    private JPanel panel = new JPanel(new BorderLayout());
    protected JCheckBox cbox = new JCheckBox();
    private static Map icons = NavigationTreeRenderer.icons;
    private static Icon defaultIcon;
    private static Icon openIcon;
    static GUIConfiguration conf;
    static int iconSize;
    private static final String COLUMNFK = "ColumnFK.class";
    protected ModelIdObjectSelection node;

    public DDLNavigationTreeRenderer() {
        this.panel.setLayout(new BorderLayout());
        this.cbox.setMargin(new Insets(0, 0, 0, 0));
        this.cbox.setBorderPaintedFlat(true);
        this.cbox.setOpaque(false);
        this.panel.add((Component)this.cbox, "West");
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String text = "";
        this.node = (ModelIdObjectSelection)value;
        ModelIDObject object = this.node.getObject();
        text = object instanceof KeyObject && ((KeyObject)object).isPK() ? "(PK) " + this.node.getName() : this.node.getName();
        if (!tree.isSelectionEmpty()) {
            tree.clearSelection();
        }
        this.panel.setOpaque(false);
        this.cbox.setOpaque(false);
        if (object instanceof RelationalObjectProxy) {
            object = ((RelationalObjectProxy)object).getObject();
        }
        this.component.setText(text);
        this.component.setSelected(selected);
        this.component.setHasFocus(hasFocus);
        ImageIcon icon = null;
        if (object instanceof Index) {
            icon = (ImageIcon)icons.get(object.getClass());
            if (((Index)object).isFK()) {
                icon = (ImageIcon)icons.get(FKIndexAssociation.class);
            }
        } else if (object instanceof Column) {
            if (((Column)object).isFKColumn()) {
                icon = (ImageIcon)icons.get(COLUMNFK);
            } else if (object != null) {
                icon = (ImageIcon)icons.get(object.getClass());
            }
        } else if (object instanceof TopView) {
            icon = (ImageIcon)icons.get(((TopView)((Object)object)).getModel().getClass());
        } else if (object instanceof SubViewObjectSet) {
            icon = (ImageIcon)icons.get(((SubViewObjectSet)((Object)object)).getElementDescriptor());
        } else if (object instanceof DesignObjectCollection) {
            icon = (ImageIcon)icons.get(((DesignObjectCollection)((Object)object)).getElementDescriptor());
        } else if (object != null) {
            icon = (ImageIcon)icons.get(object.getClass());
        }
        if (icon == null) {
            icon = (ImageIcon)icons.get(this.node.getElementDescriptor());
        }
        if (icon != null) {
            this.component.setIcon(icon);
        } else if (object instanceof StorageObject) {
            this.component.setIcon(conf.getIcon("STORAGE_OBJECT_ICON", iconSize));
        } else if (expanded) {
            this.component.setIcon(openIcon);
        } else {
            this.component.setIcon(defaultIcon);
        }
        if (value instanceof ModelIdObjectSelection) {
            ModelIdObjectSelection obj = (ModelIdObjectSelection)value;
            this.panel.remove(this.component);
            this.cbox.setSelected(obj.isSelected());
            this.panel.add((Component)this.component, "Center");
            return this.panel;
        }
        this.panel.remove(this.component);
        return this.component;
    }

    static {
        conf = GUIConfiguration.getInstance();
        iconSize = 16;
        defaultIcon = conf.getIcon("BROWSER_CLOSED_ICON", iconSize);
        openIcon = conf.getIcon("BROWSER_OPEN_ICON", iconSize);
    }
}

