/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.ddl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import oracle.dbtools.crest.exports.csv.CSVExporter;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.parser.LexerToken;
import oracle.dbtools.parser.plsql.StackParser;
import oracle.dbtools.raptor.plsql.BackgroundParser;
import oracle.dbtools.raptor.plsql.ParserEventListener;
import oracle.ide.db.model.BaseDBObjectTextNode;
import oracle.ide.db.model.DBObjectNodeUtil;
import oracle.ideimpl.db.model.SQLDevParserHelper;
import oracle.javatools.db.CancelledException;
import oracle.javatools.editor.BasicEditorPane;

public class BackgroundParserDM
extends BackgroundParser {
    private static final Logger LOGGER = new Logger(CSVExporter.class);
    private String ERROR_TEXT = "Error retrieving parrent class listeners: ";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse() {
        this.increments = new ArrayList();
        long t1 = System.currentTimeMillis();
        if (this.text == null) {
            return;
        }
        if (this.editor != null) {
            List newSrc;
            BaseDBObjectTextNode node = DBObjectNodeUtil.getNodeFromEditorPane((BasicEditorPane)this.editor);
            if (node != null) {
                try {
                    newSrc = SQLDevParserHelper.getTokens((BaseDBObjectTextNode)node);
                    this.output = SQLDevParserHelper.getParseTreeRoot((BaseDBObjectTextNode)node);
                    this.src = newSrc;
                }
                catch (CancelledException e) {
                    LOGGER.error("Error parsing ddl text: ", e);
                }
            } else {
                newSrc = LexerToken.parse((String)this.text);
                this.output = StackParser.getInstance().parse(newSrc);
                this.src = newSrc;
            }
        } else {
            this.src = LexerToken.parse((String)this.text);
            this.output = StackParser.getInstance().parse(this.src);
        }
        LinkedList<ParserEventListener> copy = new LinkedList<ParserEventListener>();
        List<ParserEventListener> listenersDM = this.getListeners();
        List<ParserEventListener> list = listenersDM;
        synchronized (list) {
            for (ParserEventListener l : listenersDM) {
                copy.add(l);
            }
        }
        for (ParserEventListener l : copy) {
            try {
                if (0 < this.increments.size()) {
                    return;
                }
                l.stateChanged((BackgroundParser)this);
            }
            catch (Throwable e) {
                e.fillInStackTrace();
            }
        }
    }

    private List<ParserEventListener> getListeners() {
        Field field = null;
        try {
            field = BackgroundParser.class.getDeclaredField("listeners");
        }
        catch (NoSuchFieldException e) {
            LOGGER.error(this.ERROR_TEXT, e);
        }
        catch (SecurityException e) {
            LOGGER.error(this.ERROR_TEXT, e);
        }
        if (field != null) {
            field.setAccessible(true);
            Object value = null;
            try {
                value = field.get((Object)this);
            }
            catch (IllegalArgumentException e) {
                LOGGER.error(this.ERROR_TEXT, e);
            }
            catch (IllegalAccessException e) {
                LOGGER.error(this.ERROR_TEXT, e);
            }
            field.setAccessible(false);
            return (List)value;
        }
        return null;
    }
}

