/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.datatypes;

import java.awt.Color;
import java.util.Map;
import oracle.dbtools.crest.model.design.datatypes.DTReference;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.datatypes.AbstractDTTV;
import oracle.dbtools.crest.swingui.datatypes.TVDTRelation;
import oracle.dbtools.crest.swingui.diagram.datatypes.DTDiagramCell;
import oracle.dbtools.crest.swingui.diagram.datatypes.ReferenceEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DefaultEdge;
import oracle.dbtools.crest.swingui.diagram.graph.DiagramConstants;
import oracle.dbtools.crest.swingui.diagram.graph.EdgeView;

public class TVDTReference
extends TVDTRelation {
    public TVDTReference(ApplicationView appView, DesignPartView dpv) {
        super(appView, dpv);
    }

    @Override
    public Color getColor() {
        return Color.BLUE;
    }

    @Override
    public DefaultEdge addConnection() {
        AbstractDTTV sourceTV = this.getDTRelation().getSourceTV(this.getDesignPartView());
        AbstractDTTV targetTV = this.getDTRelation().getTargetTV(this.getDesignPartView());
        if (this.edge == null && sourceTV.getCellView() != null && targetTV.getCellView() != null) {
            DTDiagramCell source = (DTDiagramCell)sourceTV.getCellView().getCell();
            DTDiagramCell target = (DTDiagramCell)targetTV.getCellView().getCell();
            this.edge = this.getDesignPartView().getWorkSpace().addConnection(source, target, this.getColor(), this.getDTRelation());
            this.edge.setTopView(this);
            this.setCellView(this.edge.getCellView());
            if (!ApplicationView.loading && source != target) {
                this.edge.straightLine();
            }
        }
        if (this.edge != null) {
            this.displayLabels();
            this.resetEdgeParams((ReferenceEdge)this.edge, true);
        }
        return this.edge;
    }

    @Override
    public void resetEdgeParams() {
        if (this.edge != null) {
            this.resetEdgeParams((ReferenceEdge)this.edge, true);
        }
    }

    @Override
    public void displayLabels() {
        if (this.edge != null && this.edge instanceof ReferenceEdge) {
            DTReference dtReference = (DTReference)this.getModel();
            int desc = dtReference.getTypeElement().getDatatypeDescriptor();
            if (this.edge != null && this.edge.getTopView() != null) {
                String lab = ((ReferenceEdge)this.edge).getSourceLabel();
                if (desc == 4 || desc == 3) {
                    this.displayLabel(lab, this.getLabelBounds(), 0);
                    this.getEdgeView().refreshLabels();
                } else {
                    this.removeLabel(0);
                }
            }
        } else {
            this.removeLabel(0);
        }
    }

    private void resetEdgeParams(ReferenceEdge edge, boolean repaint) {
        Map edgeAttributes = edge.getAttributes();
        DTReference dtReference = (DTReference)this.getModel();
        int desc = dtReference.getTypeElement().getDatatypeDescriptor();
        if (desc == 1) {
            DiagramConstants.setLineBegin(edgeAttributes, 1);
            DiagramConstants.setLineEnd(edgeAttributes, 9);
            DiagramConstants.setEndFill(edgeAttributes, false);
            edge.setHasSourceLabel(false);
        } else if (desc == 2) {
            DiagramConstants.setLineBegin(edgeAttributes, 0);
            DiagramConstants.setLineEnd(edgeAttributes, 9);
            DiagramConstants.setEndFill(edgeAttributes, true);
            edge.setHasSourceLabel(false);
        } else if (desc == 4) {
            DiagramConstants.setLineBegin(edgeAttributes, 0);
            DiagramConstants.setLineEnd(edgeAttributes, 9);
            DiagramConstants.setEndFill(edgeAttributes, true);
            edge.setHasSourceLabel(true);
        } else if (desc == 3) {
            DiagramConstants.setLineBegin(edgeAttributes, 1);
            DiagramConstants.setLineEnd(edgeAttributes, 9);
            DiagramConstants.setEndFill(edgeAttributes, false);
            edge.setHasSourceLabel(true);
        }
        DiagramConstants.setEndSize(edgeAttributes, 10);
        DiagramConstants.setBeginSize(edgeAttributes, 8);
        edge.setAttributes(edgeAttributes);
        EdgeView cv = (EdgeView)edge.getDiagram().getDiagramLayoutCache().getMapping(edge, false);
        if (cv != null) {
            cv.update();
            if (repaint) {
                cv.getDiagram().repaint();
            }
        }
    }

    @Override
    public DefaultEdge getEdge() {
        return this.edge;
    }

    public float getAttractionTo(TopView topView) {
        return 0.0f;
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Datatype Reference").getColor();
    }

    @Override
    public int getDefaultLineWidth() {
        return this.getDesign().getDesignLevelSettings().getDefaultLWCObject("Datatype Reference").getWidth();
    }
}

