/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui.admin.masktemplates;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dbtools.crest.model.MaskTemplate;
import oracle.dbtools.crest.model.MaskTemplateSet;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.admin.Messages;
import oracle.dbtools.crest.util.CustomDialog;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.gui.swing.CommonUtil;
import oracle.dbtools.crest.util.gui.swing.JIntegerField;
import oracle.dbtools.crest.util.gui.swing.SortedJListModel;
import oracle.dbtools.crest.util.options.Settings;
import oracle.ide.Ide;

public class MaskTemplatesAdmin
extends CustomDialog {
    private static final String EMPTY_VALUE = "";
    private static final String APPLY_TXT = Messages.getString("MaskTemplatesAdmin.Apply");
    private static final String MODIFY_TXT = Messages.getString("MaskTemplatesAdmin.Modify");
    public static final String FUNCTION_TYPE_PARTIAL = "PARTIAL";
    public static final String FUNCTION_TYPE_REGEXP = "REGEXP";
    public static final String[] FUNCTION_TYPES = new String[]{"PARTIAL", "REGEXP"};
    public static final String DATATYPE_CHARACTER = "Character";
    public static final String DATATYPE_NUMERIC = "Numeric";
    public static final String DATATYPE_DATE = "Date";
    public static final String[] DATATYPES = new String[]{"Character", "Numeric", "Date"};
    private static final Dimension DEFAULT_SIZE = new Dimension(200, 20);
    private JDialog dialog;
    private JPanel general;
    private JPanel addPanel;
    private JPanel listPanel;
    private JPanel buttonPanel;
    private boolean isSaved = true;
    private JButton btnAdd;
    private JButton btnRemove;
    private JButton btnApply;
    private JButton btnSave;
    private JButton btnClose;
    private JPanel pnProps;
    private JPanel buttonsPanel;
    private JPanel propSubPanel1;
    private JPanel propSubPanel5;
    private JPanel pnDatatype;
    private JPanel pnRegExp;
    private JPanel pnDTCharacter;
    private JPanel pnDTNumeric;
    private JPanel pnDTDate;
    private List lsDeleted = new ArrayList();
    private List lsAdded = new ArrayList();
    private List allSelected = new ArrayList();
    private boolean applyMode;
    private JTextField tfName;
    private JComboBox cbFunctionType;
    private JComboBox cbDatatype;
    private DefaultListModel allMTModel;
    private SortedJListModel sortedAllMTModel;
    private JList allMTList;
    private MaskTemplate lastSelectedMaskTemplate;
    private JTextField tfInputFormat;
    private JTextField tfOutputFormat;
    private JTextField tfMaskChar;
    private JTextField tfMonth;
    private JTextField tfDay;
    private JTextField tfYear;
    private JTextField tfHour;
    private JTextField tfMinute;
    private JTextField tfSecond;
    private JLabel lbInputFormat;
    private JLabel lbOutputFormat;
    private JLabel lbMaskChar;
    private JLabel lbMaskFrom;
    private JLabel lbMaskTo;
    private JIntegerField ifMaskFrom;
    private JIntegerField ifMaskTo;
    private JTextField tfPattern;
    private JTextField tfReplaceString;
    private JTextField tfMatchParameter;
    private JIntegerField ifPosition;
    private JIntegerField ifOccurrence;

    public MaskTemplatesAdmin(ApplicationView appView) {
        super(appView);
    }

    @Override
    protected Window getDialog() {
        if (this.dialog == null) {
            this.dialog = new JDialog(this.getApplicationView().getFrame(), Messages.getString("MaskTemplatesAdmin.MaskTemplatesAdministration"), true);
            this.dialog.setDefaultCloseOperation(0);
            this.general = new JPanel();
            this.general.setLayout(new BorderLayout());
            this.general.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            this.dialog.getContentPane().add(this.general);
            this.addPanel = new JPanel(new BorderLayout());
            this.addPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaskTemplatesAdmin.SelectMaskTemplate")));
            this.pnProps = new JPanel(new BorderLayout());
            this.pnProps.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaskTemplatesAdmin.MaskTemplateProperties")));
            this.buttonPanel = this.getButtonPanel();
            this.initAddPanel();
            this.initPropPanel();
            this.general.add((Component)this.addPanel, "West");
            this.general.add((Component)this.pnProps, "Center");
            this.general.add((Component)this.buttonPanel, "South");
            this.setDefaultActions(this.dialog);
            this.clear();
            this.dialog.pack();
            this.refreshList();
            this.enableButtons(true);
            this.dialog.setResizable(true);
            this.dialog.addComponentListener(new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    int w = MaskTemplatesAdmin.this.dialog.getWidth();
                    int h = MaskTemplatesAdmin.this.dialog.getHeight();
                    w = Math.max(840, w);
                    h = Math.max(500, h);
                    MaskTemplatesAdmin.this.dialog.setSize(w, h);
                }
            });
            Settings.DialogSettings ds = this.getApplicationView().getSettings().getDialogSettings(this.getClass().getName());
            if (ds == null) {
                int w = 840;
                int h = 500;
                this.dialog.setSize(w, h);
                CommonUtil.centerOnScreen(this.dialog);
            } else {
                int w = Math.max(840, (int)ds.rec.getSize().getWidth());
                int h = Math.max(500, (int)ds.rec.getSize().getHeight());
                this.dialog.setSize(w, h);
                this.dialog.setLocation(ds.rec.getLocation());
            }
        }
        return this.dialog;
    }

    @Override
    protected boolean canClose() {
        if (!this.isSaved) {
            String s1 = Messages.getString("MaskTemplatesAdmin.Yes");
            String s2 = Messages.getString("MaskTemplatesAdmin.No");
            Object[] options = new Object[]{s1, s2};
            int n = JOptionPane.showOptionDialog(this.dialog, Messages.getString("MaskTemplatesAdmin.MaskTemplatesNotSaved"), Messages.getString("MaskTemplatesAdmin.QuitConfirmation"), 0, 3, null, options, s1);
            return n == 0;
        }
        return true;
    }

    protected void enableButtons(boolean b) {
        this.btnAdd.setEnabled(b);
        this.btnRemove.setEnabled(b);
        this.btnApply.setEnabled(b);
    }

    private void initAddPanel() {
        this.buttonsPanel = new JPanel();
        this.buttonsPanel.setAlignmentX(0.5f);
        this.listPanel = new JPanel(new BorderLayout());
        this.listPanel.setBorder(BorderFactory.createTitledBorder(Messages.getString("MaskTemplatesAdmin.AvailableMaskTemplates")));
        this.listPanel.setAlignmentX(0.5f);
        this.addPanel.add((Component)this.buttonsPanel, "South");
        this.addPanel.add(this.listPanel);
        this.initMTButtons();
        this.initMaskTemplates();
    }

    protected void initMTButtons() {
        this.btnAdd = new JButton(Messages.getString("MaskTemplatesAdmin.Add"));
        this.btnAdd.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskTemplate maskTemplate = MaskTemplatesAdmin.this.addMaskTemplate();
                MaskTemplatesAdmin.this.allMTModel.addElement(maskTemplate);
                MaskTemplatesAdmin.this.allMTList.setSelectedIndex(MaskTemplatesAdmin.this.sortedAllMTModel.toSortedModelIndex(MaskTemplatesAdmin.this.allMTModel.indexOf(maskTemplate)));
                MaskTemplatesAdmin.this.editableAll(true);
            }
        });
        this.btnAdd.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnAdd.setMnemonic(65);
        this.btnAdd.setEnabled(false);
        this.btnRemove = new JButton(Messages.getString("MaskTemplatesAdmin.Remove"));
        this.btnRemove.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskTemplate maskTemplate;
                int i;
                MaskTemplatesAdmin.this.allSelected.clear();
                boolean deleted = false;
                int[] selected = MaskTemplatesAdmin.this.allMTList.getSelectedIndices();
                for (i = 0; i < selected.length; ++i) {
                    maskTemplate = (MaskTemplate)MaskTemplatesAdmin.this.allMTList.getModel().getElementAt(selected[i]);
                    MaskTemplatesAdmin.this.allSelected.add(maskTemplate);
                }
                for (i = 0; i < selected.length; ++i) {
                    maskTemplate = (MaskTemplate)MaskTemplatesAdmin.this.allMTList.getModel().getElementAt(selected[i]);
                    MaskTemplateSet maskTemplateSet = MaskTemplatesAdmin.this.getApplicationView().getMaskTemplateSet();
                    if (maskTemplateSet.contains(maskTemplate)) {
                        maskTemplateSet.remove(maskTemplate);
                        MaskTemplatesAdmin.this.lsDeleted.add(maskTemplate);
                    }
                    deleted = true;
                }
                if (deleted) {
                    MaskTemplatesAdmin.this.btnSave.setEnabled(true);
                    MaskTemplatesAdmin.this.isSaved = false;
                    MaskTemplatesAdmin.this.refreshList();
                    MaskTemplatesAdmin.this.clear();
                    MaskTemplatesAdmin.this.editableAll(false);
                }
            }
        });
        this.btnRemove.setMnemonic(82);
        this.btnRemove.setPreferredSize(this.btnAdd.getPreferredSize());
        this.btnApply = new JButton(APPLY_TXT);
        this.btnApply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskTemplatesAdmin.this.applyButtonClicked();
            }
        });
        this.btnApply.setPreferredSize(MessageDialogs.BUTTON_SIZE);
        this.btnApply.setMnemonic(77);
        this.buttonsPanel.add(this.btnAdd);
        this.buttonsPanel.add(this.btnRemove);
        this.buttonsPanel.add(this.btnApply);
    }

    private void initMaskTemplates() {
        this.lsDeleted.clear();
        this.lsAdded.clear();
        this.allMTModel = new DefaultListModel();
        this.sortedAllMTModel = new SortedJListModel(this.allMTModel);
        this.allMTList = new JList(this.sortedAllMTModel);
        this.allMTList.setSelectionMode(2);
        this.allMTList.setCellRenderer(new MaskTemplateCellRenderer());
        this.allMTList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (MaskTemplatesAdmin.this.lastSelectedMaskTemplate != null && MaskTemplatesAdmin.this.applyMode) {
                    int choice = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), Messages.getString("MaskTemplatesAdmin.ModifiedMaskTemplateMessage"), Messages.getString("MaskTemplatesAdmin.ModifiedMaskTemplate"), 0);
                    if (choice == 0) {
                        MaskTemplatesAdmin.this.applyButtonClicked();
                    }
                    MaskTemplatesAdmin.this.applyMode = false;
                }
                MaskTemplatesAdmin.this.lastSelectedMaskTemplate = (MaskTemplate)MaskTemplatesAdmin.this.allMTList.getSelectedValue();
                if (MaskTemplatesAdmin.this.lastSelectedMaskTemplate != null) {
                    MaskTemplatesAdmin.this.clear();
                    MaskTemplatesAdmin.this.initCurrentProperties(MaskTemplatesAdmin.this.lastSelectedMaskTemplate);
                    MaskTemplatesAdmin.this.editableAll(false);
                    MaskTemplatesAdmin.this.btnRemove.setEnabled(true);
                    MaskTemplatesAdmin.this.btnApply.setEnabled(true);
                }
            }
        });
        this.allMTList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() > 1) {
                    MaskTemplatesAdmin.this.btnApply.doClick();
                }
            }
        });
        JScrollPane sp = new JScrollPane(this.allMTList);
        sp.setPreferredSize(new Dimension(100, 300));
        this.listPanel.add(sp);
    }

    private void initCurrentProperties(MaskTemplate maskTemplate) {
        this.tfName.setText(maskTemplate.getName());
        this.cbFunctionType.setSelectedIndex(maskTemplate.getFunctionType());
        this.cbDatatype.setSelectedIndex(maskTemplate.getDataType());
        this.tfInputFormat.setText(maskTemplate.getInputFormat());
        this.tfOutputFormat.setText(maskTemplate.getOutputFormat());
        this.tfMaskChar.setText(maskTemplate.getMaskChar());
        this.ifMaskFrom.setValue((long)maskTemplate.getMaskFrom());
        this.ifMaskTo.setValue((long)maskTemplate.getMaskTo());
        this.tfMonth.setText(maskTemplate.getMonth());
        this.tfDay.setText(maskTemplate.getDay());
        this.tfYear.setText(maskTemplate.getYear());
        this.tfHour.setText(maskTemplate.getHour());
        this.tfMinute.setText(maskTemplate.getMinute());
        this.tfSecond.setText(maskTemplate.getSecond());
        this.tfPattern.setText(maskTemplate.getPattern());
        this.tfReplaceString.setText(maskTemplate.getReplaceString());
        this.ifPosition.setValue((long)maskTemplate.getPosition());
        this.ifOccurrence.setValue((long)maskTemplate.getOccurrence());
        this.tfMatchParameter.setText(maskTemplate.getMatchParameter());
    }

    private void clear() {
        this.tfName.setText(EMPTY_VALUE);
        this.cbFunctionType.setSelectedIndex(0);
        this.cbDatatype.setSelectedIndex(0);
        this.tfInputFormat.setText(EMPTY_VALUE);
        this.tfOutputFormat.setText(EMPTY_VALUE);
        this.tfMaskChar.setText(EMPTY_VALUE);
        this.ifMaskFrom.setValue(0L);
        this.ifMaskTo.setValue(0L);
        this.tfMonth.setText(EMPTY_VALUE);
        this.tfDay.setText(EMPTY_VALUE);
        this.tfYear.setText(EMPTY_VALUE);
        this.tfHour.setText(EMPTY_VALUE);
        this.tfMinute.setText(EMPTY_VALUE);
        this.tfSecond.setText(EMPTY_VALUE);
        this.tfPattern.setText(EMPTY_VALUE);
        this.tfReplaceString.setText(EMPTY_VALUE);
        this.tfMatchParameter.setText(EMPTY_VALUE);
        this.ifPosition.setValue(0L);
        this.ifOccurrence.setValue(0L);
    }

    private void refreshList() {
        this.allMTModel.clear();
        Object[] maskTemplates = this.getApplicationView().getMaskTemplateSet().toArray();
        for (int i = 0; i < maskTemplates.length; ++i) {
            Object object = maskTemplates[i];
            this.allMTModel.addElement(object);
        }
    }

    private void initPropPanel() {
        this.initPropSubPanels();
        this.editableAll(false);
    }

    @Override
    protected JPanel createRow(Component leftComp, Component rightComp) {
        JPanel newRow = new JPanel(new BorderLayout());
        newRow.add(leftComp, "West");
        newRow.add(rightComp, "Center");
        return newRow;
    }

    private void initPropSubPanels() {
        this.propSubPanel1 = new JPanel(new GridLayout(0, 1, 5, 10));
        this.propSubPanel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5));
        this.pnProps.add((Component)this.propSubPanel1, "North");
        this.propSubPanel5 = new JPanel(new BorderLayout());
        this.propSubPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.pnProps.add((Component)this.propSubPanel5, "Center");
        this.initSubPanel1();
        this.initSubPanels();
        this.cbFunctionType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskTemplatesAdmin.this.propSubPanel5.removeAll();
                switch (MaskTemplatesAdmin.this.cbFunctionType.getSelectedIndex()) {
                    case 0: {
                        MaskTemplatesAdmin.this.propSubPanel5.add(MaskTemplatesAdmin.this.pnDatatype);
                        MaskTemplatesAdmin.this.propSubPanel5.updateUI();
                        break;
                    }
                    case 1: {
                        MaskTemplatesAdmin.this.propSubPanel5.add(MaskTemplatesAdmin.this.pnRegExp);
                        MaskTemplatesAdmin.this.propSubPanel5.updateUI();
                    }
                }
            }
        });
    }

    private void initSubPanel1() {
        JLabel lbName = new JLabel(Messages.getString("MaskTemplatesAdmin.Name"));
        lbName.setPreferredSize(DEFAULT_SIZE);
        this.tfName = new JTextField();
        this.tfName.setPreferredSize(DEFAULT_SIZE);
        this.propSubPanel1.add(this.createRow(lbName, this.tfName));
        JLabel lbFunctionType = new JLabel(Messages.getString("MaskTemplatesAdmin.FunctionType"));
        lbFunctionType.setPreferredSize(DEFAULT_SIZE);
        this.cbFunctionType = new JComboBox<String>(FUNCTION_TYPES);
        this.cbFunctionType.setPreferredSize(DEFAULT_SIZE);
        this.propSubPanel1.add(this.createRow(lbFunctionType, this.cbFunctionType));
    }

    private void initSubPanels() {
        this.pnDatatype = new JPanel(new BorderLayout());
        final JPanel jpanel = new JPanel(new GridLayout(0, 1, 5, 10));
        JLabel lbDataType = new JLabel(Messages.getString("MaskTemplatesAdmin.Datatype"));
        lbDataType.setPreferredSize(DEFAULT_SIZE);
        this.cbDatatype = new JComboBox<String>(DATATYPES);
        this.cbDatatype.setPreferredSize(DEFAULT_SIZE);
        jpanel.add(this.createRow(lbDataType, this.cbDatatype));
        this.pnDatatype.add((Component)jpanel, "North");
        this.pnDTCharacter = new JPanel(new BorderLayout());
        this.pnDTCharacter.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.lbInputFormat = new JLabel(Messages.getString("MaskTemplatesAdmin.InputFormat"));
        this.lbInputFormat.setPreferredSize(DEFAULT_SIZE);
        this.tfInputFormat = new JTextField();
        this.tfInputFormat.setPreferredSize(DEFAULT_SIZE);
        this.lbOutputFormat = new JLabel(Messages.getString("MaskTemplatesAdmin.OutputFormat"));
        this.lbOutputFormat.setPreferredSize(DEFAULT_SIZE);
        this.tfOutputFormat = new JTextField();
        this.tfOutputFormat.setPreferredSize(DEFAULT_SIZE);
        this.lbMaskChar = new JLabel(Messages.getString("MaskTemplatesAdmin.MaskChar"));
        this.lbMaskChar.setPreferredSize(DEFAULT_SIZE);
        this.tfMaskChar = new JTextField();
        this.tfMaskChar.setPreferredSize(DEFAULT_SIZE);
        this.lbMaskFrom = new JLabel(Messages.getString("MaskTemplatesAdmin.MaskFrom"));
        this.lbMaskFrom.setPreferredSize(DEFAULT_SIZE);
        this.ifMaskFrom = new JIntegerField();
        this.ifMaskFrom.setPreferredSize(DEFAULT_SIZE);
        this.lbMaskTo = new JLabel(Messages.getString("MaskTemplatesAdmin.MaskTo"));
        this.lbMaskTo.setPreferredSize(DEFAULT_SIZE);
        this.ifMaskTo = new JIntegerField();
        this.ifMaskTo.setPreferredSize(DEFAULT_SIZE);
        this.pnDTNumeric = new JPanel(new BorderLayout());
        this.pnDTNumeric.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        this.pnDTDate = new JPanel(new BorderLayout());
        this.pnDTDate.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        JPanel jpDate = new JPanel(new GridLayout(0, 1, 5, 10));
        this.pnDTDate.add((Component)jpDate, "North");
        JLabel lbMonth = new JLabel(Messages.getString("MaskTemplatesAdmin.Month"));
        lbMonth.setPreferredSize(DEFAULT_SIZE);
        this.tfMonth = new JTextField();
        this.tfMonth.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbMonth, this.tfMonth));
        JLabel lbDay = new JLabel(Messages.getString("MaskTemplatesAdmin.Day"));
        lbDay.setPreferredSize(DEFAULT_SIZE);
        this.tfDay = new JTextField();
        this.tfDay.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbDay, this.tfDay));
        JLabel lbYear = new JLabel(Messages.getString("MaskTemplatesAdmin.Year"));
        lbYear.setPreferredSize(DEFAULT_SIZE);
        this.tfYear = new JTextField();
        this.tfYear.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbYear, this.tfYear));
        JLabel lbHour = new JLabel(Messages.getString("MaskTemplatesAdmin.Hour"));
        lbHour.setPreferredSize(DEFAULT_SIZE);
        this.tfHour = new JTextField();
        this.tfHour.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbHour, this.tfHour));
        JLabel lbMinute = new JLabel(Messages.getString("MaskTemplatesAdmin.Minute"));
        lbMinute.setPreferredSize(DEFAULT_SIZE);
        this.tfMinute = new JTextField();
        this.tfMinute.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbMinute, this.tfMinute));
        JLabel lbSecond = new JLabel(Messages.getString("MaskTemplatesAdmin.Second"));
        lbSecond.setPreferredSize(DEFAULT_SIZE);
        this.tfSecond = new JTextField();
        this.tfSecond.setPreferredSize(DEFAULT_SIZE);
        jpDate.add(this.createRow(lbSecond, this.tfSecond));
        this.cbDatatype.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MaskTemplatesAdmin.this.pnDatatype.removeAll();
                MaskTemplatesAdmin.this.pnDatatype.add((Component)jpanel, "North");
                switch (MaskTemplatesAdmin.this.cbDatatype.getSelectedIndex()) {
                    case 0: {
                        MaskTemplatesAdmin.this.initCharacterPanel();
                        MaskTemplatesAdmin.this.pnDatatype.add((Component)MaskTemplatesAdmin.this.pnDTCharacter, "Center");
                        MaskTemplatesAdmin.this.pnDatatype.updateUI();
                        break;
                    }
                    case 1: {
                        MaskTemplatesAdmin.this.initNumericPanel();
                        MaskTemplatesAdmin.this.pnDatatype.add((Component)MaskTemplatesAdmin.this.pnDTNumeric, "Center");
                        MaskTemplatesAdmin.this.pnDatatype.updateUI();
                        break;
                    }
                    case 2: {
                        MaskTemplatesAdmin.this.pnDatatype.add((Component)MaskTemplatesAdmin.this.pnDTDate, "Center");
                        MaskTemplatesAdmin.this.pnDatatype.updateUI();
                    }
                }
            }
        });
        this.pnRegExp = new JPanel(new BorderLayout());
        JPanel jpRegExp = new JPanel(new GridLayout(0, 1, 5, 10));
        this.pnRegExp.add((Component)jpRegExp, "North");
        JLabel lbPattern = new JLabel(Messages.getString("MaskTemplatesAdmin.Pattern"));
        lbPattern.setPreferredSize(DEFAULT_SIZE);
        this.tfPattern = new JTextField();
        this.tfPattern.setPreferredSize(DEFAULT_SIZE);
        jpRegExp.add(this.createRow(lbPattern, this.tfPattern));
        JLabel lbReplaceString = new JLabel(Messages.getString("MaskTemplatesAdmin.ReplaceString"));
        lbReplaceString.setPreferredSize(DEFAULT_SIZE);
        this.tfReplaceString = new JTextField();
        this.tfReplaceString.setPreferredSize(DEFAULT_SIZE);
        jpRegExp.add(this.createRow(lbReplaceString, this.tfReplaceString));
        JLabel lbPosition = new JLabel(Messages.getString("MaskTemplatesAdmin.Position"));
        lbPosition.setPreferredSize(DEFAULT_SIZE);
        this.ifPosition = new JIntegerField();
        this.ifPosition.setPreferredSize(DEFAULT_SIZE);
        jpRegExp.add(this.createRow(lbPosition, this.ifPosition));
        JLabel lbOccurrence = new JLabel(Messages.getString("MaskTemplatesAdmin.Occurrence"));
        lbOccurrence.setPreferredSize(DEFAULT_SIZE);
        this.ifOccurrence = new JIntegerField();
        this.ifOccurrence.setPreferredSize(DEFAULT_SIZE);
        jpRegExp.add(this.createRow(lbOccurrence, this.ifOccurrence));
        JLabel lbMatchParameter = new JLabel(Messages.getString("MaskTemplatesAdmin.MatchParameter"));
        lbMatchParameter.setPreferredSize(DEFAULT_SIZE);
        this.tfMatchParameter = new JTextField();
        this.tfMatchParameter.setPreferredSize(DEFAULT_SIZE);
        jpRegExp.add(this.createRow(lbMatchParameter, this.tfMatchParameter));
    }

    private void initCharacterPanel() {
        this.pnDTCharacter.removeAll();
        JPanel jpCharacter = new JPanel(new GridLayout(0, 1, 5, 10));
        this.pnDTCharacter.add((Component)jpCharacter, "North");
        jpCharacter.add(this.createRow(this.lbInputFormat, this.tfInputFormat));
        jpCharacter.add(this.createRow(this.lbOutputFormat, this.tfOutputFormat));
        jpCharacter.add(this.createRow(this.lbMaskChar, this.tfMaskChar));
        jpCharacter.add(this.createRow(this.lbMaskFrom, this.ifMaskFrom));
        jpCharacter.add(this.createRow(this.lbMaskTo, this.ifMaskTo));
    }

    private void initNumericPanel() {
        this.pnDTNumeric.removeAll();
        JPanel jpNumeric = new JPanel(new GridLayout(0, 1, 5, 10));
        this.pnDTNumeric.add((Component)jpNumeric, "North");
        jpNumeric.add(this.createRow(this.lbMaskChar, this.tfMaskChar));
        jpNumeric.add(this.createRow(this.lbMaskFrom, this.ifMaskFrom));
        jpNumeric.add(this.createRow(this.lbMaskTo, this.ifMaskTo));
    }

    public void setBG(Component c) {
        if (!c.getFont().isPlain()) {
            c.setFont(new Font(c.getFont().getName(), 0, c.getFont().getSize()));
        }
    }

    protected JPanel getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = new JPanel(new BorderLayout());
            this.buttonPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
            JPanel panel = new JPanel(new GridLayout(1, 4, 5, 5));
            this.btnSave = new JButton(Messages.getString("MaskTemplatesAdmin.Save"));
            this.btnSave.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MaskTemplatesAdmin.this.getApplicationView().saveMaskTemplates();
                    ApplicationView.log(Messages.getString("MaskTemplatesAdmin.MaskTemplatesSaved"));
                    MaskTemplatesAdmin.this.isSaved = true;
                    MaskTemplatesAdmin.this.btnSave.setEnabled(false);
                    MaskTemplatesAdmin.this.editableAll(false);
                    MaskTemplatesAdmin.this.lsDeleted.clear();
                    MaskTemplatesAdmin.this.lsAdded.clear();
                }
            });
            this.btnSave.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnSave.setMnemonic(83);
            this.btnSave.setEnabled(false);
            this.btnClose = new JButton(Messages.getString("MaskTemplatesAdmin.Close"));
            this.btnClose.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (MaskTemplatesAdmin.this.canClose()) {
                        MaskTemplatesAdmin.this.close();
                    }
                }
            });
            this.btnClose.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            this.btnClose.setMnemonic(67);
            JButton btnHelp = new JButton(this.getHelpAction());
            btnHelp.setPreferredSize(MessageDialogs.BUTTON_SIZE);
            btnHelp.setMnemonic(72);
            panel.add(this.btnSave);
            panel.add(this.btnClose);
            panel.add(btnHelp);
            this.buttonPanel.add((Component)panel, "East");
        }
        return this.buttonPanel;
    }

    protected boolean canApply() {
        if (!EMPTY_VALUE.equalsIgnoreCase(this.tfName.getText()) && this.tfName.getText() != null && this.tfName.getText().trim().length() > 0) {
            return true;
        }
        MessageDialogs.showErrorMessage(this, Messages.getString("MaskTemplatesAdmin.NameCanNotBeEmpty"));
        this.tfName.requestFocus();
        return false;
    }

    protected void setProperties() {
        MaskTemplate maskTemplate = this.lastSelectedMaskTemplate;
        if (maskTemplate != null) {
            maskTemplate.resetProperties();
            maskTemplate.setName(this.tfName.getText());
            maskTemplate.setFunctionType(this.cbFunctionType.getSelectedIndex());
            switch (this.cbFunctionType.getSelectedIndex()) {
                case 0: {
                    maskTemplate.setDataType(this.cbDatatype.getSelectedIndex());
                    switch (this.cbDatatype.getSelectedIndex()) {
                        case 0: {
                            maskTemplate.setInputFormat(this.tfInputFormat.getText());
                            maskTemplate.setOutputFormat(this.tfOutputFormat.getText());
                            maskTemplate.setMaskChar(this.tfMaskChar.getText());
                            maskTemplate.setMaskFrom(this.ifMaskFrom.getIntValue());
                            maskTemplate.setMaskTo(this.ifMaskTo.getIntValue());
                            break;
                        }
                        case 1: {
                            maskTemplate.setMaskChar(this.tfMaskChar.getText());
                            maskTemplate.setMaskFrom(this.ifMaskFrom.getIntValue());
                            maskTemplate.setMaskTo(this.ifMaskTo.getIntValue());
                            break;
                        }
                        case 2: {
                            maskTemplate.setMonth(this.tfMonth.getText());
                            maskTemplate.setDay(this.tfDay.getText());
                            maskTemplate.setYear(this.tfYear.getText());
                            maskTemplate.setHour(this.tfHour.getText());
                            maskTemplate.setMinute(this.tfMinute.getText());
                            maskTemplate.setSecond(this.tfSecond.getText());
                        }
                    }
                    break;
                }
                case 1: {
                    maskTemplate.setPattern(this.tfPattern.getText());
                    maskTemplate.setReplaceString(this.tfReplaceString.getText());
                    maskTemplate.setPosition(this.ifPosition.getIntValue());
                    maskTemplate.setOccurrence(this.ifOccurrence.getIntValue());
                    maskTemplate.setMatchParameter(this.tfMatchParameter.getText());
                }
            }
        }
        this.editableAll(false);
    }

    protected void editableAll(boolean enabled) {
        this.tfName.setEnabled(enabled);
        this.tfName.setEditable(enabled);
        this.cbFunctionType.setEnabled(enabled);
        this.cbDatatype.setEnabled(enabled);
        this.tfInputFormat.setEnabled(enabled);
        this.tfInputFormat.setEditable(enabled);
        this.tfOutputFormat.setEnabled(enabled);
        this.tfOutputFormat.setEditable(enabled);
        this.tfMaskChar.setEnabled(enabled);
        this.tfMaskChar.setEditable(enabled);
        this.ifMaskFrom.setEnabled(enabled);
        this.ifMaskFrom.setEditable(enabled);
        this.ifMaskTo.setEnabled(enabled);
        this.ifMaskTo.setEditable(enabled);
        this.tfMonth.setEnabled(enabled);
        this.tfMonth.setEditable(enabled);
        this.tfDay.setEnabled(enabled);
        this.tfDay.setEditable(enabled);
        this.tfYear.setEnabled(enabled);
        this.tfYear.setEditable(enabled);
        this.tfHour.setEnabled(enabled);
        this.tfHour.setEditable(enabled);
        this.tfMinute.setEnabled(enabled);
        this.tfMinute.setEditable(enabled);
        this.tfSecond.setEnabled(enabled);
        this.tfSecond.setEditable(enabled);
        this.tfPattern.setEnabled(enabled);
        this.tfPattern.setEditable(enabled);
        this.tfReplaceString.setEnabled(enabled);
        this.tfReplaceString.setEditable(enabled);
        this.tfMatchParameter.setEnabled(enabled);
        this.tfMatchParameter.setEditable(enabled);
        this.ifPosition.setEnabled(enabled);
        this.ifPosition.setEditable(enabled);
        this.ifOccurrence.setEnabled(enabled);
        this.ifOccurrence.setEditable(enabled);
        this.applyMode = enabled;
        this.btnApply.setText(enabled ? APPLY_TXT : MODIFY_TXT);
    }

    private void applyButtonClicked() {
        if (this.applyMode) {
            this.applyMode = false;
            if (this.canApply()) {
                this.setProperties();
                this.isSaved = false;
                this.btnSave.setEnabled(true);
                this.allMTList.updateUI();
            }
        } else if (this.lastSelectedMaskTemplate != null) {
            this.editableAll(true);
            this.btnApply.setMnemonic(89);
        }
    }

    public void showDialog() {
        this.getDialog().setVisible(true);
    }

    @Override
    protected void close() {
        for (MaskTemplate maskTemplate : this.lsAdded) {
            this.getApplicationView().getMaskTemplateSet().remove(maskTemplate);
        }
        for (MaskTemplate maskTemplate : this.lsDeleted) {
            this.getApplicationView().getMaskTemplateSet().add(maskTemplate);
        }
        Rectangle rectangle = new Rectangle(this.dialog.getLocation(), this.dialog.getSize());
        this.getApplicationView().getSettings().setDialogSettings(this.getClass().getName(), rectangle);
        this.dialog.dispose();
    }

    @Override
    protected String getHelpIndex() {
        return "MASK_TEMPLATES_ADMINISTRATION_DIALOG";
    }

    private MaskTemplate addMaskTemplate() {
        MaskTemplate maskTemplate = this.getApplicationView().getMaskTemplateSet().createMaskTemplate();
        this.isSaved = false;
        this.lsAdded.add(maskTemplate);
        return maskTemplate;
    }

    class MaskTemplateCellRenderer
    extends JLabel
    implements ListCellRenderer {
        MaskTemplateCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MaskTemplate maskTemplate = (MaskTemplate)value;
            this.setText(maskTemplate.getName());
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            this.setEnabled(list.isEnabled());
            this.setFont(list.getFont());
            this.setOpaque(true);
            Icon icon = GUIConfiguration.getInstance().getIcon("MASK_TEMPLATE_ICON");
            this.setIcon(icon);
            return this;
        }
    }
}

