/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.JMenuBar;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.MenuStructure;

public class ControllerSet {
    private Map controllers = new TreeMap();
    private JMenuBar menuBar;
    private MenuStructure menuStructure;
    private ApplicationView appView;

    public ControllerSet(ApplicationView view) {
        this.appView = view;
    }

    public void add(AbstractController controller) {
        this.controllers.put(controller.getName(), controller);
    }

    public void remove(AbstractController controller) {
        this.controllers.remove(controller.getName());
    }

    public AbstractController getController(String name) {
        return (AbstractController)this.controllers.get(name);
    }

    public Collection getControllers() {
        return this.controllers.values();
    }

    public JMenuBar getJMenuBar() {
        if (this.menuBar == null) {
            this.createMenuBar();
        }
        return this.menuBar;
    }

    private void createMenuBar() {
        String[] firstMenus = new String[]{AbstractController.FILE_CAPTION, AbstractController.EDIT_CAPTION, AbstractController.VIEW_CAPTION, AbstractController.DESIGN_CAPTION, AbstractController.OBJECT_CAPTION, AbstractController.RELATIONAL_CAPTION, AbstractController.STORAGE_CAPTION, AbstractController.PROCESS_MODELLING_CAPTION, AbstractController.TOOLS_CAPTION};
        String helpMenu = AbstractController.HELP_CAPTION;
        this.menuStructure = new MenuStructure(this.appView, firstMenus, helpMenu);
        for (AbstractController controller : this.controllers.values()) {
            controller.addActionsToMenu(this.menuStructure);
        }
        this.menuBar = this.menuStructure.getJMenuBar();
    }

    public MDBAction getActionByName(String name) {
        for (AbstractController controller : this.controllers.values()) {
            if (!controller.hasActionWithName(name)) continue;
            return controller.getActionByName(name);
        }
        return null;
    }

    public void updateMenu() {
        for (AbstractController controller : this.controllers.values()) {
            this.updateMenu(controller);
        }
    }

    public void updateMenu(AbstractController controller) {
        this.getJMenuBar();
        controller.addActionsToMenu(this.menuStructure);
    }

    public void remove(MDBAction action) {
        this.menuStructure.remove(action);
    }

    public void add(MDBAction action) {
        this.menuStructure.add(action);
    }

    public MenuStructure getMenuStructure() {
        return this.menuStructure;
    }

    public void updateObjectMenu(DesignPartView currentDPV) {
        if (this.menuStructure != null) {
            this.menuStructure.clearObjectActions();
            if (currentDPV != null) {
                currentDPV.getController().addObjectActionsToMenu(this.menuStructure);
            } else {
                this.menuStructure.showObjectMenu(false);
            }
        }
    }
}

