/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.swingui;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreePath;
import oracle.dbtools.crest.exports.ddl.SQLStatementBuilder;
import oracle.dbtools.crest.fcp.DMDiagramEditor;
import oracle.dbtools.crest.fcp.DataModelerAddin;
import oracle.dbtools.crest.fcp.vcs.StorableObjectStatus;
import oracle.dbtools.crest.fcp.vcs.svn.SVNClientHelper;
import oracle.dbtools.crest.model.IDGenerator;
import oracle.dbtools.crest.model.MDConfiguration;
import oracle.dbtools.crest.model.MDPreferences;
import oracle.dbtools.crest.model.MaskTemplateFileWrapper;
import oracle.dbtools.crest.model.MaskTemplateSet;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChangeEvent;
import oracle.dbtools.crest.model.SensitiveTypeFileWrapper;
import oracle.dbtools.crest.model.SensitiveTypeSet;
import oracle.dbtools.crest.model.SetEvent;
import oracle.dbtools.crest.model.StatusBarOwner;
import oracle.dbtools.crest.model.TSDPPolicyFileWrapper;
import oracle.dbtools.crest.model.TSDPPolicySet;
import oracle.dbtools.crest.model.TSDPSubPolicySet;
import oracle.dbtools.crest.model.View;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignLevelSettings;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.DesignSet;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.TableLevelConstraintEvent;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.multidimensional.MultidimensionalDesign;
import oracle.dbtools.crest.model.design.process.DataFlowDesign;
import oracle.dbtools.crest.model.design.process.ProcessModel;
import oracle.dbtools.crest.model.design.process.TransformationPackage;
import oracle.dbtools.crest.model.design.process.TransformationTask;
import oracle.dbtools.crest.model.design.relational.Index;
import oracle.dbtools.crest.model.design.relational.RelationalDesign;
import oracle.dbtools.crest.model.design.relational.Table;
import oracle.dbtools.crest.model.design.relational.TableView;
import oracle.dbtools.crest.model.design.storage.StorageDesign;
import oracle.dbtools.crest.model.design.storage.StorageEvent;
import oracle.dbtools.crest.model.design.storage.TableProxy;
import oracle.dbtools.crest.model.designrules.DRCustomScript;
import oracle.dbtools.crest.model.designrules.DRCustomValidationScript;
import oracle.dbtools.crest.model.designrules.DRLibrary;
import oracle.dbtools.crest.model.designrules.DesignRuleManager;
import oracle.dbtools.crest.model.designrules.RuleHandler;
import oracle.dbtools.crest.model.metadata.XMLTransformationManager;
import oracle.dbtools.crest.model.persistence.DBPersistenceManager;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.db.AbstractRepositoryManager;
import oracle.dbtools.crest.model.persistence.db.RepositoryObject;
import oracle.dbtools.crest.model.placeholder.DesignPartViewPlaceHolder;
import oracle.dbtools.crest.swingui.AbstractController;
import oracle.dbtools.crest.swingui.ControllerApplication;
import oracle.dbtools.crest.swingui.ControllerSet;
import oracle.dbtools.crest.swingui.DesignPartView;
import oracle.dbtools.crest.swingui.GUIConfiguration;
import oracle.dbtools.crest.swingui.MDBAction;
import oracle.dbtools.crest.swingui.Messages;
import oracle.dbtools.crest.swingui.ProgressDialog;
import oracle.dbtools.crest.swingui.SelectableObject;
import oracle.dbtools.crest.swingui.SelectedObjectChangeListener;
import oracle.dbtools.crest.swingui.StatusBar;
import oracle.dbtools.crest.swingui.SwingUIConstants;
import oracle.dbtools.crest.swingui.TopView;
import oracle.dbtools.crest.swingui.browser.BrowserPanel;
import oracle.dbtools.crest.swingui.ddl.DDLFileMaker;
import oracle.dbtools.crest.swingui.ddl.DDLFileMakerEditor;
import oracle.dbtools.crest.swingui.ddl.DDLViewer;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesManager;
import oracle.dbtools.crest.swingui.designrules.CustomDesignRulesPersistence;
import oracle.dbtools.crest.swingui.designrules.CustomLibrariesManager;
import oracle.dbtools.crest.swingui.designrules.CustomTransformationsManager;
import oracle.dbtools.crest.swingui.designrules.DDLTransformationScriptSet;
import oracle.dbtools.crest.swingui.designrules.DDLTransformationsScriptsDialog;
import oracle.dbtools.crest.swingui.designrules.DesignRuleView;
import oracle.dbtools.crest.swingui.diagram.Diagram;
import oracle.dbtools.crest.swingui.editor.ExpObject;
import oracle.dbtools.crest.swingui.editor.SelectDesignsDialog;
import oracle.dbtools.crest.swingui.editor.SelectRelationalModelDialog;
import oracle.dbtools.crest.swingui.editor.UDPLibrariesPersistence;
import oracle.dbtools.crest.swingui.logical.DPVLogical;
import oracle.dbtools.crest.swingui.logical.TVArc;
import oracle.dbtools.crest.swingui.logical.TVRelation;
import oracle.dbtools.crest.swingui.process.TVFlow;
import oracle.dbtools.crest.swingui.relational.DPVRelational;
import oracle.dbtools.crest.swingui.relational.TVFKRelation;
import oracle.dbtools.crest.swingui.search.SavedSearch;
import oracle.dbtools.crest.swingui.search.SearchProfile;
import oracle.dbtools.crest.swingui.search.SearchProfilesPersistence;
import oracle.dbtools.crest.swingui.storage.ControllerStorage;
import oracle.dbtools.crest.swingui.wizards.reports.CustomReportTemplate;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportConfiguration;
import oracle.dbtools.crest.swingui.wizards.reports.StandardReportTemplate;
import oracle.dbtools.crest.util.Extension;
import oracle.dbtools.crest.util.FileUtils;
import oracle.dbtools.crest.util.MessageDialogs;
import oracle.dbtools.crest.util.exceptions.DDLExceptionList;
import oracle.dbtools.crest.util.io.NullOutputStream;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.options.Settings;
import oracle.dbtools.crest.util.print.Config;
import oracle.dbtools.crest.util.runtime.RuntimeMonitor;
import oracle.dbtools.raptor.ui.URLFileChooser;
import oracle.ide.Ide;
import oracle.ide.config.EnvironOptions;
import oracle.ide.config.IdeSettings;
import oracle.ide.editor.Editor;
import oracle.ide.editor.EditorManager;
import oracle.ide.log.LogManager;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLFilter;
import org.openide.util.Lookup;
import org.w3c.dom.Document;

public class ApplicationView
implements SelectedObjectChangeListener,
StatusBarOwner,
View,
SwingUIConstants,
ChangeListener {
    public static final String UNTITLED_DESIGN = oracle.dbtools.crest.model.Messages.getString("Design.Untitled");
    private static final String MENU_HIDE = Messages.getString("ApplicationView.Hide");
    private static final String MENU_DELETE_SUBVIEW = Messages.getString("ApplicationView.DeleteSubView");
    private static final String USE_CUSTOM_FORMAT = "use_custom_format";
    private static final String USE_DEFAULT_COLOR = "use_default_color";
    private static final String BACKGROUND_COLOR = "background_color";
    private static final String FOREGROUND_COLOR = "foreground_color";
    public static boolean DROP_GENERATED_OBJECTS_ONLY = true;
    public static boolean USE_DROP_DEPENDENCY = true;
    private static final String NULL_STR = "NULL";
    public static final boolean EXIT_ON_CLOSE = true;
    public static boolean IS_VIEWER = false;
    public static boolean LOGICAL_MODEL_ONLY = false;
    public static final boolean BACK_UP_IS_VIEWER = IS_VIEWER;
    public static final boolean BACK_UP_LOGICAL_MODEL_ONLY = LOGICAL_MODEL_ONLY;
    public static final String TEMP_DIR = System.getProperty("java.io.tmpdir");
    public static boolean importing = false;
    public static boolean loading = false;
    public static boolean merging = false;
    public static boolean canLogging = true;
    public static boolean closing = false;
    public static boolean GUIMode = true;
    private GUIConfiguration guiConfig = GUIConfiguration.getInstance();
    private DesignPartView currentDPV;
    private ControllerSet controllers = new ControllerSet(this);
    private ControllerApplication appController;
    private ControllerStorage sharedStorageController;
    private DDLViewer ddlViewer;
    private DDLFileMakerEditor ddlFileMakerEditor;
    private Map<RelationalDesign, DDLFileMakerEditor> ddlFileMakerEditorMap;
    private StatusBar statusBar;
    private JMenuBar jmenuBar = null;
    private DesignRuleView designRuleView = null;
    private CustomDesignRulesManager customDesignRulesManager = null;
    private CustomLibrariesManager customLibrariesManager = null;
    private CustomTransformationsManager transformationsManager = null;
    private DDLTransformationsScriptsDialog ddlTransformationsScriptsDialog = null;
    private ScriptEngineManager scriptEngineManager;
    private ArrayList scriptEngines;
    private ApplicationCloser applicationCloser = null;
    private JPopupMenu popupPhS;
    private JPopupMenu popupDFD;
    private JPopupMenu popupMDD;
    private JPopupMenu popupTrTask;
    private JMenuItem miDeleteSubView;
    private JMenuItem miCloseSubView;
    private JMenuItem miRearrangeDiagram;
    private JPopupMenu.Separator sepMDCompact;
    private JMenuItem miCompactDiagramProps;
    private JMenuItem miCloseDFD;
    private JMenuItem miCloseMDD;
    private JMenuItem miCloseTrTask;
    private static DateFormat df;
    private BrowserPanel browserPanel;
    public static boolean debugMode;
    public static JFrame frame;
    public static String basePath;
    private DDLExceptionList ddlExceptionList;
    private JDialog navigator;
    private JPanel navPanel;
    private Settings settings = null;
    private Design currentDesign;
    private IDGenerator globalGenerator;
    private DDLFileMaker ddlFileMaker = null;
    protected MDConfiguration configuration = MDConfiguration.getDefaultInstance();
    private MDPreferences preferences = MDPreferences.getDefaultInstance();
    protected XMLPersistenceManager persistenceManager;
    private DesignRuleManager designRuleManager;
    private DBPersistenceManager dbPersistenceManager;
    private DropTargetListener dropTargetListener = null;
    private int currentOperation = -1;
    private List objectsToSave = new ArrayList();
    private DesignSet designSet;
    private Design hiddenDesign;
    private List copiedObjects = new ArrayList();
    private List copiedTopViews = new ArrayList();
    private ArrayList<DRCustomScript> customDesignRules = new ArrayList();
    private ArrayList<SavedSearch> savedSearches = new ArrayList();
    private ArrayList<DRLibrary> customLibraries = new ArrayList();
    private ArrayList<DDLTransformationScriptSet> ddlTransformationScriptSets = new ArrayList();
    private static ApplicationView instance;
    private CustomDesignRulesPersistence designRulesPersistence = new CustomDesignRulesPersistence(this);
    public static boolean designRulesLoaded;
    private XMLTransformationManager xmlTransformationManager = null;
    private ArrayList<StandardReportTemplate> reportTemplates = new ArrayList();
    private ArrayList<CustomReportTemplate> customReportTemplates = new ArrayList();
    private ArrayList<StandardReportConfiguration> standardReportsConfiguration = new ArrayList();
    private ArrayList<ExpObject> dmdExports = new ArrayList();
    private ArrayList<String> CRTBooleanTList = new ArrayList();
    private ArrayList<String> CRTBooleanFList = new ArrayList();
    public static boolean PROPAGATE_FKATTRIBUTE_DESCRIPTION;
    public static boolean SHOW_SENSITIVE_DATA;
    public static boolean SHOW_MASKED_DATA;
    public static boolean REBUILD_OBJECT_LIST;
    public static boolean INCLUDE_CLASS_NAME_IN_ITEM_XML;
    public static String BDA_PROPERTY_SEPARATOR;
    private static boolean searchProfilesLoaded;
    private ArrayList<SearchProfile> searchProfiles = new ArrayList();
    private Settings initialSettings;
    private MaskTemplateSet maskTemplateSet = null;
    private SensitiveTypeSet sensitiveTypeSet = null;
    private TSDPPolicySet tsdpPolicySet;
    private TSDPSubPolicySet tsdpSubPolicySet;
    public static String dmInternalsDistDir;
    private List<StorableObjectStatus> changedObjectsList = null;
    UDPLibrariesPersistence udpLibrariesPersistence;
    private boolean loadAllDesignRuleHandlers = false;
    public static String DESIGN_URL_FILTER_DESC;
    private static Logger fileLogger;
    private static final Logger LOGGER;
    private static List DM_TOOLBARS_LIST;
    boolean isUpdating = false;
    public boolean cancel = false;
    public static boolean instantiating;

    private ApplicationView(boolean guiMode, String sysDataDir) {
        GUIMode = guiMode;
        this.setJDOMparsing();
        this.setPropagateFKAttributeDescription();
        this.setSensitiveAndMasked();
        this.setRebuildObjectList();
        this.setBDAPropertySeparator();
        this.getPersistenceManager();
        this.createDesignSet();
        this.settings = new Settings(this);
        this.settings.loadPreferences();
        if (sysDataDir != null && !"".equals(sysDataDir)) {
            this.settings.initDefaultSystemTypesPath(sysDataDir);
        }
        this.setInitialSettings(this.settings);
        this.addDesign(false);
        this.nullifyDesignRuleManager();
    }

    private ApplicationView(DropTargetListener dropTargetListener) {
        this(dropTargetListener, true);
    }

    private ApplicationView(DropTargetListener dropTargetListener, boolean guiMode) {
        GUIMode = guiMode;
        if (guiMode) {
            frame = Ide.getMainWindow();
        }
        this.setDebugMode();
        this.setJDOMparsing();
        this.setPropagateFKAttributeDescription();
        this.setSensitiveAndMasked();
        this.setRebuildObjectList();
        this.setBDAPropertySeparator();
        this.getPersistenceManager();
        this.createDesignSet();
        this.hiddenDesign = new Design(this, null, true);
        Extension.isExtension = true;
        this.dropTargetListener = dropTargetListener;
        this.statusBar = new StatusBar();
        this.popupPhS = new JPopupMenu();
        this.popupDFD = new JPopupMenu();
        this.popupMDD = new JPopupMenu();
        this.popupTrTask = new JPopupMenu();
        this.miCloseSubView = new JMenuItem(MENU_HIDE);
        this.miDeleteSubView = new JMenuItem(MENU_DELETE_SUBVIEW);
        this.miRearrangeDiagram = new JMenuItem(Messages.getString("ApplicationView.RearrangeDiagram"));
        this.sepMDCompact = new JPopupMenu.Separator();
        this.miCompactDiagramProps = new JMenuItem(Messages.getString("ApplicationView.Properties"));
        this.miCloseDFD = new JMenuItem(MENU_HIDE);
        this.miCloseMDD = new JMenuItem(MENU_HIDE);
        this.miCloseTrTask = new JMenuItem(MENU_HIDE);
        this.settings = new Settings(this);
        this.settings.loadPreferences();
        if (PROPAGATE_FKATTRIBUTE_DESCRIPTION) {
            this.settings.setPropagatePKAttrNotes(true);
        } else {
            PROPAGATE_FKATTRIBUTE_DESCRIPTION = this.settings.isPropagatePKAttrNotes();
        }
        this.setInitialSettings(this.settings);
        this.loadMaskTemplates();
        this.loadSensitiveTypes();
        this.loadTSDPPolicies();
        this.addDesign(false);
        this.settings.loadPreferredDomains();
        this.settings.loadPreferredLogicalTypes();
        if (ApplicationView.isGUIMode()) {
            this.updateSettings(false, false);
        }
        this.controllers.add(this.getController());
        this.getControllerStorage();
        this.controllers.updateMenu();
        if (ApplicationView.isGUIMode()) {
            this.currentDPV = this.getDPVLogical();
        }
        if (ApplicationView.isGUIMode()) {
            this.browserPanel = new BrowserPanel(this);
            this.browserPanel.getJTree().getModel().addTreeModelListener(new MyTreeModelListener());
        }
        this.getCurrentDesign().getDataTypesDesign().setDirty(false);
        this.popupDFD.add(this.miCloseDFD);
        this.popupMDD.add(this.miCloseMDD);
        if (!IS_VIEWER) {
            this.popupMDD.addSeparator();
            this.popupMDD.add(this.miRearrangeDiagram);
        }
        this.popupMDD.add(this.sepMDCompact);
        this.popupMDD.add(this.miCompactDiagramProps);
        this.popupTrTask.add(this.miCloseTrTask);
        this.popupPhS.add(this.miCloseSubView);
        if (!IS_VIEWER) {
            this.popupPhS.addSeparator();
            this.miDeleteSubView.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    ApplicationView.this.deleteSubview();
                }
            });
            this.popupPhS.add(this.miDeleteSubView);
        }
        if (ApplicationView.isGUIMode()) {
            IdeSettings ideSettings = Ide.getSettings();
            EnvironOptions envopts = (EnvironOptions)ideSettings.getData("environment-options");
            envopts.addChangeListener((ChangeListener)new SettingsListener());
        }
        this.settings.loadPreferencesExtraData(this);
        this.nullifyDesignRuleManager();
    }

    public void loadCustomDRScripts() {
        if (!designRulesLoaded) {
            this.initScriptEngines();
            this.designRulesPersistence.loadCustomDRScripts(this.settings);
            designRulesLoaded = true;
        }
    }

    public void saveCustomDRScripts() {
        this.designRulesPersistence.saveCustomDRScripts();
    }

    public static void clearToolbar() {
        ApplicationView.showToolbar(null);
    }

    public static void showToolbar(String toolbarName) {
        try {
            ClassLoader cl = (ClassLoader)Lookup.getDefault().lookup(ClassLoader.class);
            Class<?> toolbarPoolClass = cl.loadClass("org.openide.awt.ToolbarPool");
            Object toolbarPool = toolbarPoolClass.getMethod("getDefault", new Class[0]).invoke(toolbarPoolClass, new Object[0]);
            Object[] toolBars = (Object[])toolbarPool.getClass().getMethod("getToolbars", new Class[0]).invoke(toolbarPool, new Object[0]);
            Class<?> cToolbarConfiguration = cl.loadClass("org.netbeans.core.windows.view.ui.toolbars.ToolbarConfiguration");
            Object toolbarConfig = cToolbarConfiguration.getMethod("findConfiguration", String.class).invoke(cToolbarConfiguration, "Standard");
            Class<?> toolbarClass = cl.loadClass("org.openide.awt.Toolbar");
            if (toolBars != null) {
                for (int i = 0; i < toolBars.length; ++i) {
                    JToolBar toolbar = (JToolBar)toolBars[i];
                    String name = toolbar.getName();
                    boolean visible = false;
                    if (!Extension.isDataModeler()) {
                        boolean bl = visible = !DM_TOOLBARS_LIST.contains(name);
                    }
                    if (toolbarName != null && toolbarName.equalsIgnoreCase(name)) {
                        visible = true;
                    } else if ("QuickSearch".equalsIgnoreCase(name)) {
                        visible = true;
                    }
                    toolbar.setVisible(visible);
                    if (toolbarConfig == null) continue;
                    toolbarConfig.getClass().getMethod("setToolbarVisible", toolbarClass, Boolean.TYPE).invoke(toolbarConfig, toolbar, visible);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("ApplicationView.showToolbar:", ex);
        }
    }

    public void updateIdeToolbar(String toolbarName) {
        if (!this.isUpdating) {
            this.isUpdating = true;
            try {
                ApplicationView.showToolbar(toolbarName);
            }
            finally {
                this.isUpdating = false;
            }
        }
    }

    public void openMainDiagrams() {
        ApplicationView.log(Messages.getString("ApplicationView.BuildingDiagrams"));
        this.getCurrentDesign().getLogicalDesign().setMainViewVisible(true);
        this.getCurrentDesign().getRelationalDesign().setMainViewVisible(true);
        this.controllers.updateObjectMenu(this.currentDPV);
        if (this.currentDPV != null) {
            this.updateIdeToolbar(this.currentDPV.getToolbarName());
        }
        this.getBrowserPanel().expandToPath(this.getCurrentDesign().getPath());
    }

    public void updateMainToolbar() {
        DMDiagramEditor dmEditor;
        DesignPartView dpv;
        Editor editor = EditorManager.getEditorManager().getCurrentEditor();
        if (editor != null && editor instanceof DMDiagramEditor && (dpv = (dmEditor = (DMDiagramEditor)editor).getDesignPartView()) != null) {
            this.currentDPV = dpv;
            this.updateIdeToolbar(dpv.getToolbarName());
        }
    }

    protected int getPreferredIconSize() {
        return 24;
    }

    public void clearTree() {
        if (this.browserPanel != null) {
            this.browserPanel.clearTree();
        }
    }

    public void deleteSubview() {
        this.getCurrentDPV().getDesignPart().deleteSubview(this.getCurrentDPV());
    }

    public void closeSubview() {
    }

    public void closeSubview(int index) {
    }

    public ControllerSet getControllerSet() {
        return this.controllers;
    }

    public void clearDPView(DesignPartView dpv) {
        Diagram diagram = dpv.getWorkSpace();
        diagram.removeAll();
    }

    public ControllerApplication getController() {
        if (this.appController == null) {
            this.appController = new ControllerApplication(this);
            this.appController.setName("Application");
        }
        return this.appController;
    }

    public ControllerStorage getControllerStorage() {
        if (this.sharedStorageController == null) {
            this.sharedStorageController = new ControllerStorage(this);
            this.sharedStorageController.setName("_Physical");
        }
        return this.sharedStorageController;
    }

    public AbstractController getRelationalController() {
        return this.getCurrentDesign().getRelationalDesign().getMainView().getController();
    }

    public AbstractController getLogicalController() {
        return this.getCurrentDesign().getLogicalDesign().getMainView().getController();
    }

    public Design getCurrentDesign() {
        return this.currentDesign;
    }

    public void setCurrentDesign(Design design) {
        this.currentDesign = design;
    }

    public GUIConfiguration getConfiguration() {
        return this.guiConfig;
    }

    public JFrame getFrame() {
        if (frame == null && ApplicationView.isGUIMode()) {
            frame = Ide.getMainWindow();
        }
        return frame;
    }

    public void synchronizeTitle() {
        StringBuffer title = new StringBuffer();
        title.append(this.getMDConfiguration().get("appName"));
        title.append(" - ");
        title.append(this.getCurrentDesign().getFileName());
        this.getFrame().setTitle(title.toString());
        this.updateDesignRules(!this.getCurrentDesign().isReadOnly());
    }

    public void clearTitle() {
        StringBuffer title = new StringBuffer();
        title.append(this.getMDConfiguration().get("appName"));
        this.getFrame().setTitle(title.toString());
        this.setDesignName(this.getCurrentDesign().getName());
        this.updateDesignRules(!this.getCurrentDesign().isReadOnly());
    }

    public DDLViewer getDDLViewer() {
        if (this.ddlViewer == null) {
            this.ddlViewer = new DDLViewer(this);
        }
        return this.ddlViewer;
    }

    public void putOnDDLViewer(Object object) {
        if (this.getDDLViewer().isDialogVisible()) {
            this.getDDLViewer().setDDLObject(object);
        }
    }

    public void setDDLViewerVisible(boolean value) {
        this.setDDLViewerVisible(value, false);
    }

    public void setDDLViewerVisible(boolean value, boolean hive_ddl) {
        try {
            Object object = null;
            if (value) {
                Object[] objects;
                if (this.getCurrentDPV() != null) {
                    Object selected;
                    if (this.getCurrentDPV().getDesignPart() instanceof RelationalDesign && (objects = this.getCurrentDPV().getSelectedObjects()).length > 0) {
                        this.getDDLViewer().ddlPreview(objects, (RelationalDesign)this.getCurrentDPV().getDesignPart(), null, hive_ddl);
                        this.getDDLViewer().setDialogVisible(true);
                        return;
                    }
                    if (this.getCurrentDPV().getCurrentSelection() != null && ((selected = this.getCurrentDPV().getCurrentSelection().getSelectedObject()) instanceof Table || selected instanceof TableView || selected instanceof Index)) {
                        object = selected;
                    }
                }
                if (object == null && this.getCurrentDPV() != null) {
                    objects = this.getCurrentDPV().getSelectedObjects();
                    for (int i = 0; i < objects.length; ++i) {
                        Object selected = objects[i];
                        if (!(selected instanceof Table) && (hive_ddl || !(selected instanceof TableView) && !(selected instanceof Index))) continue;
                        object = selected;
                        break;
                    }
                }
                if (object != null) {
                    this.getDDLViewer().setDDLObject(object, hive_ddl);
                }
            }
            if (object == null) {
                String message = Messages.getString("ApplicationView.msgPreviewDDL");
                JOptionPane.showMessageDialog((Component)Ide.getMainWindow(), message);
            }
            if (object != null && value) {
                this.getDDLViewer().setDialogVisible(true);
            } else {
                this.getDDLViewer().setDialogVisible(false);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error in DDL Preview", e);
        }
    }

    public DDLFileMakerEditor getDDLFileMakerEditor(RelationalDesign relationalDesign) {
        Map<RelationalDesign, DDLFileMakerEditor> map = this.getDdlFileMakerEditorMap();
        DDLFileMakerEditor ddlFileMakerEditor = map.get(relationalDesign);
        if (ddlFileMakerEditor == null) {
            ddlFileMakerEditor = new DDLFileMakerEditor(this, relationalDesign);
            map.put(relationalDesign, ddlFileMakerEditor);
        }
        ddlFileMakerEditor.clearAllEdits();
        ddlFileMakerEditor.updateRDBMSSitesComboBox();
        ddlFileMakerEditor.getStorageDesignCombo().setSelectedItem(relationalDesign.getSelectedRDBMSSite());
        ddlFileMakerEditor.updateDesignSubViewComboBox();
        this.initLineTerminator();
        return ddlFileMakerEditor;
    }

    public void removeDDLFileMakerEditorFor(RelationalDesign rd) {
        Map<RelationalDesign, DDLFileMakerEditor> map = this.getDdlFileMakerEditorMap();
        DDLFileMakerEditor editor = map.get(rd);
        if (editor != null) {
            map.remove(rd);
            editor.setDialogVisible(false);
        }
    }

    public void removeDDLFileMakerEditorsFor(Design design) {
        RelationalDesign[] rds;
        Map<RelationalDesign, DDLFileMakerEditor> map = this.getDdlFileMakerEditorMap();
        for (RelationalDesign rd : rds = map.keySet().toArray(new RelationalDesign[0])) {
            DDLFileMakerEditor editor;
            if (rd.getDesign() != design || (editor = map.get(rd)) == null) continue;
            map.remove(rd);
            editor.setDialogVisible(false);
        }
    }

    public void removeDDLFileMakerEditor(DDLFileMakerEditor ddlEditor) {
        Map<RelationalDesign, DDLFileMakerEditor> map = this.getDdlFileMakerEditorMap();
        RelationalDesign rd = null;
        for (Map.Entry<RelationalDesign, DDLFileMakerEditor> entry : map.entrySet()) {
            if (!entry.getValue().equals(ddlEditor)) continue;
            rd = entry.getKey();
            break;
        }
        if (rd != null) {
            map.remove(rd);
        }
    }

    public JMenuBar getJMenuBar() {
        if (this.jmenuBar == null) {
            this.jmenuBar = this.controllers.getJMenuBar();
        }
        return this.jmenuBar;
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        try {
            DesignPartView.NamedTabbedPane obj = (DesignPartView.NamedTabbedPane)event.getSource();
            DesignPartView dpv = (DesignPartView)obj.getSelectedComponent();
            this.editorChanged(dpv);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void editorChanged(DesignPartView dpv) {
        if (!loading) {
            if (dpv instanceof DesignPartView) {
                this.currentDPV = dpv;
                this.setCurrentDesign(this.currentDPV.getDesign());
                if (this.currentDPV.getDesignPart() instanceof DataFlowDesign) {
                    this.getCurrentDesign().getProcessModel().setDataFlowDesign((DataFlowDesign)this.currentDPV.getDesignPart());
                } else if (this.currentDPV.getDesignPart() instanceof MultidimensionalDesign) {
                    this.getCurrentDesign().setMultidimensionalDesign((MultidimensionalDesign)this.currentDPV.getDesignPart());
                }
                if (this.currentDPV != null) {
                    this.updateIdeToolbar(this.currentDPV.getToolbarName());
                }
                this.selectionChanged(this.currentDPV.getCurrentSelection());
                this.setNavigatorPanel(this.currentDPV.getNavigatorPanel());
            } else {
                this.currentDPV = null;
                ApplicationView.clearToolbar();
            }
            this.getControllerSet().updateObjectMenu(this.currentDPV);
            this.updateActions();
        }
    }

    public void updateDesignRules(boolean enable) {
    }

    public void updateActionsFor(DesignPart dp) {
        DesignPartView dpv;
        DesignPartViewPlaceHolder ph;
        dp.getMainView().getController().updateActions();
        Iterator it = dp.getDesignSubviews().iterator();
        while (it.hasNext()) {
            ph = (DesignPartViewPlaceHolder)it.next();
            dpv = ph.getDesignPartView();
            dpv.getController().updateActions();
            Iterator svit = dpv.getDisplays().iterator();
            while (svit.hasNext()) {
                DesignPartViewPlaceHolder phd = (DesignPartViewPlaceHolder)svit.next();
                DesignPartView dpvd = phd.getDesignPartView();
                dpvd.getController().updateActions();
            }
        }
        it = dp.getMainView().getDisplays().iterator();
        while (it.hasNext()) {
            ph = (DesignPartViewPlaceHolder)it.next();
            dpv = ph.getDesignPartView();
            dpv.getController().updateActions();
        }
    }

    public void updateActions() {
        try {
            this.updateActionsFor(this.getCurrentDesign().getLogicalDesign());
            for (DesignPart dp : this.getCurrentDesign().getRelationalDesigns()) {
                this.updateActionsFor(dp);
            }
            this.updateActionsFor(this.getCurrentDesign().getDataTypesDesign());
            for (DesignPart dp : this.getCurrentDesign().getMultidimensionalDesigns()) {
                this.updateActionsFor(dp);
            }
            for (DesignPart dp : this.getCurrentDesign().getProcessModel().getDataFlowDesigns()) {
                this.updateActionsFor(dp);
            }
            Iterator it = this.getCurrentDesign().getProcessModel().getTransformationPackageSet().iterator();
            while (it.hasNext()) {
                TransformationPackage tp = (TransformationPackage)it.next();
                for (TransformationTask tt : tp.getTransformationTaskSet()) {
                    this.updateActionsFor(tt);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public DPVLogical getDPVLogical() {
        return (DPVLogical)this.getCurrentDesign().getLogicalDesign().getMainView();
    }

    public DPVRelational getDPVRelational() {
        return (DPVRelational)this.getCurrentDesign().getRelationalDesign().getMainView();
    }

    public DesignPartView getCurrentDPV() {
        return this.currentDPV;
    }

    public void setCurrentDPV(DesignPartView dpv) {
        if (dpv.getContext() != null && dpv.activateEditor()) {
            return;
        }
        if (dpv.canCreateDisplays()) {
            Editor editor = DMDiagramEditor.openNewDiagram(dpv.getTabbedPane());
            if (editor != null) {
                dpv.setContext(editor.getContext());
            }
        } else {
            Editor editor = DMDiagramEditor.openNewDiagram(dpv);
            if (editor != null) {
                dpv.setContext(editor.getContext());
            }
        }
    }

    @Override
    public void selectionChanged(SelectableObject selected) {
        if (!loading && selected != null && selected.getSelectedObject() != null) {
            this.putOnDDLViewer(selected.getSelectedObject());
            this.setFixedStatusMessage(selected.getSelectedObject().toString());
            this.sharedStorageController.selectionChanged(selected);
            if (this.getCurrentDPV() != null) {
                this.getCurrentDPV().getController().selectionChanged(selected);
            }
        } else {
            this.clearStatusMessage();
        }
        this.getController().updateMenus();
    }

    @Override
    public void setFixedStatusMessage(String message) {
        this.statusBar.setFixedStatusMessage(message);
    }

    @Override
    public void setTempStatusMessage(String message, int timeoutMillis) {
        this.statusBar.setTempStatusMessage(message, timeoutMillis);
    }

    @Override
    public void setTempStatusMessage(String message) {
        this.statusBar.setTempStatusMessage(message, 5000);
    }

    @Override
    public void clearStatusMessage() {
        this.statusBar.clearStatusMessage();
    }

    @Override
    public Map getGraphicalPropsFor(DesignObject object) {
        TopView tv;
        DesignPartView dpv = this.getDPVFor(object);
        TreeMap<String, String> map = new TreeMap<String, String>();
        if (!(dpv == null || (tv = object.getTopView()) == null || tv instanceof TVRelation || tv instanceof TVArc || tv instanceof TVFlow || tv instanceof TVFKRelation)) {
            Rectangle bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
            map.put("x", String.valueOf(bounds.getX()));
            map.put("y", String.valueOf(bounds.getY()));
            map.put("w", String.valueOf(bounds.getWidth()));
            map.put("h", String.valueOf(bounds.getHeight()));
            map.put(USE_CUSTOM_FORMAT, Boolean.toString(tv.useCustomFormat()));
            map.put(USE_DEFAULT_COLOR, Boolean.toString(tv.useDefaultColor()));
            map.put(BACKGROUND_COLOR, tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
            map.put(FOREGROUND_COLOR, tv.getForegroundColor() != null ? Integer.toString(tv.getForegroundColor().getRGB()) : NULL_STR);
        }
        return map;
    }

    @Override
    public Map getGraphicalPropsFor(TopView tv) {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Rectangle bounds = tv.getCellView() != null ? tv.getCellView().getBounds().getBounds() : tv.getBounds();
        map.put("x", String.valueOf(bounds.getX()));
        map.put("y", String.valueOf(bounds.getY()));
        map.put("w", String.valueOf(bounds.getWidth()));
        map.put("h", String.valueOf(bounds.getHeight()));
        map.put(USE_CUSTOM_FORMAT, Boolean.toString(tv.useCustomFormat()));
        map.put(USE_DEFAULT_COLOR, Boolean.toString(tv.useDefaultColor()));
        map.put(BACKGROUND_COLOR, tv.getBackgroundColor() != null ? Integer.toString(tv.getBackgroundColor().getRGB()) : NULL_STR);
        map.put(FOREGROUND_COLOR, tv.getForegroundColor() != null ? Integer.toString(tv.getForegroundColor().getRGB()) : NULL_STR);
        return map;
    }

    @Override
    public void setGraphicalPropsFor(String objectID, Map map) {
        DesignObject object = this.getCurrentDesign().getDesignObject(objectID);
        if (object != null) {
            this.setGraphicalPropsFor(object, map);
        }
    }

    @Override
    public String getViewType() {
        return "SwingUI";
    }

    @Override
    public void setGraphicalPropsFor(DesignObject object, Map map) {
        TopView tv = object.getTopView();
        if (tv != null) {
            try {
                Object useDefColorObj;
                Object useCustomFormatObj;
                String xString = (String)map.get("x");
                String yString = (String)map.get("y");
                String wString = (String)map.get("w");
                String hString = (String)map.get("h");
                double x = -1.0;
                double y = -1.0;
                double h = -1.0;
                double w = -1.0;
                if (xString != null && yString != null) {
                    x = Double.parseDouble(xString);
                    y = Double.parseDouble(yString);
                }
                if (wString != null && hString != null) {
                    h = Double.parseDouble(hString);
                    w = Double.parseDouble(wString);
                }
                if (x > -1.0 && y > -1.0 && h > -1.0 && w > -1.0) {
                    if (tv.getCellView() != null) {
                        tv.getCellView().setNewBounds(new Rectangle((int)x, (int)y, (int)w, (int)h));
                    } else {
                        tv.setBounds(new Rectangle((int)x, (int)y, (int)w, (int)h));
                    }
                }
                if ((useCustomFormatObj = map.get(USE_CUSTOM_FORMAT)) != null) {
                    boolean useCustomFormat = Boolean.valueOf((String)useCustomFormatObj);
                    tv.setUseCustomFormat(useCustomFormat);
                }
                if ((useDefColorObj = map.get(USE_DEFAULT_COLOR)) != null) {
                    boolean useDefColor = Boolean.valueOf((String)useDefColorObj);
                    tv.setUseDefaultColor(useDefColor);
                    if (!useDefColor) {
                        Object foregroundColorObj;
                        Object backgroundColorObj = map.get(BACKGROUND_COLOR);
                        if (backgroundColorObj != null && !NULL_STR.equalsIgnoreCase((String)backgroundColorObj)) {
                            Color backgroundColor = new Color(Integer.parseInt((String)backgroundColorObj), true);
                            tv.setBackgroundColor(backgroundColor);
                        }
                        if ((foregroundColorObj = map.get(FOREGROUND_COLOR)) != null && !NULL_STR.equalsIgnoreCase((String)foregroundColorObj)) {
                            Color foregroundColor = new Color(Integer.parseInt((String)foregroundColorObj), true);
                            tv.setForegroundColor(foregroundColor);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Graphical info problem: " + e);
            }
        }
    }

    @Override
    public void setGraphicalPropsFor(TopView tv, Map map) {
        if (tv != null) {
            try {
                Object useDefColorObj;
                Object useCustomFormatObj;
                String xString = (String)map.get("x");
                String yString = (String)map.get("y");
                String wString = (String)map.get("w");
                String hString = (String)map.get("h");
                double x = -1.0;
                double y = -1.0;
                double h = -1.0;
                double w = -1.0;
                if (xString != null && yString != null) {
                    x = Double.parseDouble(xString);
                    y = Double.parseDouble(yString);
                }
                if (wString != null && hString != null) {
                    h = Double.parseDouble(hString);
                    w = Double.parseDouble(wString);
                }
                if (x > -1.0 && y > -1.0 && h > -1.0 && w > -1.0) {
                    if (tv.getCellView() != null) {
                        tv.getCellView().setNewBounds(new Rectangle((int)x, (int)y, (int)w, (int)h));
                    } else {
                        tv.setBounds(new Rectangle((int)x, (int)y, (int)w, (int)h));
                    }
                }
                if ((useCustomFormatObj = map.get(USE_CUSTOM_FORMAT)) != null) {
                    boolean useCustomFormat = Boolean.valueOf((String)useCustomFormatObj);
                    tv.setUseCustomFormat(useCustomFormat);
                }
                if ((useDefColorObj = map.get(USE_DEFAULT_COLOR)) != null) {
                    boolean useDefColor = Boolean.valueOf((String)useDefColorObj);
                    tv.setUseDefaultColor(useDefColor);
                    if (!useDefColor) {
                        Object foregroundColorObj;
                        Object backgroundColorObj = map.get(BACKGROUND_COLOR);
                        if (backgroundColorObj != null && !NULL_STR.equalsIgnoreCase((String)backgroundColorObj)) {
                            Color backgroundColor = new Color(Integer.parseInt((String)backgroundColorObj), true);
                            tv.setBackgroundColor(backgroundColor);
                        }
                        if ((foregroundColorObj = map.get(FOREGROUND_COLOR)) != null && !NULL_STR.equalsIgnoreCase((String)foregroundColorObj)) {
                            Color foregroundColor = new Color(Integer.parseInt((String)foregroundColorObj), true);
                            tv.setForegroundColor(foregroundColor);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Graphical info problem: " + e);
            }
        }
    }

    protected DesignPartView getDPVFor(DesignObject object) {
        return object.getDesignPart().getMainView();
    }

    public Component getSelectedWorkSpaceComponent() {
        DesignPartView component = this.currentDPV;
        if (component instanceof DesignPartView) {
            DesignPartView view = component;
            return view.getWorkSpace();
        }
        if (component instanceof JTabbedPane) {
            Component dp = ((JTabbedPane)((Object)component)).getSelectedComponent();
            if (dp instanceof DesignPartView) {
                DesignPartView view = (DesignPartView)dp;
                return view.getWorkSpace();
            }
            return dp;
        }
        return component;
    }

    public Dimension getSelectedWorkSpaceSize() {
        if (this.currentDPV != null) {
            Dimension result;
            DesignPartView component = this.currentDPV;
            if (component instanceof DesignPartView) {
                DesignPartView view = component;
                result = view.getWorkSpaceUsedSize();
            } else if (component instanceof JTabbedPane) {
                Component dp = ((JTabbedPane)((Object)component)).getSelectedComponent();
                if (dp instanceof DesignPartView) {
                    DesignPartView view = (DesignPartView)dp;
                    result = view.getWorkSpaceUsedSize();
                } else {
                    result = dp.getSize();
                }
            } else {
                result = component.getSize();
            }
            result = new Dimension(result.width + 20, result.height + 20);
            return result;
        }
        return new Dimension(0, 0);
    }

    public ApplicationCloser getApplicationCloser() {
        if (this.applicationCloser == null) {
            this.applicationCloser = new ApplicationCloser();
        }
        return this.applicationCloser;
    }

    public void closeApplication() {
        for (Design design : this.getDesigns()) {
            design.removeDeletedProxies();
        }
        this.getSettings().savePreferences();
        AbstractRepositoryManager dbman = this.getDBPersistenceManager().getDBRepositoryManager();
        if (dbman.isConnected()) {
            try {
                dbman.getConnection().close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        closing = true;
        this.getApplicationCloser().doExit();
    }

    public DesignRuleView getDesignRuleView(ModelIDObject model, List objectsList) {
        this.designRuleView = new DesignRuleView(this, model, objectsList);
        return this.designRuleView;
    }

    public void setDesignRuleViewVisible(boolean value, ModelIDObject model, List objectsList) {
        if (model != null) {
            this.getDesignRuleView(model, objectsList).getDialog().setVisible(true);
            this.loadAllDesignRuleHandlers = false;
        } else {
            RelationalDesign relDesign = null;
            if (this.getCurrentDesign().getRelationalDesigns().size() > 0) {
                relDesign = this.selectRelationalDesign();
                this.loadAllDesignRuleHandlers = true;
            }
            this.getDesignRuleView(relDesign, new ArrayList()).getDialog().setVisible(true);
        }
    }

    public DesignRuleManager getDesignRuleManager(ModelIDObject model, List objectsList) {
        if (this.designRuleManager == null) {
            this.designRuleManager = new DesignRuleManager(this.getCurrentDesign(), model, this, objectsList, this.loadAllDesignRuleHandlers);
        } else if (model != null) {
            this.designRuleManager.setModel(model);
        }
        return this.designRuleManager;
    }

    public CustomDesignRulesManager getCustomDesignRulesManager() {
        return this.customDesignRulesManager;
    }

    public CustomDesignRulesManager getCustomDesignRulesManager(RelationalDesign relDesign) {
        this.customDesignRulesManager = new CustomDesignRulesManager(this, relDesign, this.getScriptEngineManager());
        return this.customDesignRulesManager;
    }

    public void setCustomDesignRulesManagerVisible(boolean value) {
        RelationalDesign relDesign = this.selectRelationalDesign();
        if (relDesign != null) {
            this.getCustomDesignRulesManager(relDesign).getDialog().setVisible(true);
        }
    }

    public CustomLibrariesManager getCustomLibrariesManager() {
        this.customLibrariesManager = new CustomLibrariesManager(this);
        return this.customLibrariesManager;
    }

    public void setCustomLibrariesManagerVisible(boolean value) {
        this.getCustomLibrariesManager().getDialog().setVisible(true);
    }

    public CustomTransformationsManager getTransformationsManager() {
        return this.transformationsManager;
    }

    public CustomTransformationsManager getTransformationsManager(RelationalDesign relDesign) {
        this.transformationsManager = new CustomTransformationsManager(this, relDesign, this.getScriptEngineManager());
        return this.transformationsManager;
    }

    public DDLTransformationsScriptsDialog getDDLTransformationsScriptsDialog(RelationalDesign relDesign) {
        this.ddlTransformationsScriptsDialog = new DDLTransformationsScriptsDialog(this, relDesign, this.getScriptEngineManager());
        return this.ddlTransformationsScriptsDialog;
    }

    public void setTransformationsManagerVisible(boolean value) {
        RelationalDesign relDesign = this.selectRelationalDesign();
        if (relDesign != null) {
            this.getTransformationsManager(relDesign).getDialog().setVisible(true);
        }
    }

    public void setDDLTransformationsScriptsDialogVisible(boolean value) {
        RelationalDesign relDesign = this.selectRelationalDesign();
        if (relDesign != null) {
            this.getDDLTransformationsScriptsDialog(relDesign).getDialog().setVisible(true);
        }
    }

    public MDBAction getActionByName(String name) {
        return this.controllers.getActionByName(name);
    }

    public boolean closeStorageDesign(StorageDesign sd) {
        if (!sd.isTempModel() && (sd.isDirty() || sd.hasDirtyStorableObjects())) {
            int result = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ApplicationView.SavePhysicalModel"), sd.getName()), Messages.getString("ApplicationView.SaveDesign"), 1);
            switch (result) {
                case 0: {
                    ApplicationView.log(MessageFormat.format(Messages.getString("ApplicationView.SavingPhysicalModel"), sd.getName()));
                    if (!BrowserPanel.isPersistenceConsistent(sd.getDesign())) break;
                    sd.save();
                    sd.setDirty(false);
                    break;
                }
                case 1: {
                    sd.setDirty(false);
                    break;
                }
                case 2: {
                    return false;
                }
                default: {
                    return false;
                }
            }
        }
        return true;
    }

    public static void log(String s) {
        if (canLogging) {
            try {
                String dateTime = df.format(new Date(System.currentTimeMillis()));
                StringBuffer buffer = new StringBuffer(dateTime);
                buffer.append(" - ").append(s).append('\n');
                LogManager.getIdeLogWindow().log((Object)buffer.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void logMessage(String s) {
        try {
            String dateTime = df.format(new Date(System.currentTimeMillis()));
            StringBuffer buffer = new StringBuffer(dateTime);
            buffer.append(" - ").append(s).append('\n');
            LogManager.getIdeLogWindow().log((Object)buffer.toString());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public Logger getFileLogger() {
        if (fileLogger == null) {
            fileLogger = new Logger(RuleHandler.class);
        }
        return fileLogger;
    }

    public void centerDesign() {
        this.getDPVLogical().centerDesign();
        for (int i = 0; i < this.getCurrentDesign().getRelationalDesigns().size(); ++i) {
            ((RelationalDesign)this.getCurrentDesign().getRelationalDesigns().getElement(i)).getMainView().centerDesign();
        }
    }

    public String getDesignName() {
        return this.getCurrentDesign().getFileName();
    }

    public void setDesignName(String designName) {
        this.getCurrentDesign().setFileName(designName);
    }

    public boolean deleteDesign(String dsnName) {
        ApplicationView.log(MessageFormat.format(Messages.getString("ApplicationView.DeleteDesign"), dsnName));
        return this.getXMLTransformationManager().deleteDesign(this.getCurrentDesign().getDesignPath(), dsnName);
    }

    public boolean designExists(String dsnName) {
        return this.getXMLTransformationManager().designExists(this.getCurrentDesign().getDesignPath(), dsnName);
    }

    public RelationalDesign selectRelationalDesign() {
        if (this.getDesigns().size() == 1 && this.getCurrentDesign().getRelationalDesigns().size() == 1) {
            return this.getCurrentDesign().getRelationalDesign();
        }
        return SelectRelationalModelDialog.showDialog(this);
    }

    public Design selectDesign() {
        Design[] dsns = (Design[])this.getDesigns().toArray();
        if (dsns.length > 1) {
            return SelectDesignsDialog.showDialog(this);
        }
        if (dsns.length == 1) {
            return dsns[0];
        }
        return null;
    }

    public Design selectFirstDesign() {
        Design[] dsns = (Design[])this.getDesigns().toArray();
        if (dsns.length > 0) {
            return dsns[0];
        }
        return null;
    }

    public DataFlowDesign selectDataFlowDiagram() {
        Iterator it = this.getCurrentDesign().getProcessModel().getDataFlowDesigns().iterator();
        ArrayList<DataFlowDesign> col = new ArrayList<DataFlowDesign>();
        while (it.hasNext()) {
            DataFlowDesign dfd = (DataFlowDesign)it.next();
            if (!dfd.isTopLevel()) continue;
            col.add(dfd);
        }
        if (col.size() == 0) {
            return null;
        }
        if (col.size() == 1) {
            return (DataFlowDesign)col.get(0);
        }
        Object[] dfds = col.toArray();
        Object choice = JOptionPane.showInputDialog((Component)Ide.getMainWindow(), Messages.getString("ApplicationView.SelectDataFlowDiagram"), Messages.getString("ApplicationView.DataFlowDiagrams"), 3, this.getConfiguration().getIcon("DESIGN_ICON", this.getPreferredIconSize()), dfds, this.getCurrentDesign().getProcessModel().getDataFlowDesign());
        if (choice != null && choice instanceof DataFlowDesign) {
            return (DataFlowDesign)choice;
        }
        return null;
    }

    public URL getUserHomeDirectory() {
        URL url = URLFactory.newDirURL((String)Ide.getTrueUserHomeDirectory());
        return URLFileSystem.exists((URL)url) ? url : null;
    }

    public String selectDesignName(String defaultName) {
        try {
            int status;
            URLFilter fileFilter = new URLFilter(){

                public boolean accept(URL url) {
                    File file = new File(url.getPath());
                    return file.getName().toLowerCase().endsWith(".dmd") || file.getName().toLowerCase().endsWith(".dmdz") || file.getName().toLowerCase().endsWith(".xml") || file.isDirectory();
                }

                public String toString() {
                    return DESIGN_URL_FILTER_DESC;
                }
            };
            URLFileChooser fileChooser = new URLFileChooser();
            fileChooser.clearChooseableURLFilters();
            fileChooser.setSelectionScope(0);
            fileChooser.setSelectionMode(0);
            fileChooser.setShowJarsAsDirs(false);
            fileChooser.setURLFilter(fileFilter);
            fileChooser.setPathContext("dataModeler_SaveDesign");
            String lastDir = this.getSettings().getDefaultDesignsPath();
            if (lastDir != null) {
                fileChooser.setSelectedURL(URLFactory.newDirURL((String)lastDir));
            } else {
                URL url = this.getUserHomeDirectory();
                if (url != null) {
                    fileChooser.setSelectedURL(url);
                }
            }
            if (defaultName != null) {
                fileChooser.setFileNameURL(defaultName + ".dmd");
            }
            if ((status = fileChooser.showSaveDialog((Component)Ide.getMainWindow(), Messages.getString("ApplicationView.SaveDesign"))) == 0) {
                File selected = new File(fileChooser.getSelectedURL().getPath());
                this.getCurrentDesign().setDesignPath(selected.getParentFile().getAbsolutePath());
                String fileName = selected.getName();
                if (fileName.endsWith(".dmdz")) {
                    this.getCurrentDesign().setCompressedDesign(true);
                }
                return FileUtils.removeExt(fileName);
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error select design file ", e);
            return null;
        }
    }

    public boolean overwriteDesign(String name) {
        if (Extension.isSVNExtensionLoaded() && this.pathIsVersioned(new File(this.getCurrentDesign().getDesignPath(), name).getAbsolutePath())) {
            MessageDialogs.showWarningMessage(Messages.getString("ApplicationView.CanNotUseVersionedDir"));
            return false;
        }
        if (!this.checkDesignNameUnique(name)) {
            int choiceOverwrite = JOptionPane.showConfirmDialog((Component)Ide.getMainWindow(), MessageFormat.format(Messages.getString("ApplicationView.AllreadyExistsOverwrite"), name), Messages.getString("ApplicationView.DesignAlreadyExists"), 0, 3);
            switch (choiceOverwrite) {
                case 0: {
                    return true;
                }
                case 1: {
                    return false;
                }
            }
            return false;
        }
        return true;
    }

    public DDLExceptionList getDDLExceptionList() {
        if (this.ddlExceptionList == null) {
            this.ddlExceptionList = new DDLExceptionList();
        }
        return this.ddlExceptionList;
    }

    public void addRecent(String designName, String designPath) {
        if (!this.getSettings().recentDesignExists(designName, designPath)) {
            ControllerApplication.Recent action = new ControllerApplication.Recent(this.getController());
            action.setDesignName(designName);
            action.setDesignPath(designPath);
            this.getSettings().addRecent(action);
        }
    }

    public boolean isImporting() {
        return importing;
    }

    public void setImporting(boolean importing) {
        ApplicationView.importing = importing;
        if (ApplicationView.isGUIMode()) {
            this.enableControls(!importing);
        }
    }

    public boolean isMerging() {
        return merging;
    }

    public void setMerging(boolean merging) {
        ApplicationView.merging = merging;
    }

    public void enableControls(boolean enable) {
        this.getControllerSet().getMenuStructure().enableActions(enable);
        if (this.browserPanel != null) {
            this.browserPanel.getJTree().setEnabled(enable);
        }
    }

    public BrowserPanel getBrowserPanel() {
        if (this.browserPanel == null) {
            this.browserPanel = new BrowserPanel(this);
            this.browserPanel.getJTree().getModel().addTreeModelListener(new MyTreeModelListener());
        }
        return this.browserPanel;
    }

    public JDialog getNavigator() {
        if (this.navigator == null) {
            this.navigator = new JDialog(this.getFrame());
            this.navigator.setTitle(Messages.getString("ApplicationView.Navigator"));
            this.navigator.setSize(new Dimension(280, 210));
            this.navigator.setLocationRelativeTo(this.getFrame());
        }
        return this.navigator;
    }

    public JPanel getNavigatorPanel() {
        if (this.navPanel == null) {
            this.navPanel = new JPanel(new BorderLayout());
            if (this.currentDPV != null) {
                this.setNavigatorPanel(this.currentDPV.getNavigatorPanel());
            }
        }
        return this.navPanel;
    }

    public void setNavigatorPanel(JPanel navigatorPanel) {
        this.getNavigatorPanel().removeAll();
        this.getNavigatorPanel().add(navigatorPanel);
        if (this.getNavigatorPanel().getParent() != null && this.getNavigatorPanel().getParent() instanceof JPanel) {
            ((JPanel)this.getNavigatorPanel().getParent()).updateUI();
        } else {
            this.getNavigatorPanel().updateUI();
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void savePageSetupSettings(Config conf) {
        Settings settings = this.getSettings();
        settings.setPageFormat(conf.getPageFormat());
        settings.setPrinterName(conf.getPrinterName());
        settings.setPaperMediaName(conf.getPaperMediaName());
        this.updateDiagramsBackground();
    }

    public void updateDiagramsBackground() {
        this.getCurrentDesign().getDataTypesDesign().getMainView().updateBackground();
        this.getCurrentDesign().getLogicalDesign().getMainView().updateBackground();
        Iterator it = this.getCurrentDesign().getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            dpvph.getDesignPartView().updateBackground();
        }
        for (RelationalDesign pd : this.getCurrentDesign().getRelationalDesigns()) {
            pd.getMainView().updateBackground();
            Iterator it2 = pd.getDesignSubviews().iterator();
            while (it2.hasNext()) {
                DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it2.next();
                dpvph.getDesignPartView().updateBackground();
            }
        }
        for (DataFlowDesign dfd : this.getCurrentDesign().getProcessModel().getDataFlowDesigns()) {
            dfd.getMainView().updateBackground();
        }
        for (MultidimensionalDesign mdd : this.getCurrentDesign().getMultidimensionalDesigns()) {
            mdd.getMainView().updateBackground();
        }
    }

    public void updateSettings(boolean applyNotation, boolean applyBoxInbox) {
        this.getCurrentDesign().getDataTypesDesign().getMainView().updateSettings(applyNotation, applyBoxInbox);
        this.getCurrentDesign().getLogicalDesign().getMainView().updateSettings(applyNotation, applyBoxInbox);
        Iterator it = this.getCurrentDesign().getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            dpvph.getDesignPartView().updateSettings(applyNotation, applyBoxInbox);
        }
        for (RelationalDesign pd : this.getCurrentDesign().getRelationalDesigns()) {
            pd.getMainView().updateSettings(applyNotation, applyBoxInbox);
            Iterator it2 = pd.getDesignSubviews().iterator();
            while (it2.hasNext()) {
                DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it2.next();
                dpvph.getDesignPartView().updateSettings(applyNotation, applyBoxInbox);
            }
        }
        for (DataFlowDesign dfd : this.getCurrentDesign().getProcessModel().getDataFlowDesigns()) {
            dfd.getMainView().updateSettings(applyNotation, applyBoxInbox);
        }
        for (MultidimensionalDesign mdd : this.getCurrentDesign().getMultidimensionalDesigns()) {
            mdd.getMainView().updateSettings(applyNotation, applyBoxInbox);
        }
    }

    public void updateLegendsSize() {
        this.getCurrentDesign().getDataTypesDesign().getMainView().updateLegendSize();
        this.getCurrentDesign().getLogicalDesign().getMainView().updateLegendSize();
        Iterator it = this.getCurrentDesign().getLogicalDesign().getDesignSubviews().iterator();
        while (it.hasNext()) {
            DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it.next();
            dpvph.getDesignPartView().updateLegendSize();
        }
        for (RelationalDesign pd : this.getCurrentDesign().getRelationalDesigns()) {
            pd.getMainView().updateLegendSize();
            Iterator it2 = pd.getDesignSubviews().iterator();
            while (it2.hasNext()) {
                DesignPartViewPlaceHolder dpvph = (DesignPartViewPlaceHolder)it2.next();
                dpvph.getDesignPartView().updateLegendSize();
            }
        }
        for (DataFlowDesign dfd : this.getCurrentDesign().getProcessModel().getDataFlowDesigns()) {
            dfd.getMainView().updateLegendSize();
        }
        it = this.getCurrentDesign().getProcessModel().getTransformationPackageSet().iterator();
        while (it.hasNext()) {
            TransformationPackage tp = (TransformationPackage)it.next();
            for (TransformationTask tt : tp.getTransformationTaskSet()) {
                tt.getMainView().updateLegendSize();
            }
        }
        for (MultidimensionalDesign mdd : this.getCurrentDesign().getMultidimensionalDesigns()) {
            mdd.getMainView().updateLegendSize();
        }
    }

    public void exitApplication() {
        Design design = this.getCurrentDesign();
        if (design != null && !design.isNewDesign()) {
            this.getSettings().setLastOpenDesign(this.getCurrentDesign().getStorageName());
            if (this.getCurrentDPV() != null) {
                this.getSettings().setLastOpenDPV(this.getCurrentDPV().getDPVId());
            } else {
                this.getSettings().setLastOpenDPV("");
            }
        } else {
            this.getSettings().setLastOpenDesign("");
            this.getSettings().setLastOpenDPV("");
        }
        this.cancel = false;
        boolean hasCancel = false;
        if (!IS_VIEWER) {
            hasCancel = this.closeAllDesigns(false);
        }
        boolean bl = this.cancel = this.cancel || hasCancel;
        if (!hasCancel) {
            Extension.createFurstRunCheckFile();
            this.closeApplication();
        } else {
            System.gc();
            System.runFinalization();
        }
    }

    public static Object[] checkAndAddDesign(Design design, Object[] list) {
        boolean found = false;
        for (int i = 0; i < list.length; ++i) {
            if (design != list[i]) continue;
            found = true;
            break;
        }
        if (!found) {
            ArrayList<Object> ll = new ArrayList<Object>(list.length + 1);
            ll.add(design);
            for (int i = 0; i < list.length; ++i) {
                ll.add(list[i]);
            }
            return ll.toArray();
        }
        return list;
    }

    public Object[] whatToSave(boolean newDesign) {
        Object[] list = this.getDirtyDesigns(newDesign);
        String message = Messages.getString("ApplicationView.DesignNotSaved");
        return this.whatToSave(list, list, message);
    }

    public Object[] whatToSave(Object[] list, Object[] select, String message) {
        Object[] options = new Object[]{Messages.getString("ApplicationView.SaveSelected"), Messages.getString("ApplicationView.CloseWithoutSave"), Messages.getString("ApplicationView.Cancel")};
        return this.whatToSave(list, select, message, options);
    }

    public Object[] whatToSave(Object[] list, Object[] select, String message, Object[] options) {
        Collection<Object> selected = null;
        selected = select == null ? Collections.EMPTY_SET : Arrays.asList(select);
        if (list != null && list.length > 0) {
            JPanel panel = new JPanel(new GridLayout(0, 1));
            JCheckBox[] choices = new JCheckBox[list.length];
            int height = list.length <= 3 ? 90 : (list.length <= 6 ? 130 : 200);
            for (int i = 0; i < list.length; ++i) {
                choices[i] = new JCheckBox(list[i].toString(), selected.contains(list[i]));
                panel.add(choices[i]);
            }
            this.cancel = false;
            JScrollPane sp = new JScrollPane(panel);
            sp.setPreferredSize(new Dimension(300, height));
            int messageType = !Extension.isExtension ? 1 : 0;
            int option = JOptionPane.showOptionDialog(this.getFrame(), new Object[]{message, sp}, MessageFormat.format(Messages.getString("ApplicationView.SaveDesignName"), this.getCurrentDesign().getName()), messageType, 3, null, options, options[0]);
            if (option == 0) {
                ArrayList<Object> toSave = new ArrayList<Object>();
                for (int i = 0; i < choices.length; ++i) {
                    if (!choices[i].isSelected()) continue;
                    toSave.add(list[i]);
                }
                if (!Extension.isExtension) {
                    this.getFrame().setDefaultCloseOperation(0);
                }
                return toSave.toArray();
            }
            if (option == 2 || option == -1) {
                this.cancel = true;
                if (!Extension.isExtension) {
                    this.getFrame().setDefaultCloseOperation(0);
                }
                return null;
            }
            if (!Extension.isExtension) {
                this.getFrame().setDefaultCloseOperation(0);
            }
            return null;
        }
        return new Object[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doSave(Object[] list) {
        try {
            Design design = this.getCurrentDesign();
            if (design.getLoadedVersion() < design.getVersion()) {
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), oracle.dbtools.crest.model.Messages.getString("Design.ThisDesignIsInOldFormat"), oracle.dbtools.crest.model.Messages.getString("Design.Warning"), 0, 1, null, new String[]{oracle.dbtools.crest.model.Messages.getString("Design.OK")}, oracle.dbtools.crest.model.Messages.getString("Design.OK"));
                ApplicationView.getInstance().cancel = true;
                return;
            }
            int lpers = design.getLoadedModelPersistence();
            int cpers = design.getModelPersistence();
            if (Design.PERS_MODEL_MIXED_MODE != lpers && lpers != cpers) {
                JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), oracle.dbtools.crest.model.Messages.getString("Design.ModelPersistenceIsChanged"), oracle.dbtools.crest.model.Messages.getString("Design.Warning"), 0, 1, null, new String[]{oracle.dbtools.crest.model.Messages.getString("Design.OK")}, oracle.dbtools.crest.model.Messages.getString("Design.OK"));
                ApplicationView.getInstance().cancel = true;
                return;
            }
            this.objectsToSave.clear();
            this.objectsToSave.addAll(Arrays.asList(list));
            ProgressDialog monitor = new ProgressDialog(this, "", 0, list.length);
            int oldOperation = this.getCurrentOperation();
            this.setCurrentOperation(2);
            try {
                for (int i = 0; i < list.length; ++i) {
                    monitor.setNote(MessageFormat.format(Messages.getString("ApplicationView.SaveDesignNo"), String.valueOf(list[i])));
                    monitor.setProgress(i);
                    if (this.getCurrentDesign().isLoadFromDB()) {
                        AbstractRepositoryManager rman = this.getDBPersistenceManager().getDBRepositoryManager();
                        rman.writeObject((RepositoryObject)list[i]);
                        continue;
                    }
                    if (list[i] instanceof DesignPart) {
                        ((DesignPart)list[i]).save();
                        continue;
                    }
                    if (list[i] instanceof StorageDesign) {
                        ((StorageDesign)list[i]).save();
                        continue;
                    }
                    if (list[i] instanceof String) {
                        design.saveDesignFile();
                        continue;
                    }
                    if (list[i] instanceof DesignLevelSettings) {
                        design.saveDesignLevelSettings();
                        continue;
                    }
                    if (!(list[i] instanceof DomainSet)) continue;
                    this.getXMLTransformationManager().saveDomains(design);
                }
            }
            finally {
                monitor.close();
                this.setCurrentOperation(oldOperation);
            }
        }
        catch (Exception e) {
            LOGGER.error(e);
            MessageDialogs.showErrorMessage(Messages.getString("ApplicationView.UnableToSavetheDesign"), true);
        }
    }

    private boolean pathIsVersioned(String path) {
        SVNClientHelper svnClientHelper = SVNClientHelper.getInstance();
        return svnClientHelper.isVersioned(path);
    }

    protected boolean checkDesignNameUnique(String name) {
        boolean exists = this.getXMLTransformationManager().designExists(this.getCurrentDesign().getDesignPath(), name);
        return !exists;
    }

    public void loadDesign(String name, String path) {
        ControllerApplication.Recent action = new ControllerApplication.Recent(this.getController());
        action.setDesignName(name);
        action.setDesignPath(path);
        action.actionPerformed(null);
    }

    public DesignPartView createSubview(DesignPartView designPartView) {
        DesignPart dp = designPartView.getDesignPart();
        if (dp.canCreateDPSubview()) {
            DesignPartView dpv = dp.createDesignPartSubView();
            Editor editor = DMDiagramEditor.openNewDiagram(dpv.getTabbedPane());
            dpv.setContext(editor.getContext());
            dpv.setAutoRoute(designPartView.isAutoRoute());
            dpv.setNotation(designPartView.getNotation());
            dpv.setBoxInBox(designPartView.isBoxInBox());
            dpv.setShowNamesOnly(designPartView.isShowNamesOnly());
            dpv.setShowElements(designPartView.showElements());
            dpv.setShowKeyElements(designPartView.showKeyElements());
            dpv.setShowDatatype(designPartView.showDatatype());
            dpv.setShowAllDetails(designPartView.showAllDetails());
            dpv.setShowKeys(designPartView.showKeys());
            dpv.setShowClassificationTypes(designPartView.isShowClassificationTypes());
            dpv.setShowSchemaName(designPartView.showSchemaName());
            dpv.setShowComments(designPartView.showComments());
            return dpv;
        }
        return null;
    }

    public DropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }

    public int getCurrentOperation() {
        return this.currentOperation;
    }

    public void setCurrentOperation(int currentOperation) {
        this.currentOperation = currentOperation;
    }

    public boolean isSelectedForSave(Object object) {
        if (this.getCurrentOperation() != 2) {
            return true;
        }
        return this.objectsToSave.contains(object);
    }

    public static ApplicationView getInstance() {
        if (instance == null) {
            if (instantiating) {
                System.err.println("ERROR: ApplicationView.getInstanse() can not be called during initialization of ApplicationView!!!");
                System.err.println();
                return null;
            }
            instantiating = true;
            try {
                instance = new ApplicationView(null, true);
            }
            finally {
                instantiating = false;
            }
        }
        return instance;
    }

    public static ApplicationView getInstance(DropTargetListener dropTargetListener) {
        if (instance == null) {
            if (instantiating) {
                System.err.println("ERROR: ApplicationView.getInstanse() can not be called during initialization of ApplicationView!!!");
                System.err.println();
                return null;
            }
            instantiating = true;
            try {
                instance = new ApplicationView(dropTargetListener);
            }
            finally {
                instantiating = false;
            }
        }
        return instance;
    }

    public static ApplicationView getInstance(boolean guiMode, String sysDataDir) {
        if (instance == null) {
            if (instantiating) {
                System.err.println("ERROR: ApplicationView.getInstanse() can not be called during initialization of ApplicationView!!!");
                System.err.println();
                return null;
            }
            instantiating = true;
            try {
                instance = new ApplicationView(guiMode, sysDataDir);
            }
            finally {
                instantiating = false;
            }
        }
        return instance;
    }

    public void setDebugMode() {
        String debug = System.getProperty("ide.debugmode");
        if (debug == null || !"true".equalsIgnoreCase(debug)) {
            System.setOut(NullOutputStream.getNullPrintStream());
        } else {
            debugMode = true;
        }
    }

    public void setJDOMparsing() {
        String debug = System.getProperty("dm.JDOMparsing");
        XMLTransformationManager.JDOM_PARSING = debug != null && "true".equalsIgnoreCase(debug);
    }

    public void setPropagateFKAttributeDescription() {
        String debug = System.getProperty("dm.PropagateFKAttributeDescription");
        if (debug != null) {
            PROPAGATE_FKATTRIBUTE_DESCRIPTION = "true".equalsIgnoreCase(debug);
        }
    }

    public void setSensitiveAndMasked() {
        String value = System.getProperty("dm.ShowSensitiveData");
        SHOW_SENSITIVE_DATA = value == null || "true".equalsIgnoreCase(value);
        value = System.getProperty("dm.ShowMaskedData");
        SHOW_MASKED_DATA = value == null || "true".equalsIgnoreCase(value);
    }

    public void setRebuildObjectList() {
        String value = System.getProperty("dm.RebuildObjectList");
        REBUILD_OBJECT_LIST = value == null || "true".equalsIgnoreCase(value);
    }

    public void setBDAPropertySeparator() {
        String value = System.getProperty("dm.BDAPropertySeparator");
        if (value != null) {
            BDA_PROPERTY_SEPARATOR = "space".equalsIgnoreCase(value) ? " " : value;
        }
    }

    public IDGenerator getIDGenerator() {
        if (this.globalGenerator == null) {
            this.globalGenerator = new IDGenerator();
        }
        return this.globalGenerator;
    }

    public MDConfiguration getMDConfiguration() {
        return this.configuration;
    }

    public MDPreferences getPreference() {
        return this.preferences;
    }

    public XMLPersistenceManager getPersistenceManager() {
        if (this.persistenceManager == null) {
            this.persistenceManager = new XMLPersistenceManager(this.configuration);
            this.persistenceManager.setAppView(this);
        }
        return this.persistenceManager;
    }

    public Object[] getDirtyDesigns(boolean newDesign) {
        LogicalDesign logical;
        ArrayList<Object> list = new ArrayList<Object>();
        if (this.getCurrentDesign().isDirty()) {
            list.add(this.getCurrentDesign().getName() + " - design file is changed");
        }
        if (this.getCurrentDesign().getDomainSet().isDirty()) {
            list.add(this.getCurrentDesign().getDomainSet());
        }
        if ((logical = this.getCurrentDesign().getLogicalDesign()).isDirty() || logical.hasDirtyStorableObjects()) {
            list.add(logical);
        }
        for (RelationalDesign pDesign : this.getCurrentDesign().getRelationalDesigns()) {
            if (pDesign.isDirty() || pDesign.hasDirtyStorableObjects()) {
                list.add(pDesign);
            }
            StorageDesign[] storageDesigns = pDesign.getStorageDesignFactory().getOpenStorageDesigns();
            for (int i = 0; i < storageDesigns.length; ++i) {
                if (!storageDesigns[i].isDirty() && !storageDesigns[i].hasDirtyStorableObjects() || !storageDesigns[i].isOpen()) continue;
                list.add(storageDesigns[i]);
            }
        }
        ProcessModel processModel = this.getCurrentDesign().getProcessModel();
        if (processModel.isDirty() && !processModel.isEmpty() || processModel.hasDirtyStorableObjects()) {
            list.add(processModel);
        }
        for (DataFlowDesign dfd : processModel.getDataFlowDesigns()) {
            if (!dfd.isDirty() && !dfd.hasDirtyStorableObjects()) continue;
            list.add(dfd);
        }
        if (this.getCurrentDesign().getDataTypesDesign().isDirty() || this.getCurrentDesign().getDataTypesDesign().hasDirtyStorableObjects()) {
            list.add(this.getCurrentDesign().getDataTypesDesign());
        }
        for (DesignPart dp : this.getCurrentDesign().getMultidimensionalDesigns()) {
            if (!dp.isDirty() && !dp.hasDirtyStorableObjects()) continue;
            list.add(dp);
        }
        if (!newDesign && this.getCurrentDesign().areDesignLevelSettingsChanged()) {
            list.add(0, this.getCurrentDesign().getDesignLevelSettings());
        }
        return list.toArray();
    }

    public DBPersistenceManager getDBPersistenceManager() {
        if (this.dbPersistenceManager == null) {
            this.dbPersistenceManager = new DBPersistenceManager(this);
        }
        return this.dbPersistenceManager;
    }

    public DesignSet getDesigns() {
        return this.designSet;
    }

    private void createDesignSet() {
        this.designSet = new DesignSet(this);
        this.designSet.setName(Messages.getString("ApplicationView.ApplicationView.Designs"));
        this.designSet.setElementDescriptor(Design.class);
        this.designSet.setParent(this);
    }

    public Design getHiddenDesign() {
        return this.hiddenDesign;
    }

    public Design addDesign(boolean openMainDiagrams) {
        this.currentDesign = (Design)this.designSet.createElement(null);
        this.designSet.sortByName();
        if (openMainDiagrams) {
            this.openMainDiagrams();
        }
        this.currentDesign.setDirty(false);
        return this.currentDesign;
    }

    public void removeDesign(Design design) {
        ArrayList temp = new ArrayList(EditorManager.getEditorManager().getAllEditors());
        ArrayList<Editor> editors = new ArrayList<Editor>();
        for (Editor ed : temp) {
            if (!(ed instanceof DMDiagramEditor) || !((DMDiagramEditor)ed).isDiagramForDesign(design)) continue;
            editors.add(ed);
        }
        design.closeAllDiagramsAndClearRefs();
        for (Editor ed : editors) {
            if (!(ed instanceof DMDiagramEditor)) continue;
            ((DMDiagramEditor)ed).clearDiagramForDesign(design);
        }
        this.designSet.remove(design);
        if (this.getDBPersistenceManager().getDBRepositoryManager().getDesign() == design) {
            this.getDBPersistenceManager().nullifyDBRepositoryManager();
        }
        if (this.currentDPV != null && this.currentDPV.getDesign() == design) {
            this.currentDPV = null;
        }
        this.currentDesign = this.designSet.size() > 0 ? (Design)this.designSet.getElement(this.designSet.size() - 1) : this.addDesign(true);
        if (this.getBrowserPanel() != null && this.getBrowserPanel().getJTree() != null) {
            this.getBrowserPanel().getJTree().update(this.getBrowserPanel().getJTree().getGraphics());
        }
        SetEvent.clearEvents();
        ObjectChangeEvent.clearEvents();
        StorageEvent.clearEvents();
        TableLevelConstraintEvent.clearEvents();
        Domain.clearEvents();
        LogicalDatatype.clearEvents();
        TableProxy.clearEvents();
    }

    public void closeAllDesigns() {
        this.closeAllDesigns(true);
    }

    public boolean closeAllDesigns(boolean callGC) {
        boolean res = false;
        Object[] designs = this.designSet.toArray();
        for (int i = designs.length - 1; i >= 0; --i) {
            Design design = (Design)designs[i];
            this.setCurrentDesign(design);
            ((ControllerApplication.CloseDesign)this.getController().getCloseDesignAction()).execute();
            boolean bl = res = res || this.cancel;
            if (this.cancel) continue;
            this.closeAllDesignEditors(design);
        }
        if (callGC) {
            System.gc();
            System.runFinalization();
        }
        return res;
    }

    private void closeAllDesignEditors(Design design) {
        StorageDesign[] openStorageDesigns = design.getStorageDesignFactory().getOpenStorageDesigns();
        for (int i = 0; i < openStorageDesigns.length; ++i) {
            DataModelerAddin.closeAllEditors(openStorageDesigns[i], false);
        }
    }

    public List getCopiedObjects() {
        return this.copiedObjects;
    }

    public void addCopiedObject(DesignObject copiedObject) {
        this.copiedObjects.add(copiedObject);
    }

    public void addCopiedTopView(TopView tv) {
        this.copiedTopViews.add(tv);
    }

    public void clearCopiedObjects() {
        this.copiedObjects.clear();
        this.copiedTopViews.clear();
    }

    public ArrayList<DRCustomScript> getCustomDesignRules() {
        return this.customDesignRules;
    }

    public ArrayList<DRCustomValidationScript> getCustomValidationRules() {
        ArrayList<DRCustomValidationScript> list = new ArrayList<DRCustomValidationScript>();
        for (DRCustomScript o : this.getCustomDesignRules()) {
            DRCustomValidationScript drcs;
            if (!(o instanceof DRCustomValidationScript) || !(drcs = (DRCustomValidationScript)o).getPurpose().equals("validation")) continue;
            list.add(drcs);
        }
        return list;
    }

    public ArrayList<DRCustomValidationScript> getCustomTransformationsScripts() {
        ArrayList<DRCustomValidationScript> list = new ArrayList<DRCustomValidationScript>();
        for (DRCustomScript o : this.getCustomDesignRules()) {
            DRCustomValidationScript drcs;
            if (!(o instanceof DRCustomValidationScript) || !(drcs = (DRCustomValidationScript)o).getPurpose().equals("transformation")) continue;
            list.add(drcs);
        }
        return list;
    }

    public DRCustomScript getCustomTransformationScriptByID(String id) {
        for (DRCustomScript drcs : this.getCustomDesignRules()) {
            if (!drcs.getPurpose().equals("ddl_transformation") || !drcs.getRuleId().equals(id)) continue;
            return drcs;
        }
        return null;
    }

    public DRCustomScript getDDLTransformationScriptByName(String name) {
        for (DDLTransformationScriptSet set : this.getDdlTransformationScriptSets()) {
            if (!set.isActive()) continue;
            for (DRCustomScript script : set.getScripts()) {
                if (!script.getName().equals(name)) continue;
                return script;
            }
        }
        return null;
    }

    public ArrayList<DRLibrary> getCustomLibraries() {
        return this.customLibraries;
    }

    public ArrayList<DDLTransformationScriptSet> getDdlTransformationScriptSets() {
        return this.ddlTransformationScriptSets;
    }

    public ScriptEngineManager getScriptEngineManager() {
        if (this.scriptEngineManager == null) {
            this.scriptEngineManager = new ScriptEngineManager();
        }
        return this.scriptEngineManager;
    }

    public XMLTransformationManager getXMLTransformationManager() {
        if (this.xmlTransformationManager == null) {
            this.xmlTransformationManager = new XMLTransformationManager();
        }
        return this.xmlTransformationManager;
    }

    private void initScriptEngines() {
        this.scriptEngines = new ArrayList();
        List<ScriptEngineFactory> factoryList = this.getScriptEngineManager().getEngineFactories();
        for (ScriptEngineFactory factory : factoryList) {
            if (factory.getNames().contains("EmbeddedJavaScript")) continue;
            String name = factory.getEngineName();
            this.getScriptEngineManager().registerEngineName(name, factory);
            this.scriptEngines.add(name);
        }
    }

    public ArrayList getScriptEngines() {
        if (this.scriptEngines == null) {
            this.initScriptEngines();
        }
        return this.scriptEngines;
    }

    public ArrayList<StandardReportTemplate> getReportTemplates() {
        return this.reportTemplates;
    }

    public ArrayList<CustomReportTemplate> getCustomReportTemplates() {
        return this.customReportTemplates;
    }

    public ArrayList<StandardReportConfiguration> getStandardReportConfigurations() {
        return this.standardReportsConfiguration;
    }

    public ArrayList<ExpObject> getDMDExports() {
        return this.dmdExports;
    }

    public ArrayList<String> getCRTBooleanTList() {
        return this.CRTBooleanTList;
    }

    public ArrayList<String> getCRTBooleanFList() {
        return this.CRTBooleanFList;
    }

    public ArrayList<SearchProfile> getSearchProfiles() {
        return this.searchProfiles;
    }

    public void closeAllDialogs() {
        try {
            Window[] wnds = Window.getWindows();
            for (int i = wnds.length - 1; i >= 0; --i) {
                Window w = wnds[i];
                if (!(w instanceof Dialog)) continue;
                w.dispose();
            }
        }
        catch (Exception e) {
            LOGGER.error("ApplicationView.closeAllDialogs", e);
        }
    }

    public static void waitLoadFilesThreadToComplete() {
        Thread[] threads = new Thread[Thread.activeCount()];
        Thread.enumerate(threads);
        for (Thread t : threads) {
            if (t == null || !t.getClass().getName().equals("javax.swing.plaf.basic.BasicDirectoryModel$LoadFilesThread")) continue;
            try {
                t.join();
            }
            catch (Exception e) {
                System.out.println("error in waitLoadFilesThreadToComplete " + t.getClass().getName());
            }
        }
    }

    public void initLineTerminator() {
        IdeSettings settings = Ide.getSettings();
        EnvironOptions envopts = (EnvironOptions)settings.getData("environment-options");
        int eol = envopts.getLineTerminator();
        String ls = eol == 1 ? "\r\n" : (eol == 3 ? "\r" : (eol == 2 ? "\n" : System.getProperty("line.separator")));
        SQLStatementBuilder.NEWLINE = ls;
    }

    public Settings getInitialSettings() {
        return this.initialSettings;
    }

    public void setInitialSettings(Settings initialSettings) {
        this.initialSettings = new Settings(this);
        this.initialSettings.loadSettingsFromString(initialSettings.saveSettingsToString());
    }

    public void nullifyDesignRuleManager() {
        this.designRuleManager = null;
    }

    public ArrayList getSavedSearches() {
        return this.savedSearches;
    }

    public MaskTemplateSet getMaskTemplateSet() {
        if (this.maskTemplateSet == null) {
            this.maskTemplateSet = new MaskTemplateSet(this);
            this.maskTemplateSet.setName(Messages.getString("ApplicationView.MaskTemplates"));
            this.maskTemplateSet.setParent(this);
        }
        return this.maskTemplateSet;
    }

    public SensitiveTypeSet getSensitiveTypeSet() {
        if (this.sensitiveTypeSet == null) {
            this.sensitiveTypeSet = new SensitiveTypeSet(this);
            this.sensitiveTypeSet.setName(Messages.getString("ApplicationView.SensitiveTypes"));
            this.sensitiveTypeSet.setParent(this);
        }
        return this.sensitiveTypeSet;
    }

    public TSDPPolicySet getTSDPPolicySet() {
        if (this.tsdpPolicySet == null) {
            this.tsdpPolicySet = new TSDPPolicySet(this);
            this.tsdpPolicySet.setName(Messages.getString("ApplicationView.TSDPPolicies"));
            this.tsdpPolicySet.setParent(this);
        }
        return this.tsdpPolicySet;
    }

    public TSDPSubPolicySet getTSDPSubPolicySet() {
        if (this.tsdpSubPolicySet == null) {
            this.tsdpSubPolicySet = new TSDPSubPolicySet(this);
            this.tsdpSubPolicySet.setName(Messages.getString("ApplicationView.TSDPSubPolicies"));
            this.tsdpSubPolicySet.setParent(this);
        }
        return this.tsdpSubPolicySet;
    }

    public void loadMaskTemplates() {
        String fileName = this.getDefaultMaskTemplatesFileName();
        File file = new File(fileName);
        if (file.exists()) {
            MaskTemplateFileWrapper wrapper = new MaskTemplateFileWrapper(this);
            this.getXMLTransformationManager().transformFromXMLToObject(wrapper, file, false);
        }
    }

    public void saveMaskTemplates() {
        MaskTemplateFileWrapper wrapper;
        XMLTransformationManager trmgr = this.getXMLTransformationManager();
        Document doc = trmgr.getXMLContent(wrapper = new MaskTemplateFileWrapper(this));
        if (doc != null) {
            XMLTransformationManager.saveDocument(this.getDefaultMaskTemplatesFileName(), doc, false);
        }
    }

    public String getDefaultSystemTypesPath() {
        String sysTypesPath = this.getSettings().getDefaultSystemTypesPath();
        if (!"".equals(sysTypesPath)) {
            return sysTypesPath;
        }
        File fPath = new File(basePath);
        return fPath.getAbsolutePath() + "/" + MDConfiguration.getDefaultInstance().get("typesPath");
    }

    public String getDefaultSensitiveTypesFileName() {
        try {
            return new File(this.getDefaultSystemTypesPath(), "sensitiveTypes.xml").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public String getDefaultMaskTemplatesFileName() {
        try {
            return new File(this.getDefaultSystemTypesPath(), "maskTemplates.xml").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public void setChangedObjectsList(List<StorableObjectStatus> changedObjectsList) {
        this.changedObjectsList = changedObjectsList;
    }

    public List<StorableObjectStatus> getChangedObjectsList() {
        return this.changedObjectsList;
    }

    public String getDefaultTSDPPoliciesFileName() {
        try {
            return new File(this.getDefaultSystemTypesPath(), "tsdpPolicies.xml").getCanonicalPath();
        }
        catch (IOException e) {
            LOGGER.error(e);
            return null;
        }
    }

    public void loadSensitiveTypes() {
        String fileName = this.getDefaultSensitiveTypesFileName();
        File file = new File(fileName);
        if (file.exists()) {
            SensitiveTypeFileWrapper wrapper = new SensitiveTypeFileWrapper(this);
            this.getXMLTransformationManager().transformFromXMLToObject(wrapper, file, false);
        }
    }

    public void saveSensitiveTypes() {
        SensitiveTypeFileWrapper wrapper;
        XMLTransformationManager trmgr = this.getXMLTransformationManager();
        Document doc = trmgr.getXMLContent(wrapper = new SensitiveTypeFileWrapper(this));
        if (doc != null) {
            XMLTransformationManager.saveDocument(this.getDefaultSensitiveTypesFileName(), doc, false);
        }
    }

    public void loadTSDPPolicies() {
        String fileName = this.getDefaultTSDPPoliciesFileName();
        File file = new File(fileName);
        if (file.exists()) {
            TSDPPolicyFileWrapper wrapper = new TSDPPolicyFileWrapper(this);
            this.getXMLTransformationManager().transformFromXMLToObject(wrapper, file, false);
        }
    }

    public void saveTSDPPolicies() {
        TSDPPolicyFileWrapper wrapper;
        XMLTransformationManager trmgr = this.getXMLTransformationManager();
        Document doc = trmgr.getXMLContent(wrapper = new TSDPPolicyFileWrapper(this));
        if (doc != null) {
            XMLTransformationManager.saveDocument(this.getDefaultTSDPPoliciesFileName(), doc, false);
        }
    }

    public void clearDomainsDatatypes(LogicalDatatype lt) {
        if (lt != null) {
            for (Design design : this.getDesigns()) {
                design.clearDomainsDatatypes(lt);
            }
        }
    }

    public void loadSearchProfiles() {
        if (!searchProfilesLoaded) {
            SearchProfilesPersistence searchProfilesPersistence = new SearchProfilesPersistence(this);
            searchProfilesPersistence.load(this, XMLTransformationManager.getDefaultSystemTypesPath(this.settings));
            searchProfilesLoaded = true;
        }
    }

    public UDPLibrariesPersistence getUDPLibrariesPersistence() {
        if (this.udpLibrariesPersistence == null) {
            this.udpLibrariesPersistence = new UDPLibrariesPersistence();
        }
        return this.udpLibrariesPersistence;
    }

    public List getCopiedTopViews() {
        return this.copiedTopViews;
    }

    public static boolean isGUIMode() {
        return GUIMode;
    }

    public Map<RelationalDesign, DDLFileMakerEditor> getDdlFileMakerEditorMap() {
        if (this.ddlFileMakerEditorMap == null) {
            this.ddlFileMakerEditorMap = new HashMap<RelationalDesign, DDLFileMakerEditor>();
        }
        return this.ddlFileMakerEditorMap;
    }

    static {
        debugMode = false;
        frame = null;
        basePath = "../";
        instance = null;
        designRulesLoaded = false;
        PROPAGATE_FKATTRIBUTE_DESCRIPTION = false;
        SHOW_SENSITIVE_DATA = true;
        SHOW_MASKED_DATA = true;
        REBUILD_OBJECT_LIST = true;
        INCLUDE_CLASS_NAME_IN_ITEM_XML = true;
        BDA_PROPERTY_SEPARATOR = ":";
        searchProfilesLoaded = false;
        DESIGN_URL_FILTER_DESC = "Oracle SQL Developer Data Modeler " + Messages.getString("ImportDesignDialog.Design") + " (*.dmd, *.dmdz, *.xml)";
        LOGGER = new Logger(ApplicationView.class);
        df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        DM_TOOLBARS_LIST = new ArrayList();
        DM_TOOLBARS_LIST.add("Logical Model");
        DM_TOOLBARS_LIST.add("Relational Model");
        DM_TOOLBARS_LIST.add("DataTypes Model");
        DM_TOOLBARS_LIST.add("Multidimensional Model");
        DM_TOOLBARS_LIST.add("Process Model");
        DM_TOOLBARS_LIST.add("Transformation Model");
        instantiating = false;
    }

    class SettingsListener
    implements ChangeListener {
        SettingsListener() {
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (!closing) {
                LOGGER.update();
            }
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        TreePath lastSucPath;

        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent e) {
        }

        @Override
        public void treeNodesInserted(TreeModelEvent e) {
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent e) {
        }

        @Override
        public void treeStructureChanged(TreeModelEvent e) {
            TreePath path;
            if (!ApplicationView.this.getCurrentDesign().isClosing() && !loading && (path = e.getTreePath()).getParentPath() != null) {
                this.lastSucPath = path;
            }
        }
    }

    public class ApplicationCloser
    extends WindowAdapter {
        private String[] options = new String[]{Messages.getString("ApplicationView.WaitUntilTasksFinish"), Messages.getString("ApplicationView.ExitLoseData")};
        String appName = MDConfiguration.getDefaultInstance().get("appName");
        private Object messageWarning = new String[]{MessageFormat.format(Messages.getString("ApplicationView.WaitingTasksTofinish"), this.appName), MessageFormat.format(Messages.getString("ApplicationView.IfYouSelect"), this.options[1]), Messages.getString("ApplicationView.DoNotContinue")};
        private int closeCount = 0;

        @Override
        public void windowClosing(WindowEvent e) {
            ControllerApplication.ExitApplication exitAction;
            ControllerApplication appControler = ApplicationView.this.getController();
            if (appControler != null && (exitAction = appControler.getExitAction()) != null) {
                ApplicationView.this.getFrame().setDefaultCloseOperation(0);
                ((MDBAction)exitAction).doActionPerformed(null);
                return;
            }
            this.doExit();
        }

        private void doExit() {
            if (++this.closeCount > 1) {
                this.forceExit();
            } else if (!Extension.isExtension) {
                RuntimeMonitor.getInstance().systemExitAfterThreadsNonBlocking();
            }
        }

        private void forceExit() {
            int choice = JOptionPane.showOptionDialog((Component)Ide.getMainWindow(), this.messageWarning, Messages.getString("ApplicationView.Closeapplication"), 1, 2, null, this.options, this.options[0]);
            if (choice == 1) {
                System.exit(0);
            }
        }
    }

    class ToggleListener
    implements ActionListener {
        ToggleListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            AbstractButton b = (AbstractButton)e.getSource();
            Component[] buttons = Ide.getToolbar().getComponents();
            for (int i = 0; i < buttons.length; ++i) {
                if (!(buttons[i] instanceof AbstractButton)) continue;
                AbstractButton button = (AbstractButton)buttons[i];
                if (button != b) {
                    button.setSelected(false);
                    continue;
                }
                button.setSelected(true);
            }
        }
    }
}

