/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.standalone_domains;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.dbtools.crest.model.MDUserFactory;
import oracle.dbtools.crest.model.ModelIDObject;
import oracle.dbtools.crest.model.ObjectChange;
import oracle.dbtools.crest.model.design.Constraint;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.Domain;
import oracle.dbtools.crest.model.design.DomainFileWrapper;
import oracle.dbtools.crest.model.design.DomainSet;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.constraint.AVT;
import oracle.dbtools.crest.model.design.constraint.CheckConstraint;
import oracle.dbtools.crest.model.design.constraint.ConstraintEnumeration;
import oracle.dbtools.crest.model.design.logical.LogicalDesign;
import oracle.dbtools.crest.model.design.storage.RDBMSSite;
import oracle.dbtools.crest.model.persistence.xml.XMLConstants;
import oracle.dbtools.crest.swingui.ApplicationView;
import oracle.dbtools.crest.util.logging.Logger;
import oracle.dbtools.crest.util.propertymap.PropertyMap;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class ReadStAlDomains
implements XMLConstants {
    private static final Logger LOGGER = new Logger(ReadStAlDomains.class);
    private static final String domainFileRootNodeName = "DomainFile";
    private static final String oldDomainFileRootNodeName = "domain";
    private List domainList = new ArrayList();
    private DomainSet domainSet;
    private Design design;
    private Design targetDesgn;

    public ReadStAlDomains(ApplicationView appView, RDBMSSite site, Design targetDesgn) {
        this.design = new Design(appView);
        this.targetDesgn = targetDesgn;
        if (site != null) {
            this.design.getRelationalDesign().setSelectedRDBMSSite(site);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List readDomains(File file) {
        block24: {
            BufferedReader br = null;
            this.domainList.clear();
            if (file.exists()) {
                try {
                    FileInputStream is = new FileInputStream(file);
                    br = new BufferedReader(new InputStreamReader((InputStream)is, "UTF-8"));
                    InputSource inputSource = new InputSource(br);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    DocumentBuilder db = null;
                    try {
                        db = dbf.newDocumentBuilder();
                    }
                    catch (ParserConfigurationException e1) {
                        // empty catch block
                    }
                    if (db == null) break block24;
                    try {
                        Document doc = db.parse(inputSource);
                        Element root = doc.getDocumentElement();
                        if (!root.getNodeName().equals(domainFileRootNodeName) && !root.getNodeName().equals(oldDomainFileRootNodeName)) {
                            if (br != null) {
                                try {
                                    br.close();
                                }
                                catch (IOException e) {
                                    // empty catch block
                                }
                            }
                            List list = this.domainList;
                            return list;
                        }
                        this.recreateDomains(doc, this.design, false);
                    }
                    catch (SAXException e2) {
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
                catch (Exception e) {
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
        }
        return this.domainList;
    }

    public void checkAndSetIDGenerator(List domainList) {
        Iterator it = domainList.iterator();
        long max = 0L;
        long temp = 0L;
        while (it.hasNext()) {
            ModelIDObject mo = (ModelIDObject)it.next();
            String id = mo.getObjectID();
            if (id.indexOf(64) <= -1 || (temp = DesignPart.getCounter(id)) <= max) continue;
            max = temp;
        }
        long startCounter = this.design.getAppView().getIDGenerator().getStartCounter();
        long lastIndex = this.design.getAppView().getIDGenerator().getLastIDIndex();
        if (max > lastIndex) {
            this.design.getAppView().getIDGenerator().setCounter(max - startCounter + 1L);
        }
    }

    private void recreateDomains(Document doc, Design design, boolean hasDomainFileLock) {
        Element root = doc.getDocumentElement();
        String tagname = root.getTagName();
        if (tagname.equals(oldDomainFileRootNodeName)) {
            NodeList domains = doc.getDocumentElement().getElementsByTagName("object");
            int length = domains.getLength();
            Element domainElm = null;
            for (int i = 0; i < length; ++i) {
                domainElm = (Element)domains.item(i);
                if (!"Domain".equals(domainElm.getAttribute("type"))) continue;
                Domain domain = this.recreateDomain(domainElm, design, hasDomainFileLock);
                this.domainList.add(domain);
            }
        } else {
            DomainFileWrapper dw = new DomainFileWrapper(this.targetDesgn, this.targetDesgn.getFileName(), this.getDomainSet());
            ApplicationView.getInstance().getXMLTransformationManager().transformFromXMLToObject((Object)dw, doc);
            this.domainList.addAll(dw.getDomains());
        }
        if (this.domainSet.size() > this.domainList.size()) {
            this.domainSet.remove(this.domainSet.getByName("Unknown"));
        }
    }

    public Domain recreateDomain(Element domainElm, Design design, boolean tryReadWriteLocking) {
        String importedId;
        String id = domainElm.getAttribute("id");
        Domain domain = null;
        if (domain == null) {
            domain = (Domain)this.instantiateDesignObject(id);
        }
        if ((importedId = domainElm.getAttribute("imported_id")) != null && !"".equalsIgnoreCase(importedId)) {
            domain.setImportedId(importedId);
        }
        this.readBasicObjectInfo(domainElm, domain, tryReadWriteLocking);
        this.readObjectInfo(domainElm, domain, tryReadWriteLocking);
        this.readAVT(domainElm, domain);
        this.readConstraint(domainElm, domain);
        Element logicalTypeElm = ReadStAlDomains.getFirstChildByTagName(domainElm, "logicaltype");
        String lid = logicalTypeElm.getAttribute("oid");
        String typeName = logicalTypeElm.getAttribute("name");
        LogicalDatatype logType = LogicalDatatype.getLogicalDatatype(this.getTargetDesgn(), typeName, lid);
        this.readDataTypeParameters(domainElm, domain);
        domain.setLogicalDatatype(logType);
        String filename = domainElm.getAttribute("file");
        if (filename != null && !"".equals(filename)) {
            domain.setFileName(filename);
        }
        return domain;
    }

    protected void readBasicObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        this.readBasicObjectInfo_0(objInfo, desObject, tryReadWriteLocking);
        NodeList list = objInfo.getElementsByTagName("engineering");
        if (list.getLength() > 0) {
            Element engineerElm = (Element)list.item(0);
            if (((DesignObject)desObject).getDesignPart() instanceof LogicalDesign) {
                NodeList rdList = objInfo.getElementsByTagName("relational_design");
                for (int i = 0; i < rdList.getLength(); ++i) {
                    Element rdElm = (Element)rdList.item(i);
                    String rd_id = rdElm.getAttribute("id");
                    boolean value = Boolean.valueOf(rdElm.getAttribute("should"));
                    ((DesignObject)desObject).setEngineerTo(rd_id, value);
                }
            } else {
                String value = engineerElm.getAttribute("should");
                if (value != null && value.equals(VALUE_TRUE)) {
                    desObject.setShouldEngineer(true);
                } else {
                    desObject.setShouldEngineer(false);
                }
            }
        }
    }

    protected void readBasicObjectInfo_0(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        Element versionElm;
        String value;
        NodeList list;
        String genId;
        Node textNode;
        Element generatorElm;
        String notes;
        Node textNode2;
        Element notesElm;
        String comment;
        Node textNode3;
        Element nameElm = ReadStAlDomains.getFirstChildByTagName(objInfo, "name");
        if (nameElm != null && nameElm.getFirstChild() != null) {
            String name = nameElm.getFirstChild().getNodeValue();
            desObject.setName(StringUtilities.decodeAttributeValue(name));
        }
        NodeList changes = objInfo.getElementsByTagName("alter");
        int length = changes.getLength();
        for (int i = 0; i < length; ++i) {
            Element changeElm = (Element)changes.item(i);
            if (!changeElm.getParentNode().equals(objInfo)) continue;
            String label = changeElm.getAttribute("type");
            this.readChange(changeElm, desObject, label);
        }
        Element commentElm = ReadStAlDomains.getFirstChildByTagName(objInfo, "comment");
        if (commentElm != null && (textNode3 = commentElm.getFirstChild()) != null && (comment = textNode3.getNodeValue()) != null) {
            desObject.setComment(StringUtilities.decodeAttributeValue(comment));
        }
        if ((notesElm = ReadStAlDomains.getFirstChildByTagName(objInfo, "notes")) != null && (textNode2 = notesElm.getFirstChild()) != null && (notes = textNode2.getNodeValue()) != null) {
            desObject.setNotes(StringUtilities.decodeAttributeValue(notes));
        }
        if ((generatorElm = ReadStAlDomains.getFirstChildByTagName(objInfo, "generator")) != null && (textNode = generatorElm.getFirstChild()) != null && (genId = textNode.getNodeValue()) != null) {
            desObject.setGeneratorID(genId);
        }
        if (desObject instanceof DesignObject && (list = objInfo.getElementsByTagName("des_obj_version")) != null && list.getLength() > 0 && (value = (versionElm = (Element)list.item(0)).getAttribute("version")) != null) {
            try {
                float version = Float.parseFloat(value);
                ((DesignObject)desObject).setLoadedVersion(version);
            }
            catch (NumberFormatException e) {
                ((DesignObject)desObject).setLoadedVersion(0.0f);
            }
        }
        this.readObjectInfo(objInfo, desObject, tryReadWriteLocking);
    }

    protected void readChange(Element changeNode, ModelIDObject desObject, String label) {
        ObjectChange change = null;
        if ("created".equals(label)) {
            change = desObject.getCreation();
        } else if ("changed".equals(label)) {
            change = desObject.getChange();
        } else {
            return;
        }
        Element userElm = ReadStAlDomains.getFirstChildByTagName(changeNode, "user");
        change.setUser(MDUserFactory.getInstance().getUser(userElm.getFirstChild().getNodeValue()));
        Element timeElm = ReadStAlDomains.getFirstChildByTagName(changeNode, "timestamp");
        change.setTimeString(timeElm.getFirstChild().getNodeValue());
    }

    protected void readObjectInfo(Element objInfo, ModelIDObject desObject, boolean tryReadWriteLocking) {
        if (desObject instanceof Domain) {
            String dimension;
            Domain domain = (Domain)desObject;
            String synonym = objInfo.getAttribute("synonym");
            if (synonym != null) {
                domain.setSynonym(StringUtilities.decodeAttributeValue(synonym));
            }
            if ((dimension = objInfo.getAttribute("dimension")) != null) {
                domain.setDimension(StringUtilities.decodeAttributeValue(dimension));
            }
        }
    }

    protected void readDataTypeParameters(Element parent, Domain domain) {
        Element parameters = ReadStAlDomains.getFirstChildByTagName(parent, "parameters");
        if (parameters != null) {
            NodeList paramList = parent.getElementsByTagName("parameter");
            int length = paramList.getLength();
            for (int j = 0; j < length; ++j) {
                Element parameter = (Element)paramList.item(j);
                domain.setDataTypeParameter(parameter.getAttribute("name"), StringUtilities.decodeAttributeValue(parameter.getAttribute("value")));
            }
        }
    }

    protected DesignObject instantiateDesignObject(String objectID) {
        return this.getDomainSet().createDomain(objectID);
    }

    protected void readConstraint(Element parent, Domain domain) {
        NodeList list = parent.getElementsByTagName("constraint");
        if (list.getLength() > 0) {
            Element constraintElm = (Element)list.item(0);
            String type = constraintElm.getAttribute("type");
            Constraint constraint = domain.getDesign().getConstraintSet().createConstraint(type);
            this.readConstraintInfo(constraintElm, constraint);
            this.readPropertiesListLocateRoot(constraintElm, constraint);
            if (type.equalsIgnoreCase("check constraint")) {
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                domain.setCheck((CheckConstraint)constraint);
            } else if (type.equalsIgnoreCase("enumerated String")) {
                this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                domain.setValueList((ConstraintEnumeration)constraint);
            }
            if (list.getLength() > 1) {
                constraintElm = (Element)list.item(1);
                type = constraintElm.getAttribute("type");
                constraint = domain.getDesign().getConstraintSet().createConstraint(type);
                this.readConstraintInfo(constraintElm, constraint);
                this.readPropertiesListLocateRoot(constraintElm, constraint);
                if (type.equalsIgnoreCase("check constraint")) {
                    domain.setCheck((CheckConstraint)constraint);
                } else if (type.equalsIgnoreCase("enumerated String")) {
                    this.readConstraintEnumerationList(constraintElm, (ConstraintEnumeration)constraint);
                    domain.setValueList((ConstraintEnumeration)constraint);
                }
            }
        }
    }

    protected void readPropertiesListLocateRoot(Element parent, PropertyMap object) {
        NodeList list = parent.getElementsByTagName("properties");
        if (list.getLength() > 0) {
            this.readPropertiesList((Element)list.item(0), object);
        }
    }

    protected void readPropertiesList(Element parent, PropertyMap object) {
        NodeList paramList = parent.getElementsByTagName("parameter");
        int length = paramList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)paramList.item(i);
            this.doReadPropertyFromParameterElement(parameter, object);
        }
    }

    private void doReadPropertyFromParameterElement(Element parameter, PropertyMap object) {
        String key = parameter.getAttribute("name");
        String value = parameter.getAttribute("value");
        object.setProperty(key, ReadStAlDomains.decodeAttributeValue(value));
    }

    public static String decodeAttributeValue(String encoded) {
        return StringUtilities.decodeAttributeValue(encoded);
    }

    private void readConstraintEnumerationList(Element parent, ConstraintEnumeration object) {
        NodeList list = parent.getElementsByTagName("properties");
        if (list.getLength() > 0) {
            this.readConstraintEnumeration((Element)list.item(0), object);
        }
    }

    private void readConstraintEnumeration(Element parent, ConstraintEnumeration object) {
        NodeList paramList = parent.getElementsByTagName("parameter");
        int length = paramList.getLength();
        for (int i = 0; i < length; ++i) {
            Element parameter = (Element)paramList.item(i);
            String value = parameter.getAttribute("value");
            String desc = parameter.getAttribute("desc");
            object.add(value, desc);
        }
    }

    protected void readConstraintInfo(Element constraintElm, Constraint constraint) {
        try {
            Element nameElm = ReadStAlDomains.getFirstChildByTagName(constraintElm, "name");
            if (nameElm != null && nameElm.getFirstChild() != null) {
                String name = nameElm.getFirstChild().getNodeValue();
                constraint.setName(name);
            }
        }
        catch (Exception e) {
            LOGGER.warn(e.getMessage(), e);
        }
    }

    protected void readAVT(Element parent, Domain domain) {
        NodeList list = parent.getElementsByTagName("avt");
        int length = list.getLength();
        if (length > 0) {
            for (int i = 0; i < length; ++i) {
                String description;
                String endvalue;
                String beginvalue;
                Element constraintElm = (Element)list.item(i);
                AVT avt = null;
                Element nameElm = ReadStAlDomains.getFirstChildByTagName(constraintElm, "beginvalue");
                if (nameElm != null && nameElm.getFirstChild() != null && (beginvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    avt = new AVT(StringUtilities.decodeAttributeValue(beginvalue), "", "");
                }
                if ((nameElm = ReadStAlDomains.getFirstChildByTagName(constraintElm, "endvalue")) != null && nameElm.getFirstChild() != null && (endvalue = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setEndValue(StringUtilities.decodeAttributeValue(endvalue));
                    } else {
                        avt = new AVT("", StringUtilities.decodeAttributeValue(endvalue), "");
                    }
                }
                if ((nameElm = ReadStAlDomains.getFirstChildByTagName(constraintElm, "description")) != null && nameElm.getFirstChild() != null && (description = nameElm.getFirstChild().getNodeValue()) != null) {
                    if (avt != null) {
                        avt.setDescription(StringUtilities.decodeAttributeValue(description));
                    } else {
                        avt = new AVT("", "", StringUtilities.decodeAttributeValue(description));
                    }
                }
                if (avt == null) continue;
                domain.addAVT(avt);
            }
        }
    }

    public static Element getFirstChildByTagName(Element parent, String tagName) {
        NodeList children = parent.getChildNodes();
        int length = children.getLength();
        for (int i = 0; i < length; ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || !((Element)child).getTagName().equals(tagName)) continue;
            return (Element)child;
        }
        return null;
    }

    public static void main(String[] args) {
    }

    public DomainSet getDomainSet() {
        if (this.domainSet == null) {
            this.domainSet = new DomainSet(this.targetDesgn.getLogicalDesign());
            this.domainSet.setDesign(this.targetDesgn);
            this.domainSet.setName("Domains");
            this.domainSet.createUnknownDomain();
        }
        return this.domainSet;
    }

    public Design getDesign() {
        return this.design;
    }

    public Design getTargetDesgn() {
        return this.targetDesgn;
    }
}

