/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.process;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.process.ExternalAgent;
import oracle.dbtools.crest.model.design.process.ExternalData;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.process.DFConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLAgent
extends AbstractRXMLDesignObject
implements DFConstants {
    public RXMLAgent(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getProcessModel().getDataFlowDesign().getExternalAgentSet().createExternalAgent(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        ExternalAgent agent = (ExternalAgent)super.recreateObject(objInfo, design, tryReadWriteLocking);
        String synonym = objInfo.getAttribute("synonym");
        if (synonym != null) {
            agent.setSynonym(StringUtilities.decodeAttributeValue(synonym));
        }
        Map map = this.getProperties(objInfo, "attributes");
        try {
            int type = Integer.parseInt((String)map.get("type"));
            agent.setType(type);
        }
        catch (Exception e) {
            // empty catch block
        }
        agent.setOwner(StringUtilities.decodeAttributeValue((String)map.get("agentowner")));
        agent.setSource(StringUtilities.decodeAttributeValue((String)map.get("agentsource")));
        agent.setFileName(StringUtilities.decodeAttributeValue((String)map.get("filename")));
        agent.setLocation(StringUtilities.decodeAttributeValue((String)map.get("location")));
        agent.setFileType(StringUtilities.decodeAttributeValue((String)map.get("filetype")));
        agent.setFieldSeparator(StringUtilities.decodeAttributeValue((String)map.get("fieldseparator")));
        agent.setTransferType(StringUtilities.decodeAttributeValue((String)map.get("transfertype")));
        agent.setSelfDescribing(new Boolean((String)map.get("selfDescribing")));
        if (map.get("skipRecords") != null) {
            agent.setSkipRecords(new Integer((String)map.get("skipRecords")));
        }
        agent.setTextDelimiter((String)map.get("textDelimiter"));
        Map objMap = this.getProperties(objInfo, "agentextdatas");
        Object[] objects = objMap.keySet().toArray();
        for (int i = 0; i < objects.length; ++i) {
            String aID = (String)objMap.get(objects[i]);
            ExternalData extData = (ExternalData)agent.getDesign().getProcessModel().getExternalDataSet().getObjectByID(aID);
            if (extData == null) continue;
            agent.addExternalData(extData);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(agent.getObjectID())).append(".dmd");
        agent.setFilePath(buffer.toString());
        return agent;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getProcessModel().getDataFlowDesign().getObjectID();
            buffer.append(designName).append('/');
            if (this.isOldDesign()) {
                buffer.append("processmodel/dataflows");
            } else {
                buffer.append(DATAFLOW_PATH);
            }
            buffer.append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("agentPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == ExternalAgent.class;
    }
}

