/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.TreeMap;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.multidimensional.SelectionCriteria;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLSelectionCriteria
extends AbstractWXMLDesignObject
implements MDConstants {
    private SelectionCriteria sc = null;

    public WXMLSelectionCriteria(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof SelectionCriteria;
        if (result) {
            this.sc = (SelectionCriteria)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.sc != null) {
            String designName = this.sc.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(StringUtilities.encodeAttributeValue(this.sc.getDesignPart().getObjectID())).append('/');
        }
        buffer.append(this.getConfiguration().get("selcriteriaPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof SelectionCriteria) {
            SelectionCriteria sc = (SelectionCriteria)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("selectioncriteria", String.valueOf(sc.getSelectionCriteria()));
            map.put("description", String.valueOf(sc.getDescription()));
            map.put("entity", String.valueOf(sc.getEntity() != null ? StringUtilities.encodeAttributeValue(sc.getEntity().getObjectID()) : NULL_STR));
            map.put("partition", String.valueOf(sc.getPartition()));
            map.put("measure_id", String.valueOf(sc.getMeasureWrapper() != null ? StringUtilities.encodeAttributeValue(sc.getMeasureWrapper().getMeasure().getObjectID()) : NULL_STR));
            map.put("aggr_function_id", String.valueOf(sc.getMeasureWrapper() != null ? StringUtilities.encodeAttributeValue(sc.getMeasureWrapper().getAggrFunction().getObjectID()) : NULL_STR));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

