/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.List;
import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLDimension
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLDimension(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getDimensionSet().createDimension(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        Dimension dimension = (Dimension)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        dimension.setDescription((String)map.get("description"));
        dimension.setTimeDimension(Boolean.valueOf((String)map.get("timedimension")));
        String natKeys = (String)map.get("use_natural_keys");
        if (natKeys != null && "FALSE".equalsIgnoreCase(natKeys)) {
            dimension.setUseNaturalKeys(false);
        }
        this.handleCalcMembers(objInfo, dimension);
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(dimension.getObjectID())).append(".dmd");
        dimension.setFilePath(buffer.toString());
        return dimension;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("dimensionPath"));
        return buffer.toString();
    }

    private void handleCalcMembers(Element objInfo, Dimension dim) {
        Element wrlist = RXMLDimension.getFirstChildByTagName(objInfo, "calculated_members");
        if (wrlist != null) {
            NodeList funcList = wrlist.getElementsByTagName("calculated_member");
            int length = funcList.getLength();
            List calcmembers = dim.getPermanentCalcMembers();
            for (int j = 0; j < length; ++j) {
                Element param = (Element)funcList.item(j);
                String name = param.getAttribute("name");
                String expression = param.getAttribute("expression");
                if (name == null || expression == null) continue;
                Dimension dimension = dim;
                dimension.getClass();
                Dimension.PermanentCalcMember pcm = dimension.new Dimension.PermanentCalcMember(StringUtilities.decodeAttributeValue(name), StringUtilities.decodeAttributeValue(expression));
                calcmembers.add(pcm);
            }
        }
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Dimension.class;
    }
}

