/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.multidimensional;

import java.util.Map;
import oracle.dbtools.crest.model.design.ContainerObject;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.multidimensional.Cube;
import oracle.dbtools.crest.model.design.multidimensional.Dimension;
import oracle.dbtools.crest.model.design.multidimensional.FactEntitiesJoin;
import oracle.dbtools.crest.model.design.multidimensional.Level;
import oracle.dbtools.crest.model.design.multidimensional.Measure;
import oracle.dbtools.crest.model.design.multidimensional.Slice;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.multidimensional.MDConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLCube
extends AbstractRXMLDesignObject
implements MDConstants {
    public RXMLCube(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getMultidimensionalDesign().getCubeSet().createCube(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String hierID;
        Level level;
        String levID;
        Dimension dim;
        String dimID;
        Slice slice;
        String sliceID;
        String compessedComp;
        Cube cube = (Cube)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        cube.setDescription((String)map.get("description"));
        cube.setVirtual(Boolean.valueOf((String)map.get("virtual")));
        cube.setPartitioned(Boolean.valueOf((String)map.get("partitioned")));
        cube.setPartitioningDescription((String)map.get("partdescription"));
        String globComp = (String)map.get("global_composites");
        if (globComp != null && "true".equalsIgnoreCase(globComp)) {
            cube.setUseGlobalComposites(true);
        }
        if ((compessedComp = (String)map.get("compressed_composites")) != null && "true".equalsIgnoreCase(compessedComp)) {
            cube.setCompressedComposites(true);
        }
        if (!"null".equalsIgnoreCase(sliceID = (String)map.get("fullcubemat")) && (slice = (Slice)cube.getDesign().getMultidimensionalDesign().getSliceSet().getObjectByID(sliceID)) != null) {
            cube.setFullCubeMaterialization(slice);
            slice.setCube(cube);
        }
        if ((dimID = (String)map.get("part_dimension")) != null && !"null".equalsIgnoreCase(dimID) && (dim = (Dimension)cube.getDesign().getMultidimensionalDesign().getDimensionSet().getObjectByID(dimID)) != null) {
            cube.setPartDimension(dim);
        }
        if ((levID = (String)map.get("part_level")) != null && !"null".equalsIgnoreCase(levID) && (level = (Level)cube.getDesign().getMultidimensionalDesign().getLevelSet().getObjectByID(levID)) != null) {
            cube.setPartLevel(level);
        }
        if ((hierID = (String)map.get("part_hierarchy")) != null && !"null".equalsIgnoreCase(hierID)) {
            cube.setPartHierarchyID(hierID);
        }
        map = this.getProperties(objInfo, "dimensions");
        Object[] dims = map.keySet().toArray();
        for (int i = 0; i < dims.length; ++i) {
            String aID = (String)map.get(dims[i]);
            Dimension dim2 = (Dimension)cube.getDesign().getMultidimensionalDesign().getDimensionSet().getObjectByID(aID);
            if (dim2 == null) continue;
            cube.getDimensionsOrderList().add(dim2);
        }
        map = this.getProperties(objInfo, "measures");
        Object[] measures = map.keySet().toArray();
        for (int i = 0; i < measures.length; ++i) {
            String aID = (String)map.get(measures[i]);
            Measure measure = (Measure)cube.getDesign().getMultidimensionalDesign().getMeasureSet().getObjectByID(aID);
            if (measure == null) continue;
            cube.addMeasure(measure);
        }
        map = this.getProperties(objInfo, "slices");
        Object[] slices = map.keySet().toArray();
        for (int i = 0; i < slices.length; ++i) {
            String aID = (String)map.get(slices[i]);
            Slice slice2 = (Slice)cube.getDesign().getMultidimensionalDesign().getSliceSet().getObjectByID(aID);
            if (slice2 == null) continue;
            cube.addPrecalculatedSlice(slice2);
        }
        map = this.getProperties(objInfo, "fact_entities");
        Object[] ents = map.keySet().toArray();
        for (int i = 0; i < ents.length; ++i) {
            String aID = (String)map.get(ents[i]);
            ContainerObject ent = (ContainerObject)cube.getDesign().getLogicalDesign().getEntitySet().getObjectByID(aID);
            if (ent == null) {
                ent = (ContainerObject)cube.getDesign().getLogicalDesign().getEntityViewSet().getObjectByID(aID);
            }
            if (ent == null) continue;
            cube.addFactEntity(ent);
        }
        map = this.getProperties(objInfo, "fact_joins");
        Object[] joins = map.keySet().toArray();
        for (int i = 0; i < joins.length; ++i) {
            String aID = (String)map.get(joins[i]);
            FactEntitiesJoin join = (FactEntitiesJoin)cube.getDesign().getMultidimensionalDesign().getFactEntitiesJoinSet().getObjectByID(aID);
            if (join == null) continue;
            cube.addFactEntitiesJoin(join);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(cube.getObjectID())).append(".dmd");
        cube.setFilePath(buffer.toString());
        return cube;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null && this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesigns().size() > 0) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            String dfDesName = this.getPersistenceManager().getAppView().getCurrentDesign().getMultidimensionalDesign().getObjectID();
            buffer.append(designName).append('/').append("multidimensional").append('/').append(dfDesName).append('/');
        }
        buffer.append(this.getConfiguration().get("cubePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == Cube.class;
    }
}

