/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.datatypes;

import java.util.Map;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.design.datatypes.Method;
import oracle.dbtools.crest.model.design.datatypes.MethodParam;
import oracle.dbtools.crest.model.design.datatypes.StructuredType;
import oracle.dbtools.crest.model.design.datatypes.TypeElement;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.datatypes.DTConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class RXMLStructuredType
extends AbstractRXMLDesignObject
implements DTConstants {
    public RXMLStructuredType(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        boolean isVisible = Boolean.valueOf(objInfo.getAttribute("visible"));
        return design.getDataTypesDesign().getStructuredTypeSet().createStructuredType(StringUtilities.decodeAttributeValue(objectID), isVisible);
    }

    @Override
    public Object recreateObject(Document doc, Design design, boolean tryReadWriteLocking) {
        try {
            Element child;
            int i;
            int length;
            NodeList objElms;
            Element objInfo = RXMLStructuredType.getFirstChildByTagName(doc.getDocumentElement(), "object");
            StructuredType structuredType = (StructuredType)this.recreateObject(objInfo, design, tryReadWriteLocking);
            if (RXMLStructuredType.getFirstChildByTagName(doc.getDocumentElement(), "contained") != null) {
                objElms = RXMLStructuredType.getFirstChildByTagName(doc.getDocumentElement(), "contained").getElementsByTagName("object");
                length = objElms.getLength();
                for (i = 0; i < length; ++i) {
                    child = (Element)objElms.item(i);
                    TypeElement te = this.instantiateTypeElement(child.getAttribute("id"), design, structuredType, child);
                    this.readElementInfo(child, te, tryReadWriteLocking, design, structuredType);
                }
            }
            if (RXMLStructuredType.getFirstChildByTagName(doc.getDocumentElement(), "methods") != null) {
                objElms = RXMLStructuredType.getFirstChildByTagName(doc.getDocumentElement(), "methods").getElementsByTagName("object");
                length = objElms.getLength();
                for (i = 0; i < length; ++i) {
                    child = (Element)objElms.item(i);
                    Method method = this.instantiateMethod(child.getAttribute("id"), design, structuredType, child);
                    this.readMethodInfo(child, method, tryReadWriteLocking, design, structuredType);
                }
            }
            return structuredType;
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        StructuredType structuredType = (StructuredType)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        boolean isVisible = Boolean.valueOf(objInfo.getAttribute("visible"));
        structuredType.setVisible(isVisible);
        String parentTypeID = StringUtilities.decodeAttributeValue((String)map.get("parent_type"));
        if (!"null".equalsIgnoreCase(parentTypeID)) {
            StructuredType st = (StructuredType)structuredType.getDesign().getDesignObject(parentTypeID);
            if (st != null) {
                structuredType.setParentType(st, false);
            } else {
                structuredType.setParentTypeID(parentTypeID);
            }
        }
        structuredType.setFinal(Boolean.valueOf((String)map.get("final")));
        structuredType.setInstantiable(Boolean.valueOf((String)map.get("instantiable")));
        structuredType.setPredefined(Boolean.valueOf((String)map.get("predefined")));
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(structuredType.getObjectID()).append(".dmd");
        structuredType.setFilePath(buffer.toString());
        return structuredType;
    }

    private TypeElement instantiateTypeElement(String objectID, Design design, StructuredType desObject, Element child) {
        TypeElement te = new TypeElement(desObject.getDesignPart(), desObject);
        te.setObjectID(objectID);
        te.setDesign(desObject.getDesign());
        desObject.add(te);
        return te;
    }

    private Method instantiateMethod(String objectID, Design design, StructuredType desObject, Element child) {
        Method method = new Method(desObject.getDesignPart(), desObject);
        method.setObjectID(StringUtilities.decodeAttributeValue(objectID));
        method.setDesign(desObject.getDesign());
        desObject.addMethod(method);
        return method;
    }

    private void readElementInfo(Element objInfo, TypeElement te, boolean tryReadWriteLocking, Design design, DesignObject designObject) {
        this.readBasicObjectInfo(objInfo, te, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        te.setReference(Boolean.valueOf((String)map.get("reference")));
        String typeID = StringUtilities.decodeAttributeValue((String)map.get("typeid"));
        if (!"null".equalsIgnoreCase(typeID)) {
            DesignObject obj = designObject.getDesign().getDesignObject(typeID);
            if (obj != null) {
                te.setType(obj);
            } else {
                te.setTypeID(typeID);
            }
        }
        try {
            te.setSize((String)map.get("size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            te.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            te.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        boolean val = Boolean.valueOf((String)map.get("mandatory"));
        te.setMandatory(val);
    }

    private void readMethodInfo(Element objInfo, Method method, boolean tryReadWriteLocking, Design design, DesignObject designObject) {
        DesignObject obj;
        this.readBasicObjectInfo(objInfo, method, tryReadWriteLocking);
        Map map = this.getProperties(objInfo, "attributes");
        method.setConstructor(Boolean.valueOf((String)map.get("constructor")));
        String overridedID = (String)map.get("overrided_method");
        if (!"null".equalsIgnoreCase(overridedID) && (obj = designObject.getDesign().getDesignObject(overridedID)) != null) {
            method.setOverridedMethod((Method)obj);
        }
        method.setBody((String)map.get("body"));
        NodeList paramElms = objInfo.getElementsByTagName("methodparam");
        for (int i = 0; i < paramElms.getLength(); ++i) {
            Element child = (Element)paramElms.item(i);
            MethodParam param = new MethodParam(method.getDesignPart());
            param.setDesign(method.getDesign());
            this.readParamInfo(child, method, param);
            method.addParameter(param);
        }
        Element retElm = RXMLStructuredType.getFirstChildByTagName(objInfo, "return_value");
        if (retElm != null) {
            MethodParam param = new MethodParam(method.getDesignPart());
            param.setDesign(method.getDesign());
            this.readParamInfo(retElm, method, param);
            method.setReturnValue(param);
        }
    }

    private void readParamInfo(Element objInfo, Method method, MethodParam param) {
        String id;
        Map map = this.getProperties(objInfo, "attributes");
        param.setName((String)map.get("name"));
        String typeID = StringUtilities.decodeAttributeValue((String)map.get("typeid"));
        if (!"null".equalsIgnoreCase(typeID)) {
            DesignObject obj = param.getDesign().getDesignObject(typeID);
            if (obj != null) {
                param.setType(obj);
            } else {
                param.setTypeID(typeID);
            }
        }
        if ((id = (String)map.get("id")) != null) {
            param.setObjectID(id);
        }
        try {
            param.setSize((String)map.get("size"));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            param.setScale(Integer.parseInt((String)map.get("Scale")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        try {
            param.setPrecision(Integer.parseInt((String)map.get("Precision")));
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        param.setReference(Boolean.valueOf((String)map.get("reference")));
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("datatypes").append('/');
        }
        buffer.append(this.getConfiguration().get("structuredtypePath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == StructuredType.class;
    }
}

