/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.TreeMap;
import oracle.dbtools.crest.model.businessinfo.BIDocument;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Element;

public class WXMLDocument
extends AbstractWXMLDesignObject
implements BIConstants {
    private BIDocument doc = null;

    public WXMLDocument(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        boolean result = object instanceof BIDocument;
        if (result) {
            this.doc = (BIDocument)object;
        }
        return result;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.doc != null) {
            String designName = this.doc.getDesignPart().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("docPath"));
        return buffer.toString();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        if (object instanceof BIDocument) {
            BIDocument doc = (BIDocument)object;
            TreeMap<String, String> map = new TreeMap<String, String>();
            map.put("docreference", StringUtilities.encodeAttributeValue(String.valueOf(doc.getReference())));
            map.put("type", StringUtilities.encodeAttributeValue(String.valueOf(doc.getType())));
            this.appendProperties(objectInfoNode, "attributes", map);
        }
    }
}

