/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml.businessinfo;

import java.util.Map;
import oracle.dbtools.crest.model.businessinfo.BIContact;
import oracle.dbtools.crest.model.businessinfo.BIEmail;
import oracle.dbtools.crest.model.businessinfo.BILocation;
import oracle.dbtools.crest.model.businessinfo.BIPhone;
import oracle.dbtools.crest.model.businessinfo.BIResourceLocator;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.DesignPart;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractRXMLDesignObject;
import oracle.dbtools.crest.model.persistence.xml.businessinfo.BIConstants;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RXMLContact
extends AbstractRXMLDesignObject
implements BIConstants {
    public RXMLContact(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    protected DesignObject instantiateDesignObject(String objectID, Design design, Element objInfo) {
        return design.getBusinessInfoDesign().getContactSet().createContact(StringUtilities.decodeAttributeValue(objectID));
    }

    @Override
    public Object recreateObject(Element objInfo, Design design, boolean tryReadWriteLocking) {
        String objID;
        int i;
        BIContact contact = (BIContact)super.recreateObject(objInfo, design, tryReadWriteLocking);
        Map objMap = this.getProperties(objInfo, "emails");
        Object[] objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            objID = (String)objMap.get(objects[i]);
            BIEmail email = (BIEmail)contact.getDesign().getBusinessInfoDesign().getEmailSet().getObjectByID(objID);
            if (email == null) continue;
            contact.addEmail(email);
        }
        objMap = this.getProperties(objInfo, "locations");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            objID = (String)objMap.get(objects[i]);
            BILocation location = (BILocation)contact.getDesign().getBusinessInfoDesign().getLocationSet().getObjectByID(objID);
            if (location == null) continue;
            contact.addLocation(location);
        }
        objMap = this.getProperties(objInfo, "phones");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            objID = (String)objMap.get(objects[i]);
            BIPhone phone = (BIPhone)contact.getDesign().getBusinessInfoDesign().getPhoneSet().getObjectByID(objID);
            if (phone == null) continue;
            contact.addPhone(phone);
        }
        objMap = this.getProperties(objInfo, "urls");
        objects = objMap.keySet().toArray();
        for (i = 0; i < objects.length; ++i) {
            objID = (String)objMap.get(objects[i]);
            BIResourceLocator url = (BIResourceLocator)contact.getDesign().getBusinessInfoDesign().getUrlSet().getObjectByID(objID);
            if (url == null) continue;
            contact.addUrl(url);
        }
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            buffer.append(this.getPersistenceManager().getAppView().getCurrentDesign().getDesignPath()).append('/');
        }
        buffer.append(this.getRelativePath()).append('/').append(StringUtilities.decodeAttributeValue(contact.getObjectID())).append(".dmd");
        contact.setFilePath(buffer.toString());
        return contact;
    }

    @Override
    public Object recreateDesign(Document doc, DesignPart design, boolean tryReadWriteLocking) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        if (this.getPersistenceManager().getAppView() != null) {
            String designName = this.getPersistenceManager().getAppView().getDesignName();
            buffer.append(designName).append('/').append("businessinfo").append('/');
        }
        buffer.append(this.getConfiguration().get("contactPath"));
        return buffer.toString();
    }

    @Override
    public boolean isReaderForClass(Class type) {
        return type == BIContact.class;
    }
}

