/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.crest.model.persistence.xml;

import java.util.Map;
import java.util.TreeMap;
import oracle.dbtools.crest.model.design.Design;
import oracle.dbtools.crest.model.design.DesignObject;
import oracle.dbtools.crest.model.design.LogicalDatatype;
import oracle.dbtools.crest.model.design.storage.RDBMSType;
import oracle.dbtools.crest.model.persistence.XMLPersistenceManager;
import oracle.dbtools.crest.model.persistence.xml.AbstractWXMLDesignObject;
import oracle.dbtools.crest.util.string.StringUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class WXMLTypes
extends AbstractWXMLDesignObject {
    private String[] typesRDBMSSites;

    public WXMLTypes(XMLPersistenceManager persistenceMgr) {
        super(persistenceMgr);
    }

    @Override
    public boolean canWrite(Object object) {
        return object instanceof LogicalDatatype;
    }

    @Override
    public Document writeDocument(Object object) {
        return null;
    }

    @Override
    public String getRelativePath() {
        StringBuffer buffer = new StringBuffer();
        String designName = this.getPersistenceManager().getAppView().getDesignName();
        buffer.append(designName).append('/').append(this.getConfiguration().get("logtypePath"));
        return buffer.toString();
    }

    public void appendTypeInfo(Element parent, LogicalDatatype logicalDatatype) {
        Object[] testArr = Design.getDefaultRDBMSTypeSet().toArray();
        this.typesRDBMSSites = new String[testArr.length];
        this.setTypesRDBMSSites(testArr);
        this.appendDesignObjectInfo(parent, logicalDatatype);
    }

    private void setTypesRDBMSSites(Object[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            this.typesRDBMSSites[i] = ((RDBMSType)objects[i]).getName();
        }
    }

    @Override
    public String getFilenameFor(Object object) {
        return ((LogicalDatatype)object).getFileName();
    }

    @Override
    protected void appendDesignObjectInfo(Element objectInfoNode, DesignObject object) {
        this.appendLogicalType(objectInfoNode, object);
    }

    private void appendLogicalType(Element objectInfoNode, DesignObject object) {
        if (object instanceof LogicalDatatype) {
            LogicalDatatype logicalDatatype = (LogicalDatatype)object;
            Element logicalTypeElm = objectInfoNode.getOwnerDocument().createElement("logicaltype");
            logicalTypeElm.setAttribute("name", StringUtilities.encodeAttributeValue(logicalDatatype.getName()));
            logicalTypeElm.setAttribute("objectid", StringUtilities.encodeAttributeValue(logicalDatatype.getObjectID()));
            if (logicalDatatype.getName().equalsIgnoreCase("UNKNOWN")) {
                logicalTypeElm.setAttribute("default", "true");
            }
            objectInfoNode.appendChild(logicalTypeElm);
            this.appendMapping(logicalTypeElm, logicalDatatype);
        }
    }

    private void appendMapping(Element parent, LogicalDatatype logicalDatatype) {
        Map map = logicalDatatype.getToPhysical();
        Map defaults0 = logicalDatatype.getDefaultValues();
        for (int i = 0; i < this.typesRDBMSSites.length; ++i) {
            String encString = (String)map.get(this.typesRDBMSSites[i]);
            Element child = parent.getOwnerDocument().createElement("mapping");
            child.setAttribute("rdbms", this.typesRDBMSSites[i]);
            TreeMap defaults1 = (TreeMap)defaults0.get(this.typesRDBMSSites[i]);
            if (defaults1 != null) {
                String scdf;
                String sdf;
                String pdf = (String)defaults1.get("precision_default_value");
                if (pdf != null && pdf.trim().length() > 0) {
                    child.setAttribute("precision_default_value", (String)defaults1.get("precision_default_value"));
                }
                if ((sdf = (String)defaults1.get("scale_default_value")) != null && sdf.trim().length() > 0) {
                    child.setAttribute("scale_default_value", (String)defaults1.get("scale_default_value"));
                }
                if ((scdf = (String)defaults1.get("size_default_value")) != null && scdf.trim().length() > 0) {
                    child.setAttribute("size_default_value", (String)defaults1.get("size_default_value"));
                }
            }
            Text content = parent.getOwnerDocument().createTextNode(encString);
            child.appendChild(content);
            parent.appendChild(child);
        }
    }
}

